# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .arm_base_model_py3 import ARMBaseModel


class Alert(ARMBaseModel):
    """Alert on the data box edge/gateway device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar title: Alert title.
    :vartype title: str
    :ivar alert_type: Alert type.
    :vartype alert_type: str
    :ivar appeared_at_date_time: UTC time when the alert appeared.
    :vartype appeared_at_date_time: datetime
    :ivar recommendation: Alert recommendation.
    :vartype recommendation: str
    :ivar severity: Severity of the alert. Possible values include:
     'Informational', 'Warning', 'Critical'
    :vartype severity: str or ~azure.mgmt.edgegateway.models.AlertSeverity
    :ivar error_details: Error details of the alert.
    :vartype error_details: ~azure.mgmt.edgegateway.models.AlertErrorDetails
    :ivar detailed_information: Alert details.
    :vartype detailed_information: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'title': {'readonly': True},
        'alert_type': {'readonly': True},
        'appeared_at_date_time': {'readonly': True},
        'recommendation': {'readonly': True},
        'severity': {'readonly': True},
        'error_details': {'readonly': True},
        'detailed_information': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'alert_type': {'key': 'properties.alertType', 'type': 'str'},
        'appeared_at_date_time': {'key': 'properties.appearedAtDateTime', 'type': 'iso-8601'},
        'recommendation': {'key': 'properties.recommendation', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'error_details': {'key': 'properties.errorDetails', 'type': 'AlertErrorDetails'},
        'detailed_information': {'key': 'properties.detailedInformation', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(Alert, self).__init__(**kwargs)
        self.title = None
        self.alert_type = None
        self.appeared_at_date_time = None
        self.recommendation = None
        self.severity = None
        self.error_details = None
        self.detailed_information = None
