# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.secretsstoreextension import SecretsStoreExtensionMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-secretsstoreextension
# USAGE
    python secret_syncs_create_or_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecretsStoreExtensionMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.secret_syncs.begin_create_or_update(
        resource_group_name="rg-ssc-example",
        secret_sync_name="secretsync-ssc-example",
        resource={
            "extendedLocation": {
                "name": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg-ssc-example/providers/Microsoft.ExtendedLocation/customLocations/example-custom-location",
                "type": "CustomLocation",
            },
            "location": "eastus",
            "properties": {
                "kubernetesSecretType": "Opaque",
                "objectSecretMapping": [{"sourcePath": "kv-secret-name/0", "targetKey": "kv-secret-name/0"}],
                "secretProviderClassName": "akvspc-ssc-example",
                "serviceAccountName": "example-k8s-sa-name",
            },
            "tags": {"example-tag": "example-tag-value"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2024-08-21-preview/SecretSyncs_CreateOrUpdate_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
