# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class Bypass(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are
    any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to
    bypass none of those traffics.
    """

    NONE = "None"
    """Represents no bypassing of traffic."""
    LOGGING = "Logging"
    """Represents bypassing logging traffic."""
    METRICS = "Metrics"
    """Represents bypassing metrics traffic."""
    AZURE_SERVICES = "AzureServices"
    """Represents bypassing azure services traffic."""


class ControlState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data type state."""

    ENABLED = "Enabled"
    """Field to enable a setting."""
    DISABLED = "Disabled"
    """Field to disable a setting."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DataProductUserRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data type state."""

    READER = "Reader"
    """Field to specify user of type Reader."""
    SENSITIVE_READER = "SensitiveReader"
    """Field to specify user of type SensitiveReader.
    #: This user has privileged access to read sensitive data of a data product."""


class DataTypeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data type state."""

    STOPPED = "Stopped"
    """Field to specify stopped state."""
    RUNNING = "Running"
    """Field to specify running state."""


class DefaultAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the default action of allow or deny when no other rules match."""

    ALLOW = "Allow"
    """Represents allow action."""
    DENY = "Deny"
    """Represents deny action."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Represents a succeeded operation."""
    FAILED = "Failed"
    """Represents a failed operation."""
    CANCELED = "Canceled"
    """Represents a canceled operation."""
    PROVISIONING = "Provisioning"
    """Represents a pending operation."""
    UPDATING = "Updating"
    """Represents a pending operation."""
    DELETING = "Deleting"
    """Represents an operation under deletion."""
    ACCEPTED = "Accepted"
    """Represents an accepted operation."""


class Versions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The available API versions for the Microsoft.NetworkAnalytics RP."""

    V2023_11_15 = "2023-11-15"
    """The 2023-11-15 stable version."""
