% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan.R
\name{tidy.lavaan}
\alias{tidy.lavaan}
\alias{lavaan_tidiers}
\alias{sem_tidiers}
\alias{cfa_tidiers}
\title{Tidy a(n) lavaan object}
\usage{
\method{tidy}{lavaan}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{A \code{lavaan} object, such as those returned from \code{\link[lavaan:cfa]{lavaan::cfa()}},
and \code{\link[lavaan:sem]{lavaan::sem()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments passed to \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.
\strong{Cautionary note}: Misspecified arguments may be silently ignored.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with one row for each estimated parameter and
columns:

\item{term}{The result of paste(lhs, op, rhs)}
\item{op}{The operator in the model syntax (e.g. \verb{~~} for covariances, or
\code{~} for regression parameters)}
\item{group}{The group (if specified) in the lavaan model}
\item{estimate}{The parameter estimate (may be standardized)}
\item{std.error}{}
\item{statistic}{The z value returned by \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}}
\item{p.value}{}
\item{conf.low}{}
\item{conf.high}{}
\item{std.lv}{Standardized estimates based on the variances of the
(continuous) latent variables only}
\item{std.all}{Standardized estimates based on both the variances
of both (continuous) observed and latent variables.}
\item{std.nox}{Standardized estimates based on both the variances
of both (continuous) observed and latent variables, but not the
variances of exogenous covariates.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (rlang::is_installed("lavaan")) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(lavaan)

cfa.fit <- cfa("F =~ x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9",
  data = HolzingerSwineford1939, group = "school"
)

tidy(cfa.fit)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[lavaan:cfa]{lavaan::cfa()}}, \code{\link[lavaan:sem]{lavaan::sem()}},
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}

Other lavaan tidiers: 
\code{\link{glance.lavaan}()}
}
\concept{lavaan tidiers}
