% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{forecast.mean_model}
\alias{forecast.mean_model}
\alias{meanf}
\title{Mean Forecast}
\usage{
\method{forecast}{mean_model}(
  object,
  h = 10,
  level = c(80, 95),
  fan = FALSE,
  lambda = object$lambda,
  biasadj = attr(object$lambda, "biasadj"),
  bootstrap = FALSE,
  npaths = 5000,
  ...
)

meanf(
  y,
  h = 10,
  level = c(80, 95),
  fan = FALSE,
  lambda = NULL,
  biasadj = FALSE,
  bootstrap = FALSE,
  npaths = 5000,
  x = y
)
}
\arguments{
\item{object}{An object of class \code{mean_model} as returned by \code{\link[=mean_model]{mean_model()}}.}

\item{h}{Number of periods for forecasting. Default value is twice the
largest seasonal period (for seasonal data) or ten (for non-seasonal data).}

\item{level}{Confidence levels for prediction intervals.}

\item{fan}{If \code{TRUE}, \code{level} is set to \code{seq(51, 99, by = 3)}.
This is suitable for fan plots.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{bootstrap}{If \code{TRUE}, then prediction intervals are produced by
simulation using resampled errors (rather than normally distributed errors). Ignored if \code{innov} is not \code{NULL}.}

\item{npaths}{Number of sample paths used in computing simulated prediction
intervals.}

\item{...}{Additional arguments not used.}

\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{x}{Deprecated. Included for backwards compatibility.}
}
\description{
Returns forecasts and prediction intervals for a Gaussian iid model.
\code{\link[=meanf]{meanf()}} is a convenience function that combines \code{\link[=mean_model]{mean_model()}} and \code{\link[=forecast]{forecast()}}.
}
\details{
The model assumes that the data are independent and identically distributed

\deqn{Y_t \sim N(\mu,\sigma^2)}{Y[t] ~ N(mu, sigma^2)}

Forecasts are given by

\deqn{Y_{n+h|n}=\mu}{Y[n+h|n]=mu}

where \eqn{\mu}{mu} is estimated by the sample mean.

The function \code{\link[=summary]{summary()}} is used to obtain and print a summary of the
results, while the function \code{\link[=plot]{plot()}} produces a plot of the forecasts and
prediction intervals.
The generic accessor functions \code{\link[stats:fitted.values]{stats::fitted()}} and \code{\link[stats:residuals]{stats::residuals()}}
extract useful features of the object returned by \code{\link[=mean_model]{mean_model()}}.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{
fit_nile <- mean_model(Nile)
fit_nile |> forecast(h = 10) |> autoplot()
nile.fcast <- meanf(Nile, h = 10)
}
\seealso{
\code{\link[=mean_model]{mean_model()}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
