% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition-manual.R
\name{transition_manual}
\alias{transition_manual}
\title{Create an animation by specifying the frame membership directly}
\usage{
transition_manual(frames, ..., cumulative = FALSE)
}
\arguments{
\item{frames}{The unquoted name of the column holding the frame membership.}

\item{...}{Additional variables}

\item{cumulative}{Keep data from previous frames as part of the current frame
data}
}
\description{
This transition allows you to map a variable in your data to a specific frame
in the animation. No tweening of data will be made and the number of frames
in the animation will be decided by the number of levels in the frame
variable.
}
\section{Label variables}{

\code{transition_states} makes the following variables available for string
literal interpretation, in addition to the general ones provided by
\code{\link[=animate]{animate()}}:
\itemize{
\item \strong{previous_frame} The name of the last frame the animation was at
\item \strong{current_frame} The name of the current frame
\item \strong{next_frame} The name of the next frame in the animation
}
}

\section{Object permanence}{

\code{transition_manual} does not link rows across data to the same graphic
element. Every frame is a discrete state and no animation between the states
is done.
}

\section{Computed Variables}{

It is possible to use variables calculated by the statistic to define the
transition. Simply inclose the variable in \code{stat()} in the same way as when
using computed variables in aesthetics.
}

\examples{
anim <- ggplot(mtcars, aes(factor(gear), mpg)) +
  geom_boxplot() +
  transition_manual(gear)

# Using `cumulative = TRUE` to keep data from older frames
anim2 <- ggplot(mtcars, aes(factor(gear), mpg)) +
  geom_boxplot() +
  transition_manual(gear, cumulative = TRUE)

# Use `factor()` to set the order of the frames
anim3 <- ggplot(mtcars, aes(factor(gear), mpg)) +
  geom_boxplot() +
  transition_manual(factor(gear, levels = c('4', '3', '5')))

}
\seealso{
Other transitions: 
\code{\link{transition_components}()},
\code{\link{transition_events}()},
\code{\link{transition_filter}()},
\code{\link{transition_layers}()},
\code{\link{transition_null}()},
\code{\link{transition_reveal}()},
\code{\link{transition_states}()},
\code{\link{transition_time}()}
}
\concept{transitions}
