% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background_image.R
\name{background_image}
\alias{background_image}
\title{Add Background Image to ggplot2}
\usage{
background_image(raster.img)
}
\arguments{
\item{raster.img}{raster object to display, as returned by the function
\code{readPNG()}[in \code{png} package] and \code{readJPEG()} [in \code{jpeg} package].}
}
\description{
Add background image to ggplot2.
}
\examples{
\dontrun{
install.packages("png")

# Import the image
img.file <- system.file(file.path("images", "background-image.png"),
                       package = "ggpubr")
img <- png::readPNG(img.file)

# Plot with background image
ggplot(iris, aes(Species, Sepal.Length))+
 background_image(img)+
 geom_boxplot(aes(fill = Species), color = "white")+
 fill_palette("jco")
 }

}
\author{
Alboukadel Kassambara <alboukadel.kassambara@gmail.com>
}
