% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-utils.R
\name{getEllipse}
\alias{getEllipse}
\title{Calculates the points for drawing a confidence ellipsoid}
\usage{
getEllipse(loc = c(0, 0), cov = matrix(c(1, 0, 0, 1), ncol = 2), crit = 0.975)
}
\arguments{
\item{loc}{location vector}

\item{cov}{a \code{pXp} covariance matrix}

\item{crit}{the confidence level, default is \code{crit=0.975}}
}
\value{
A matrix with two columns containing the calculated points.
}
\description{
A simple function to calculate the points of
  a confidence ellipsoid, by default \code{dist=qchisq(0.975, 2)}
}
\examples{

data(hbk)
cc <- cov.wt(hbk)
e1 <- getEllipse(loc=cc$center[1:2], cov=cc$cov[1:2,1:2])
e2 <- getEllipse(loc=cc$center[1:2], cov=cc$cov[1:2,1:2], crit=0.99)
plot(X2~X1, data=hbk,
    xlim=c(min(X1, e1[,1], e2[,1]), max(X1,e1[,1], e2[,1])),
    ylim=c(min(X2, e1[,2], e2[,2]), max(X2,e1[,2], e2[,2])))
lines(e1, type="l", lty=1, col="red")
lines(e2, type="l", lty=2, col="blue")
legend("topleft", legend=c(0.975, 0.99), lty=1:2, col=c("red", "blue"))

}
\author{
Valentin Todorov, \email{valentin.todorov@chello.at}
}
