/* -copyright-
#-# Copyright © 2021 Eric Bina, Dave Black, TJ Phan, 
#-#    Vincent Renardias, Jim Rees, Willem Vermin
#-# 
#-# Permission is hereby granted, free of charge, to any person 
#-# obtaining a copy of this software and associated documentation 
#-# files (the “Software”), to deal in the Software without 
#-# restriction, including without limitation the rights to use, 
#-# copy, modify, merge, publish, distribute, sublicense, and/or 
#-# sell copies of the Software, and to permit persons to whom 
#-# the Software is furnished to do so, subject to the following 
#-# conditions:
#-# 
#-# The above copyright notice and this permission notice shall 
#-# be included in all copies or substantial portions of the Software.
#-# 
#-# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, 
#-# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
#-# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
#-# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
#-# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
#-# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
#-# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
#-# OTHER DEALINGS IN THE SOFTWARE.
#-# 
 */

#pragma once
#define FLAGSFILE ".xfishtankrc"
#define _(string) (char *)(string)

#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include "xdo.h"

extern Display *Dpy;
extern Window  xfishtankWin;
extern int flimit;
extern int blimit;
extern char *bcolorstring;
extern char *bgcolorstring;
extern float speedfactor;
extern int   allworkspaces;
extern int   monitor;
extern char *DesktopSession;
extern xdo_t *myxdo;
extern int nomenu;
extern GtkWidget *gtkwin;
extern int      width;                       /* width of initial window in pixels */
extern int      height;                      /* height of initial window in pixels */
extern int      fullwidth;                   /* width of full screen window in pixels */
extern int      fullheight;                  /* height of full screen window in pixels */
extern int      xfishtank_trans;             /* true if we have a transparent window */
extern Window   wid;                         /* aquarium */
extern Window   wid1;                         /* aquarium */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_XDBEALLOCATEBACKBUFFERNAME
#define DOUBLE_BUFFER
#endif

extern void create_fishes(int n);
extern void create_bubbles(int n);
extern void setbcolor(void);
extern void setbgcolor(void);
extern void set_defaults(void);
extern void setspeed(float s);
extern void remove_all_bubbles(void);

