// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/user_list_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [UserListService.GetUserList][google.ads.googleads.v0.services.UserListService.GetUserList].
type GetUserListRequest struct {
	// The resource name of the user list to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetUserListRequest) Reset()         { *m = GetUserListRequest{} }
func (m *GetUserListRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserListRequest) ProtoMessage()    {}
func (*GetUserListRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_list_service_a212d0fa5504c897, []int{0}
}
func (m *GetUserListRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetUserListRequest.Unmarshal(m, b)
}
func (m *GetUserListRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetUserListRequest.Marshal(b, m, deterministic)
}
func (dst *GetUserListRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUserListRequest.Merge(dst, src)
}
func (m *GetUserListRequest) XXX_Size() int {
	return xxx_messageInfo_GetUserListRequest.Size(m)
}
func (m *GetUserListRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUserListRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetUserListRequest proto.InternalMessageInfo

func (m *GetUserListRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [UserListService.MutateUserLists][google.ads.googleads.v0.services.UserListService.MutateUserLists].
type MutateUserListsRequest struct {
	// The ID of the customer whose user lists are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual user lists.
	Operations           []*UserListOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MutateUserListsRequest) Reset()         { *m = MutateUserListsRequest{} }
func (m *MutateUserListsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateUserListsRequest) ProtoMessage()    {}
func (*MutateUserListsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_list_service_a212d0fa5504c897, []int{1}
}
func (m *MutateUserListsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateUserListsRequest.Unmarshal(m, b)
}
func (m *MutateUserListsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateUserListsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateUserListsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateUserListsRequest.Merge(dst, src)
}
func (m *MutateUserListsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateUserListsRequest.Size(m)
}
func (m *MutateUserListsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateUserListsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateUserListsRequest proto.InternalMessageInfo

func (m *MutateUserListsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateUserListsRequest) GetOperations() []*UserListOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation (create, update) on a user list.
type UserListOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*UserListOperation_Create
	//	*UserListOperation_Update
	//	*UserListOperation_Remove
	Operation            isUserListOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *UserListOperation) Reset()         { *m = UserListOperation{} }
func (m *UserListOperation) String() string { return proto.CompactTextString(m) }
func (*UserListOperation) ProtoMessage()    {}
func (*UserListOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_list_service_a212d0fa5504c897, []int{2}
}
func (m *UserListOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListOperation.Unmarshal(m, b)
}
func (m *UserListOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListOperation.Marshal(b, m, deterministic)
}
func (dst *UserListOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListOperation.Merge(dst, src)
}
func (m *UserListOperation) XXX_Size() int {
	return xxx_messageInfo_UserListOperation.Size(m)
}
func (m *UserListOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListOperation.DiscardUnknown(m)
}

var xxx_messageInfo_UserListOperation proto.InternalMessageInfo

func (m *UserListOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isUserListOperation_Operation interface {
	isUserListOperation_Operation()
}

type UserListOperation_Create struct {
	Create *resources.UserList `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type UserListOperation_Update struct {
	Update *resources.UserList `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type UserListOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*UserListOperation_Create) isUserListOperation_Operation() {}

func (*UserListOperation_Update) isUserListOperation_Operation() {}

func (*UserListOperation_Remove) isUserListOperation_Operation() {}

func (m *UserListOperation) GetOperation() isUserListOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *UserListOperation) GetCreate() *resources.UserList {
	if x, ok := m.GetOperation().(*UserListOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *UserListOperation) GetUpdate() *resources.UserList {
	if x, ok := m.GetOperation().(*UserListOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *UserListOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*UserListOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserListOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserListOperation_OneofMarshaler, _UserListOperation_OneofUnmarshaler, _UserListOperation_OneofSizer, []interface{}{
		(*UserListOperation_Create)(nil),
		(*UserListOperation_Update)(nil),
		(*UserListOperation_Remove)(nil),
	}
}

func _UserListOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserListOperation)
	// operation
	switch x := m.Operation.(type) {
	case *UserListOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *UserListOperation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *UserListOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("UserListOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _UserListOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserListOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.UserList)
		err := b.DecodeMessage(msg)
		m.Operation = &UserListOperation_Create{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.UserList)
		err := b.DecodeMessage(msg)
		m.Operation = &UserListOperation_Update{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &UserListOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _UserListOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserListOperation)
	// operation
	switch x := m.Operation.(type) {
	case *UserListOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserListOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserListOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for user list mutate.
type MutateUserListsResponse struct {
	// All results for the mutate.
	Results              []*MutateUserListResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *MutateUserListsResponse) Reset()         { *m = MutateUserListsResponse{} }
func (m *MutateUserListsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateUserListsResponse) ProtoMessage()    {}
func (*MutateUserListsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_list_service_a212d0fa5504c897, []int{3}
}
func (m *MutateUserListsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateUserListsResponse.Unmarshal(m, b)
}
func (m *MutateUserListsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateUserListsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateUserListsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateUserListsResponse.Merge(dst, src)
}
func (m *MutateUserListsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateUserListsResponse.Size(m)
}
func (m *MutateUserListsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateUserListsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateUserListsResponse proto.InternalMessageInfo

func (m *MutateUserListsResponse) GetResults() []*MutateUserListResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the user list mutate.
type MutateUserListResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateUserListResult) Reset()         { *m = MutateUserListResult{} }
func (m *MutateUserListResult) String() string { return proto.CompactTextString(m) }
func (*MutateUserListResult) ProtoMessage()    {}
func (*MutateUserListResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_list_service_a212d0fa5504c897, []int{4}
}
func (m *MutateUserListResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateUserListResult.Unmarshal(m, b)
}
func (m *MutateUserListResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateUserListResult.Marshal(b, m, deterministic)
}
func (dst *MutateUserListResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateUserListResult.Merge(dst, src)
}
func (m *MutateUserListResult) XXX_Size() int {
	return xxx_messageInfo_MutateUserListResult.Size(m)
}
func (m *MutateUserListResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateUserListResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateUserListResult proto.InternalMessageInfo

func (m *MutateUserListResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetUserListRequest)(nil), "google.ads.googleads.v0.services.GetUserListRequest")
	proto.RegisterType((*MutateUserListsRequest)(nil), "google.ads.googleads.v0.services.MutateUserListsRequest")
	proto.RegisterType((*UserListOperation)(nil), "google.ads.googleads.v0.services.UserListOperation")
	proto.RegisterType((*MutateUserListsResponse)(nil), "google.ads.googleads.v0.services.MutateUserListsResponse")
	proto.RegisterType((*MutateUserListResult)(nil), "google.ads.googleads.v0.services.MutateUserListResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// UserListServiceClient is the client API for UserListService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UserListServiceClient interface {
	// Returns the requested user list.
	GetUserList(ctx context.Context, in *GetUserListRequest, opts ...grpc.CallOption) (*resources.UserList, error)
	// Creates or updates user lists. Operation statuses are returned.
	MutateUserLists(ctx context.Context, in *MutateUserListsRequest, opts ...grpc.CallOption) (*MutateUserListsResponse, error)
}

type userListServiceClient struct {
	cc *grpc.ClientConn
}

func NewUserListServiceClient(cc *grpc.ClientConn) UserListServiceClient {
	return &userListServiceClient{cc}
}

func (c *userListServiceClient) GetUserList(ctx context.Context, in *GetUserListRequest, opts ...grpc.CallOption) (*resources.UserList, error) {
	out := new(resources.UserList)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.UserListService/GetUserList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userListServiceClient) MutateUserLists(ctx context.Context, in *MutateUserListsRequest, opts ...grpc.CallOption) (*MutateUserListsResponse, error) {
	out := new(MutateUserListsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.UserListService/MutateUserLists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserListServiceServer is the server API for UserListService service.
type UserListServiceServer interface {
	// Returns the requested user list.
	GetUserList(context.Context, *GetUserListRequest) (*resources.UserList, error)
	// Creates or updates user lists. Operation statuses are returned.
	MutateUserLists(context.Context, *MutateUserListsRequest) (*MutateUserListsResponse, error)
}

func RegisterUserListServiceServer(s *grpc.Server, srv UserListServiceServer) {
	s.RegisterService(&_UserListService_serviceDesc, srv)
}

func _UserListService_GetUserList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserListServiceServer).GetUserList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.UserListService/GetUserList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserListServiceServer).GetUserList(ctx, req.(*GetUserListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserListService_MutateUserLists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateUserListsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserListServiceServer).MutateUserLists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.UserListService/MutateUserLists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserListServiceServer).MutateUserLists(ctx, req.(*MutateUserListsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _UserListService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.UserListService",
	HandlerType: (*UserListServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetUserList",
			Handler:    _UserListService_GetUserList_Handler,
		},
		{
			MethodName: "MutateUserLists",
			Handler:    _UserListService_MutateUserLists_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/user_list_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/user_list_service.proto", fileDescriptor_user_list_service_a212d0fa5504c897)
}

var fileDescriptor_user_list_service_a212d0fa5504c897 = []byte{
	// 592 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0x41, 0x8b, 0xd3, 0x4c,
	0x18, 0xfe, 0x92, 0xfd, 0xa8, 0xec, 0x44, 0x59, 0x1c, 0x16, 0x0d, 0x45, 0xb0, 0x44, 0x0f, 0xa5,
	0x8b, 0x93, 0xda, 0x8a, 0x6c, 0xb7, 0xec, 0xa1, 0x05, 0xed, 0x0a, 0xae, 0x96, 0x2c, 0xee, 0x41,
	0x0a, 0x65, 0xb6, 0x99, 0x0d, 0xa1, 0x4d, 0x26, 0xce, 0x3b, 0xe9, 0x65, 0xd9, 0x8b, 0xe0, 0xd5,
	0x8b, 0xff, 0x40, 0xf0, 0xe2, 0xbf, 0xf0, 0xea, 0x55, 0x7f, 0x82, 0x7f, 0x43, 0x90, 0x64, 0x32,
	0xdd, 0x76, 0x6b, 0xa9, 0xbb, 0xb7, 0x37, 0x93, 0xe7, 0x79, 0xde, 0x27, 0xcf, 0xbc, 0x6f, 0xd0,
	0x6e, 0xc0, 0x79, 0x30, 0x61, 0x2e, 0xf5, 0xc1, 0x55, 0x65, 0x56, 0x4d, 0xeb, 0x2e, 0x30, 0x31,
	0x0d, 0x47, 0x0c, 0xdc, 0x14, 0x98, 0x18, 0x4e, 0x42, 0x90, 0xc3, 0xe2, 0x88, 0x24, 0x82, 0x4b,
	0x8e, 0x2b, 0x0a, 0x4e, 0xa8, 0x0f, 0x64, 0xc6, 0x24, 0xd3, 0x3a, 0xd1, 0xcc, 0xf2, 0xe3, 0x55,
	0xda, 0x82, 0x01, 0x4f, 0xc5, 0x82, 0xb8, 0x12, 0x2d, 0xdf, 0xd3, 0x94, 0x24, 0x74, 0x69, 0x1c,
	0x73, 0x49, 0x65, 0xc8, 0x63, 0x28, 0xde, 0x16, 0x2d, 0xdd, 0xfc, 0xe9, 0x24, 0x3d, 0x75, 0x4f,
	0x43, 0x36, 0xf1, 0x87, 0x11, 0x85, 0xb1, 0x42, 0x38, 0x2d, 0x84, 0x7b, 0x4c, 0xbe, 0x01, 0x26,
	0x5e, 0x86, 0x20, 0x3d, 0xf6, 0x2e, 0x65, 0x20, 0xf1, 0x03, 0x74, 0x4b, 0xb7, 0x1c, 0xc6, 0x34,
	0x62, 0xb6, 0x51, 0x31, 0xaa, 0x9b, 0xde, 0x4d, 0x7d, 0xf8, 0x8a, 0x46, 0xcc, 0xf9, 0x68, 0xa0,
	0x3b, 0x87, 0xa9, 0xa4, 0x92, 0x69, 0x3a, 0x68, 0xfe, 0x7d, 0x64, 0x8d, 0x52, 0x90, 0x3c, 0x62,
	0x62, 0x18, 0xfa, 0x05, 0x1b, 0xe9, 0xa3, 0x17, 0x3e, 0x3e, 0x42, 0x88, 0x27, 0x4c, 0x28, 0xb3,
	0xb6, 0x59, 0xd9, 0xa8, 0x5a, 0x8d, 0x26, 0x59, 0x17, 0x10, 0xd1, 0x8d, 0x5e, 0x6b, 0xae, 0x37,
	0x27, 0xe3, 0x7c, 0x30, 0xd1, 0xed, 0x25, 0x04, 0x6e, 0x23, 0x2b, 0x4d, 0x7c, 0x2a, 0x59, 0xfe,
	0xd9, 0xf6, 0xff, 0x15, 0xa3, 0x6a, 0x35, 0xca, 0xba, 0x97, 0x4e, 0x86, 0x3c, 0xcf, 0x92, 0x39,
	0xa4, 0x30, 0xf6, 0x90, 0x82, 0x67, 0x35, 0x7e, 0x86, 0x4a, 0x23, 0xc1, 0xa8, 0x54, 0x09, 0x58,
	0x8d, 0x9d, 0x95, 0x1e, 0x67, 0x57, 0x34, 0x33, 0x79, 0xf0, 0x9f, 0x57, 0x90, 0x33, 0x19, 0x25,
	0x6a, 0x9b, 0xd7, 0x92, 0x51, 0x64, 0x6c, 0xa3, 0x92, 0x60, 0x11, 0x9f, 0x32, 0x7b, 0x23, 0x4b,
	0x34, 0x7b, 0xa3, 0x9e, 0xbb, 0x16, 0xda, 0x9c, 0x05, 0xe1, 0x8c, 0xd1, 0xdd, 0xa5, 0x7b, 0x81,
	0x84, 0xc7, 0xc0, 0x70, 0x1f, 0xdd, 0x10, 0x0c, 0xd2, 0x89, 0xd4, 0xa1, 0x3f, 0x5d, 0x1f, 0xfa,
	0xa2, 0x96, 0x97, 0xd3, 0x3d, 0x2d, 0xe3, 0xb4, 0xd1, 0xf6, 0xdf, 0x00, 0xff, 0x34, 0x42, 0x8d,
	0xdf, 0x26, 0xda, 0xd2, 0xbc, 0x23, 0xd5, 0x0f, 0x7f, 0x31, 0x90, 0x35, 0x37, 0x92, 0xf8, 0xc9,
	0x7a, 0x87, 0xcb, 0x13, 0x5c, 0xbe, 0x4a, 0xc2, 0x4e, 0xf3, 0xfd, 0x8f, 0x5f, 0x9f, 0xcc, 0x47,
	0x78, 0x27, 0xdb, 0xb5, 0xb3, 0x05, 0xdb, 0xfb, 0x7a, 0x68, 0xc1, 0xad, 0xe5, 0xcb, 0x97, 0xe7,
	0xe9, 0xd6, 0xce, 0xf1, 0x37, 0x03, 0x6d, 0x5d, 0x8a, 0x19, 0xef, 0x5e, 0x35, 0x4d, 0xbd, 0x31,
	0xe5, 0xd6, 0x35, 0x98, 0xea, 0x4e, 0x9d, 0x56, 0xee, 0xbe, 0xe9, 0x90, 0xcc, 0xfd, 0x85, 0xdd,
	0xb3, 0xb9, 0x0d, 0xdc, 0xaf, 0x9d, 0x5f, 0x98, 0xdf, 0x8b, 0x72, 0xa1, 0x3d, 0xa3, 0xd6, 0xfd,
	0x69, 0xa0, 0x87, 0x23, 0x1e, 0xad, 0xed, 0xdd, 0xdd, 0xbe, 0x74, 0x4b, 0xfd, 0x6c, 0x6d, 0xfa,
	0xc6, 0xdb, 0x83, 0x82, 0x19, 0xf0, 0x09, 0x8d, 0x03, 0xc2, 0x45, 0xe0, 0x06, 0x2c, 0xce, 0x97,
	0x4a, 0xff, 0xc1, 0x92, 0x10, 0x56, 0xff, 0x2c, 0xdb, 0xba, 0xf8, 0x6c, 0x6e, 0xf4, 0x3a, 0x9d,
	0xaf, 0x66, 0xa5, 0xa7, 0x04, 0x3b, 0x3e, 0x10, 0x55, 0x66, 0xd5, 0x71, 0x9d, 0x14, 0x8d, 0xe1,
	0xbb, 0x86, 0x0c, 0x3a, 0x3e, 0x0c, 0x66, 0x90, 0xc1, 0x71, 0x7d, 0xa0, 0x21, 0x27, 0xa5, 0xdc,
	0x40, 0xf3, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x4b, 0x04, 0x32, 0x1d, 0xac, 0x05, 0x00, 0x00,
}
