/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebKitDOMattribute.h"

#include "CSSImportRule.h"
#include "DOMObjectCache.h"
#include "Document.h"
#include "ExceptionCode.h"
#include "ExceptionCodeDescription.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMattributePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_ATTRIBUTE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_DOM_TYPE_ATTRIBUTE, WebKitDOMattributePrivate)

typedef struct _WebKitDOMattributePrivate {
    RefPtr<WebCore::attribute> coreObject;
} WebKitDOMattributePrivate;

namespace WebKit {

WebKitDOMattribute* kit(WebCore::attribute* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_ATTRIBUTE(ret);

    return wrapattribute(obj);
}

WebCore::attribute* core(WebKitDOMattribute* request)
{
    return request ? static_cast<WebCore::attribute*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMattribute* wrapattribute(WebCore::attribute* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_ATTRIBUTE(g_object_new(WEBKIT_DOM_TYPE_ATTRIBUTE, "core-object", coreObject, nullptr));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMattribute, webkit_dom_attribute, WEBKIT_DOM_TYPE_OBJECT)

enum {
    PROP_0,
    PROP_READONLY,
};

static void webkit_dom_attribute_finalize(GObject* object)
{
    WebKitDOMattributePrivate* priv = WEBKIT_DOM_ATTRIBUTE_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMattributePrivate();
    G_OBJECT_CLASS(webkit_dom_attribute_parent_class)->finalize(object);
}

static void webkit_dom_test_exception_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebKitDOMTestException* self = WEBKIT_DOM_TEST_EXCEPTION(object);

    switch (propertyId) {
    case PROP_NAME:
        g_value_take_string(value, webkit_dom_test_exception_get_name(self));
        break;
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}
static void webkit_dom_attribute_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebKitDOMattribute* self = WEBKIT_DOM_ATTRIBUTE(object);

    switch (propertyId) {
    case PROP_READONLY:
        g_value_take_string(value, webkit_dom_attribute_get_readonly(self));
        break;
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_attribute_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_attribute_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMattributePrivate* priv = WEBKIT_DOM_ATTRIBUTE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::attribute*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_attribute_class_init(WebKitDOMattributeClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMattributePrivate));
    gobjectClass->constructor = webkit_dom_attribute_constructor;
    gobjectClass->finalize = webkit_dom_attribute_finalize;
    gobjectClass->get_property = webkit_dom_attribute_get_property;

    g_object_class_install_property(
        gobjectClass,
        PROP_NAME,
        g_param_spec_string(
            "name",
            "TestException:name",
            "read-only gchar* TestException:name",
            "",
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_READONLY,
        g_param_spec_string(
            "readonly",
            "attribute:readonly",
            "read-only gchar* attribute:readonly",
            "",
            WEBKIT_PARAM_READABLE));

}

static void webkit_dom_attribute_init(WebKitDOMattribute* request)
{
    WebKitDOMattributePrivate* priv = WEBKIT_DOM_ATTRIBUTE_GET_PRIVATE(request);
    new (priv) WebKitDOMattributePrivate();
}

gchar* webkit_dom_attribute_get_readonly(WebKitDOMattribute* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ATTRIBUTE(self), 0);
    WebCore::attribute* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->readonly());
    return result;
}

