// SPDX-FileCopyrightText: 2021 - 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
#ifndef COMMONLYWIDGET_H
#define COMMONLYWIDGET_H

#include <QPaintEvent>
#include <QIcon>

#include <DFrame>

#if (QT_VERSION < QT_VERSION_CHECK(6, 0, 0))
using EnterEvent = QEvent;
#else
using EnterEvent = QEnterEvent;
#endif

DWIDGET_USE_NAMESPACE

class CommonlyWidget : public DFrame
{
    Q_OBJECT
public:
    explicit CommonlyWidget(bool isArrow, QString svgPath, QString text, QWidget *parent = nullptr);
    void setMethod(QString method) {m_method = method;}
    QString getMethod() {return m_method;}

protected:
    void paintEvent(QPaintEvent *event) Q_DECL_OVERRIDE;
    void enterEvent(EnterEvent *event) Q_DECL_OVERRIDE;
    void leaveEvent(QEvent *event) Q_DECL_OVERRIDE;
    void mouseReleaseEvent(QMouseEvent *event) Q_DECL_OVERRIDE;

signals:
    void clicked();

private:
    QString editorText(QFontMetrics fm, QString text);

    QPixmap m_pixmap;
    QString m_text;
    QString m_method;
    QIcon m_icon;
    bool m_hover;
    bool m_isArrow {false};
};

#endif
