# Music|deepin-music|

## Overview

Music is an application focused on local music playback, providing you with a brand-new interface design, an exceptional playback experience, along with features like scanning local music and synchronized lyrics.

![main](fig/main.png)

## Getting Started

Run or close Music through the following methods, and create shortcuts.

### Run Music

1. Click the Launcher icon ![launcher_icon](../common/deepin_launcher.svg) on the taskbar to enter the Launcher interface.
2. Scroll the mouse wheel or search to find the Music icon ![music_icon24](../common/music_icon24.svg), then click to run.
3. Right-click ![music_icon24](../common/music_icon24.svg) to:
   - Click **Send to Desktop** to create a desktop shortcut.
   - Click **Pin to Taskbar** to pin the application to the taskbar.
   - Click **Startup Automatically** to add the application to startup items, automatically running it when the computer boots.

> ![notes](../common/notes.svg) Note: If Music is already pinned to the taskbar by default, you can also click the taskbar icon ![music_icon24](../common/music_icon24.svg) to run it.

### Hide to System Tray

In the Music interface, click ![icon_menu](../common/icon_menu.svg) > **Settings**, then check **Minimize to System Tray**. Each time you close the main window, Music will automatically hide in the system tray. Right-click the tray icon to:
- Play/Pause.
- Previous.
- Next.
- Quit.

### Close Music

- In the Music interface, if you set "Close main window" to "Exit", click ![close_icon](../common/close.svg) to quit Music.
- Right-click ![music_icon24](../common/music_icon24.svg) in the system tray and select **Quit**.
- Right-click ![music_icon24](../common/music_icon24.svg) on the taskbar and select **Close All**.

### View Shortcuts

In the Music interface, use the shortcut **Ctrl + Shift + ?** to open the shortcut preview. Mastering shortcuts will significantly improve your efficiency.

![0|view](fig/hotkey.png)

## Interface Introduction

Perform playback operations, view playlists, lyrics, etc., through interface buttons.

![1|main](fig/music_main.png)

| No. | Name             | Description                                                  |
|-----|------------------|--------------------------------------------------------------|
| 1   | Search Box       | Quickly find music via the search box.                       |
| 2   | Add Music        | Add music files to the playlist.                             |
| 3   | Main Menu        | Add new playlists, add music, configure settings, view help, quit, etc. |
| 4   | Sort By          | Sort songs by: Date Added, Title, Artist, Album (default: Date Added). |
| 5   | Previous/Next    | Switch to the previous/next track.                           |
| 6   | Play/Pause       | Play or pause the song.                                      |
| 7   | Playback Box     | Displays the current song's title, cover, and artist.        |
| 8   | Favorite         | Add music to "My Favorites"; click again to remove.          |
| 9   | Lyrics           | Toggle lyrics display; click again to exit.                  |
| 10  | Playback Mode    | Cycle modes: List Loop, Single Loop, Shuffle.                |
| 11  | Volume Control   | Adjust volume level.                                         |
| 12  | Play Queue       | Open the play queue.                                         |

## Common Operations

Add, delete, and view information for local music.

> ![notes](../common/notes.svg) Note: Supported features vary by decoding technology; refer to the actual interface.

### Add Music

In the Music interface, add music via:
- Click the Add button ![icon_menu](../common/add1.svg) on the title bar.
- Click ![icon_menu](../common/icon_menu.svg) > **Add Music**.
- Drag music files directly into the interface.

> ![notes](../common/notes.svg) Note: If no music exists, click **Add Music**, **Add Song Path**, or **Scan** music directories. Right-click library/playlist items to add music when songs are present.

### Search Music

1. In the search box, click ![search](../common/search.svg) and enter keywords.
2. Press **Enter** to search.
3. Click ![0|close](../common/close.svg) or delete text to clear/cancel the search.

### Play Music

Play music via:
- Double-click a song or right-click and select **Play**.
- Click **Play All** to play all songs in the current list.
- Right-click a playlist and select **Play** to play all songs in it.

> ![tips](../common/tips.svg) Tip: Click ![play_normal](../common/play_normal.svg) to play selected songs; ![suspend_normal](../common/suspend_normal.svg) to pause; ![last_normal](../common/last_normal.svg) or ![next_normal](../common/next_normal.svg) to skip tracks per playback mode.

### Favorite Music

1. Play a song.
2. Click ![collect](../common/collect.svg) to add it to "My Favorites".

> ![tips](../common/tips.svg) Tip: Right-click a song > **Add to Playlist** > **My Favorites**.

### View Lyrics

Click ![lyric_normal](../common/lyric_normal.svg) or <img src="../common/music.png" alt="music" style="zoom: 8%;" /> to toggle lyrics display.

> ![notes](../common/notes.svg) Note: If a song has a cover, <img src="../common/music.png" alt="music" style="zoom:8%;" /> becomes the cover; click it to view lyrics.

### Adjust Playback Mode

Click ![single](../common/single_tune_circulation_normal.svg) (Single Loop), ![cross_cycling_normal](../common/cross_cycling_normal.svg) (Shuffle), or ![sequential_loop_normal](../common/sequential_loop_normal.svg) (List Loop).

### Open in File Manager

1. Right-click a song.
2. Select **Open in File Manager** to locate its storage path.

![0|infile](fig/infile.png)

### Delete Music

Right-click a song in the playlist:
- **Remove from Playlist** > **Remove**: Removes from the list but keeps the local file.
- **Delete from Disk** > **Delete**: Permanently deletes the file.

![0|delete](fig/delete.png)

### Set Encoding

Fix garbled text by changing encoding:
1. Right-click a song.
2. Select **Encoding** and choose an alternative.

### View Song Info

1. Right-click a song.
2. Select **Song Info** to view details.

![0|info](fig/info.png)

## Playlist Management

Create, rename, delete playlists, or add songs to playlists.

> ![notes](../common/notes.svg) Note: **All Songs** (default, undeletable) contains every song. Manage favorites directly or via the toolbar.

### Add New Playlist

1. Click ![icon_plus](../common/add.svg) next to "My Playlists" or ![icon_menu](../common/icon_menu.svg) > **Add New Playlist**.
2. Enter a name and press **Enter**.

![0|music_list](fig/music_list.png)

### Rename Playlist

1. Select a playlist under "My Playlists".
2. Right-click and select **Rename**.
3. Enter a new name and press **Enter**.

![0|music_list](fig/rename.png)

### Add Songs to Playlist

1. Right-click a song.
2. Select **Add to** > [Playlist Name].

> ![tips](../common/tips.svg) Tip: Drag songs directly into a playlist.

![0|addtolist](fig/addtolist.png)

### Remove Songs from Playlist

1. Select a song under a playlist.
2. Right-click and select **Remove from Playlist**.

![0|remove](fig/remove.png)

### Delete Playlist

1. Right-click a playlist under "My Playlists".
2. Select **Delete** > **Delete** in the dialog.

![0|deletelist](fig/deletelist.png)

## Main Menu

Add playlists, add music, adjust equalizer, configure settings, switch themes, view help, etc.

### Equalizer

Adjust audio quality for optimal sound:
1. Click ![icon_menu](../common/icon_menu.svg) > **Equalizer**.
2. Enable **Equalizer**, customize "Preamp" and frequency bands, then click **Save**. Or select a preset mode (auto-saved).
3. Click **Restore Defaults** to reset.

<img src="fig/equalizer.png" alt="equalizer" style="zoom:67%;" />

### Settings

#### Basic Settings
1. Click ![icon_menu](../common/icon_menu.svg) > **Settings**.
   - **Playback**:
     - **Auto-play on startup**: Play music when Music launches.
     - **Remember last playback position**: Resume progress on startup.
     - **Enable fade in/out**: Gradual volume change when starting/stopping playback.
   - **Close Main Window**:
     - **Minimize to system tray**: Hide to tray when closed.
     - **Exit**: Quit the application.
     - **Ask every time**: Confirm before closing.

#### Shortcut Settings
1. Navigate to **Settings** > **Shortcuts**.
2. View or customize shortcuts.

### Theme
Switch themes (Light, Dark, System):
1. Click ![icon_menu](../common/icon_menu.svg) > **Theme**.
2. Select a theme.

### Help
View the help manual:
1. Click ![icon_menu](../common/icon_menu.svg) > **Help**.

### About
View version and info:
1. Click ![icon_menu](../common/icon_menu.svg) > **About**.

### Exit
Quit Music:
1. Click ![icon_menu](../common/icon_menu.svg) > **Exit**.