---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, syntaxe, 
              erreur de BibTeX, chaîne trop longue
---

# Comment gérer une chaîne trop longue dans BibTeX ?

Parfois BibTeX donne l'avertissement suivant :

```text
Warning--you've exceeded 1000, the global-string-size, for entry
XXX
while executing--line 42 of file ma_biblio.bst
*Please notify the bibstyle designer*
```

Il est généralement du à deux causes simultanées :
- un résumé ou une annotation avec un volume de texte important dans la base
  de données ;
- l'utilisation du style bibliographique `abstract.bst` ou des styles 
  qui en sont dérivés (dans la mesure où il n'y a généralement pas 
  d'annotations dans les autres styles).


## Avec une modification du fichier de style bibliographique

La solution est de faire une copie du fichier de style (par exemple 
`abstract-long.bst`). Maintenant, éditez-le :

- trouvez la fonction `output.nonnull`. Sa première ligne (ligne 60 
  dans la version sur le CTAN) doit être :

  ```{noedit}
  { 's :=
  ```

- changez cette ligne en

  ```{noedit}
  { swap$
  ```

- enfin, supprimez la dernière ligne de la fonction, qui dit simplement `s`
  (ligne 84 dans la version sur CTAN).

Enfin, modifiez votre commande `\bibliographystyle{⟨style⟩}` pour qu'elle fasse
référence au nom du nouveau fichier de `⟨style⟩`.

Cette technique s'applique également à n'importe quel style bibliographique : 
la même modification peut être apportée à n'importe quelle fonction 
`output.nonnull` similaire.


## Avec une modification de l'entrée bibliographique

Si vous êtes réticent à faire ce genre de changement, la seule solution serait
de retirer l'entrée de la base de données, afin de ne pas rencontrer la limite
de BibTeX, mais vous pouvez avoir besoin de conserver l'entrée 
parce qu'elle sera incluse dans le document dactylographié. Dans ce cas, 
placez le corps de l'entrée dans un fichier séparé :

```bibtex
@article{longggggggg,
  author   =  "Fred Bavard",
  ...      = "...",
  abstract =  "{\input{abstracts/long.tex}}
}
```

De cette façon, BibTeX ne s'occupe que du nom du fichier, mais il demande bien
à TeX (le cas échéant) d'inclure votre texte long présent 
dans le fichier `long.tex`.


:::{sources}
[String too long in BibTeX](faquk:FAQ-bibstrtl)
:::