---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, index, hiérarchie, 
              index hiérarchique
---

# Comment construire un index hiérarchique ?

Pour cela, il faut utiliser la construction suivante :

```{noedit}
\index{niveau un!niveau deux}
```

Cela va donner dans ce cas une entrée "niveau deux" au-dessous de l'entrée 
"niveau un". Des entrées de niveau trois, quatre et suivants sont possibles
en suivant la même logique, le symbole `!` indiquant le passage du niveau "N"
au niveau "N+1". L'exemple ci-dessous, plus complet, illustre en particulier
deux cas d'entrées de niveau trois :

```{noedit}
\documentclass[french]{report}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{makeidx}

  \makeindex

\begin{document}
\chapter{Sports.}
Le sport\index{Sport} c'est fantastique ! Mes sports préférés sont :
\begin{itemize}
   \item l'escalade\index{Sport!Escalade} et surtout les sorties en falaise ;
   \item l'équitation\index{Sport!Equitation} et en particulier 
     les disciplines de dressage\index{Sport!Equitation!Dressage} et de
     complet\index{Sport!Equitation!Complet} ;
   \item le judo\index{Sport!Judo}.
\end{itemize}

\printindex
\end{document}
```