/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.HmacCore;
import com.sun.crypto.provider.PKCS12PBECipherCore;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class HmacPKCS12PBECore
extends HmacCore {
    private final String algorithm;
    private final int bl;

    public HmacPKCS12PBECore(String string, int n) throws NoSuchAlgorithmException {
        super(string, n);
        this.algorithm = string;
        this.bl = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        char[] cArray;
        Object object;
        int n;
        byte[] byArray;
        block22: {
            block23: {
                block25: {
                    block24: {
                        block21: {
                            byArray = null;
                            n = 0;
                            if (!(key instanceof PBEKey)) break block21;
                            object = (PBEKey)key;
                            cArray = object.getPassword();
                            byArray = object.getSalt();
                            n = object.getIterationCount();
                            break block22;
                        }
                        if (!(key instanceof SecretKey)) break block23;
                        if (!key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) break block24;
                        byte[] byArray2 = key.getEncoded();
                        object = byArray2;
                        if (byArray2 != null) break block25;
                    }
                    throw new InvalidKeyException("Missing password");
                }
                cArray = new char[((Object)object).length];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = (char)(object[i] & 0x7F);
                }
                Arrays.fill((byte[])object, (byte)0);
                break block22;
            }
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        try {
            if (algorithmParameterSpec == null) {
                if (byArray == null || n == 0) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec required for salt and iteration count");
                }
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
                }
                PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
                if (byArray != null) {
                    if (!Arrays.equals(byArray, pBEParameterSpec.getSalt())) {
                        throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                    }
                } else {
                    byArray = pBEParameterSpec.getSalt();
                }
                if (n != 0) {
                    if (n != pBEParameterSpec.getIterationCount()) {
                        throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                    }
                } else {
                    n = pBEParameterSpec.getIterationCount();
                }
            }
            if (byArray.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            if (n <= 0) {
                throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
            }
            object = PKCS12PBECipherCore.derive(cArray, byArray, n, this.engineGetMacLength(), 3, this.algorithm, this.bl);
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "HmacSHA1");
        super.engineInit(secretKeySpec, null);
    }

    public static final class HmacPKCS12PBE_SHA512_256
    extends HmacPKCS12PBECore {
        public HmacPKCS12PBE_SHA512_256() throws NoSuchAlgorithmException {
            super("SHA-512/256", 128);
        }
    }

    public static final class HmacPKCS12PBE_SHA512_224
    extends HmacPKCS12PBECore {
        public HmacPKCS12PBE_SHA512_224() throws NoSuchAlgorithmException {
            super("SHA-512/224", 128);
        }
    }

    public static final class HmacPKCS12PBE_SHA512
    extends HmacPKCS12PBECore {
        public HmacPKCS12PBE_SHA512() throws NoSuchAlgorithmException {
            super("SHA-512", 128);
        }
    }

    public static final class HmacPKCS12PBE_SHA384
    extends HmacPKCS12PBECore {
        public HmacPKCS12PBE_SHA384() throws NoSuchAlgorithmException {
            super("SHA-384", 128);
        }
    }

    public static final class HmacPKCS12PBE_SHA256
    extends HmacPKCS12PBECore {
        public HmacPKCS12PBE_SHA256() throws NoSuchAlgorithmException {
            super("SHA-256", 64);
        }
    }

    public static final class HmacPKCS12PBE_SHA224
    extends HmacPKCS12PBECore {
        public HmacPKCS12PBE_SHA224() throws NoSuchAlgorithmException {
            super("SHA-224", 64);
        }
    }

    public static final class HmacPKCS12PBE_SHA1
    extends HmacPKCS12PBECore {
        public HmacPKCS12PBE_SHA1() throws NoSuchAlgorithmException {
            super("SHA1", 64);
        }
    }
}

