#include <err.h>
#include <fcntl.h>
#include <signal.h>
#include <stddef.h>
#include <sys/time.h>
#include <unistd.h>

static void
sigalrm_handler(int sig)
{}

int
main(void)
{
	struct sigaction sig_act = {
		.sa_handler = sigalrm_handler,
		.sa_flags = SA_RESTART,
	};
	struct itimerval timer = {
		.it_value = { .tv_usec = 10000 },
		.it_interval = { .tv_usec = 10000 },
	};
	unsigned long long it = 0;

	if (sigaction(SIGALRM, &sig_act, NULL) < 0)
		err(111, "sigaction(SIGALRM, ...)");

	/* kill with SIGALRM repeatedly, to race for -EINTR on the caught syscall */
	if (setitimer(ITIMER_REAL, &timer, NULL) < 0)
		err(111, "setitimer()");

	for (;;) {
		int fd;

		fd = open("test", O_CREAT | O_EXCL | O_WRONLY, 0644);
		if (fd < 0)
			err(111, "fatal: unable to create 'test'");

		close(fd);

		if (unlink("test") < 0)
			err(111, "fatal: unable to remove 'test'");

		it++;

		if (!(it % 1000))
			warnx("finished %llu iterations", it);
	}

	return 0;
}
