/*
Apple never published a database of OSType codes for File Types.  However,
a database of known OSType codes representing Creators and File Types used on
Apple systems prior to 2003 is available at:

   http://www.lacikam.co.il/tcdb/download/TCDBdata.zip

Among the 12034 distinct OSType codes for File Types that are listed in the TCDB
database, there are 121 for which the UTTypeCreatePreferredIdentifierForTag
function (deprecated in macOS 12.0) was able to generate a Uniform Type
Identifier on macOS 12.5.1.  The mapping from those OSTypes to Uniform Type
identifiers is given by the following array, in which OSTypes are represented as
strings of length 4.
*/

typedef struct {
  char *ostype;
  char *identifier;
} IdentifierForOSType;

static const IdentifierForOSType OSTypeDB[] = {
    {".SGI", "com.sgi.sgi-image"},
    {".WAV", "com.microsoft.waveform-audio"},
    {"8BPS", "com.adobe.photoshop-image"},
    {"ABPR", "com.apple.addressbook.person"},
    {"AIFC", "public.aifc-audio"},
    {"AIFF", "public.aiff-audio"},
    {"APPC", "com.apple.deprecated-application-file"},
    {"APPD", "com.apple.deprecated-application-file"},
    {"APPL", "com.apple.application-bundle"},
    {"ASF_", "com.microsoft.advanced-systems-format"},
    {"ASX_", "com.microsoft.advanced-stream-redirector"},
    {"BMP ", "com.microsoft.bmp"},
    {"BMPf", "com.microsoft.bmp"},
    {"BNDL", "com.apple.generic-bundle"},
    {"DDim", "com.apple.disk-image-raw"},
    {"DICM", "org.nema.dicom"},
    {"DOTM", "org.openxmlformats.wordprocessingml.template.macro-enabled"},
    {"EM3F", "com.apple.logic-song"},
    {"EPSF", "com.adobe.encapsulated-postscript"},
    {"FFIL", "com.apple.font-suitcase"},
    {"FLI ", "public.flc-animation"},
    {"FNDR", "com.apple.legacy.finder-icon"},
    {"GIFf", "com.compuserve.gif"},
    {"HTML", "public.html"},
    {"JPEG", "public.jpeg"},
    {"LWFN", "com.adobe.postscript-lwfn-font"},
    {"MP3 ", "public.mp3"},
    {"MP3!", "public.mp3"},
    {"MP3U", "com.apple.tv.m3u-playlist"},
    {"MPEG", "public.mpeg"},
    {"MPG ", "public.mpeg"},
    {"MPG2", "com.apple.music.mp2"},
    {"MPG3", "public.mp3"},
    {"Midi", "public.midi-audio"},
    {"MooV", "com.apple.quicktime-movie"},
    {"Mp3 ", "public.mp3"},
    {"PAT ", "org.gimp.pat"},
    {"PDF ", "com.adobe.pdf"},
    {"PICT", "com.apple.pict"},
    {"PNGf", "public.png"},
    {"PNRA", "com.real.realaudio"},
    {"PNRM", "com.real.realmedia"},
    {"PNTG", "com.apple.macpaint-image"},
    {"PPOT", "com.microsoft.powerpoint.pot"},
    {"PPSS", "com.microsoft.powerpoint.pps"},
    {"RTF ", "public.rtf"},
    {"SDP ", "public.sdp"},
    {"SIT5", "com.stuffit.archive.sit"},
    {"SLD8", "com.microsoft.powerpoint.ppt"},
    {"Sd2f", "com.digidesign.sd2-audio"},
    {"TEXT", "com.apple.traditional-mac-plain-text"},
    {"TIFF", "public.tiff"},
    {"TPIC", "com.truevision.tga-image"},
    {"ULAW", "public.ulaw-audio"},
    {"VfW ", "public.avi"},
    {"W8BN", "com.microsoft.word.doc"},
    {"W8TN", "com.microsoft.word.dot"},
    {"WAVE", "com.microsoft.waveform-audio"},
    {"XLA5", "com.microsoft.excel.xla"},
    {"XLS8", "com.microsoft.excel.xls"},
    {"XLW8", "com.microsoft.excel.xlw"},
    {"alis", "com.apple.alias-record"},
    {"appe", "com.apple.deprecated-application-file"},
    {"cdev", "com.apple.deprecated-application-file"},
    {"clpp", "com.apple.finder.pictclipping"},
    {"clps", "com.apple.finder.sound-clipping"},
    {"clpt", "com.apple.finder.textclipping"},
    {"clpu", "com.apple.finder.clipping"},
    {"ctrl", "com.apple.legacy.finder-icon"},
    {"dfil", "com.apple.deprecated-application-file"},
    {"dict", "com.apple.document-type.dictionary"},
    {"disk", "public.volume"},
    {"docs", "com.apple.documents-folder"},
    {"dvc!", "public.dv-movie"},
    {"ffil", "com.apple.font-suitcase"},
    {"flpy", "com.apple.storage-removable"},
    {"fold", "public.folder"},
    {"font", "com.apple.legacy.finder-icon"},
    {"grup", "com.apple.user-group"},
    {"hdrv", "com.apple.disk-image-raw"},
    {"hdsk", "com.apple.storage-internal"},
    {"help", "com.apple.help-document"},
    {"hkdb", "com.apple.itunes.db"},
    {"hvpl", "com.apple.music.visual"},
    {"ilaf", "com.apple.afp-internet-location"},
    {"ilfi", "com.apple.file-internet-location"},
    {"ilft", "com.apple.ftp-internet-location"},
    {"ilge", "com.apple.generic-internet-location"},
    {"ilht", "com.apple.web-internet-location"},
    {"ilma", "com.apple.mail-internet-location"},
    {"ilnw", "com.apple.news-internet-location"},
    {"macD", "com.apple.legacy.finder-icon"},
    {"mp3!", "public.mp3"},
    {"mpg3", "public.mp3"},
    {"note", "com.apple.alert-note"},
    {"osas", "com.apple.applescript.script"},
    {"plug", "com.apple.plugin"},
    {"pref", "com.apple.legacy.finder-icon"},
    {"prfb", "com.apple.icon-overlay.private-folder-badge"},
    {"prof", "com.apple.colorsync-profile"},
    {"qtif", "com.apple.quicktime-image"},
    {"sLS8", "com.microsoft.excel.xlt"},
    {"sM3F", "com.apple.logic-song"},
    {"sbBF", "com.apple.finder.burn-folder"},
    {"scrp", "com.apple.legacy.finder-icon"},
    {"sdoc", "com.apple.generic-stationery"},
    {"sfnt", "com.apple.font-suitcase"},
    {"shlb", "com.apple.legacy.finder-icon"},
    {"srvr", "com.apple.file-server"},
    {"svg ", "public.svg-image"},
    {"svgz", "public.svg-image"},
    {"tDoc", "com.apple.documents-folder"},
    {"tfil", "com.apple.font-suitcase"},
    {"trsh", "com.apple.trash-empty"},
    {"ttcf", "public.truetype-collection-font"},
    {"ttro", "com.apple.traditional-mac-plain-text"},
    {"txtn", "com.apple.txn.text-multimedia-data"},
    {"url ", "public.url"},
    {"user", "com.apple.user"},
    {"utxt", "public.utf16-plain-text"},
    {"vCrd", "public.vcard"},
    {NULL, NULL}
};
