/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Qualcomm MSM8996 interconnect IDs
 *
 * Copyright (c) 2021 Yassine Oudjana <y.oudjana@protonmail.com>
 */

#ifndef __DRIVERS_INTERCONNECT_QCOM_MSM8996_H__
#define __DRIVERS_INTERCONNECT_QCOM_MSM8996_H__

#define MSM8996_MASTER_PCIE_0				1
#define MSM8996_MASTER_PCIE_1				2
#define MSM8996_MASTER_PCIE_2				3
#define MSM8996_MASTER_CNOC_A1NOC			4
#define MSM8996_MASTER_CRYPTO_CORE0			5
#define MSM8996_MASTER_PNOC_A1NOC			6
#define MSM8996_MASTER_USB3				7
#define MSM8996_MASTER_IPA				8
#define MSM8996_MASTER_UFS				9
#define MSM8996_MASTER_AMPSS_M0				10
#define MSM8996_MASTER_GRAPHICS_3D			11
#define MSM8996_MASTER_MNOC_BIMC			12
#define MSM8996_MASTER_SNOC_BIMC			13
#define MSM8996_MASTER_SNOC_CNOC			14
#define MSM8996_MASTER_QDSS_DAP				15
#define MSM8996_MASTER_CNOC_MNOC_MMSS_CFG		16
#define MSM8996_MASTER_CNOC_MNOC_CFG			17
#define MSM8996_MASTER_CPP				18
#define MSM8996_MASTER_JPEG				19
#define MSM8996_MASTER_MDP_PORT0			20
#define MSM8996_MASTER_MDP_PORT1			21
#define MSM8996_MASTER_ROTATOR				22
#define MSM8996_MASTER_VIDEO_P0				23
#define MSM8996_MASTER_VFE				24
#define MSM8996_MASTER_SNOC_VMEM			25
#define MSM8996_MASTER_VIDEO_P0_OCMEM			26
#define MSM8996_MASTER_SNOC_PNOC			27
#define MSM8996_MASTER_SDCC_1				28
#define MSM8996_MASTER_SDCC_2				29
#define MSM8996_MASTER_SDCC_4				30
#define MSM8996_MASTER_USB_HS				31
#define MSM8996_MASTER_BLSP_1				32
#define MSM8996_MASTER_BLSP_2				33
#define MSM8996_MASTER_TSIF				34
#define MSM8996_MASTER_HMSS				35
#define MSM8996_MASTER_QDSS_BAM				36
#define MSM8996_MASTER_SNOC_CFG				37
#define MSM8996_MASTER_BIMC_SNOC_0			38
#define MSM8996_MASTER_BIMC_SNOC_1			39
#define MSM8996_MASTER_A0NOC_SNOC			40
#define MSM8996_MASTER_A1NOC_SNOC			41
#define MSM8996_MASTER_A2NOC_SNOC			42
#define MSM8996_MASTER_QDSS_ETR				43

#define MSM8996_SLAVE_A0NOC_SNOC			44
#define MSM8996_SLAVE_A1NOC_SNOC			45
#define MSM8996_SLAVE_A2NOC_SNOC			46
#define MSM8996_SLAVE_EBI_CH0				47
#define MSM8996_SLAVE_HMSS_L3				48
#define MSM8996_SLAVE_BIMC_SNOC_0			49
#define MSM8996_SLAVE_BIMC_SNOC_1			50
#define MSM8996_SLAVE_CNOC_A1NOC			51
#define MSM8996_SLAVE_CLK_CTL				52
#define MSM8996_SLAVE_TCSR				53
#define MSM8996_SLAVE_TLMM				54
#define MSM8996_SLAVE_CRYPTO_0_CFG			55
#define MSM8996_SLAVE_MPM				56
#define MSM8996_SLAVE_PIMEM_CFG				57
#define MSM8996_SLAVE_IMEM_CFG				58
#define MSM8996_SLAVE_MESSAGE_RAM			59
#define MSM8996_SLAVE_BIMC_CFG				60
#define MSM8996_SLAVE_PMIC_ARB				61
#define MSM8996_SLAVE_PRNG				62
#define MSM8996_SLAVE_DCC_CFG				63
#define MSM8996_SLAVE_RBCPR_MX				64
#define MSM8996_SLAVE_QDSS_CFG				65
#define MSM8996_SLAVE_RBCPR_CX				66
#define MSM8996_SLAVE_QDSS_RBCPR_APU_CFG		67
#define MSM8996_SLAVE_CNOC_MNOC_CFG			68
#define MSM8996_SLAVE_SNOC_CFG				69
#define MSM8996_SLAVE_SNOC_MPU_CFG			70
#define MSM8996_SLAVE_EBI1_PHY_CFG			71
#define MSM8996_SLAVE_A0NOC_CFG				72
#define MSM8996_SLAVE_PCIE_1_CFG			73
#define MSM8996_SLAVE_PCIE_2_CFG			74
#define MSM8996_SLAVE_PCIE_0_CFG			75
#define MSM8996_SLAVE_PCIE20_AHB2PHY			76
#define MSM8996_SLAVE_A0NOC_MPU_CFG			77
#define MSM8996_SLAVE_UFS_CFG				78
#define MSM8996_SLAVE_A1NOC_CFG				79
#define MSM8996_SLAVE_A1NOC_MPU_CFG			80
#define MSM8996_SLAVE_A2NOC_CFG				81
#define MSM8996_SLAVE_A2NOC_MPU_CFG			82
#define MSM8996_SLAVE_SSC_CFG				83
#define MSM8996_SLAVE_A0NOC_SMMU_CFG			84
#define MSM8996_SLAVE_A1NOC_SMMU_CFG			85
#define MSM8996_SLAVE_A2NOC_SMMU_CFG			86
#define MSM8996_SLAVE_LPASS_SMMU_CFG			87
#define MSM8996_SLAVE_CNOC_MNOC_MMSS_CFG		88
#define MSM8996_SLAVE_MMAGIC_CFG			89
#define MSM8996_SLAVE_CPR_CFG				90
#define MSM8996_SLAVE_MISC_CFG				91
#define MSM8996_SLAVE_VENUS_THROTTLE_CFG		92
#define MSM8996_SLAVE_VENUS_CFG				93
#define MSM8996_SLAVE_VMEM_CFG				94
#define MSM8996_SLAVE_DSA_CFG				95
#define MSM8996_SLAVE_MMSS_CLK_CFG			96
#define MSM8996_SLAVE_DSA_MPU_CFG			97
#define MSM8996_SLAVE_MNOC_MPU_CFG			98
#define MSM8996_SLAVE_DISPLAY_CFG			99
#define MSM8996_SLAVE_DISPLAY_THROTTLE_CFG		100
#define MSM8996_SLAVE_CAMERA_CFG			101
#define MSM8996_SLAVE_CAMERA_THROTTLE_CFG		102
#define MSM8996_SLAVE_GRAPHICS_3D_CFG			103
#define MSM8996_SLAVE_SMMU_MDP_CFG			104
#define MSM8996_SLAVE_SMMU_ROTATOR_CFG			105
#define MSM8996_SLAVE_SMMU_VENUS_CFG			106
#define MSM8996_SLAVE_SMMU_CPP_CFG			107
#define MSM8996_SLAVE_SMMU_JPEG_CFG			108
#define MSM8996_SLAVE_SMMU_VFE_CFG			109
#define MSM8996_SLAVE_MNOC_BIMC				110
#define MSM8996_SLAVE_VMEM				111
#define MSM8996_SLAVE_SERVICE_MNOC			112
#define MSM8996_SLAVE_PNOC_A1NOC			113
#define MSM8996_SLAVE_USB_HS				114
#define MSM8996_SLAVE_SDCC_2				115
#define MSM8996_SLAVE_SDCC_4				116
#define MSM8996_SLAVE_TSIF				117
#define MSM8996_SLAVE_BLSP_2				118
#define MSM8996_SLAVE_SDCC_1				119
#define MSM8996_SLAVE_BLSP_1				120
#define MSM8996_SLAVE_PDM				121
#define MSM8996_SLAVE_AHB2PHY				122
#define MSM8996_SLAVE_APPSS				123
#define MSM8996_SLAVE_LPASS				124
#define MSM8996_SLAVE_USB3				125
#define MSM8996_SLAVE_SNOC_BIMC				126
#define MSM8996_SLAVE_SNOC_CNOC				127
#define MSM8996_SLAVE_OCIMEM				128
#define MSM8996_SLAVE_PIMEM				129
#define MSM8996_SLAVE_SNOC_VMEM				130
#define MSM8996_SLAVE_SNOC_PNOC				131
#define MSM8996_SLAVE_QDSS_STM				132
#define MSM8996_SLAVE_PCIE_0				133
#define MSM8996_SLAVE_PCIE_1				134
#define MSM8996_SLAVE_PCIE_2				135
#define MSM8996_SLAVE_SERVICE_SNOC			136

#endif /* __DRIVERS_INTERCONNECT_QCOM_MSM8996_H__ */
