// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::create_bucket_metadata_table_configuration::_create_bucket_metadata_table_configuration_output::CreateBucketMetadataTableConfigurationOutputBuilder;

pub use crate::operation::create_bucket_metadata_table_configuration::_create_bucket_metadata_table_configuration_input::CreateBucketMetadataTableConfigurationInputBuilder;

impl crate::operation::create_bucket_metadata_table_configuration::builders::CreateBucketMetadataTableConfigurationInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.create_bucket_metadata_table_configuration();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `CreateBucketMetadataTableConfiguration`.
///
/// <p>Creates a metadata table configuration for a general purpose bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/metadata-tables-overview.html">Accelerating data discovery with S3 Metadata</a> in the <i>Amazon S3 User Guide</i>.</p>
/// <dl>
/// <dt>
/// Permissions
/// </dt>
/// <dd>
/// <p>To use this operation, you must have the following permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/metadata-tables-permissions.html">Setting up permissions for configuring metadata tables</a> in the <i>Amazon S3 User Guide</i>.</p>
/// <p>If you also want to integrate your table bucket with Amazon Web Services analytics services so that you can query your metadata table, you need additional permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-integrating-aws.html"> Integrating Amazon S3 Tables with Amazon Web Services analytics services</a> in the <i>Amazon S3 User Guide</i>.</p>
/// <ul>
/// <li>
/// <p><code>s3:CreateBucketMetadataTableConfiguration</code></p></li>
/// <li>
/// <p><code>s3tables:CreateNamespace</code></p></li>
/// <li>
/// <p><code>s3tables:GetTable</code></p></li>
/// <li>
/// <p><code>s3tables:CreateTable</code></p></li>
/// <li>
/// <p><code>s3tables:PutTablePolicy</code></p></li>
/// </ul>
/// </dd>
/// </dl>
/// <p>The following operations are related to <code>CreateBucketMetadataTableConfiguration</code>:</p>
/// <ul>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetadataTableConfiguration.html">DeleteBucketMetadataTableConfiguration</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetadataTableConfiguration.html">GetBucketMetadataTableConfiguration</a></p></li>
/// </ul>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct CreateBucketMetadataTableConfigurationFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::create_bucket_metadata_table_configuration::builders::CreateBucketMetadataTableConfigurationInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationOutput,
        crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError,
    > for CreateBucketMetadataTableConfigurationFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationOutput,
            crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl CreateBucketMetadataTableConfigurationFluentBuilder {
    /// Creates a new `CreateBucketMetadataTableConfigurationFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the CreateBucketMetadataTableConfiguration as a reference.
    pub fn as_input(
        &self,
    ) -> &crate::operation::create_bucket_metadata_table_configuration::builders::CreateBucketMetadataTableConfigurationInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins =
            crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfiguration::operation_runtime_plugins(
                self.handle.runtime_plugins.clone(),
                &self.handle.conf,
                self.config_override,
            );
        crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfiguration::orchestrate(&runtime_plugins, input)
            .await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationOutput,
        crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The general purpose bucket that you want to create the metadata table configuration in.</p>
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.bucket(input.into());
        self
    }
    /// <p>The general purpose bucket that you want to create the metadata table configuration in.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_bucket(input);
        self
    }
    /// <p>The general purpose bucket that you want to create the metadata table configuration in.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_bucket()
    }
    /// <p>The <code>Content-MD5</code> header for the metadata table configuration.</p>
    pub fn content_md5(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_md5(input.into());
        self
    }
    /// <p>The <code>Content-MD5</code> header for the metadata table configuration.</p>
    pub fn set_content_md5(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_md5(input);
        self
    }
    /// <p>The <code>Content-MD5</code> header for the metadata table configuration.</p>
    pub fn get_content_md5(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_md5()
    }
    /// <p>The checksum algorithm to use with your metadata table configuration.</p>
    pub fn checksum_algorithm(mut self, input: crate::types::ChecksumAlgorithm) -> Self {
        self.inner = self.inner.checksum_algorithm(input);
        self
    }
    /// <p>The checksum algorithm to use with your metadata table configuration.</p>
    pub fn set_checksum_algorithm(mut self, input: ::std::option::Option<crate::types::ChecksumAlgorithm>) -> Self {
        self.inner = self.inner.set_checksum_algorithm(input);
        self
    }
    /// <p>The checksum algorithm to use with your metadata table configuration.</p>
    pub fn get_checksum_algorithm(&self) -> &::std::option::Option<crate::types::ChecksumAlgorithm> {
        self.inner.get_checksum_algorithm()
    }
    /// <p>The contents of your metadata table configuration.</p>
    pub fn metadata_table_configuration(mut self, input: crate::types::MetadataTableConfiguration) -> Self {
        self.inner = self.inner.metadata_table_configuration(input);
        self
    }
    /// <p>The contents of your metadata table configuration.</p>
    pub fn set_metadata_table_configuration(mut self, input: ::std::option::Option<crate::types::MetadataTableConfiguration>) -> Self {
        self.inner = self.inner.set_metadata_table_configuration(input);
        self
    }
    /// <p>The contents of your metadata table configuration.</p>
    pub fn get_metadata_table_configuration(&self) -> &::std::option::Option<crate::types::MetadataTableConfiguration> {
        self.inner.get_metadata_table_configuration()
    }
    /// <p>The expected owner of the general purpose bucket that contains your metadata table configuration.</p>
    pub fn expected_bucket_owner(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.expected_bucket_owner(input.into());
        self
    }
    /// <p>The expected owner of the general purpose bucket that contains your metadata table configuration.</p>
    pub fn set_expected_bucket_owner(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_expected_bucket_owner(input);
        self
    }
    /// <p>The expected owner of the general purpose bucket that contains your metadata table configuration.</p>
    pub fn get_expected_bucket_owner(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_expected_bucket_owner()
    }
}
