---
title: "rclone completion bash"
description: "Output bash completion script for rclone."
aliases:
  - /commands/rclone_genautocomplete_bash/
# autogenerated - DO NOT EDIT, instead edit the source code in cmd/completion/bash/ and as part of making a release run "make commanddocs"
---
# rclone completion bash

Output bash completion script for rclone.

## Synopsis

Generates a bash shell autocompletion script for rclone.

By default, when run without any arguments,

```console
rclone completion bash
```

the generated script will be written to

```console
/etc/bash_completion.d/rclone
```

and so rclone will probably need to be run as root, or with sudo.

If you supply a path to a file as the command line argument, then
the generated script will be written to that file, in which case
you should not need root privileges.

If output_file is "-", then the output will be written to stdout.

If you have installed the script into the default location, you
can logout and login again to use the autocompletion script.

Alternatively, you can source the script directly

```console
. /path/to/my_bash_completion_scripts/rclone
```

and the autocompletion functionality will be added to your
current shell.

```
rclone completion bash [output_file] [flags]
```

## Options

```
  -h, --help   help for bash
```

See the [global flags page](/flags/) for global options not listed here.

## See Also

<!-- markdownlint-capture -->
<!-- markdownlint-disable ul-style line-length -->

* [rclone completion](/commands/rclone_completion/)	 - Output completion script for a given shell.


<!-- markdownlint-restore -->
