/*
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 */ 
package org.apache.rat.analysis.generation;

import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

/**
 * JavaDocs are generated and so no license is required.
 * It is useful to note these separately.
 */
public class JavaDocLicenseNotRequired implements IHeaderMatcher {

    private static final String JAVADOC_REGEX_DEFN = "Generated by javadoc";
    
    public boolean match(Document subject, String line) throws RatHeaderAnalysisException {
        boolean result = line.contains(JAVADOC_REGEX_DEFN);
        if (result) {
            reportOnLicense(subject);
        }
        return result;
    }

    private void reportOnLicense(Document subject) {
        subject.getMetaData().set(MetaData.RAT_LICENSE_FAMILY_CATEGORY_DATUM_GEN);
    }
    
    public void reset() {
        // stateless
    }
}
