# Copyright (c) 2024 Broadcom, Inc.  All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the “License”); you may not
# use this file except in compliance with the License.  You may obtain a copy of
# the License at:
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed
# under the License is distributed on an “AS IS” BASIS, without warranties or
# conditions of any kind, EITHER EXPRESS OR IMPLIED.  See the License for the
# specific language governing permissions and limitations under the License.

import glob
import os
import pytest
import shutil
import subprocess
import yaml
import xmltodict


THIS_DIR = os.path.dirname(os.path.abspath(__file__))
OVA_COMPOSE = os.path.join(THIS_DIR, "..", "ova-compose", "ova-compose.py")

VMDK_CONVERT=os.path.join(THIS_DIR, "..", "build", "vmdk", "vmdk-convert")

CONFIG_DIR=os.path.join(THIS_DIR, "configs")

WORK_DIR=os.path.join(os.getcwd(), "pytest-configs")


def test_disk_file_id(setup_test):
    disk_id = "foo_id"
    file_id = "bar_id"
    in_yaml = os.path.join(CONFIG_DIR, "custom_disk_id.yaml")

    basename = os.path.basename(in_yaml.rsplit(".", 1)[0])
    out_ovf = os.path.join(WORK_DIR, f"{basename}.ovf")

    process = subprocess.run([OVA_COMPOSE, "-i", in_yaml, "-o", out_ovf,
                              "--param", f"rootdisk=dummy.vmdk",
                              "--param", f"disk_id={disk_id}",
                              "--param", f"file_id={file_id}",
                              "--vmdk-convert", VMDK_CONVERT
                             ],
                             cwd=WORK_DIR)
    assert process.returncode == 0

    with open(out_ovf) as f:
        ovf = xmltodict.parse(f.read())

    assert ovf['Envelope']['References']['File']['@ovf:id'] == file_id
    assert ovf['Envelope']['DiskSection']['Disk']['@ovf:diskId'] == disk_id
