/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.error;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterErrorOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.console.JupyterOutputConsoleView;
import com.intellij.jupyter.core.jupyter.editor.outputs.error.ErrorOutputContentProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.error.ErrorTextOutputComponent;
import com.intellij.jupyter.core.jupyter.editor.outputs.error.JupyterErrorOutputCustomizer;
import com.intellij.jupyter.core.jupyter.editor.outputs.error.JupyterErrorOutputFiltersProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.util.ConsoleViewUtilsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\nH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/JupyterErrorOutputConsoleView;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/console/JupyterOutputConsoleView;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterErrorOutputDataKey;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "parentComponent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/ErrorTextOutputComponent;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/ErrorTextOutputComponent;)V", "exceptionType", "", "exceptionValue", "errorFilters", "", "Lcom/intellij/execution/filters/Filter;", "setContent", "", "outputDataKey", "loadFilterList", "updateFoldings", "startLine", "", "endLine", "getFoldTitle", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterErrorOutputConsoleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterErrorOutputConsoleView.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/error/JupyterErrorOutputConsoleView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,88:1\n808#2,11:89\n1869#2,2:100\n1374#2:102\n1460#2,5:103\n1563#2:108\n1634#2,3:109\n24#3:112\n*S KotlinDebug\n*F\n+ 1 JupyterErrorOutputConsoleView.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/error/JupyterErrorOutputConsoleView\n*L\n36#1:89,11\n36#1:100,2\n47#1:102\n47#1:103,5\n56#1:108\n56#1:109,3\n68#1:112\n*E\n"})
public final class JupyterErrorOutputConsoleView
extends JupyterOutputConsoleView<JupyterErrorOutputDataKey> {
    @Nullable
    private String exceptionType;
    @Nullable
    private String exceptionValue;
    @NotNull
    private List<? extends Filter> errorFilters;

    public JupyterErrorOutputConsoleView(@NotNull EditorImpl editor, @NotNull ErrorTextOutputComponent parentComponent) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        super(editor, parentComponent);
        this.errorFilters = CollectionsKt.emptyList();
    }

    @Override
    public void setContent(@NotNull JupyterErrorOutputDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        boolean isTheSameError = Intrinsics.areEqual((Object)this.exceptionType, (Object)outputDataKey.getExceptionType()) && Intrinsics.areEqual((Object)this.exceptionValue, (Object)outputDataKey.getExceptionValue());
        this.exceptionType = outputDataKey.getExceptionType();
        this.exceptionValue = outputDataKey.getExceptionValue();
        List<String> contentStrings = ErrorOutputContentProvider.Companion.getContent(outputDataKey);
        ConsoleViewImpl consoleViewImpl = this;
        ProcessOutputType processOutputType = ProcessOutputType.STDERR;
        Intrinsics.checkNotNullExpressionValue((Object)processOutputType, (String)"STDERR");
        ConsoleViewUtilsKt.setContent(consoleViewImpl, contentStrings, processOutputType);
        if (!isTheSameError) {
            this.installFilters();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Filter> loadFilterList() {
        void $this$mapTo$iv$iv;
        List list;
        Iterable destination$iv$iv;
        Object object;
        Iterator $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.errorFilters;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof Disposable)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable it = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.errorFilters = CollectionsKt.emptyList();
        String type = this.exceptionType;
        String value = this.exceptionValue;
        List<Filter> superFilter = super.loadFilterList();
        JupyterErrorOutputConsoleView jupyterErrorOutputConsoleView = this;
        if (type != null && value != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Object element$iv;
            element$iv = JupyterErrorOutputFiltersProvider.Companion.getEP_NAME().getExtensionList();
            object = jupyterErrorOutputConsoleView;
            boolean $i$f$flatMap = false;
            void bl = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                JupyterErrorOutputFiltersProvider it = (JupyterErrorOutputFiltersProvider)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it.getFilters(this.getNotebookEditorImpl(), type, value);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
            jupyterErrorOutputConsoleView = object;
        } else {
            list = CollectionsKt.emptyList();
        }
        jupyterErrorOutputConsoleView.errorFilters = list;
        List finalFilters = CollectionsKt.plus((Collection)superFilter, (Iterable)this.errorFilters);
        Iterable $this$map$iv = JupyterErrorOutputFiltersProvider.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JupyterErrorOutputFiltersProvider bl2 = (JupyterErrorOutputFiltersProvider)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            it.updateFilters(finalFilters, this.getNotebookEditorImpl());
            object.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv3;
        return finalFilters;
    }

    protected void updateFoldings(int startLine, int endLine) {
        block1: {
            super.updateFoldings(startLine, endLine);
            String title = this.getFoldTitle();
            String type = this.exceptionType;
            if (type == null) {
                JupyterErrorOutputConsoleView $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterErrorOutputConsoleView.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Jupyter error output console view type is null");
                return;
            }
            Regex regex = new Regex("\\n\\h*" + Regex.Companion.escape(type) + ":");
            MatchResult matchResult = (MatchResult)SequencesKt.lastOrNull((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)this.getText(), (int)0, (int)2, null));
            if (matchResult == null) break block1;
            MatchResult match = matchResult;
            boolean bl = false;
            Editor editor = this.getEditor();
            Intrinsics.checkNotNull((Object)editor);
            FoldingModel $this$updateFoldings_u24lambda_u246_u24lambda_u245 = editor.getFoldingModel();
            boolean bl2 = false;
            $this$updateFoldings_u24lambda_u246_u24lambda_u245.runBatchFoldingOperation(() -> JupyterErrorOutputConsoleView.updateFoldings$lambda$6$lambda$5$lambda$4($this$updateFoldings_u24lambda_u246_u24lambda_u245, match, title, endLine, startLine));
        }
    }

    private final String getFoldTitle() {
        return JupyterErrorOutputCustomizer.Companion.getFoldedTextPlaceholder(JupyterEditorExtensionsKt.getNotebookOrNull((Editor)this.getNotebookEditorImpl()));
    }

    private static final void updateFoldings$lambda$6$lambda$5$lambda$4(FoldingModel $this_with, MatchResult $match, String $title, int $endLine, int $startLine) {
        block0: {
            FoldRegion foldRegion;
            FoldRegion foldRegion2 = $this_with.addFoldRegion(0, $match.getRange().getFirst(), $title);
            if (foldRegion2 == null) break block0;
            FoldRegion $this$updateFoldings_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243 = foldRegion = foldRegion2;
            boolean bl = false;
            $this$updateFoldings_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.setExpanded($endLine - $startLine <= 100);
        }
    }
}

