// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

// inspiredBy [org/intellij/plugins/markdown/extensions/jcef/processLinks/processLinks.js]
if (window.__IntelliJTools === undefined) {
  window.__IntelliJTools = {}
}

(function () {
  window.__IntelliJTools.processClick = function (link) {
    if (!hasHrefAttribute(link)) {
      return false
    }
    const href = getHrefAttribute(link)
    if (typeof window.__IntelliJTools.openInExternalBrowser === "function") {
      window.__IntelliJTools.openInExternalBrowser(href)
    }
    return false
  }

  window.document.onclick = function (e) {
    let target = e.target
    while (target && (typeof target.tagName === 'undefined' || target.tagName.toLowerCase() !== 'a')) {
      target = target.parentNode
    }
    if (!target) {
      return true
    }
    if (target.tagName.toLowerCase() === 'a' && hasHrefAttribute(target)) {
      e.stopPropagation()
      return window.__IntelliJTools.processClick(target)
    }
  }

  const hasHrefAttribute = (target) => {
    const href = getHrefAttribute(target)
    return href !== undefined && href.startsWith('http')
  }

  const getHrefAttribute = (target) => target.getAttribute('href') || target.getAttribute('xlink:href')
})()