pub const SETTINGS_ROOT_KEY_VALUE_PATTERN: &str = r#"(document
    (object
        (pair
            key: (string (string_content) @name)
            value: (_)  @value
        )
    )
)"#;

pub const SETTINGS_NESTED_KEY_VALUE_PATTERN: &str = r#"(document
    (object
        (pair
            key: (string (string_content) @parent_key)
            value: (object
                (pair
                    key: (string (string_content) @setting_name)
                    value: (_) @setting_value
                )
            )
        )
    )
)"#;

pub const SETTINGS_LANGUAGES_PATTERN: &str = r#"(document
    (object
        (pair
            key: (string (string_content) @languages)
            value: (object
            (pair
                key: (string)
                value: (object
                    (pair
                        key: (string (string_content) @setting_name)
                        value: (_) @value
                    )
                )
            ))
        )
    )
    (#eq? @languages "languages")
)"#;

pub const SETTINGS_ASSISTANT_TOOLS_PATTERN: &str = r#"(document
    (object
        (pair
            key: (string (string_content) @assistant)
            value: (object
                (pair
                    key: (string (string_content) @profiles)
                    value: (object
                        (pair
                            key: (_)
                            value: (object
                                (pair
                                    key: (string (string_content) @tools_key)
                                    value: (object
                                        (pair
                                            key: (string (string_content) @tool_name)
                                            value: (_) @tool_value
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            )
        )
    )
    (#eq? @assistant "assistant")
    (#eq? @profiles "profiles")
    (#eq? @tools_key "tools")
)"#;

pub const SETTINGS_ASSISTANT_PATTERN: &str = r#"(document
    (object
        (pair
            key: (string (string_content) @key)
        )
    )
    (#eq? @key "assistant")
)"#;

pub const SETTINGS_EDIT_PREDICTIONS_ASSISTANT_PATTERN: &str = r#"(document
    (object
        (pair
            key: (string (string_content) @edit_predictions)
            value: (object
                (pair key: (string (string_content) @enabled_in_assistant))
            )
        )
    )
    (#eq? @edit_predictions "edit_predictions")
    (#eq? @enabled_in_assistant "enabled_in_assistant")
)"#;

pub const SETTINGS_DUPLICATED_AGENT_PATTERN: &str = r#"(document
    (object
        (pair
            key: (string (string_content) @agent1)
            value: (_)
        ) @pair1
        (pair
            key: (string (string_content) @agent2)
            value: (_)
        )
    )
    (#eq? @agent1 "agent")
    (#eq? @agent2 "agent")
)"#;
