
  /*!
  * ol-contextmenu - v5.2.1
  * https://github.com/jonataswalker/ol-contextmenu
  * Built: Fri Mar 31 2023 20:27:32 GMT-0300 (Brasilia Standard Time)
  */

var U = Object.defineProperty;
var z = (s, e, t) => e in s ? U(s, e, { enumerable: !0, configurable: !0, writable: !0, value: t }) : s[e] = t;
var h = (s, e, t) => (z(s, typeof e != "symbol" ? e + "" : e, t), t);
class B {
  /**
   * @param {string} type Type.
   */
  constructor(e) {
    this.propagationStopped, this.defaultPrevented, this.type = e, this.target = null;
  }
  /**
   * Prevent default. This means that no emulated `click`, `singleclick` or `doubleclick` events
   * will be fired.
   * @api
   */
  preventDefault() {
    this.defaultPrevented = !0;
  }
  /**
   * Stop event propagation.
   * @api
   */
  stopPropagation() {
    this.propagationStopped = !0;
  }
}
const w = B, F = {
  /**
   * Triggered when a property is changed.
   * @event module:ol/Object.ObjectEvent#propertychange
   * @api
   */
  PROPERTYCHANGE: "propertychange"
};
class V {
  constructor() {
    this.disposed = !1;
  }
  /**
   * Clean up.
   */
  dispose() {
    this.disposed || (this.disposed = !0, this.disposeInternal());
  }
  /**
   * Extension point for disposable objects.
   * @protected
   */
  disposeInternal() {
  }
}
const j = V;
function x() {
}
function I(s) {
  for (const e in s)
    delete s[e];
}
function Y(s) {
  let e;
  for (e in s)
    return !1;
  return !e;
}
class G extends j {
  /**
   * @param {*} [target] Default event target for dispatched events.
   */
  constructor(e) {
    super(), this.eventTarget_ = e, this.pendingRemovals_ = null, this.dispatching_ = null, this.listeners_ = null;
  }
  /**
   * @param {string} type Type.
   * @param {import("../events.js").Listener} listener Listener.
   */
  addEventListener(e, t) {
    if (!e || !t)
      return;
    const n = this.listeners_ || (this.listeners_ = {}), r = n[e] || (n[e] = []);
    r.includes(t) || r.push(t);
  }
  /**
   * Dispatches an event and calls all listeners listening for events
   * of this type. The event parameter can either be a string or an
   * Object with a `type` property.
   *
   * @param {import("./Event.js").default|string} event Event object.
   * @return {boolean|undefined} `false` if anyone called preventDefault on the
   *     event object or if any of the listeners returned false.
   * @api
   */
  dispatchEvent(e) {
    const t = typeof e == "string", n = t ? e : e.type, r = this.listeners_ && this.listeners_[n];
    if (!r)
      return;
    const i = t ? new w(e) : (
      /** @type {Event} */
      e
    );
    i.target || (i.target = this.eventTarget_ || this);
    const o = this.dispatching_ || (this.dispatching_ = {}), l = this.pendingRemovals_ || (this.pendingRemovals_ = {});
    n in o || (o[n] = 0, l[n] = 0), ++o[n];
    let u;
    for (let c = 0, E = r.length; c < E; ++c)
      if ("handleEvent" in r[c] ? u = /** @type {import("../events.js").ListenerObject} */
      r[c].handleEvent(i) : u = /** @type {import("../events.js").ListenerFunction} */
      r[c].call(this, i), u === !1 || i.propagationStopped) {
        u = !1;
        break;
      }
    if (--o[n] === 0) {
      let c = l[n];
      for (delete l[n]; c--; )
        this.removeEventListener(n, x);
      delete o[n];
    }
    return u;
  }
  /**
   * Clean up.
   */
  disposeInternal() {
    this.listeners_ && I(this.listeners_);
  }
  /**
   * Get the listeners for a specified event type. Listeners are returned in the
   * order that they will be called in.
   *
   * @param {string} type Type.
   * @return {Array<import("../events.js").Listener>|undefined} Listeners.
   */
  getListeners(e) {
    return this.listeners_ && this.listeners_[e] || void 0;
  }
  /**
   * @param {string} [type] Type. If not provided,
   *     `true` will be returned if this event target has any listeners.
   * @return {boolean} Has listeners.
   */
  hasListener(e) {
    return this.listeners_ ? e ? e in this.listeners_ : Object.keys(this.listeners_).length > 0 : !1;
  }
  /**
   * @param {string} type Type.
   * @param {import("../events.js").Listener} listener Listener.
   */
  removeEventListener(e, t) {
    const n = this.listeners_ && this.listeners_[e];
    if (n) {
      const r = n.indexOf(t);
      r !== -1 && (this.pendingRemovals_ && e in this.pendingRemovals_ ? (n[r] = x, ++this.pendingRemovals_[e]) : (n.splice(r, 1), n.length === 0 && delete this.listeners_[e]));
    }
  }
}
const Z = G, W = {
  /**
   * Generic change event. Triggered when the revision counter is increased.
   * @event module:ol/events/Event~BaseEvent#change
   * @api
   */
  CHANGE: "change",
  /**
   * Generic error event. Triggered when an error occurs.
   * @event module:ol/events/Event~BaseEvent#error
   * @api
   */
  ERROR: "error",
  BLUR: "blur",
  CLEAR: "clear",
  CONTEXTMENU: "contextmenu",
  CLICK: "click",
  DBLCLICK: "dblclick",
  DRAGENTER: "dragenter",
  DRAGOVER: "dragover",
  DROP: "drop",
  FOCUS: "focus",
  KEYDOWN: "keydown",
  KEYPRESS: "keypress",
  LOAD: "load",
  RESIZE: "resize",
  TOUCHMOVE: "touchmove",
  WHEEL: "wheel"
};
function g(s, e, t, n, r) {
  if (n && n !== s && (t = t.bind(n)), r) {
    const o = t;
    t = function() {
      s.removeEventListener(e, t), o.apply(this, arguments);
    };
  }
  const i = {
    target: s,
    type: e,
    listener: t
  };
  return s.addEventListener(e, t), i;
}
function S(s, e, t, n) {
  return g(s, e, t, n, !0);
}
function M(s) {
  s && s.target && (s.target.removeEventListener(s.type, s.listener), I(s));
}
class y extends Z {
  constructor() {
    super(), this.on = /** @type {ObservableOnSignature<import("./events").EventsKey>} */
    this.onInternal, this.once = /** @type {ObservableOnSignature<import("./events").EventsKey>} */
    this.onceInternal, this.un = /** @type {ObservableOnSignature<void>} */
    this.unInternal, this.revision_ = 0;
  }
  /**
   * Increases the revision counter and dispatches a 'change' event.
   * @api
   */
  changed() {
    ++this.revision_, this.dispatchEvent(W.CHANGE);
  }
  /**
   * Get the version number for this object.  Each time the object is modified,
   * its version number will be incremented.
   * @return {number} Revision.
   * @api
   */
  getRevision() {
    return this.revision_;
  }
  /**
   * @param {string|Array<string>} type Type.
   * @param {function((Event|import("./events/Event").default)): ?} listener Listener.
   * @return {import("./events.js").EventsKey|Array<import("./events.js").EventsKey>} Event key.
   * @protected
   */
  onInternal(e, t) {
    if (Array.isArray(e)) {
      const n = e.length, r = new Array(n);
      for (let i = 0; i < n; ++i)
        r[i] = g(this, e[i], t);
      return r;
    }
    return g(
      this,
      /** @type {string} */
      e,
      t
    );
  }
  /**
   * @param {string|Array<string>} type Type.
   * @param {function((Event|import("./events/Event").default)): ?} listener Listener.
   * @return {import("./events.js").EventsKey|Array<import("./events.js").EventsKey>} Event key.
   * @protected
   */
  onceInternal(e, t) {
    let n;
    if (Array.isArray(e)) {
      const r = e.length;
      n = new Array(r);
      for (let i = 0; i < r; ++i)
        n[i] = S(this, e[i], t);
    } else
      n = S(
        this,
        /** @type {string} */
        e,
        t
      );
    return t.ol_key = n, n;
  }
  /**
   * Unlisten for a certain type of event.
   * @param {string|Array<string>} type Type.
   * @param {function((Event|import("./events/Event").default)): ?} listener Listener.
   * @protected
   */
  unInternal(e, t) {
    const n = (
      /** @type {Object} */
      t.ol_key
    );
    if (n)
      X(n);
    else if (Array.isArray(e))
      for (let r = 0, i = e.length; r < i; ++r)
        this.removeEventListener(e[r], t);
    else
      this.removeEventListener(e, t);
  }
}
y.prototype.on;
y.prototype.once;
y.prototype.un;
function X(s) {
  if (Array.isArray(s))
    for (let e = 0, t = s.length; e < t; ++e)
      M(s[e]);
  else
    M(
      /** @type {import("./events.js").EventsKey} */
      s
    );
}
const q = y;
let J = 0;
function Q(s) {
  return s.ol_uid || (s.ol_uid = String(++J));
}
class T extends w {
  /**
   * @param {string} type The event type.
   * @param {string} key The property name.
   * @param {*} oldValue The old value for `key`.
   */
  constructor(e, t, n) {
    super(e), this.key = t, this.oldValue = n;
  }
}
class ee extends q {
  /**
   * @param {Object<string, *>} [values] An object with key-value pairs.
   */
  constructor(e) {
    super(), this.on, this.once, this.un, Q(this), this.values_ = null, e !== void 0 && this.setProperties(e);
  }
  /**
   * Gets a value.
   * @param {string} key Key name.
   * @return {*} Value.
   * @api
   */
  get(e) {
    let t;
    return this.values_ && this.values_.hasOwnProperty(e) && (t = this.values_[e]), t;
  }
  /**
   * Get a list of object property names.
   * @return {Array<string>} List of property names.
   * @api
   */
  getKeys() {
    return this.values_ && Object.keys(this.values_) || [];
  }
  /**
   * Get an object of all property names and values.
   * @return {Object<string, *>} Object.
   * @api
   */
  getProperties() {
    return this.values_ && Object.assign({}, this.values_) || {};
  }
  /**
   * @return {boolean} The object has properties.
   */
  hasProperties() {
    return !!this.values_;
  }
  /**
   * @param {string} key Key name.
   * @param {*} oldValue Old value.
   */
  notify(e, t) {
    let n;
    n = `change:${e}`, this.hasListener(n) && this.dispatchEvent(new T(n, e, t)), n = F.PROPERTYCHANGE, this.hasListener(n) && this.dispatchEvent(new T(n, e, t));
  }
  /**
   * @param {string} key Key name.
   * @param {import("./events.js").Listener} listener Listener.
   */
  addChangeListener(e, t) {
    this.addEventListener(`change:${e}`, t);
  }
  /**
   * @param {string} key Key name.
   * @param {import("./events.js").Listener} listener Listener.
   */
  removeChangeListener(e, t) {
    this.removeEventListener(`change:${e}`, t);
  }
  /**
   * Sets a value.
   * @param {string} key Key name.
   * @param {*} value Value.
   * @param {boolean} [silent] Update without triggering an event.
   * @api
   */
  set(e, t, n) {
    const r = this.values_ || (this.values_ = {});
    if (n)
      r[e] = t;
    else {
      const i = r[e];
      r[e] = t, i !== t && this.notify(e, i);
    }
  }
  /**
   * Sets a collection of key-value pairs.  Note that this changes any existing
   * properties and adds new ones (it does not remove any existing properties).
   * @param {Object<string, *>} values Values.
   * @param {boolean} [silent] Update without triggering an event.
   * @api
   */
  setProperties(e, t) {
    for (const n in e)
      this.set(n, e[n], t);
  }
  /**
   * Apply any properties from another object without triggering events.
   * @param {BaseObject} source The source object.
   * @protected
   */
  applyProperties(e) {
    e.values_ && Object.assign(this.values_ || (this.values_ = {}), e.values_);
  }
  /**
   * Unsets a property.
   * @param {string} key Key name.
   * @param {boolean} [silent] Unset without triggering an event.
   * @api
   */
  unset(e, t) {
    if (this.values_ && e in this.values_) {
      const n = this.values_[e];
      delete this.values_[e], Y(this.values_) && (this.values_ = null), t || this.notify(e, n);
    }
  }
}
const te = ee, ne = {
  /**
   * Triggered after a map frame is rendered.
   * @event module:ol/MapEvent~MapEvent#postrender
   * @api
   */
  POSTRENDER: "postrender",
  /**
   * Triggered when the map starts moving.
   * @event module:ol/MapEvent~MapEvent#movestart
   * @api
   */
  MOVESTART: "movestart",
  /**
   * Triggered after the map is moved.
   * @event module:ol/MapEvent~MapEvent#moveend
   * @api
   */
  MOVEEND: "moveend",
  /**
   * Triggered when loading of additional map data (tiles, images, features) starts.
   * @event module:ol/MapEvent~MapEvent#loadstart
   * @api
   */
  LOADSTART: "loadstart",
  /**
   * Triggered when loading of additional map data has completed.
   * @event module:ol/MapEvent~MapEvent#loadend
   * @api
   */
  LOADEND: "loadend"
};
function D(s) {
  return s && s.parentNode ? s.parentNode.removeChild(s) : null;
}
class se extends te {
  /**
   * @param {Options} options Control options.
   */
  constructor(e) {
    super();
    const t = e.element;
    t && !e.target && !t.style.pointerEvents && (t.style.pointerEvents = "auto"), this.element = t || null, this.target_ = null, this.map_ = null, this.listenerKeys = [], e.render && (this.render = e.render), e.target && this.setTarget(e.target);
  }
  /**
   * Clean up.
   */
  disposeInternal() {
    D(this.element), super.disposeInternal();
  }
  /**
   * Get the map associated with this control.
   * @return {import("../Map.js").default|null} Map.
   * @api
   */
  getMap() {
    return this.map_;
  }
  /**
   * Remove the control from its current map and attach it to the new map.
   * Pass `null` to just remove the control from the current map.
   * Subclasses may set up event handlers to get notified about changes to
   * the map here.
   * @param {import("../Map.js").default|null} map Map.
   * @api
   */
  setMap(e) {
    this.map_ && D(this.element);
    for (let t = 0, n = this.listenerKeys.length; t < n; ++t)
      M(this.listenerKeys[t]);
    this.listenerKeys.length = 0, this.map_ = e, e && ((this.target_ ? this.target_ : e.getOverlayContainerStopEvent()).appendChild(this.element), this.render !== x && this.listenerKeys.push(
      g(e, ne.POSTRENDER, this.render, this)
    ), e.render());
  }
  /**
   * Renders the control.
   * @param {import("../MapEvent.js").default} mapEvent Map event.
   * @api
   */
  render(e) {
  }
  /**
   * This function is used to set a target element for the control. It has no
   * effect if it is called after the control has been added to the map (i.e.
   * after `setMap` is called on the control). If no `target` is set in the
   * options passed to the control constructor and if `setTarget` is not called
   * then the control is added to the map's overlay container.
   * @param {HTMLElement|string} target Target.
   * @api
   */
  setTarget(e) {
    this.target_ = typeof e == "string" ? document.getElementById(e) : e;
  }
}
const ie = se;
var C = {}, re = {
  get exports() {
    return C;
  },
  set exports(s) {
    C = s;
  }
};
function A() {
}
A.prototype = {
  on: function(s, e, t) {
    var n = this.e || (this.e = {});
    return (n[s] || (n[s] = [])).push({
      fn: e,
      ctx: t
    }), this;
  },
  once: function(s, e, t) {
    var n = this;
    function r() {
      n.off(s, r), e.apply(t, arguments);
    }
    return r._ = e, this.on(s, r, t);
  },
  emit: function(s) {
    var e = [].slice.call(arguments, 1), t = ((this.e || (this.e = {}))[s] || []).slice(), n = 0, r = t.length;
    for (n; n < r; n++)
      t[n].fn.apply(t[n].ctx, e);
    return this;
  },
  off: function(s, e) {
    var t = this.e || (this.e = {}), n = t[s], r = [];
    if (n && e)
      for (var i = 0, o = n.length; i < o; i++)
        n[i].fn !== e && n[i].fn._ !== e && r.push(n[i]);
    return r.length ? t[s] = r : delete t[s], this;
  }
};
re.exports = A;
var oe = C.TinyEmitter = A;
class ae extends w {
  /**
   * @param {string} type Event type.
   * @param {import("./Map.js").default} map Map.
   * @param {?import("./Map.js").FrameState} [frameState] Frame state.
   */
  constructor(e, t, n) {
    super(e), this.map = t, this.frameState = n !== void 0 ? n : null;
  }
}
const le = ae;
class he extends le {
  /**
   * @param {string} type Event type.
   * @param {import("./Map.js").default} map Map.
   * @param {EVENT} originalEvent Original event.
   * @param {boolean} [dragging] Is the map currently being dragged?
   * @param {import("./Map.js").FrameState} [frameState] Frame state.
   * @param {Array<PointerEvent>} [activePointers] Active pointers.
   */
  constructor(e, t, n, r, i, o) {
    super(e, t, i), this.originalEvent = n, this.pixel_ = null, this.coordinate_ = null, this.dragging = r !== void 0 ? r : !1, this.activePointers = o;
  }
  /**
   * The map pixel relative to the viewport corresponding to the original event.
   * @type {import("./pixel.js").Pixel}
   * @api
   */
  get pixel() {
    return this.pixel_ || (this.pixel_ = this.map.getEventPixel(this.originalEvent)), this.pixel_;
  }
  set pixel(e) {
    this.pixel_ = e;
  }
  /**
   * The coordinate corresponding to the original browser event.  This will be in the user
   * projection if one is set.  Otherwise it will be in the view projection.
   * @type {import("./coordinate.js").Coordinate}
   * @api
   */
  get coordinate() {
    return this.coordinate_ || (this.coordinate_ = this.map.getCoordinateFromPixel(this.pixel)), this.coordinate_;
  }
  set coordinate(e) {
    this.coordinate_ = e;
  }
  /**
   * Prevents the default browser action.
   * See https://developer.mozilla.org/en-US/docs/Web/API/event.preventDefault.
   * @api
   */
  preventDefault() {
    super.preventDefault(), "preventDefault" in this.originalEvent && this.originalEvent.preventDefault();
  }
  /**
   * Prevents further propagation of the current event.
   * See https://developer.mozilla.org/en-US/docs/Web/API/event.stopPropagation.
   * @api
   */
  stopPropagation() {
    super.stopPropagation(), "stopPropagation" in this.originalEvent && this.originalEvent.stopPropagation();
  }
}
const ce = he;
var N = /* @__PURE__ */ ((s) => (s.CONTEXTMENU = "contextmenu", s.CLICK = "click", s.DBLCLICK = "dblclick", s))(N || {}), m = /* @__PURE__ */ ((s) => (s.BEFOREOPEN = "beforeopen", s.OPEN = "open", s.CLOSE = "close", s.ADD_MENU_ENTRY = "add-menu-entry", s))(m || {});
class R extends ce {
  constructor(e) {
    super(e.type, e.map, e.originalEvent);
  }
}
const ue = {
  width: 150,
  scrollAt: 4,
  eventType: N.CONTEXTMENU,
  defaultItems: !0,
  items: []
}, f = "ol-ctx-menu", a = {
  namespace: f,
  container: `${f}-container`,
  separator: `${f}-separator`,
  submenu: `${f}-submenu`,
  hidden: `${f}-hidden`,
  icon: `${f}-icon`,
  zoomIn: `${f}-zoom-in`,
  zoomOut: `${f}-zoom-out`,
  unselectable: "ol-unselectable"
}, P = [
  {
    text: "Zoom In",
    classname: `${a.zoomIn} ${a.icon}`,
    callback: (s, e) => {
      const t = e.getView();
      t.animate({
        zoom: Number(t.getZoom()) + 1,
        duration: 700,
        center: s.coordinate
      });
    }
  },
  {
    text: "Zoom Out",
    classname: `${a.zoomOut} ${a.icon}`,
    callback: (s, e) => {
      const t = e.getView();
      t.animate({
        zoom: Number(t.getZoom()) - 1,
        duration: 700,
        center: s.coordinate
      });
    }
  }
];
function _(s) {
  const e = document.createDocumentFragment(), t = document.createElement("div");
  for (t.innerHTML = s; t.firstChild; )
    e.append(t.firstChild);
  return e;
}
function de(s) {
  const e = document.importNode(s), t = s.offsetWidth;
  e.style.cssText = `position: fixed; top: 0; left: 0; overflow: auto; visibility: hidden; pointer-events: none; height: unset; max-height: unset; width: ${t}px`;
  const n = _("<span>Foo</span>"), r = _("<span>Foo</span>"), i = document.createElement("li"), o = document.createElement("li");
  i.append(n), o.append(r), e.append(i), e.append(o), s.parentNode?.append(e);
  const l = e.offsetHeight / 2;
  return s.parentNode?.removeChild(e), l;
}
function $({
  parentNode: s,
  item: e,
  isSubmenu: t = !1,
  isInsideSubmenu: n = !1,
  emitter: r
}) {
  const i = `_${Math.random().toString(36).slice(2, 11)}`;
  if (typeof e != "string" && "text" in e) {
    const E = `<span>${e.text}</span>`, v = _(E), p = document.createElement("li");
    e.classname = e.classname || "", e.icon && (e.classname === "" ? e.classname = a.icon : e.classname.includes(a.icon) === !1 && (e.classname += ` ${a.icon}`), p.setAttribute("style", `background-image:url(${e.icon})`)), p.id = i, p.className = e.classname, p.append(v), s.append(p);
    const b = {
      id: i,
      isSubmenu: t,
      isInsideSubmenu: n,
      isSeparator: !1,
      callback: "callback" in e ? e.callback : null,
      data: "data" in e ? e.data : null
    };
    return r.emit(m.ADD_MENU_ENTRY, b, p), p;
  }
  const o = `<li id="${i}" class="${a.separator}"><hr></li>`, l = _(o);
  s.append(l);
  const u = s.lastChild, c = {
    id: i,
    isSubmenu: !1,
    isInsideSubmenu: !1,
    isSeparator: !0,
    callback: null,
    data: null
  };
  return r.emit(m.ADD_MENU_ENTRY, c, u), u;
}
function O({
  container: s,
  items: e,
  menuWidth: t,
  isInsideSubmenu: n,
  emitter: r
}) {
  e.forEach((i) => {
    if (typeof i != "string" && "items" in i && Array.isArray(i.items)) {
      const o = $({ parentNode: s, item: i, isSubmenu: !0, emitter: r });
      o.classList.add(a.submenu);
      const l = document.createElement("ul");
      l.classList.add(a.container), l.style.width = `${t}px`, o.append(l), O({
        emitter: r,
        menuWidth: t,
        container: l,
        items: i.items,
        isInsideSubmenu: !0
      });
    } else
      $({
        parentNode: s,
        item: i,
        isSubmenu: !1,
        isInsideSubmenu: n,
        emitter: r
      });
  });
}
function L(s, e) {
  if (!s)
    throw new Error(e);
}
class fe extends ie {
  constructor(t = {}) {
    L(typeof t == "object", "@param `opts` should be object type!");
    const n = document.createElement("div");
    super({ element: n });
    h(this, "map");
    h(this, "emitter", new oe());
    h(this, "container");
    h(this, "coordinate", []);
    h(this, "pixel", []);
    h(this, "contextMenuEventListener");
    h(this, "entryCallbackEventListener");
    h(this, "mapMoveListener");
    h(this, "lineHeight", 0);
    h(this, "disabled");
    h(this, "opened");
    h(this, "items", []);
    h(this, "menuEntries", /* @__PURE__ */ new Map());
    h(this, "options");
    this.options = { ...ue, ...t };
    const r = document.createElement("ul");
    n.append(r), n.style.width = `${this.options.width}px`, n.classList.add(
      a.container,
      a.unselectable,
      a.hidden
    ), this.container = n, this.contextMenuEventListener = (i) => {
      this.handleContextMenu(i);
    }, this.entryCallbackEventListener = (i) => {
      this.handleEntryCallback(i);
    }, this.mapMoveListener = () => {
      this.handleMapMove();
    }, this.disabled = !1, this.opened = !1, window.addEventListener(
      "beforeunload",
      () => {
        this.removeListeners();
      },
      { once: !0 }
    );
  }
  clear() {
    for (const t of this.menuEntries.keys())
      this.removeMenuEntry(t);
    this.container.replaceChildren(), this.container.append(document.createElement("ul"));
  }
  enable() {
    this.disabled = !1;
  }
  disable() {
    this.disabled = !0;
  }
  getDefaultItems() {
    return P;
  }
  countItems() {
    return this.menuEntries.size;
  }
  extend(t) {
    L(Array.isArray(t), "@param `items` should be an Array."), O({
      items: t,
      emitter: this.emitter,
      menuWidth: this.options.width,
      container: this.container.firstElementChild
    });
  }
  closeMenu() {
    this.opened = !1, this.container.classList.add(a.hidden), this.dispatchEvent(m.CLOSE);
  }
  isOpen() {
    return this.opened;
  }
  updatePosition(t) {
    L(Array.isArray(t), "@param `pixel` should be an Array."), this.isOpen() && (this.pixel = t, this.positionContainer());
  }
  pop() {
    const t = Array.from(this.menuEntries.keys()).pop();
    t && this.removeMenuEntry(t);
  }
  shift() {
    const t = Array.from(this.menuEntries.keys()).shift();
    t && this.removeMenuEntry(t);
  }
  push(t) {
    t && this.extend([t]);
  }
  setMap(t) {
    if (super.setMap(t), t) {
      this.map = t, t.getViewport().addEventListener(
        this.options.eventType,
        this.contextMenuEventListener,
        !1
      ), t.on("movestart", () => {
        this.handleMapMove();
      }), this.emitter.on(
        m.ADD_MENU_ENTRY,
        (r, i) => {
          this.handleAddMenuEntry(r, i);
        },
        this
      ), this.items = this.options.defaultItems ? this.options.items.concat(P) : this.options.items, O({
        items: this.items,
        emitter: this.emitter,
        menuWidth: this.options.width,
        container: this.container.firstElementChild
      });
      const n = this.getMenuEntriesLength();
      this.lineHeight = n > 0 ? this.container.offsetHeight / n : de(this.container);
    } else
      this.removeListeners(), this.clear();
  }
  removeListeners() {
    this.map.getViewport().removeEventListener(this.options.eventType, this.contextMenuEventListener, !1), this.emitter.off(m.ADD_MENU_ENTRY);
  }
  removeMenuEntry(t) {
    let n = document.getElementById(t);
    n?.remove(), n = null, this.menuEntries.delete(t);
  }
  handleContextMenu(t) {
    this.coordinate = this.map.getEventCoordinate(t), this.pixel = this.map.getEventPixel(t), this.dispatchEvent(
      new R({
        map: this.map,
        originalEvent: t,
        type: m.BEFOREOPEN
      })
    ), !this.disabled && (this.options.eventType === N.CONTEXTMENU && (t.stopPropagation(), t.preventDefault()), setTimeout(() => {
      this.openMenu(t);
    }), t.target?.addEventListener(
      "pointerdown",
      (n) => {
        this.opened && (n.stopPropagation(), this.closeMenu());
      },
      { once: !0 }
    ));
  }
  openMenu(t) {
    this.opened = !0, this.positionContainer(), this.container.classList.remove(a.hidden), this.dispatchEvent(
      new R({
        map: this.map,
        originalEvent: t,
        type: m.OPEN
      })
    );
  }
  getMenuEntriesLength() {
    return Array.from(this.menuEntries).filter(
      ([, t]) => t.isSeparator === !1 && t.isSubmenu === !1 && t.isInsideSubmenu === !1
    ).length;
  }
  positionContainer() {
    const t = this.map.getSize() || [0, 0], n = {
      w: t[0] - this.pixel[0],
      h: t[1] - this.pixel[1]
    }, r = this.getMenuEntriesLength(), i = {
      w: this.container.offsetWidth,
      // a cheap way to recalculate container height
      // since offsetHeight is like cached
      h: Math.round(this.lineHeight * r)
    }, o = n.w >= i.w ? this.pixel[0] + 5 : this.pixel[0] - i.w;
    this.container.style.left = `${o}px`, this.container.style.top = n.h >= i.h ? `${this.pixel[1] - 10}px` : `${this.pixel[1] - i.h}px`, this.container.style.right = "auto", this.container.style.bottom = "auto", n.w -= i.w;
    const l = (E) => Array.from(E.children).filter(
      (v) => v.tagName === "LI" && v.classList.contains(a.submenu)
    );
    let u = 0;
    const c = (E, v) => {
      u += 1, l(E).forEach((b) => {
        const H = v >= i.w ? i.w - 8 : (i.w + 8) * -1, d = b.querySelector(
          `ul.${a.container}`
        ), k = Math.round(
          this.lineHeight * Array.from(d.children).filter((K) => K.tagName === "LI").length
        );
        d.style.left = `${H}px`, d.style.right = "auto", d.style.top = n.h >= k + i.h ? "0" : `-${d.offsetHeight - 25}px`, d.style.bottom = "auto", d.style.zIndex = String(u), l(d).length > 0 && c(d, v - i.w);
      });
    };
    c(this.container.firstElementChild, n.w);
  }
  handleMapMove() {
    this.closeMenu();
  }
  handleEntryCallback(t) {
    t.preventDefault(), t.stopPropagation();
    const n = t.currentTarget, r = this.menuEntries.get(n.id);
    if (!r)
      return;
    const i = {
      data: r.data,
      coordinate: this.coordinate
    };
    this.closeMenu(), r.callback?.(i, this.map);
  }
  handleAddMenuEntry(t, n) {
    this.menuEntries.set(t.id, t), this.positionContainer(), "callback" in t && typeof t.callback == "function" && n.addEventListener("click", this.entryCallbackEventListener, !1);
  }
}
export {
  fe as default
};
