//MIT License
//
//Copyright (c) 2016 Drake Levy
//Copyright (c) 2023 szlldm
//
//Permission is hereby granted, free of charge, to any person obtaining a copy
//of this software and associated documentation files (the "Software"), to deal
//in the Software without restriction, including without limitation the rights
//to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//copies of the Software, and to permit persons to whom the Software is
//furnished to do so, subject to the following conditions:
//
//The above copyright notice and this permission notice shall be included in all
//copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//SOFTWARE.


static const int16_t fx3_paramFeatureBias[16] = {
    -178, 21, -229, -1051, -26, -19, 409, 181, 32, -133, 143, 96, -1003, 384, 152, 337, 
};

static const int16_t fx3_paramFeatureWeights[400] = {
    -99, 6, 129, 45, -296, 32, 121, 590, -84, 658, 135, 3, 7, -53, 55, -55, 
    592, -185, 81, -144, -132, -181, 155, -505, -418, 696, -90, -649, 194, 286, -1053, 93, 
    325, 518, 74, -33, -589, 1441, 299, 1913, -995, -1149, 75, 151, 247, -398, 428, -56, 
    -682, 341, 409, -130, 363, -108, 239, -1017, 392, 403, -44, -321, 319, -83, 1107, -1099, 
    600, 55, 22, 68, 37, 74, -59, -559, 304, -517, 40, 14, -118, -1, 159, -475, 
    127, -385, -88, 2, 523, -200, -280, -259, 642, 865, -447, 362, -208, 410, -1074, 520, 
    -174, 1308, -1074, -916, 1112, 769, 559, -1125, 690, -216, -107, -44, 1117, -290, 788, -1529, 
    -439, -200, -2218, -1923, -268, -4205, -2571, -412, 2700, 2075, 916, -1100, 2152, -377, 527, -1484, 
    -98, -1835, -769, -295, -1610, 163, 194, 750, -609, -1431, -772, 659, 155, 285, -1175, 3029, 
    -825, 299, 26, -171, 8, -8, -56, 1941, 545, 887, 226, -308, 199, -518, 201, -521, 
    -1244, 1118, 457, 203, -329, -63, -545, 884, -906, 72, -390, 820, -215, -1664, 28, -650, 
    176, -3619, -231, 842, 3074, -837, 904, 833, -602, -521, 3155, -6513, 477, 1581, 523, -140, 
    237, 3500, 5263, 4627, 564, 6209, -4547, 1029, -1832, -2177, 958, 4502, 6724, -3023, -2426, 3396, 
    4529, -1166, -2999, 622, -1615, -1047, 601, -681, -1988, 3375, -3866, 3081, 114, 3955, 3203, -1744, 
    -1678, -79, -37, -18, -353, 641, -352, -2912, -101, -1929, 506, -437, 91, -150, -546, 277, 
    -141, -206, -143, 13, 389, 362, -217, 402, 442, -283, -287, 210, -80, 1549, 1951, -587, 
    45, -866, 516, 417, -561, -1078, 22, 389, -652, 993, 645, 677, -735, -388, -1182, 59, 
    -1148, 1055, -572, 4044, 734, -1071, 4753, -1441, 2113, 304, -1450, -510, -1399, -697, 2634, 703, 
    134, 614, 167, 296, -616, -1052, 1673, 1693, 788, -2703, 12, -420, -127, 326, -1616, 264, 
    -729, 120, 71, 286, -219, 117, -325, -266, -255, 1282, 445, -159, -462, -241, -218, 336, 
    -261, 94, 51, -60, -195, -174, 114, -358, -617, 289, -169, -347, 135, -437, -487, -34, 
    644, -114, 59, 139, 49, 279, -450, -230, 1385, -161, 350, -213, -341, 25, 1211, 796, 
    -398, -240, 705, -51, -282, -551, -647, -1638, -1380, -1079, -64, -48, -13, -607, -2464, -954, 
    556, -252, 79, 43, 293, 357, -681, 875, -156, 639, 268, 416, -345, 331, -653, -1069, 
    219, -88, 23, -38, -22, -74, 123, -38, 552, -274, -178, -241, 70, 100, -260, -12, 
};

static const int16_t fx3_paramModel1Bias[16] = {
    510, -340, -261, -84, -393, -39, -13538, -483, -6098, -285, -435, -6127, 255, 626, 241, -2098, 
};

static const int16_t fx3_paramModel1Weights[2304] = {
    204, 4585, -1981, -596, 1505, -2071, 1043, 2324, -3001, -1919, 1128, 1968, -84, -1893, -2885, -166, 
    376, -1208, -1744, 1832, 756, 3826, -878, 2143, -1663, 5599, 1958, 839, 427, 2, -33, -611, 
    664, 792, 1318, 1345, 559, 2959, 1332, 1101, 2303, 2376, -1950, 915, -633, -664, 186, -785, 
    1331, 2708, 165, 3044, -1299, -1408, 1135, -1795, 42, -1107, 1271, 351, 2058, -2119, 34, -2456, 
    632, 2949, -4994, 1042, 2081, 4148, 3716, 1540, -4872, -1784, -1725, -116, -1272, -1113, 66, -144, 
    302, -1968, 3150, -4118, 1403, 2271, -1027, 2253, -1056, 1231, 366, 1624, -0, -248, -1443, -659, 
    7483, 3377, -586, -3343, 1144, -548, -6700, -649, 596, 4113, 1241, 360, -677, 2583, 3003, 2523, 
    1615, -3456, -1662, 3651, -2714, 1321, -301, 4280, -220, -620, 1646, -1805, 3120, 2106, -1062, -2686, 
    -657, -84, 1771, -61, 422, 2125, 1490, 272, 1332, -368, 158, -723, -2400, -1800, -3251, -1122, 
    -194, 2166, 1847, 703, 649, 258, -3020, -1808, 1591, -100, -921, -2063, 1333, -2690, 2356, -2058, 
    165, 8, -3799, 3654, -1254, 1989, 3288, -1502, -3359, -1520, -4221, 2739, 1618, 2216, 659, -58, 
    -127, -1602, -241, -5525, -839, 3495, -1542, 5822, -509, 3101, -237, -3066, 1447, -1362, -320, 1486, 
    344, -345, -1256, 562, 1515, -4021, 1172, -1395, -1867, -995, -617, -617, 602, 292, 1422, 1855, 
    -738, -248, -1366, 636, -92, -2186, 146, 1441, -173, -1070, 81, 3153, -977, 3701, 563, -1935, 
    -823, 89, 503, -611, -950, -693, 1454, 1122, 1549, -795, 3679, -1430, 1315, 1957, -628, 3300, 
    -575, 2270, 1137, -2866, 1867, -1448, -33, -1132, 1460, 2165, -3036, 248, -296, 1190, 1765, -3677, 
    210, -3703, 1466, -1165, 399, 6546, 403, 2438, -2156, -1993, -338, -1094, -166, -1269, -4339, 175, 
    -558, -403, 459, -1592, 930, -1284, 548, -2917, -1268, 2499, 2730, 264, 113, 1517, 1205, 232, 
    -2114, -2238, -591, -293, -957, 2485, -3828, 513, 3894, -3285, 3785, 2063, 1078, 770, -257, 969, 
    -1331, -1846, -951, 2205, -1100, -2100, 3108, -3981, 18, 452, 1071, 591, 1447, -2603, 596, -2228, 
    -3093, -4665, -2259, -3871, 3320, 1500, -4462, -2220, -1135, 509, 1527, -33, 742, -1178, 3722, 2614, 
    -3053, -1191, 268, -619, -1765, -5039, -2322, -516, -3426, 3524, 319, 1041, -568, -1866, 590, 1625, 
    4504, -397, 5265, -690, -2560, -1212, 2037, 504, -3148, -117, -2654, 3445, 5903, -2408, 450, -864, 
    1390, -2325, 1160, -1946, -2317, -781, 2489, -4310, 2927, -2796, 3510, -4815, -4451, 589, -435, 2859, 
    783, 4972, 252, 1099, 350, -476, -1218, -2105, 3132, -681, -5150, 48, -143, 9675, 4725, 574, 
    -2928, -233, -811, -1939, -1079, -1645, -1315, 1547, 2748, -13984, -850, 1989, -719, -526, 4, -2283, 
    203, 4041, -925, 2871, -55, -2359, 2392, 1661, -832, -1522, 6734, -2308, 1162, 176, -818, -545, 
    1863, 1201, 1621, -5816, 4009, -391, 390, 1208, -908, 6644, -2742, 8440, -634, -2838, 2939, -3823, 
    -1735, -1726, -3484, -163, 345, -7, -2541, -2241, -310, -3968, -1704, 1628, -800, 3632, -3005, -1567, 
    -976, -1806, 2008, 88, 897, 611, -17, 1172, -2235, 263, -3777, -638, -2683, -6912, 296, 450, 
    1312, -396, 1347, 969, 3116, -1694, -2846, 1596, 921, -682, 881, -2481, 2531, 1655, 3276, 1873, 
    -4235, -1193, -2630, 1625, -1048, 616, -719, 2684, -2476, -3831, 4041, -6651, 1164, 470, 1233, -1557, 
    -1352, 1005, 729, 1246, 1128, -1969, 4169, 3426, 1208, 2772, 2738, -43, -502, -824, -546, -755, 
    1985, -993, 147, 501, 484, -3575, 434, -538, -1303, 5407, 1350, 293, 515, -4240, -306, -295, 
    179, -41, 413, -202, -2716, -4897, 2089, 1046, -1049, 1201, 4668, 582, -1370, 895, -1561, 648, 
    668, 3056, 778, 293, -1157, 3942, 343, 5963, -684, 594, 921, -1948, -37, -2893, -1846, -798, 
    -3602, -3363, 3839, 1943, -1605, 1612, -1417, 1544, 1131, -1357, 3501, -363, -1958, -331, -3025, -867, 
    988, 1814, 3238, -301, 3630, -2316, -354, -1603, -1986, 3695, -686, 716, 162, -2473, 150, -29, 
    2366, 4774, -1019, 4216, -1193, -1075, 1283, -2891, 848, 0, -4194, 60, 152, 1732, 334, -124, 
    2313, 2041, -1731, -3570, -3258, 2835, -2065, 8361, 709, -7558, 2298, 745, 1641, 660, -1322, -1036, 
    119, -798, 4615, -2109, 261, -2674, -196, 258, -1053, 1360, -10242, -101, -1136, -3039, 3958, 587, 
    2124, 2038, -194, 389, -864, -774, 402, -1128, -138, -11906, -1549, -1532, -3746, -9455, 115, 211, 
    84, -2862, 2638, -369, 1005, 1721, 218, 1372, -61, -1675, -415, -1568, -921, -454, 2975, 2769, 
    -397, 3612, -789, 3050, -2194, 2791, -191, -6406, 885, -746, 305, 547, 1791, 4391, 942, -501, 
    703, 1640, 1999, 916, -2412, -872, 714, 1174, 923, -808, 1134, -2576, -935, -1299, 1186, 1741, 
    158, -2509, -1381, 12, -360, -5321, -2162, -441, 2511, 1902, -2594, -218, 2921, 1525, 1322, -1334, 
    75, 1715, 791, -1812, 730, -186, 29, 676, -1914, -435, 2144, -1452, -1376, -134, 2623, 3743, 
    -402, 4369, 1014, -395, 195, -5148, -2780, -744, 3527, 440, -4092, 8111, -1237, 67, -1352, 1728, 
    -2013, 1693, -1080, -3658, 2111, -879, -1645, -2277, 787, 8332, -802, 237, 1193, 2575, 112, -239, 
    1001, -616, -889, -2847, 1641, 4140, 2646, -2411, -343, -413, -2717, 1218, 1013, 150, 1197, -1224, 
    2137, -1655, 1812, 3359, -98, 1027, -683, -5469, -2446, -158, -1365, -2270, -936, 2778, 1013, 702, 
    -1030, -7563, 3028, -2697, 2561, -1279, -4746, 8404, 558, 1105, 440, 2939, 65, 2710, -960, -3508, 
    3095, 3948, -5603, -521, 508, 8679, -4117, 4474, -2644, 8524, -5320, 472, -2736, -1108, -1028, 50, 
    -946, -1448, -545, 3506, -2921, 4166, -3507, 1200, 3330, -1783, 3972, -5875, 1754, 890, 1265, 1538, 
    -2145, 1187, 4459, -4098, 1874, 1415, -1957, -2669, -1819, 5911, 1104, 2868, 1526, -1897, -3655, -3083, 
    1097, -2138, 2797, -528, -545, 4173, -210, 1615, -706, -714, 2274, -81, 56, -4275, -2205, 3348, 
    -1883, -6357, 740, 1514, 2223, -2848, -2625, -1820, -731, -3823, 4357, 672, 667, 411, -1690, 318, 
    976, 1521, 2233, -824, -2709, 2269, -3591, 1709, 142, 11657, 608, 4925, -2135, -387, -1957, 452, 
    -1172, 1503, 2947, -4338, 1680, -2716, 2410, -988, -1209, -1919, -2478, -3155, 780, 1677, 1072, 608, 
    -2978, 695, 947, 6936, 2811, -205, 3389, -6134, -1264, -105, -2714, 1080, 74, -457, -771, 2733, 
    -2591, -3619, 785, 330, -1403, 1747, -145, 1078, 1549, 667, -461, -2170, -2033, 178, 83, -65, 
    -772, 2574, 128, 1028, -297, -1083, -217, -2454, -1151, -2322, 99, -1923, -497, -3263, -1351, 1131, 
    3097, 1767, -1961, 505, 1941, 3518, 623, 3763, 178, 3478, 1051, 2109, 1649, -2204, -1031, -2013, 
    -1470, -217, 496, -2841, -2196, 942, 1849, -5275, 1776, -2511, 1974, -10622, -2441, 1649, -1482, 5883, 
    3023, -258, 503, 4078, -1562, 1873, 5378, -8897, 6445, 6506, -6476, -9605, -6614, 3965, -1271, -1812, 
    -2511, -1479, -1660, 1446, 1185, -374, 814, -4623, 1442, -9970, 1801, -4494, 5637, -872, 4686, -2337, 
    936, 1568, -3854, 1543, 6505, 290, 4557, 9162, 3555, -161, 8921, 1408, 1739, -2629, 2121, 2229, 
    -2041, 2617, -799, -3574, -461, 1821, 4661, -13814, 10055, 3675, 6651, -5997, 3932, 4860, 2460, -834, 
    -4539, -2687, -742, -12127, 72, 3906, -9650, -9708, -6490, 3001, -4519, -2679, -466, 3355, -1743, -4399, 
    -849, -8998, 2370, 7417, -8448, -5345, 496, -6091, 14583, 1488, 3643, -4217, -1383, 3345, -646, 3406, 
    5392, -11967, 10517, -6817, 4776, 3920, 8376, 5436, -7482, 2526, 7359, 229, 177, 1620, 2144, 237, 
    5085, 380, -5014, 4154, 10858, -2874, 4924, -13810, 3556, -822, -12827, 8914, -43, 1340, -914, -240, 
    -1455, -4890, 5883, -1093, -3215, -666, 683, 7538, 9705, -3479, 11097, -5808, 5326, 6190, -893, 1446, 
    5486, 2015, 1539, -441, 1881, -1205, 1674, -1705, -5113, -4719, -8013, 10277, -4197, 1837, -2438, -6163, 
    -2246, -3282, 4691, -532, 917, 784, -8342, -5391, 9789, -3710, 7840, -2994, 612, 10027, -4814, 7704, 
    -2140, 2417, -3874, 8930, -6554, -1649, -3571, 6859, 3293, -2694, 428, -3390, -1935, 2184, 12154, -8404, 
    -1187, -3019, 2611, 112, 217, 2479, -2672, 3559, -5158, 643, -4485, 3298, -3143, 3557, -4386, -2655, 
    -4508, -14, 928, 407, 2449, 1370, 812, 3630, 564, 585, 2310, 2248, -209, 2459, -1839, -3848, 
    6269, -4848, -2461, 3094, -2993, -1469, -851, -1204, 709, 3315, -4371, -2165, -1419, -2463, 2323, 2270, 
    378, 3212, 6116, -4210, -544, 2718, -2361, 5970, -2497, -2100, -3888, 9799, 5129, -5446, 949, -4438, 
    314, 237, 2499, -601, 78, -1843, 417, 3233, 1613, 190, 1716, -937, 2692, 1563, 1380, 31, 
    -824, 1301, -1063, 365, -3296, 795, -1320, 4397, 1960, -5383, 79, -1796, 2580, -4640, 1394, -605, 
    -1603, 1585, 436, 989, -3476, -2374, 207, -1089, -2146, 929, 7966, 956, -1438, -83, 735, 2062, 
    2606, 2651, 1889, -204, -936, -1314, -3924, 6430, 3303, 2179, -3979, 1030, 1270, -8795, -1829, -517, 
    -2754, -4249, 4694, -2063, 5899, 1300, 8018, 3837, 911, 203, 3192, -658, -2228, -668, 2212, -1834, 
    -2586, -3401, -4218, -186, -2011, 1530, -2032, -2654, 2394, -6797, 405, -1832, 237, -922, -249, -526, 
    4874, -1533, 3545, -2195, 1828, 494, -2001, 740, -2473, -432, 5139, -85, -940, -1980, 1971, 480, 
    995, -1750, 1436, -1529, -2381, 6897, 2239, -3031, -627, -2603, -2747, 3057, 1338, -545, 1800, -988, 
    1201, 252, -1303, -40, -4450, -340, -1686, -5601, -2227, 1212, -2919, -2649, 23, -584, -900, 6653, 
    -694, 1801, -727, 2826, 2305, 466, -647, -663, -771, 6741, -2706, 1483, 573, -9196, -176, 4428, 
    -739, -1280, -3460, -1856, 385, -488, 1452, -659, 3531, 218, -4411, 2976, -3848, -71, -2563, -2099, 
    -3455, -4591, 4344, 5345, 1837, -1604, 94, -4, 2290, -1784, 1196, -2428, -2900, 470, -1763, 6052, 
    427, -364, 1477, 319, 959, -1708, 2678, 638, 1065, 1138, 5209, -1424, 3453, -883, 2382, 278, 
    -2736, 940, -598, 1020, -2207, -3482, -1561, -3090, -202, -1915, -1231, -3137, -1991, -4449, -2145, 696, 
    1461, 1737, -7119, -887, 1591, 3531, 1069, 1264, 2820, 706, -446, -231, 1262, -1699, -1802, -987, 
    522, -2522, -116, -1996, 190, 138, 3223, -2138, 484, 2242, 2014, -5928, 1322, -4395, 1463, 913, 
    -2933, 704, -422, 1679, -608, -1374, -269, 2017, -1050, -899, 1845, 1288, 1013, 8, 77, 125, 
    995, 1118, 2137, 2660, -1249, -970, 1980, -791, -784, 5427, -3182, 1620, 1054, -290, 245, -81, 
    -2873, -2717, -1696, 443, -1506, 5899, -505, -4724, 894, -3425, 434, -4851, -1479, 181, -543, -1211, 
    -478, 115, 580, 3566, -3385, -1647, -962, 5219, -1342, -13, 2484, 3194, 1140, -275, -857, -766, 
    3226, -996, -2521, 1615, -2474, -3731, 2091, -2885, 250, -1477, -189, -248, 3750, -1828, 1082, 1626, 
    2189, -669, -1938, 2628, 1649, 2722, -2442, 2520, 280, 589, -2670, 1493, 972, 1846, -792, -2119, 
    -750, -3197, 462, -2888, -382, -2556, -251, 1096, 3058, -323, 377, -394, 967, 353, -701, -333, 
    3557, 1139, -509, 4043, 2465, 1013, -736, -5487, -1404, -376, 1601, -3627, -1548, -113, 922, -3941, 
    -1600, 3296, -1078, -196, 38, 1030, 1591, -867, -4134, -586, -588, -1727, 365, -822, -1774, -1059, 
    1108, -1048, -827, 1805, 1731, -2277, 6106, -636, -610, 3449, -1169, -1674, 2206, 2149, 825, -173, 
    1738, -1300, 817, 2074, -2211, 1307, 37, 1796, 688, 3140, -176, 208, 936, -2254, -884, 1129, 
    -1539, -5239, -2347, -3222, -1162, 23, -2128, 4073, -1912, 880, 519, -5448, 357, 2668, -99, -123, 
    -2448, 66, -514, -249, 827, -53, 1899, -1193, -337, 272, -787, 1691, 353, 118, -1136, -2204, 
    -1028, 1808, 130, 538, -1389, 897, -485, -1929, -170, -1042, 4016, 1080, -1130, 1689, -2831, 3451, 
    444, -690, -1018, -1297, 70, -2292, 1815, 410, -1433, 697, -1231, -543, 2100, -3145, 365, -2726, 
    -882, 914, -62, -1545, 48, 1801, -940, -3034, -26, -716, 574, 10927, 2735, 5678, 987, -11462, 
    -146, -338, 1810, -3201, -2813, -1936, -2121, -4556, -1771, 593, -1840, 7, 4321, 1113, 1019, 354, 
    -1295, -680, 2411, 230, 454, 4006, 3691, 1665, 5973, 1488, 5093, -3229, 2054, 865, 5671, 1302, 
    -812, 3656, 78, 817, 3133, -6858, 5206, 1036, -2741, 67, 2016, -1181, -73, 354, -1010, 2305, 
    1169, 3382, -2595, -2467, 407, 3450, 3489, -969, -9, 3073, 4183, 3053, -735, -1072, -2085, -300, 
    -1325, 811, -4311, -7684, -3750, -3760, 353, 3953, -2971, -1348, -1548, 1148, -1005, -1227, 1484, 1141, 
    6004, -604, 2516, 4688, 6032, -464, 10462, 3073, 2455, 2056, -7113, 1105, -523, -3587, 745, -1222, 
    3325, -4307, 3740, -8825, -4595, -907, 748, 5500, 57, -1562, -855, -3941, 914, -1045, 1333, 664, 
    1753, 7544, 2302, -639, -1995, -4496, -4508, 10822, 2596, -1096, -1217, 4771, -2881, -2439, 1989, 3585, 
    2045, 609, -3996, 1051, 4001, -1040, -2196, -1514, -3280, 2153, -215, -326, 2835, 1500, 134, -2325, 
    -2758, -25, -1215, -2473, -3467, 2618, -3556, 682, -3905, -2472, 1623, -3074, 2496, 3441, 1161, 649, 
    3416, 565, -2821, 1416, 1319, -2004, -508, 3068, -2342, 500, 5467, 4998, -2153, -9757, 567, 4679, 
    741, 1142, 2072, -7766, 660, 2684, 2370, -7536, -589, -6738, 2721, 2130, 520, 3825, 1004, 2351, 
    3167, 1061, 982, -210, 1016, 368, -1271, 1338, 2408, 1289, 812, -82, 3380, -3527, -1755, 3502, 
    -1111, -1943, 4961, -1762, -643, 763, -1157, 1507, -1398, 2492, -4466, 1091, 2596, -290, 2379, -1522, 
    1003, 210, 1853, 3482, 1625, -675, -608, -364, 1290, -3084, 1068, 1275, -3305, 5287, -1447, 1501, 
    1316, -927, 545, -1903, 1227, -635, 148, 221, -190, 1438, -628, -409, -732, 2641, 2887, 7868, 
    -2585, -94, 545, 190, 203, 1230, 1179, 1705, 1625, -2954, 1171, 4011, 833, -1655, 704, -636, 
    121, 3326, 282, -2166, 970, -2947, -2284, -829, -1308, 3, -3056, 640, 607, 833, 162, -583, 
    1152, -2568, 3292, -3060, -432, 943, -1596, 1464, 1825, 1166, 1108, -1135, -1870, 214, 1613, -1428, 
    -1550, -554, 1851, 2094, 45, 1680, 964, -2932, -574, -511, 663, 2, 608, -2319, 165, -2081, 
    -1006, -635, 2300, -1134, -869, -2403, -696, 1412, 4636, 922, 1336, 225, 726, 1088, -1111, 703, 
    1251, -574, 915, 1870, 434, 975, -1422, 313, -820, 97, 1161, 48, 348, 221, -332, -2491, 
    3230, -765, 1657, -8911, 1195, 1832, -945, 2818, 680, 533, -3022, 1979, -1448, 2646, -1563, -392, 
    2393, -930, 1109, 1437, -1342, 2222, 601, -3067, -781, 118, 346, -2178, 2265, 2433, -593, -1451, 
    -453, 640, 828, -1724, -2766, -760, 2743, 910, -1151, 761, 1111, -1714, -240, 453, -2339, 123, 
    -324, 740, -137, 140, -870, -3459, 2287, 1403, -674, -5228, -1552, -3089, 275, -4709, -3303, 697, 
    -2731, -2324, 171, 1377, -1324, 2269, -206, -1048, -6869, -52, 1518, 4851, -1187, -2309, 478, 2468, 
    2071, 453, -2348, -412, -135, -917, -1607, 1830, 1026, -4377, 1145, 2349, 3434, 1469, 749, -2106, 
    -924, -274, -1959, 1193, 647, -532, 3323, -1738, -258, -839, -3657, -1340, -2286, 1518, 2033, -267, 
    -768, -494, 404, 761, 498, 1609, 1105, 2232, 1233, 1337, 1877, -3437, 1067, -1160, -1337, 1912, 
    1258, -599, -1551, -209, 1302, -1510, 855, 797, 1290, -184, 281, 2845, 2446, 973, 1713, 383, 
    -1361, 790, 267, -1408, -662, 202, -1228, -1062, -532, 537, 1152, -10041, -366, -3491, 203, 3368, 
};

static const int16_t fx3_paramModel1Alpha[16] = {
    6059, -685, 994, -5659, -3844, 389, 187, -2217, -43, 5236, 24, 182, 6844, 1234, 8212, 115, 
};

static const int16_t fx3_paramModel2Bias[16] = {
    1079, -1040, 1316, 2290, 135, 1026, 2233, -765, 1427, -971, -200, 1134, 223, -1470, 844, -888, 
};

static const int16_t fx3_paramModel2Weights[2304] = {
    -418, -895, -1111, 6507, -2969, -213, 1397, 779, -1283, -994, 521, -1882, 633, 1113, -3107, -1821, 
    3883, 1263, 1906, 234, -1956, -1046, 1890, -2109, 723, -1586, 2929, -2505, -1558, 27, -750, 557, 
    295, -685, 356, 1499, -402, -773, 84, -1200, -435, -569, -66, 30, -386, 1483, -1728, -1524, 
    -1505, -1916, -741, 247, 696, -591, 628, 2331, 585, -977, 556, 684, 3, 1805, 1224, -680, 
    -4600, 5025, -292, -947, 1220, -847, -2306, 653, -3038, -1625, -1808, 1818, 1718, 1436, -1472, 4389, 
    -609, 154, 828, -1847, 899, 941, 3684, 177, -1262, 1810, -3515, 3051, -914, 1576, 2517, 1408, 
    -1285, 652, -862, -226, -2068, -665, -233, -224, 500, -1190, -1235, 7, -131, -1265, 1041, 2663, 
    394, 279, 2173, -686, 2121, 203, 366, -366, 1469, -2614, -1610, 510, 697, 2569, 1934, -1823, 
    1622, -761, -373, -258, 1912, -1342, -1092, 847, -974, -86, -1671, 5330, -862, -1490, -1040, -35, 
    632, 804, 2200, -1265, 3726, -545, 649, 60, -744, -265, 288, 63, -1923, -596, -644, 1691, 
    328, 1434, -2559, -124, 702, 15, -348, 1148, 1533, 920, -822, 881, 419, 1408, 953, -850, 
    60, 2126, -1303, 208, -458, 5958, 724, -3104, 267, -4690, -2490, -1237, 57, -2660, 657, 2166, 
    61, 1455, -702, -424, 1010, 2494, -254, -1460, 1774, 2666, -583, -683, 3379, -1101, 544, -2997, 
    2573, -730, 440, 177, 1294, 3215, 3842, 1528, -2488, 756, -235, 628, 1604, 629, 948, 37, 
    -517, -660, 783, -923, -1638, -794, -2262, 1754, -60, -481, -1738, 489, -409, 226, -559, -374, 
    222, -248, -1087, -394, 2165, -3980, -2292, -4571, 665, 833, -158, -2023, 453, 1098, -1053, 299, 
    2587, -570, -3692, -1106, -3466, 1118, 481, 2794, 447, -1574, -772, 2037, 1068, -180, -3699, -7545, 
    744, -476, 4372, 227, -1259, 79, -2737, -2233, -62, 122, -2954, 1628, -496, 1498, -3361, -1302, 
    -587, -1273, 2678, -1336, -30, 280, 611, -1421, 1390, 1301, -1568, 1051, 249, -169, -3007, -2788, 
    4331, -3199, 1464, 2867, 52, 2299, 1378, -655, -1027, -228, 384, -411, -225, -583, 2029, -510, 
    -10905, -5369, -1165, -8236, 988, -507, -3500, -4533, 8816, 688, -1059, 2899, -3330, -2824, -3620, 3698, 
    3856, 2274, -4462, 1943, -765, 876, -2390, -1652, 897, -5512, -440, -6607, -3466, 1616, 1984, 756, 
    -3404, 1191, -4226, 1359, -518, 150, 1655, -3291, 1259, -8295, 6136, -1183, -213, -3715, 2785, 1538, 
    -142, -3358, -2261, -872, 218, 1917, -1571, 821, -576, -11345, 9970, 97, 70, -531, 4008, 3852, 
    -674, 509, 7, -6942, 2983, -3285, 3445, -2886, -6301, 902, 1212, -5600, 532, -1385, -273, -1284, 
    -407, 2132, 172, 2823, 1838, 681, -385, 224, -3045, -908, -2979, -659, -2204, -456, 2017, -1178, 
    -1998, -1039, -832, 862, -1751, -1377, 46, 3109, -363, 1267, 1287, 2438, 52, -987, -1007, -1090, 
    -87, 2103, -1385, 291, -1049, 443, 2818, 921, -137, -460, -2072, -798, 939, 562, -245, 87, 
    -1427, 2128, 877, 2127, 1566, -995, -1512, 394, 173, 4259, 174, -481, 1901, 274, 50, 4908, 
    1655, -293, -1181, -1143, -3331, 2700, 364, -3877, -595, 2689, -913, -304, -1282, -1150, -415, 732, 
    -1505, 1185, 137, -956, -1178, -333, -483, -5890, -799, -416, -2099, 190, -517, 1433, -48, 1365, 
    -211, 710, 2088, -1243, -677, 719, 2389, 1551, -78, -2033, -1396, -416, 291, 776, -2276, -356, 
    1188, -1404, 2382, -6252, -3187, 3334, 2027, 128, -675, -877, 28, 78, 1550, -518, 1250, -2895, 
    -1211, -2578, -428, 1165, -2433, 492, -553, -3278, 268, -1599, -1322, -567, 1697, 1415, -2734, 399, 
    -784, -1766, 1376, 70, 200, 135, -701, -645, -9, 200, 1209, 1234, 349, -129, 761, -837, 
    924, -1997, 1310, -469, 109, 891, 5603, -1952, 96, 390, 530, 381, -628, -128, 124, -453, 
    2940, 53, 445, -8884, 19, -425, 2179, 1835, -2664, -1591, 566, -1899, 1502, 155, 1431, -5891, 
    336, -3108, -4778, -1897, 725, -6, 359, -434, 204, 7559, -3291, -2486, -4014, 3223, 180, -2133, 
    -1357, -1226, 1626, -850, 156, 329, -25, -1348, 2742, 2399, -3962, 1690, 520, -2444, 2477, -159, 
    514, 441, 1137, 871, 205, -1870, 3039, -978, 1632, -1752, 773, 1978, 554, 4536, -3337, 3248, 
    998, 214, -748, -2521, -1366, 63, -2205, 940, -459, 65, 258, -275, 783, -513, -815, -5818, 
    975, -703, 3261, -1564, -263, 991, -2656, 923, -971, -2348, -5034, 3, 742, -4, -4467, 305, 
    -303, 443, -290, -1001, -218, -1380, 845, 1988, -713, -1609, -548, -2401, 372, 363, -467, 1895, 
    1046, -129, -2290, -194, 819, 2106, -844, 188, -265, -709, 937, -479, -811, -1628, -1405, -552, 
    1126, -674, -344, 1049, -809, -196, 1958, -673, 584, -100, 78, -814, 1180, -166, -851, 1311, 
    790, 1721, 272, -2145, 854, 312, 1619, 300, -1270, 1718, -439, 2243, 140, -241, 1360, 1546, 
    505, 1138, -807, 954, 31, -265, -922, 109, -464, -3147, 1227, -2287, -188, -487, 759, 31, 
    -1537, 209, -747, 530, -8, 126, 365, -58, -471, 1932, -1177, 677, -65, 2615, 481, 437, 
    1682, 188, -4278, 3461, -7345, -715, -463, 1121, -4140, -171, -6893, -1330, -5835, 95, -6555, -3718, 
    709, 726, -4172, 191, -966, -1371, -752, 106, -109, -3610, 442, 3434, -1900, -1939, -3710, 3681, 
    2297, -2652, 1391, -1416, -1298, -1265, -301, -455, -619, -3065, 24, -2490, -1008, 1778, -3397, -302, 
    2808, 10329, 376, 1170, 257, -848, 489, 273, 1374, -3714, -2146, 1744, -435, -2493, -2295, -3041, 
    -524, 749, -1776, 1328, -3036, 4084, -2754, -1137, -1484, 835, 2659, -1950, 3070, 64, -3627, -1078, 
    574, 244, 343, 333, -743, 1674, -484, -2626, 1086, -893, 2106, -903, -178, 1166, 4346, -1614, 
    -414, -3105, -490, 576, -4291, 2452, -178, -220, 818, 632, -861, -1752, 113, -1364, -1516, 429, 
    1279, -6163, -804, 945, -1692, -385, 3038, -1075, 457, 6082, -1340, -1692, 344, -1995, -1329, 379, 
    -2290, 1337, 1083, -1179, -192, 969, -1197, 4059, 5031, -2806, -2019, 6195, -4835, 538, -685, 925, 
    82, -213, 3787, 681, 960, 1282, -3262, -192, 4943, 2547, -5234, -2320, -1288, -7, 1472, -667, 
    -1094, 2867, 1940, -112, 320, -353, 4068, -1566, 2329, -3465, -2215, -410, 1004, 2083, -469, 241, 
    1469, -4296, -4206, -2462, -1004, 6349, 76, 3765, -338, -8204, 3033, 1074, 584, -4740, -831, -439, 
    31, -577, 564, -1379, 6937, 2274, -4434, -5079, -1002, -166, 889, 1102, 4972, -261, -89, -1790, 
    -3687, 987, 4512, 1208, -2898, -617, 5952, 4682, 1082, 736, -1203, -541, -710, 783, -882, 2469, 
    481, 3737, 3971, 546, 1452, 590, 1070, -1599, -1272, -725, -2141, -450, -676, -527, 1792, -135, 
    -2027, 2316, -1372, -2469, 515, -3023, -3377, -2348, -23, -1838, -1170, -3167, 26, -652, -87, -2011, 
    -604, -2548, 2401, -1957, -5669, -1915, -638, -11198, -638, 6696, 6856, -622, -549, 219, -2821, -12572, 
    -2236, -1807, -2316, -1679, -1862, -3549, -7279, 2774, 190, 2164, -3675, -4365, -3067, -5715, -8586, 476, 
    700, 5827, -3661, -1658, 246, 1972, -1726, -447, -1345, 1172, -5561, 2659, -1626, 574, 1860, -4025, 
    -15314, -3514, 21, 1148, -69, -4289, -3, -632, -902, -4213, 2195, -3667, 325, 1373, -5039, -1081, 
    -3651, 441, 344, -3348, 3997, 170, -4108, -4310, -6327, 2332, -747, 1075, -6177, 262, -608, -3192, 
    -90, -5356, -8240, 656, -443, 5548, -3863, 997, 1303, -1491, -4426, 1481, -3560, -286, -3293, -4480, 
    -3414, 3989, 1203, 2009, -5142, -221, 4734, 467, 2165, -1762, -1903, 354, 224, 3197, 2692, -316, 
    -387, -2572, -11592, -351, 103, -643, -571, -959, -6049, 608, -2335, 2172, -123, 2866, -2783, 9601, 
    9042, -454, -1703, -1875, 4236, 486, -2137, 3407, -5177, -900, 1786, -6943, -51, 813, 4782, 718, 
    2318, -328, -546, -1649, 2861, -1538, -1744, -3004, 1648, 1818, -13472, 4047, -695, -1355, -696, -3816, 
    -392, -2878, 5794, 780, 1458, 2122, 2449, -10250, 1072, -572, -2956, 405, 428, -2785, -4317, -661, 
    -1445, -4105, 6600, -1656, -2340, -17279, -2277, 4010, 1867, -2263, -5591, 1461, 366, -604, 2581, -1879, 
    -2610, -8875, -7396, 2962, 2793, -2731, 2775, 137, -5332, -3760, 11, 2360, 6130, -852, -2200, 1591, 
    -4417, -2377, -893, 7317, 10714, 2212, -3515, -1407, 4251, 560, -2544, -1836, -420, 739, 9324, -4670, 
    6357, -12477, -921, 1194, 797, 1600, 5185, 4188, 11604, 7011, 5525, 5090, 1892, -2244, -897, -1954, 
    1758, 7136, 4231, 2032, 2068, -1555, 1966, 400, 2167, -4095, 4113, 6350, -5591, 718, 6982, -1483, 
    -1083, -654, -773, -6203, -889, -3753, 95, -3737, 1398, 227, 571, -1577, 2572, 643, -556, -5162, 
    -51, 1137, 6330, -665, 324, -8007, -6949, -614, 915, 2763, -956, -3544, 2705, 4, -3553, -1102, 
    -1013, -95, 3605, -573, 160, -1567, -2135, -1617, -2402, -91, 450, -1809, 238, 174, 251, -1397, 
    -844, 2343, 881, -247, 120, 1208, -936, 492, -1087, 2211, 2003, 1964, -215, 181, -1087, -199, 
    1062, -489, 252, -3078, 761, 593, -1509, -5428, 844, -296, -3058, 1676, -5459, -2806, -3068, -1388, 
    3502, -10989, -4304, -618, 973, 3658, -3043, -766, -354, -2049, -1559, 94, 2056, -1751, -4340, -3693, 
    -1355, 824, 1241, -772, -1519, -1435, -601, -446, 849, -776, 1010, 218, 634, 2542, -1105, 64, 
    393, 896, -4876, 361, -1540, 2346, -4509, 228, -2979, -3523, 1117, -1104, 2288, -610, -4899, 2437, 
    -3086, -399, 1570, 2376, -268, -1152, -714, 1617, -1489, -1226, 1210, -697, 1643, 996, 58, -1959, 
    -4098, 184, -1684, 2006, -773, 36, -2062, 4153, -210, -5348, -1048, -336, -141, 2958, -8627, 1741, 
    633, -1140, -608, 398, -1583, -591, 1145, -3053, -21, 1712, 1401, -1104, -1319, -30, 319, 1372, 
    -866, -558, 2126, 77, 2204, 3293, -224, -1154, -1016, 233, 1645, 216, 1124, 416, -6006, 190, 
    302, -1590, -130, 2140, 722, -709, -4231, -610, 2173, -428, 3315, 496, 1445, 154, -2500, -5429, 
    4088, -7431, -1302, -2248, 463, -1404, -870, 821, -1056, -6179, 2400, -2698, -1715, 4343, 2204, 2710, 
    1418, 2036, -203, -3083, 911, -475, 312, 588, -2747, 1573, 297, -6285, 439, 1347, -419, 53, 
    1221, -601, 2453, -224, 1166, -1462, 1258, 16, 1112, 6148, -334, 429, -842, 986, -7838, 74, 
    -798, 902, 1060, 656, -1901, -1012, -851, 2402, 3178, -2565, -3436, -2210, -245, -698, -1837, 2598, 
    -123, 1137, -234, -118, -373, -376, -1201, -119, -5644, -5463, 1320, -2653, 1169, -2846, 261, 530, 
    749, -812, -197, 289, -26, -580, -2144, -197, -603, -758, -1340, -1994, -1418, -493, 1493, 745, 
    -1770, -991, 302, 739, -772, 558, 3802, -71, -1019, 1769, 1260, 1196, -3795, 3256, -1304, -1136, 
    569, -918, 1077, 2186, 2310, -1643, -2996, 4415, 1073, -665, -1713, 4338, 1015, 314, -825, 2005, 
    2147, 113, 3333, 730, -351, 543, 2226, 1386, -1529, -338, 1260, -1919, -284, 658, 3150, -1683, 
    -376, -449, 1824, 1786, -1560, 617, 305, -2608, -114, 907, 877, 1958, 181, -937, 104, 2308, 
    -1534, -904, -1431, 320, 2703, 1433, 2688, 655, -225, 4985, -1562, -188, 1300, 1470, -582, 1274, 
    2801, -246, -66, -1614, -1104, -313, 1794, 929, 1888, 857, -2936, 2075, -312, -547, 388, -662, 
    776, -667, 1353, -973, -819, -18, -256, 399, 344, 3449, 2191, 1598, 600, 1267, 2237, 1237, 
    223, 535, -1705, -508, 66, -1658, 6, 1082, 2685, -2043, -4613, 222, -206, -1063, -823, -7, 
    295, -2628, -1280, -3163, -130, -3800, -150, -94, 799, -8355, -388, -969, -1271, -1898, 2151, -1024, 
    1109, 489, 3769, -3558, -2337, 111, 887, 4002, 1030, -444, -947, -998, 152, 562, -1289, -1051, 
    -1801, -1232, 2873, -1444, -3469, -1129, -3655, 1182, 613, 354, 625, -1473, -591, 457, -777, -261, 
    -1725, 4386, 276, -1012, 1910, -914, 2536, -634, 234, 1521, 1692, 941, -91, 1389, 161, -684, 
    -1116, -8130, -1044, -258, 2438, -3660, -5689, 1115, 1316, -6322, -667, 2027, -1144, -1291, -1085, 226, 
    -1129, 199, -1289, 1655, 2948, 959, 33, -4485, 4544, -923, -1206, -40, -1771, -479, 992, -2530, 
    -1483, 2797, 1154, 1199, -1207, -1513, -4717, -80, 2353, -4144, 4941, 2, -18, -5830, -4444, 1713, 
    -450, -2117, -1464, 1258, 2799, 1693, 3076, -1335, 2041, 1292, 4484, -945, 731, 2413, -375, -3973, 
    3472, -2107, -1045, 260, -2723, -7107, 1702, 395, 3734, 1952, -5323, 3997, -5035, 1115, -2173, -1354, 
    -29, -206, 345, 2760, 3178, -2426, 572, -1040, -2168, -1643, 2234, 1437, -4037, 399, 1037, 4410, 
    268, -2831, 3557, -166, 1147, -3151, 3728, -443, 1499, 186, 6270, -54, -2822, -1312, 240, 121, 
    -653, -387, 86, 29, -1458, 17, 3797, -4352, -345, 70, 330, 981, -888, -3355, 2320, 1535, 
    -2162, -2254, -2092, 28, 1134, 6604, -6441, -1516, 2235, 2510, 1943, 885, 3704, 6111, 450, 1336, 
    -5738, -254, 485, 43, -295, 527, -1265, -855, -1643, -377, -2482, -7293, 324, 189, -182, -458, 
    -1245, -2390, -6500, -189, -1789, 53, -1179, -1054, -2943, 4590, -104, 109, -1712, -530, -324, 696, 
    688, -804, -2220, 374, -48, 1397, -2896, 5458, 433, -1030, -1367, 3629, -530, 2278, -502, -1129, 
    -624, 1588, 1984, -2095, 4211, 739, 119, -351, -2907, -388, -3920, -1533, -1202, -3919, -2562, -260, 
    1987, 883, -2538, -5107, -2678, 1453, 674, -386, 1332, -1070, -467, 2519, 1074, 121, -764, -1883, 
    -2881, 3180, 3035, 1050, -4175, -2974, 149, -788, 1052, -2748, -808, 999, -505, 1161, -1493, 427, 
    -2290, 1089, 3714, -1487, -231, -1123, -4179, -1349, -1014, -1651, 2652, -604, -651, 66, -787, 83, 
    2968, -1926, -2909, 47, -3710, -6134, -1925, -858, -2649, 1584, 1188, 2208, -1331, 2736, -1864, -294, 
    2330, -524, -506, -1265, 2062, 572, 1159, 2816, 31, -1156, -620, 3615, 303, 210, 847, 1109, 
    -344, -1696, -1491, 748, 1197, 4317, 8452, -3885, 789, 1381, 10594, -2537, 1565, -1254, -2501, 691, 
    -317, 1093, 1656, -25, 3573, -5501, -3615, -2528, -940, -479, 2138, 80, 352, 237, -1236, -2869, 
    -3326, 796, 1159, -511, -4991, -6054, 6994, -775, 3064, -1537, -6918, -370, -2215, 611, -183, -561, 
    1437, -662, 1280, 2507, 2153, -1904, 1230, 2613, 730, -1899, 754, -2114, -1059, 334, 4170, 4376, 
    897, -1565, 1924, 1507, -1108, -442, 4097, -1713, -34, 1953, 4186, -20, -2059, -939, 1542, -1266, 
    -298, 238, 979, -146, 927, -120, 2542, -1126, 902, 583, 399, -1351, -2516, -1986, -106, 317, 
    -3362, 790, -2531, -152, 583, -2085, -1863, -477, 1943, 1799, -1962, 121, 1555, 570, -880, -1537, 
    -1743, -102, -1612, 2135, 522, 51, -55, -1721, 729, -215, -248, 2987, 1170, -962, 230, 2553, 
    -1469, -919, -347, -1758, -851, 870, 4584, 459, -2557, -982, -2588, -607, 30, 424, 2611, -234, 
    1679, -503, -367, 635, -590, -282, 5504, -254, -414, -463, 907, -480, 76, -145, 3627, 519, 
    -2913, -1804, 181, 1673, 49, 514, -409, -283, -2274, -1542, 262, 608, 2169, -251, 1410, 1982, 
    -840, 1885, 396, -1721, -22, 388, 35, -1983, 1431, -810, -887, 2989, -144, 339, 569, -673, 
    3364, 2466, 1439, -1464, -251, 3683, -1295, 1352, 634, -606, 2534, 208, -170, 1247, 109, 411, 
    -1302, -181, 1414, 2229, -206, 985, -171, 11, -590, -961, -217, 1158, -278, -117, 233, 583, 
    -1169, -120, -524, -776, -403, 2219, -818, -290, -3483, -238, -177, -1359, 895, 877, 2339, -445, 
};

static const int16_t fx3_paramModel2Alpha[16] = {
    565, -1953, 1843, -316, 1582, 90, -370, 2442, 5216, -663, 4525, 2598, -459, 1090, 607, -1329, 
};

static const int16_t fx3_paramModel3Bias[16] = {
    2271, 3349, 1169, -3278, -2331, -474, 458, -2556, -2370, -179, -83, -2850, -1046, 664, 25, -2765, 
};

static const int16_t fx3_paramModel3Weights[2304] = {
    -1642, 350, 64, 1338, -282, -47, 232, -778, 237, -2010, 564, -281, -249, -348, -263, -3712, 
    319, 361, -370, -1547, 1078, 2658, -464, -306, 120, 1156, -1061, -199, -2115, -1081, -735, 1316, 
    -384, 661, 2, 1566, 349, -156, 1795, -284, 3763, 1340, 3481, -198, 1209, 824, 1277, 205, 
    311, -679, 146, 1412, 80, -229, 760, 1768, -1625, -135, 2097, 2017, -1759, 4, -1976, 772, 
    -1184, 478, 498, -18, 2895, 244, 573, -4259, -2947, 379, -172, -601, 435, -505, 87, 999, 
    -549, 107, -1609, 306, -1256, 1160, -384, 85, 61, -1285, -931, -1118, -803, -664, 953, -3187, 
    -1075, -179, 23, 210, 2451, -807, -2215, -1591, 451, 109, -461, -112, 1058, -1716, 1803, -1173, 
    1480, 709, -1710, 811, -1800, 2799, 215, -660, -889, -1000, -1075, -1312, 1761, 1517, -490, -1241, 
    1373, 36, 380, -1631, 3001, -944, 57, 690, -596, 605, -106, 431, 807, -101, 536, 1199, 
    992, 989, 1, 340, -450, -946, 657, 873, -205, 423, -96, -884, -280, -912, 301, -1454, 
    1655, 354, -2444, 1077, -3103, -1448, -3787, 947, 879, -917, 842, -887, -223, 2249, -134, 803, 
    -1347, 980, 1115, 229, 4003, 2611, 1569, 242, 71, -2020, -1334, -708, 1697, -1471, -938, -1301, 
    1652, 209, 938, -3005, -2464, 178, 329, 537, 2783, 502, -613, -1777, -1455, 197, 343, 1282, 
    -1079, 2259, -1334, 1944, 651, -36, 760, 584, -631, 313, 172, -1001, -564, -1255, -558, 725, 
    411, -3084, -1024, 4342, -753, 401, -62, -156, -706, -1349, 398, -448, -1377, 3002, 1285, 942, 
    -2921, -738, -2604, -675, 660, 570, 1659, -311, 395, -68, -2030, 1017, -670, 164, -1266, -525, 
    1987, -1120, -1051, -67, -3760, -1317, -273, -391, -2083, -611, -939, 2366, -2892, -1672, 457, -3514, 
    1967, -1029, -1789, -8401, 1604, 324, 193, -1171, -1698, 778, 1117, 1847, -2217, -1376, -522, 1596, 
    196, 430, 983, 1875, 1775, -514, 1011, 360, 877, -1032, -6, 553, 2994, -1326, 38, 38, 
    -239, -606, 597, -1143, -351, 572, -704, 865, 45, -2055, 853, -2222, -2308, -247, -419, -2285, 
    898, 924, 950, 24, 161, -1397, -2656, -1303, 2219, -304, 149, -4563, -132, 1134, -237, -490, 
    1099, 822, -780, 39, -3477, 645, -145, -3556, -2622, -3250, -872, -1348, -760, 1127, -52, -3500, 
    574, -1293, -527, -49, 972, -902, 216, -188, 1135, -2344, 300, -1143, -1621, -4495, 4, -1497, 
    721, 736, -402, -1010, 1192, -800, -760, -2022, -3111, -1086, -3837, -4259, 41, 323, -249, 905, 
    -3703, -874, 433, -7878, 2492, -1191, 1697, 2402, -2732, 341, 550, 1888, -321, -2393, 252, 1314, 
    -2712, 3071, -1638, 4543, 762, -2203, -17, -3665, -480, 2075, 502, 2149, -1820, 757, -230, -641, 
    2789, -3899, 32, -1327, -3107, 96, 1750, 592, 370, 250, -1189, 531, -2815, 2970, -1235, 1938, 
    -3159, 1647, -478, 2260, 2576, 2733, 2562, 983, 1961, -1208, -289, 1104, -2619, 910, 912, 2275, 
    5237, -2242, -1469, 901, 2082, 538, 455, -862, -2484, 501, 317, 1113, 1069, 136, -1491, -1295, 
    -2165, 1080, -751, -1856, 1050, 562, 946, -426, -4391, -215, 1135, 2621, 2415, 792, -729, 555, 
    500, -3923, 117, 1505, -218, 615, -868, -425, -116, -2084, 1426, 1554, -436, 4173, -4370, -1200, 
    1636, -2092, 658, -4758, -1145, -185, 1274, 396, -725, -194, 322, -526, -1922, -11, 2058, -1789, 
    216, -1093, 192, 2009, 2339, 1321, 316, -1351, -97, 160, -1554, 1832, -47, -1123, -207, -2207, 
    -1854, -658, -574, -6852, -2083, 1984, -443, -3196, -1305, -1820, 996, -579, 224, 73, 257, 2213, 
    -206, 854, 905, 1742, -1016, -1344, -0, -495, 7, 1271, -135, -27, 1254, 363, -1109, 872, 
    1352, -858, 625, -1002, -437, 645, 547, -1180, 2182, -1354, -511, -1896, 317, 439, -514, -4482, 
    826, 356, 8, 163, 44, -17, 234, -820, -1484, -318, -682, 325, 1712, 719, -256, 909, 
    239, -874, 228, -1455, 411, 1336, -636, 1381, -6707, 384, -1245, -3644, 95, -1624, 379, -452, 
    -28, -1326, -1284, -1264, -685, -229, 146, -903, 95, -481, -616, 349, -346, -1490, 507, -344, 
    -347, 225, 503, -1473, 346, -54, 47, 2402, 968, -1242, 12, -570, 1362, -176, 227, -175, 
    694, -81, -2597, -1422, 1598, -1495, 2267, 1564, 1284, -296, 44, -65, -885, -680, 1188, 1372, 
    3060, 287, -1195, -677, -394, 89, 530, -3194, -725, 1225, -688, 1070, 1763, 266, 1685, -673, 
    629, 76, -611, 489, -1950, -313, 1070, 492, 68, 405, 580, 698, 1159, 1688, -1108, 1185, 
    1953, -111, -33, -2217, 1124, 3440, 972, 1964, 8, 161, -1145, 496, -678, 30, -287, -528, 
    -711, -305, 1420, -203, 491, -812, 111, -1263, 582, 681, 145, -493, -4336, 813, 133, 1508, 
    3747, -1272, -1576, 1167, 969, 606, 256, 1161, 1516, -1463, 1467, -66, 1479, 2447, 203, 2212, 
    -147, 926, 1917, 792, 508, 487, -615, -5953, 48, 524, -1523, -559, 1340, 2270, 544, -1601, 
    -6312, 2297, -1833, 1102, -689, 31, 1466, 1321, -247, 335, 1009, -3124, -3490, 73, -841, -859, 
    -354, -25, -546, -1278, -6166, -3198, 473, 2984, 2042, 508, -2529, -2346, 13, 478, -649, -336, 
    298, -1796, -1998, -605, 205, 1107, -148, -703, -222, -6946, -1153, -40, -1763, 22, 272, 224, 
    -509, 1450, 3089, -65, -4749, -862, 327, 1598, -847, 4104, 3875, -526, 780, -1132, 2259, -507, 
    -1610, 1110, -2, 525, 727, 698, 925, 1603, -3380, 62, 637, -650, -1989, -1205, -249, -389, 
    -508, -653, 1203, -1813, -4139, -2379, 1530, -8340, -121, 1717, -383, -3179, 1580, -1970, -1142, -1546, 
    228, -50, -4595, 1278, -640, -3725, 710, -4229, 371, -1819, 507, -2022, -1015, -2839, 130, -2984, 
    2352, -1031, 2202, 1414, 2237, -7182, -948, -4209, -611, -446, 370, -2756, 2820, 635, -6501, 1748, 
    -516, 1394, -3958, 755, -7471, -4056, -4228, -2255, -873, -153, -394, -1791, 660, 434, 3651, -2288, 
    2351, 173, -28, 1791, 304, -1735, 651, 584, -2178, 163, -319, 452, -1459, -4385, 589, -2960, 
    1429, 2920, 129, -1358, 410, 1316, 244, 1952, 422, 3579, 624, -105, -1139, 1115, 1206, 435, 
    -915, -3226, -3385, 715, -510, -3836, -6526, 1683, -679, 452, -2346, 862, 437, -541, -1928, -340, 
    2276, -3521, -8508, -69, 2135, 1403, 1869, -961, -246, -1818, 1388, 307, -1153, -1200, 2266, -2850, 
    -759, -1346, 2136, 93, 1061, 301, 1129, 1340, 308, -51, -1814, -0, -3997, 583, 1187, -369, 
    218, -109, 245, 280, 490, 1147, 620, 384, -207, 820, -223, 1077, -741, -898, 447, 375, 
    483, -1593, -5523, -797, -175, 205, -1788, 1503, -170, -2953, 862, 458, 1343, 2189, -896, 186, 
    -2481, -503, -5881, -277, 322, -58, -741, -96, -7, -350, 1578, 2316, -3274, 849, -2468, -571, 
    -1713, -5017, 1864, -4993, -12225, 2321, -2862, 5588, -5342, 151, 2239, -1823, -369, 389, -1306, -557, 
    274, -4690, -121, -4420, 2334, -4872, 902, -1883, -956, 2906, -763, 1633, -85, -1900, -148, 1069, 
    6024, -2078, 1059, -2841, -9869, 3759, 1705, -5665, 403, -2143, -1898, 1230, -378, -1727, 855, -1928, 
    -5191, -3556, -3259, 212, 392, -1299, -826, -2367, -1244, 388, 3455, 124, -3153, -2825, -1661, 974, 
    -2402, 192, 1237, -1263, -2476, 509, 1610, -358, -2063, -2572, 726, -625, 1151, 1322, -1071, 739, 
    1060, -2522, -1199, -852, 2165, 665, 2861, -3550, -1563, -2803, 368, -748, 2039, 345, -296, -7929, 
    354, 2932, 1185, 471, -1020, -294, -1095, -1096, 286, -1725, 912, -4430, -3809, 1331, -1026, 3626, 
    -809, 4905, -1427, 33, -1502, 411, -242, -3552, -422, -1855, -2111, 11, 6075, -1561, 327, 297, 
    2866, 1752, 1451, 7218, 1717, -3597, -487, -65, 167, 1077, 2055, -214, -3232, 860, 3268, 1980, 
    -7429, -867, -6859, -788, -1066, 1127, 413, -595, 3619, -4474, 900, -61, -6552, 6973, -3065, 2533, 
    -6416, -1584, 4435, 6732, 212, 243, 1300, 34, -59, 3372, 1910, 2210, 3686, -4819, -1978, 1435, 
    -1730, -1169, 4206, 4691, 309, 6041, 1733, 2407, -2963, -324, 906, 449, 3399, -461, -1132, 8021, 
    1708, -527, 6252, -3305, 1712, -1051, 1667, 2278, -1617, -2026, -1334, -2679, -2968, 1711, 470, -680, 
    -1469, -4896, 712, -595, 192, 1787, 2260, -290, -7772, -3258, -564, 1598, -1579, 3790, 146, 1006, 
    658, 4964, 3171, -1883, -624, -110, -2672, 766, 1014, -5316, -774, -1113, 678, 566, -10417, 1722, 
    4144, -4093, 4999, -264, 1201, 292, 3212, -959, -3477, -3025, -1618, -2162, -402, -2674, 811, -366, 
    269, -1210, -1366, -4143, -7652, -2947, -1212, 2219, -2095, 862, 113, -772, 128, -603, 195, -2168, 
    -4480, -1245, 2352, -2319, -4065, 44, -1582, 1014, 2518, 826, 814, -1453, -1380, -1843, 761, 1332, 
    1892, -1514, -1341, -3964, -4379, 69, 509, -332, 1307, -786, 145, -1218, -451, -744, 319, 388, 
    -1912, 592, -273, -4717, 418, -238, -614, 1159, 1078, -893, -27, -688, -1940, -302, 46, -3728, 
    -1563, -1589, 34, -306, 80, -487, -946, 398, 282, -2531, -414, -2563, 2702, -841, -246, 418, 
    1435, -771, -697, 2321, -850, 1674, -579, 1216, -4608, -248, -103, -3167, 78, -2854, -853, -149, 
    752, -626, 1269, 321, -1084, 239, -282, 460, 1000, -2206, -603, -2751, 878, -460, 50, 862, 
    -229, 2183, 351, -3402, 19, 9, -641, 2532, -205, -1635, -1122, -699, 286, 1159, -732, 131, 
    3533, -547, 1291, 3291, -2079, -1241, -311, 1351, -323, -69, 632, -65, -4189, -585, -1401, -559, 
    5704, -2040, 1123, -2860, -1515, 729, -855, 803, -1402, -61, -312, -1281, 2895, -397, 1036, -249, 
    543, 1971, -1123, 1131, -2437, -2684, 934, -320, 1182, -64, 897, 1687, -1008, 1417, -1692, -265, 
    -1178, 2492, -508, -4704, 2882, 1776, 2076, 1826, -125, -1999, -928, -434, -245, 302, 658, -2333, 
    -4663, 897, 605, 264, -1309, -109, 1084, 1781, 132, 41, -234, -481, -4431, 4465, -2062, -2951, 
    420, 1495, 187, -213, 2563, 2995, 48, -919, 1431, -3166, 1847, 886, 26, 2403, -1470, 187, 
    895, -1510, 685, -442, -18, -690, -389, 2025, -817, 1467, -1984, -761, 804, 2826, 1404, 2637, 
    644, -34, 1742, -866, -49, 952, -152, 2344, -2484, 583, 352, -4398, 2704, -2755, 160, 3593, 
    1281, 633, -526, -178, -7452, -2226, -230, -392, -1727, -1226, 98, 999, -549, 275, 371, 207, 
    42, -114, -797, 631, 310, 231, -211, -258, -132, 184, -1417, -379, -2782, -828, 369, 691, 
    -199, 826, 2089, 1011, -879, 713, -1743, -25, 638, -714, 3838, -2292, 109, 446, 578, -1695, 
    464, 865, 1058, 1157, -1567, 725, 482, 1598, -1123, -631, -184, 656, -209, -513, -2586, 373, 
    -137, 1615, 1857, 87, -3935, -2049, -1391, 2456, 825, -349, 69, -922, 3891, -1703, 174, 975, 
    -1031, 132, -855, 468, -223, 1268, -1796, 63, -382, -951, -55, -853, 29, -1892, 747, 666, 
    1516, -3630, 2905, -1061, 532, -148, 58, 803, -541, -462, -622, -495, -762, -1962, 1474, -2095, 
    1675, -827, -2851, 1479, -1105, 2038, 116, 1218, -1314, 579, -651, -710, 2133, -48, 955, -796, 
    -578, 407, -641, -513, -852, 1246, -1074, 218, -1984, -455, -806, 557, -22, 1668, -299, -351, 
    256, -94, 272, 537, 1720, -1912, 178, -593, -313, 997, 232, 233, -208, 344, 409, 1, 
    -381, 365, 659, -2676, 246, -989, -3853, -1072, 20, 15, 273, -519, 914, -1238, -852, 262, 
    1070, -90, -1318, -284, 1137, 735, 353, -1472, -1010, -843, 1717, -437, -144, -1869, 1889, -402, 
    1564, 145, 261, 311, 316, 182, 920, 272, -575, 958, -1266, 282, -615, 160, 1821, 332, 
    -654, 577, 418, -131, 65, 755, 144, -359, 907, -13, -91, -297, -195, 230, 450, -1523, 
    259, -871, -1454, -2157, -17, 702, -2532, 829, -3333, 168, 208, -4586, 920, 2286, -4537, 942, 
    -505, -164, 363, 595, -155, 210, 24, 77, 957, -847, -888, 185, -870, -1915, -3004, 139, 
    -1496, 5, -1265, -520, -5326, -1996, 936, -366, -1213, -1150, -913, 774, 641, -791, -143, 447, 
    2084, 0, -597, -244, -2253, 2323, 1314, 0, 1405, 1416, -1506, -458, 82, -1294, 655, 1058, 
    -647, -563, -342, -3697, 1805, 773, -2516, -614, 59, -117, 1749, 1071, 1211, 756, 241, 270, 
    -2979, -148, -1830, -1712, 4523, -2088, -474, -611, 669, 766, 100, -1199, -356, -51, -1059, -195, 
    -110, 1178, -969, 583, 413, -1683, -1671, 1397, 119, 559, 410, -1203, 2134, -453, -1056, -63, 
    303, 693, -705, -503, 1997, 1515, -1829, 732, -1115, 55, -56, 142, 1816, -885, -251, -809, 
    -292, -2085, 1321, 1799, -2079, -115, -1048, 2380, -837, -1527, -827, -2629, 2014, -2762, 239, -53, 
    1761, 1145, 1605, -722, 365, 1651, -534, 1688, -742, -899, -2210, -1119, 1514, 950, 1933, -210, 
    3757, 1045, 341, -1382, 1211, -1328, 317, -1226, 943, -64, -820, 1038, -1542, -512, -438, -837, 
    -836, -4258, 557, 298, 834, -3546, 1328, -1041, 1448, -849, 506, -650, -1090, 501, -221, -710, 
    303, 3205, 2006, -7867, 2417, 818, -1567, -128, 338, 1856, 1815, -892, 1795, -184, -66, 983, 
    3641, -2839, 377, 856, 2217, 379, 1212, -1026, 431, -2405, 3147, 1332, 911, -519, -830, 222, 
    -797, -827, -583, 226, 484, -751, 787, -227, -290, -342, 496, 1940, -4983, 399, 8, -680, 
    -29, 926, -323, 251, 102, 1663, 1081, -1288, -2310, -5047, 1325, 142, 618, 4387, -4208, -492, 
    109, 97, -849, 1691, 57, 1264, -2839, 829, -1625, 1282, 106, -9297, -516, 1854, -1613, -936, 
    -466, -350, -756, -634, 997, -1338, 2082, -241, 878, -1633, -912, -889, -3830, -914, 800, -276, 
    -480, -590, -136, 391, -7544, 854, 299, 571, 454, 889, 153, 964, -49, -875, 104, 362, 
    -1698, -6, -288, 283, 308, -2230, 2676, 283, 1065, 866, -1052, -2658, -312, 140, 741, 1293, 
    -239, 198, -667, -423, -420, 578, 2511, -1506, -1303, 907, 1522, 2957, -1279, -365, -204, -1640, 
    -17, 59, -1769, 362, 1377, 89, 974, -1317, 1097, 1225, -1541, 1745, -996, -132, -82, -4016, 
    343, -233, -531, 582, 98, -827, -646, 696, 1487, -1551, 9, -696, -363, 195, -73, -373, 
    239, -2789, -102, -864, -112, 171, -348, 757, -3724, -315, 159, -1630, 757, -2775, 159, -340, 
    -443, -1260, -66, 254, -161, 640, -928, 617, 554, -454, 519, -1207, -324, -460, -445, -2221, 
    1486, 279, 83, -1358, -744, 720, -258, 565, 292, -805, -298, 878, 2112, 2154, -282, -705, 
    -665, 977, -399, -223, 2030, 413, 398, -251, -1804, 415, 390, 487, 555, -88, 137, -384, 
    63, -128, 951, -1133, -1137, -1510, -165, -1072, 692, -1124, 623, 875, 1171, -351, -291, -854, 
    -301, -645, 1385, -614, -118, -1301, -290, 891, 429, 1299, 1258, -1124, 1118, 1275, -831, 1467, 
    1075, -547, 1478, -723, 3406, 1321, 982, 461, -35, -298, 1757, -41, -993, 1200, -8, 8, 
    -638, -61, -3, -249, -33, 692, 441, -69, -305, -987, -562, 598, 1502, 83, -1189, 454, 
    -166, 598, -466, -317, 1812, 799, -301, -1243, 1727, 244, 1529, -752, 573, 1792, -2675, 1025, 
    100, -416, 224, 1833, 1992, 521, 1034, 1662, -1175, -212, -2438, -2797, 810, 2198, -1127, 1341, 
    -102, 23, -282, -1, 193, -586, 1363, 559, 2027, 835, 398, -2902, -3026, -719, 293, 727, 
};

static const int16_t fx3_paramModel3Alpha[16] = {
    185, -1784, 3629, 270, -506, -33, 3767, -678, 1571, -237, -462, -256, -165, 1226, 592, -512, 
};

static const int16_t fx3_paramModel4Bias[16] = {
    -860, 163, -2500, -691, -362, -906, -402, -613, -756, -1274, -349, -2743, -2579, -212, -360, -445, 
};

static const int16_t fx3_paramModel4Weights[2304] = {
    358, -972, 892, -740, -77, -842, 236, -511, -494, -2517, -152, -89, 271, 203, 55, -226, 
    134, -1651, -877, -39, 116, -1545, -32, -442, -463, -243, 95, -901, -481, -1324, 471, -76, 
    -1038, 1018, -1213, -2176, 449, -837, -1663, 513, 401, -1335, 410, -272, -68, 241, -867, 125, 
    -1891, 167, -864, 1207, -483, 53, -1123, -1464, 105, -322, 383, 1923, -72, 35, -288, -1724, 
    -279, -1034, 687, -355, -9, 576, -323, -128, -236, -1921, -641, 503, 106, -402, 150, -297, 
    -255, -1808, -299, 184, -779, -3260, 376, 115, -1559, 1382, -196, 710, -387, 39, 113, -323, 
    -264, 517, 158, -743, -851, -108, -410, 93, -938, -731, -639, -903, 381, -179, -190, 839, 
    636, 184, 196, -586, -1417, 78, -605, -2806, -616, 153, -100, -1278, -437, -24, -104, 424, 
    559, 1077, 13, -599, 551, -902, -161, 28, -948, -1924, -645, 479, -157, -776, -805, -799, 
    -591, 312, 366, 221, -31, 1061, -124, -15, -91, -705, -282, -199, 421, 1190, 289, -37, 
    107, -720, -655, 375, -180, -703, -511, -568, -315, -2543, -234, -1791, 845, -24, 1047, -229, 
    -220, 27, 338, -3019, -125, 1, -507, -1348, 1228, 59, 443, -1718, -18, -157, 532, -1899, 
    -194, 474, -84, -245, -230, 11, -570, -369, -469, 32, -219, 180, -790, -76, 176, 88, 
    796, -396, -225, -204, -52, -1383, -270, 642, 241, -949, -473, -348, 211, -604, 412, 237, 
    -777, 524, 172, -414, 331, -150, -1542, -914, -564, -25, 752, -236, -437, 1092, 1337, -463, 
    -462, -127, -597, 836, -41, 142, -314, -3589, 258, 18, 482, 133, 694, 6, 190, -619, 
    741, 1531, -125, -738, 146, -2116, -571, 223, 38, -1497, 619, -178, 505, 827, -224, -961, 
    805, -1287, -138, 432, -561, 646, 529, -272, 804, -1362, -586, -3955, 65, 160, -924, 246, 
    -592, -588, -307, -2473, 293, -274, -948, -516, -236, 348, 1414, 2021, 1412, -62, -2384, 799, 
    2064, 53, -1099, -218, -769, 140, -902, -789, -251, -560, -35, -570, 498, 86, -171, -766, 
    -902, -1277, 678, -15, -155, -59, 398, -388, 1459, -264, 761, -1817, 333, -402, -429, -119, 
    186, -356, 466, 145, -550, -1046, -15, 688, 37, 412, -128, 295, -36, -693, -780, -168, 
    409, 111, 378, -1089, 1957, -1147, -2593, -3787, -769, 1068, -1129, -1171, 392, 910, 25, -412, 
    706, -47, -262, -58, 1006, 302, -755, 184, 345, 316, -1431, 338, 618, -67, -466, -658, 
    881, 443, -736, 1249, -498, -1544, 631, -291, 430, 312, 817, -1988, -855, -1835, -268, 2393, 
    -73, 2004, 376, 403, -1107, -2320, 810, -84, -792, 378, -321, -254, -1540, 35, 958, -579, 
    2676, 1252, -2000, -1742, -791, 1057, 973, 79, 40, 302, -783, -871, 1353, 401, 1666, -7371, 
    -1697, 214, 1829, -1004, -1040, -3, -1475, 496, -3420, -23, 144, -164, -900, -231, 2627, 921, 
    -597, -2905, -377, 635, -391, -100, -196, -951, 599, 1086, 891, -142, -499, 323, 581, -261, 
    60, -950, 201, -140, -516, 656, -139, -532, 270, 922, 614, -290, -432, -43, 688, -156, 
    -954, -242, 808, -51, 922, 24, -2120, -857, -480, 951, -387, -1798, -681, -381, -698, 172, 
    -553, -150, -1491, -566, -973, 230, 501, -529, -75, -165, -70, -259, -737, 79, -165, -226, 
    266, -1139, 514, 267, -140, 352, 128, 197, 480, -152, 397, -746, -245, -109, 148, 600, 
    -156, -2069, 746, -546, 81, -2365, -1490, -9025, -289, -348, -993, -2967, 268, -93, 120, -1577, 
    46, -270, -846, -80, 812, -740, -1454, -489, -1044, -184, -260, 607, 56, 590, -931, -642, 
    -89, 163, -262, 101, -244, 101, -951, -90, 50, -480, -738, -1057, -49, 42, 161, -211, 
    -294, -1762, -151, -288, -150, -1126, -54, 431, 46, 650, -721, 1240, -49, -235, 523, -245, 
    -95, -374, -91, -9005, -720, 1360, -313, -1116, 547, -2225, 21, -1623, -12, -681, 157, -6164, 
    -173, 84, 665, 721, 984, -1138, -1863, -223, 403, -422, -1194, -1314, 101, 605, -703, -279, 
    -188, 32, 433, -101, -1843, 28, -800, -398, -92, 4, 76, 74, 492, -92, -300, -72, 
    727, 1979, -522, 700, -144, 476, -512, 301, 54, -256, -1364, -150, -251, -113, 730, 182, 
    827, -143, -109, -1561, -615, -1344, 251, -2421, -282, -1141, -792, -11039, 232, 55, -821, -6114, 
    675, -493, -343, 789, 16, -476, 33, -1841, -484, -346, -40, -1045, 542, -155, 1104, -18, 
    645, 18, 539, 254, -2, -151, -937, 156, -565, 107, 115, -286, 381, 43, -0, 221, 
    567, 586, -124, -928, 370, 718, -610, -60, 538, 352, -305, 65, -96, 1010, -315, 322, 
    26, 339, -625, -1372, 27, -813, -755, -2081, -274, 1804, -297, -1045, 536, -830, -223, -6221, 
    -515, 174, -169, -171, -310, -165, -494, 516, 537, -184, -1243, -2782, -196, 106, 1045, -977, 
    372, -23, 185, 77, -178, -2, -928, -333, -928, -28, -172, 620, 582, 18, 732, 104, 
    557, 1120, 1315, 420, -257, -1873, 195, 638, 543, 483, -23, -546, -316, 214, 218, 475, 
    782, 1185, 722, -380, -386, -3003, 279, -21, 878, -3307, 50, -15, -445, -2102, -555, 96, 
    -1504, 1480, -981, 350, -1351, 587, -195, -4759, -401, -550, 134, -331, 805, 610, 659, -386, 
    -1641, -289, -1950, 962, -492, 39, -435, -316, 299, 140, -190, -6290, -407, -131, 197, -2338, 
    -266, -3352, -2007, -28, -67, 919, 62, 311, 595, -829, -1925, -1876, -141, 613, -528, 184, 
    1053, -10599, 1996, 436, -92, 879, -124, 17, 698, -5338, 437, -1864, -33, -2378, -14, 510, 
    -311, 3172, 685, 1207, 755, 1271, 176, 1968, 1624, -2933, -727, -977, -1720, -2632, 1073, -75, 
    4485, -88, -1019, -5441, -1563, -151, -79, -10845, -722, -744, 884, -1076, -567, 154, -92, -5137, 
    611, 182, 591, 1397, -217, -1785, -872, -531, -99, -964, -1194, -944, -91, -2930, 89, -5, 
    -536, -1132, 223, -353, -1059, -7031, -122, 202, -105, -5895, 172, 204, -824, -2115, 725, -255, 
    558, 51, 262, -2417, 929, -1071, -145, -4715, -860, -3498, -273, -5846, -152, 514, -360, -1008, 
    -498, -323, -630, 617, 225, -24, 1138, -848, 846, 45, -472, -1915, -1283, 439, 1008, 2075, 
    -112, 423, 371, -412, -113, -620, -1360, 418, 411, -164, 851, -348, 1093, -700, 2731, 338, 
    900, 200, -404, 130, 457, -3091, 229, -318, -190, -511, 573, 152, -97, -54, -1531, -654, 
    537, -411, 300, -15, -952, -1558, 1, -1002, -271, 1201, -601, -2092, 1103, 1454, -1544, -8006, 
    -998, -60, 481, -9730, 977, 100, -696, -442, -1157, -5, -601, -754, 1886, -366, 338, 1242, 
    625, -579, 240, -189, -338, -135, 287, -1403, -916, -6134, -515, -530, 50, -1984, -73, -2620, 
    -894, -1429, 901, 50, 1650, -3396, -423, 772, -1154, -5237, 845, 5603, 2226, -6280, 770, -98, 
    -1404, -1032, -1283, -1127, 954, -198, -943, 1916, -1897, -1065, -655, -58, 1618, -752, 5431, 1695, 
    2774, -441, -1263, -261, -1118, -112, -507, -1139, 1343, 1701, 122, 2751, -383, -511, -2613, 30, 
    -450, -3992, -376, 1589, 207, -195, -2312, 2780, -4841, 1712, 3039, 2135, -355, 1041, -564, -1320, 
    -413, -3076, 2848, 114, -179, -9696, 1914, -887, -2852, 1748, -1828, -986, 324, -1547, -1885, -152, 
    547, -2590, -931, -11003, 191, -732, 3569, -4179, 3068, 3406, -187, -1558, -3936, -900, 1578, -1073, 
    3766, -231, 447, -347, 2536, -774, -1542, -235, -895, -1173, 1903, -3282, 25, 85, 1470, 258, 
    -3384, -180, -1854, -2922, -716, 373, 2232, 2441, -29, 13, 1167, 1106, -336, -1648, 1376, 1703, 
    1116, -1913, -1497, -1597, 142, 3245, 229, 529, -368, 288, -1429, 123, 465, -5743, -854, -817, 
    -4754, 1262, -671, 2932, 1988, 1595, -519, 66, -579, -1126, 100, -3090, 2104, -191, -4546, 3477, 
    -6158, -1281, -5108, -1284, -2351, 309, 3837, -85, -3891, -39, -1396, -821, 1153, -217, 4522, -544, 
    -1405, -39, -1405, -547, 451, -2179, 2404, -365, 70, 1229, 2147, 670, -1869, -951, 5774, -2474, 
    1725, -10202, 1870, 516, 1644, 1230, -537, 678, 1441, 2894, 425, 1539, 610, -8251, -749, -755, 
    869, -1227, -623, -7412, -379, 1458, 4680, 581, 320, 2258, -781, -3649, -369, 2646, 1403, -851, 
    1919, 237, 4991, 280, -2190, -625, -1692, -794, 2318, 850, -1020, 3625, -2892, 275, -558, -271, 
    199, -1178, 1321, -92, 23, -265, -934, 357, 304, -498, 1201, -263, -595, -844, -696, -114, 
    148, 259, 1569, 88, -377, -1875, -1813, 475, 417, -1546, -1877, -4119, -1426, 179, -468, -721, 
    -303, 1330, -937, 479, -403, -766, -971, -3003, 105, -670, -532, 329, 812, -58, 818, -925, 
    -2010, 12, -1862, -727, 143, -267, -1075, -155, -248, 618, -575, 1489, 197, -303, -68, -106, 
    -904, -645, 1312, -228, -634, -1205, 18, 772, 1948, 696, -1011, -1071, -9, -799, 245, -1144, 
    292, -257, -636, -460, -846, -101, -1582, -189, 1094, -971, 1565, -505, -382, -1000, 52, 695, 
    160, 1165, -629, 146, 931, -301, -35, 756, -572, -1014, -447, -1397, -682, 339, 904, -2094, 
    -419, 193, -308, 252, -1022, 65, -811, -494, 1586, -557, 404, 51, -354, 122, 307, 526, 
    996, -466, -57, -390, 492, 496, -795, 289, -417, -745, -148, -757, -525, -722, -899, -44, 
    -882, 1469, 492, -324, -439, -2971, 735, 672, -785, -2243, -345, -31, 869, 63, -160, -120, 
    -1091, -1307, 183, -676, 9, -549, 319, -2338, -179, -719, -917, -1728, -915, 382, -269, -1712, 
    654, -48, -1189, 278, 1118, -163, 710, -62, -884, -176, -672, 41, 147, 201, 423, -467, 
    -174, 593, 135, 445, -489, 705, -1270, -919, -794, -1408, -1300, -103, 484, 87, -430, -641, 
    -125, -1667, -6864, 143, -832, -2564, -2008, -1216, 979, 1392, 20, 2836, 164, -452, 2455, -11, 
    1004, -203, -63, -70, -439, -720, 117, -793, -1157, 231, 1115, -13511, -677, 139, -202, -3247, 
    -933, 40, 486, 328, -311, -318, 1040, -404, 337, 153, 13, 1343, 677, -43, -188, 6, 
    448, -702, -209, -557, 11, 1290, 390, -1198, -510, -1792, -242, 1054, 191, -438, -624, -27, 
    100, -3491, 46, 78, 638, -2368, 695, -687, -497, -413, 294, -570, -196, 1014, -311, -154, 
    297, 260, -1554, -2152, -626, -561, -506, -2169, -728, -1137, -306, -1765, 136, -712, -122, 482, 
    369, 769, 224, -1178, -1201, -3254, -1462, -695, 244, -1146, 60, 1093, 180, 1859, 931, -3914, 
    -391, -1273, 351, 9, -339, 528, 206, 161, -228, 305, -456, 1098, -293, 472, -861, -2112, 
    -1320, -6460, -319, -956, -905, -845, -262, -181, -1, 385, -794, 192, 2, -2, -777, -383, 
    723, 814, -1006, 1161, 302, 155, -728, 898, -934, -1852, 1608, -2014, -1496, -5061, -1618, 1035, 
    1995, -4372, 1117, -584, -2294, 504, -141, -2336, -522, 541, -27, -1425, 142, -4917, -1766, -8732, 
    179, 280, 795, 40, -499, -1647, -751, 638, -155, -1695, -275, -474, -1, 600, -307, 390, 
    122, -14, 235, -1, -890, 461, 121, -547, -250, 177, 391, 47, 111, 565, 209, -420, 
    -51, 21, -365, -101, 438, -608, -177, -1431, -77, 314, 596, -602, -27, -366, 206, -289, 
    -62, 2889, -86, 611, 280, -3311, -1029, -650, 823, 63, 556, 1086, 655, -898, -391, -577, 
    -551, -1147, -682, -3, -60, -347, 177, -478, -368, -261, 15, 276, -1457, -1441, 748, -4, 
    39, -3203, -139, -258, -815, -531, -350, 42, 538, -48, 341, -131, 1236, -1552, 321, 297, 
    -136, -579, -549, 302, -430, -33, 186, -1801, 315, 94, 139, -145, 111, 1031, 583, -5310, 
    207, -2352, -336, -7765, -658, -1296, -314, 267, 29, -1512, 185, -1454, -151, 1177, -191, 1970, 
    -7, -839, -121, -19, 230, -1006, 161, 299, 310, 511, 336, -1637, -2004, -2362, 107, 287, 
    -410, -4067, -257, -996, -816, -1646, -786, 161, -241, -1588, -534, -999, 110, 466, -470, -613, 
    1426, -280, -2543, 1717, -501, -877, -92, -3871, 74, 632, 117, 877, -1356, 528, 3339, -11041, 
    -3, 1334, -1186, -930, 510, -6907, -543, 583, -334, -5371, -541, -631, -1114, -5060, -263, -380, 
    -1719, -3508, -38, -1378, 91, -425, 379, 1230, 1571, -99, 939, -1581, 1225, -1389, -1892, -2764, 
    90, -1190, 1830, -366, -930, -2469, 335, 176, 322, 823, 1093, 1126, -1385, -468, -2240, 208, 
    -856, 299, 584, -3767, 211, -747, -1313, 250, -2111, 1240, 1264, -660, -3108, -1105, -2348, -6857, 
    678, 2023, -483, 726, -96, -3850, 787, -1087, -50, 1830, -384, -428, -698, -5819, -3472, 281, 
    -77, 506, -1004, 353, -402, -3039, -97, -265, -16, -1155, 208, -144, 673, -708, -473, -896, 
    -407, 431, -1366, -680, 202, 420, 488, -252, -202, -2161, -311, -254, 521, 507, 296, 556, 
    607, 174, 215, -116, -263, -435, 154, -492, 444, 339, -148, -353, 373, 7, 386, 1455, 
    -1670, -4709, 492, -534, -1390, -864, -1898, -647, -250, -1203, 529, -828, -291, -4546, -1549, 396, 
    -288, -1312, 789, -572, -576, -1297, 139, 797, -609, -336, 407, -551, -361, -3139, 1474, 1262, 
    1648, 835, 868, 240, 368, -1534, -332, -505, -793, 1598, 140, 71, 345, 779, 65, -380, 
    -412, 774, 297, -3070, 1, 173, -1952, 1215, -519, 935, 202, -2542, 243, 408, -265, 2200, 
    700, -521, -2559, -101, 584, -7772, 1041, -75, 164, -2443, -1008, 574, -252, -7403, 609, -16, 
    887, -1045, 483, 34, -647, 1522, -373, -1418, 500, -1028, 114, 422, -270, -1758, 235, -372, 
    1139, 243, 267, -162, -170, -1432, -681, -435, 492, -65, 486, -433, -226, -1558, -1409, 282, 
    818, 434, -1389, -2157, -1584, -518, -720, -1487, 400, 139, 474, -119, 88, 159, 153, -1909, 
    -364, 1079, -713, 204, -818, -2171, -860, -156, 716, -5149, 429, -212, 689, 72, 1285, 36, 
    -343, -881, -267, 443, -181, -637, -340, -527, -85, 2406, -136, -792, -72, 1009, 875, -112, 
    454, -579, -836, -189, -12, 276, -7, -84, -964, -669, -300, -143, 133, -3545, -183, -244, 
    264, 330, 236, -136, -450, -123, -341, 1082, 188, -803, 1527, -1638, 299, 295, -1166, -1515, 
    -164, -1715, 126, 142, -601, -19, 95, -892, 1698, -206, -851, 618, 214, -3683, -1170, 534, 
    92, -704, 23, -69, -202, -192, 65, -423, 274, 92, -984, 46, -324, 284, 345, 44, 
    -379, 804, 510, 162, -1286, -893, -975, -212, 46, -1558, -1520, 73, -66, -435, 39, -100, 
    -70, -23, -528, -136, 364, -243, -252, 658, 160, 126, 445, -1476, 219, 180, 102, 547, 
    107, -118, -317, -380, -501, -3091, -213, -85, 157, 419, -40, -60, 364, -2299, -562, -207, 
    -849, 677, -37, 98, -183, 1174, -1019, -466, -23, -182, -180, -802, -102, 1520, -17, 180, 
    722, -468, -181, 33, 221, -538, -1591, -304, 484, 2307, 215, -335, -723, -914, -1269, -140, 
    -634, -254, 326, 661, -654, -590, -549, -763, -105, 90, -331, -1257, 408, -333, 560, -1035, 
    203, -8261, -1574, -196, -260, -683, -253, -43, -418, 1244, -54, -355, 501, 1445, 710, -237, 
};

static const int16_t fx3_paramModel4Alpha[16] = {
    181, 920, 2155, -119, -471, 397, 1706, 96, -483, 47, 1805, -464, 191, -209, 2048, 346, 
};

static const int16_t fx3_paramResidualBias[16] = {
    -217, -97, 188, -137, 78, -155, -121, -494, -328, -541, -590, -88, 284, -666, -942, -439, 
};

static const int16_t fx3_paramResidualWeights[256] = {
    629, -475, -1068, -1340, -3677, 293, 261, 262, 2106, -138, 53, 36, 48, -92, -22, -254, 
    -262, -1127, 2350, -2406, -595, 476, -282, -2027, 155, -243, 52, -421, -51, -220, 181, 107, 
    1118, -1222, -3878, -3474, -142, 704, 653, -430, 213, -408, -749, 617, 746, -280, -1, -175, 
    1875, -6746, -10733, 763, -694, -1258, -3928, 284, 8, -3160, -1549, 7, 344, -319, 57, -9237, 
    267, 117, -246, -650, 5217, 411, -1590, -1029, 1439, 267, 122, 205, 2836, 625, -118, -104, 
    373, 263, 551, 3488, 1325, 613, 681, 7704, -252, 83, -251, 1486, 563, 685, -422, -773, 
    -549, 3000, -1270, -489, 1597, 1833, -323, 2940, 463, -645, 783, -610, -3246, 988, -420, 464, 
    993, -752, 1181, -94, 185, 3688, 5938, 153, -394, 58, 658, 589, 500, 47, -674, 216, 
    -274, 71, -161, 146, -982, 1170, 101, 1339, 212, 116, -33, -587, -3378, 193, -1156, 38, 
    322, 683, -189, -540, 664, 86, -2357, 571, 10, -834, 122, -2650, -534, -223, -36, -3352, 
    -1452, 859, -272, 398, 192, 537, -205, 76, 883, 1363, -30, 133, -224, -2421, 996, -749, 
    -256, -48, -8109, 679, -2371, -166, 608, 274, 708, -11, -1326, 221, -1328, 655, -5233, -563, 
    -391, -594, -172, -787, 16, 572, -40, 1198, 589, -72, -19, 628, -1479, -6, 400, 763, 
    -210, 121, 1333, 1193, 32, 227, 1101, 765, -81, 868, -99, 993, -520, -295, -409, -323, 
    -4, 229, 398, -415, 593, -1640, -618, -71, 2017, 290, 117, -174, 85, 1389, 962, -1088, 
    1373, 211, -1115, 36, -867, -5280, -7181, -1910, -743, 103, 523, -160, -589, 433, -806, 304, 
};

static const int16_t fx3_paramResidualAlpha[16] = {
    -23, 6514, 8178, 8207, 7470, 6551, 8194, 2, 115, 277, 3362, 3922, 8063, 495, -215, 1145, 
};

static const int16_t fx3_paramSubConvolutionBias[12] = {
    1004, 999, 976, 0, 1039, 1032, 1009, 0, 1052, 1046, 1024, 0, 
};

static const int16_t fx3_paramSubConvolutionWeights[1728] = {
    -129, -50, 36, 0, 101, 81, 98, 0, -89, -177, -108, 0, -243, -115, -42, 0, 
    -43, -47, -36, 0, 194, 87, 34, 0, -48, -23, -2, 0, -145, -120, -84, 0, 
    23, -19, -65, 0, 130, -20, -99, 0, 108, 53, 23, 0, -94, -75, -71, 0, 
    234, 127, -34, 0, 186, -22, -29, 0, 49, 187, 135, 0, 31, -52, 5, 0, 
    177, 112, -17, 0, -110, -55, -18, 0, 210, 203, 61, 0, 67, -81, -50, 0, 
    54, 55, 12, 0, -117, -67, -8, 0, 172, 112, -21, 0, 72, -40, -78, 0, 
    121, 3, -41, 0, -96, 23, 20, 0, -143, 98, 151, 0, -75, -17, 16, 0, 
    -35, -2, 37, 0, -19, 19, 24, 0, -60, 98, 156, 0, 55, 112, 40, 0, 
    -1, -9, 5, 0, 61, 42, 37, 0, -61, 61, 108, 0, 80, 90, 18, 0, 
    -114, -186, -122, 0, -238, 89, 4, 0, -1650, -613, 216, 0, 14, 150, 64, 0, 
    -167, -193, -107, 0, 76, -101, -93, 0, -208, 57, 342, 0, 187, 72, 47, 0, 
    -134, -140, -72, 0, 82, -29, 27, 0, 449, 294, 215, 0, -11, -32, -7, 0, 
    -123, -142, 240, 0, -250, 56, -83, 0, 155, 327, -233, 0, 407, 326, 213, 0, 
    -88, -122, -45, 0, 291, 462, 420, 0, -433, -408, -483, 0, 573, 625, 530, 0, 
    10, -29, -102, 0, 128, 311, 322, 0, -347, -243, -180, 0, 302, 366, 367, 0, 
    -147, -237, 47, 0, 46, 273, 290, 0, -28, -179, -215, 0, -377, 142, 392, 0, 
    161, 108, 211, 0, -608, -609, -485, 0, 375, 415, 423, 0, -126, -110, 177, 0, 
    233, 122, 79, 0, -381, -419, -383, 0, 156, 254, 347, 0, 107, -58, 6, 0, 
    31, 191, 226, 0, 47, -207, -261, 0, 664, -254, -702, 0, -268, 50, 194, 0, 
    -190, -211, -139, 0, 187, 115, -17, 0, 316, 90, -94, 0, 39, 13, 60, 0, 
    -11, -9, -7, 0, 25, 70, 71, 0, 68, 0, -52, 0, -16, -107, 10, 0, 
    206, 297, 233, 0, 339, 279, -171, 0, 1965, 652, -1867, 0, 29, -467, -434, 0, 
    36, 96, 50, 0, 265, 172, 151, 0, 705, 461, -337, 0, 67, 51, 171, 0, 
    66, 65, 21, 0, 100, 43, 141, 0, 131, 359, 363, 0, 39, 70, 42, 0, 
    28, 46, 22, 0, -121, -119, 8, 0, 62, 67, 362, 0, -234, -192, -136, 0, 
    29, 26, 0, 0, -50, -82, 119, 0, 64, 19, 9, 0, -240, -278, -195, 0, 
    30, 11, -18, 0, -99, -189, -125, 0, 86, 63, 44, 0, -138, -187, -173, 0, 
    44, -21, -354, 0, 67, -62, -12, 0, -97, -152, -80, 0, 49, 63, -179, 0, 
    -153, -117, -108, 0, 134, 41, -134, 0, -156, -122, 10, 0, -0, 40, 50, 0, 
    -87, -5, 92, 0, 90, 46, -56, 0, -161, -126, -28, 0, 2, 23, 130, 0, 
    -11, -43, -29, 0, -13, 95, 156, 0, -215, -131, 181, 0, -34, -60, -24, 0, 
    7, -22, -87, 0, -39, 19, 101, 0, -78, 37, 58, 0, 40, 74, 130, 0, 
    -6, -18, -14, 0, -7, -2, -6, 0, 49, 109, -35, 0, 62, 90, 110, 0, 
    -45, -161, -167, 0, -25, -72, 90, 0, -429, -55, 1398, 0, 27, -9, 105, 0, 
    -16, -83, -139, 0, 23, -0, 80, 0, -346, -227, 268, 0, -77, -27, 81, 0, 
    3, -12, -48, 0, 8, 15, 54, 0, -193, -178, -68, 0, -153, -48, 23, 0, 
    -281, -240, -27, 0, -115, 173, -27, 0, 559, -608, -621, 0, 31, 302, 172, 0, 
    -385, -220, 42, 0, 237, 253, -58, 0, 673, -522, -455, 0, 195, 367, 179, 0, 
    -301, -123, 100, 0, 516, 250, -30, 0, -50, -648, -400, 0, 534, 429, 188, 0, 
    63, -382, -277, 0, -387, -158, -3, 0, -380, -61, -67, 0, 105, 96, 24, 0, 
    256, -212, -208, 0, 306, -113, -53, 0, -92, 24, -32, 0, -291, 0, 30, 0, 
    314, -117, -216, 0, 448, -87, -85, 0, 361, 149, 4, 0, -250, -66, 22, 0, 
    301, 10, -42, 0, -150, -61, 19, 0, 111, 99, 24, 0, 944, -18, -235, 0, 
    -319, -91, -15, 0, 159, -36, -41, 0, 46, 160, 36, 0, 668, -135, -232, 0, 
    111, 0, -62, 0, 75, 29, -19, 0, -67, 157, 104, 0, 80, -189, -131, 0, 
    513, 185, 54, 0, -626, 789, 341, 0, 2770, 751, -338, 0, 377, 36, -20, 0, 
    497, 211, 52, 0, -1056, 1027, 576, 0, 771, -166, -188, 0, -332, 45, 121, 0, 
    259, 147, 45, 0, -904, 677, 364, 0, -2638, -1176, 143, 0, -576, 85, 103, 0, 
    -81, -210, 419, 0, -195, 872, -790, 0, -442, 564, -696, 0, 2880, 2689, 3093, 0, 
    -104, -132, 672, 0, -639, 621, -265, 0, 812, 1935, 321, 0, 3264, 2961, 3168, 0, 
    -269, -213, 656, 0, -369, 884, 719, 0, 32, 714, -715, 0, 4473, 4305, 4186, 0, 
    760, -404, -967, 0, -678, -931, -1040, 0, -2225, -2885, -2736, 0, 93, -181, -111, 0, 
    368, -507, -703, 0, 834, 1221, 768, 0, -1526, -1990, -1769, 0, 132, 6, -445, 0, 
    342, -356, -372, 0, 671, 1258, 865, 0, 17, -12, 20, 0, -159, 412, 84, 0, 
    29, 406, 509, 0, 261, 171, -101, 0, 2111, 187, -934, 0, -1634, -14, 2136, 0, 
    -452, -659, -686, 0, -112, 160, 353, 0, 2070, -564, -1626, 0, -1681, 88, 2019, 0, 
    180, 304, 179, 0, -357, -411, -62, 0, 1829, -526, -1446, 0, -1087, 292, 1303, 0, 
    4192, 4282, 3979, 0, 411, 307, -801, 0, -1243, 267, 2558, 0, -620, 500, 924, 0, 
    3676, 3655, 3380, 0, 396, 364, -1101, 0, 1525, 1968, 1247, 0, 878, 755, -293, 0, 
    2738, 2690, 2549, 0, 265, 269, -844, 0, 2128, 198, -3120, 0, 635, -590, -1454, 0, 
    5, 12, 78, 0, -146, -154, -49, 0, -416, -327, 831, 0, 490, 556, 254, 0, 
    13, 25, 51, 0, -309, -266, -190, 0, -212, -136, 1224, 0, 476, 783, 711, 0, 
    23, 50, 44, 0, -507, -431, -188, 0, -149, -166, 729, 0, 180, 559, 898, 0, 
    613, 581, -324, 0, -271, -413, -263, 0, 38, -210, -10, 0, 26, 36, 131, 0, 
    549, 418, -735, 0, -251, -475, 181, 0, 4, -301, -114, 0, 38, 37, -52, 0, 
    393, 249, -732, 0, -120, -345, 265, 0, -94, -278, 6, 0, 53, 43, -264, 0, 
    67, -6, -63, 0, -57, -67, 121, 0, -15, -286, 17, 0, -53, -160, -100, 0, 
    16, -1, -109, 0, 30, -18, -129, 0, -172, -414, 74, 0, -44, -225, -232, 0, 
    -45, -44, 54, 0, 80, 117, -80, 0, -237, -290, 173, 0, -110, -267, -250, 0, 
    141, 199, 707, 0, -86, -50, 257, 0, 349, 387, -467, 0, 99, -111, -637, 0, 
    163, 229, 751, 0, -60, -98, 241, 0, 547, 630, 1165, 0, 38, -128, 35, 0, 
    63, 49, 357, 0, -40, -137, 96, 0, -317, 62, 1736, 0, 1, -10, 383, 0, 
    48, 31, -18, 0, 91, 108, 70, 0, 7, 45, 99, 0, -108, -79, -17, 0, 
    87, -37, -59, 0, -312, -106, -85, 0, -205, -206, -154, 0, -118, -93, -10, 0, 
    -25, -119, -59, 0, -157, 101, -9, 0, 418, -112, -243, 0, -287, -116, -20, 0, 
    31, 96, 55, 0, 166, 77, 23, 0, 50, 101, 66, 0, -24, -28, -16, 0, 
    67, 17, -59, 0, 122, 50, 10, 0, 23, 49, -30, 0, -4, -11, 5, 0, 
    228, -22, -107, 0, -222, -63, -9, 0, 96, 171, 10, 0, 142, 48, 21, 0, 
    -73, -36, -44, 0, 30, 3, 7, 0, 11, 71, 55, 0, -162, -72, 52, 0, 
    -98, -31, -32, 0, 25, 23, 10, 0, -129, -27, 20, 0, -71, -20, 65, 0, 
    339, 89, -7, 0, -210, -30, 20, 0, -90, 8, 40, 0, 367, -30, -62, 0, 
    -104, -75, -23, 0, -42, -78, -61, 0, -360, 72, 277, 0, 55, -9, -93, 0, 
    -230, -138, -22, 0, -52, -111, -180, 0, -385, 408, 307, 0, 74, 48, 67, 0, 
    -190, -192, -63, 0, -217, 172, -90, 0, 964, 782, 2, 0, 276, 75, 49, 0, 
    -11, -61, -36, 0, -103, -88, -186, 0, -360, -359, -559, 0, 254, 294, 359, 0, 
    -64, -97, 82, 0, -487, -402, -902, 0, -830, -861, -1217, 0, 496, 677, 834, 0, 
    -53, -151, 150, 0, 83, 556, -700, 0, 126, 464, -202, 0, 252, 368, 717, 0, 
    -70, -226, -274, 0, 72, 134, 110, 0, -127, -185, -213, 0, -17, 9, 6, 0, 
    288, -122, -343, 0, 180, 192, 19, 0, -143, -306, -391, 0, 7, -5, 50, 0, 
    395, -41, -238, 0, -161, -445, -666, 0, -141, -518, -534, 0, -3, -82, 135, 0, 
    -24, -64, -101, 0, -63, -26, 17, 0, -36, -138, -197, 0, 20, -19, -47, 0, 
    -132, -224, -216, 0, -115, -78, 1, 0, 67, -194, -396, 0, -171, -169, 79, 0, 
    108, 417, 504, 0, 75, -158, -275, 0, 484, -178, -617, 0, -702, -320, 769, 0, 
    190, 204, 218, 0, -27, 9, 24, 0, 824, 678, -197, 0, 230, 66, -12, 0, 
    256, 291, 325, 0, 155, 135, -41, 0, 1642, 365, -952, 0, 209, -62, 58, 0, 
    619, 685, 624, 0, 408, 298, -268, 0, -1803, -2482, -1205, 0, -747, -414, 370, 0, 
    17, -4, -10, 0, 175, 258, 274, 0, 127, 98, 138, 0, -195, -273, -364, 0, 
    5, -10, 16, 0, 66, 102, -9, 0, -46, -37, 104, 0, -193, -391, -577, 0, 
    5, -7, 58, 0, 78, 125, 176, 0, -189, -96, 577, 0, -15, -222, -650, 0, 
    -121, -102, -151, 0, 44, 83, 168, 0, 92, 101, 147, 0, -49, -7, 5, 0, 
    100, 176, 130, 0, 41, 104, 280, 0, 90, 123, 340, 0, -69, -44, 51, 0, 
    123, 149, -162, 0, -31, -2, 172, 0, 69, 52, 453, 0, 1, -16, 97, 0, 
    -10, -15, -18, 0, -40, -35, -48, 0, -66, 1, -52, 0, 132, 117, 76, 0, 
    -5, 8, -19, 0, -41, -66, -109, 0, -17, 2, -101, 0, 49, 55, 130, 0, 
    29, 13, 18, 0, -44, -36, 46, 0, -134, -305, -292, 0, 90, 83, 169, 0, 
    -169, -194, -287, 0, -11, -3, -7, 0, -194, -211, 281, 0, 10, 38, 151, 0, 
    -221, -340, -509, 0, -41, 9, 60, 0, -403, -3, 1304, 0, 63, 193, 347, 0, 
    -134, -257, -303, 0, -52, 13, 209, 0, -562, -287, -284, 0, 124, 137, -221, 0, 
};

