/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Transfer : transfer from one location to another
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Transfer {
    #[serde(rename = "to")]
    pub to: Box<models::Place>,
    /// optional; missing if the GTFS did not contain a transfer transfer duration in minutes according to GTFS (+heuristics) 
    #[serde(rename = "default", skip_serializing_if = "Option::is_none")]
    pub default: Option<f64>,
    /// optional; missing if no path was found (timetable / osr) transfer duration in minutes for the foot profile 
    #[serde(rename = "foot", skip_serializing_if = "Option::is_none")]
    pub foot: Option<f64>,
    /// optional; missing if no path was found with foot routing transfer duration in minutes for the foot profile 
    #[serde(rename = "footRouted", skip_serializing_if = "Option::is_none")]
    pub foot_routed: Option<f64>,
    /// optional; missing if no path was found with the wheelchair profile  transfer duration in minutes for the wheelchair profile 
    #[serde(rename = "wheelchair", skip_serializing_if = "Option::is_none")]
    pub wheelchair: Option<f64>,
    /// optional; missing if no path was found with the wheelchair profile transfer duration in minutes for the wheelchair profile 
    #[serde(rename = "wheelchairRouted", skip_serializing_if = "Option::is_none")]
    pub wheelchair_routed: Option<f64>,
    /// optional; missing if no path was found with the wheelchair profile true if the wheelchair path uses an elevator 
    #[serde(rename = "wheelchairUsesElevator", skip_serializing_if = "Option::is_none")]
    pub wheelchair_uses_elevator: Option<bool>,
    /// optional; missing if no path was found with car routing transfer duration in minutes for the car profile 
    #[serde(rename = "car", skip_serializing_if = "Option::is_none")]
    pub car: Option<f64>,
}

impl Transfer {
    /// transfer from one location to another
    pub fn new(to: models::Place) -> Transfer {
        Transfer {
            to: Box::new(to),
            default: None,
            foot: None,
            foot_routed: None,
            wheelchair: None,
            wheelchair_routed: None,
            wheelchair_uses_elevator: None,
            car: None,
        }
    }
}

