/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.core.internal.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.karaf.http.core.BalancingPolicy;
import org.apache.karaf.http.core.ProxyService;
import org.apache.karaf.http.core.ServletService;
import org.apache.karaf.http.core.internal.HttpMBeanImpl;
import org.apache.karaf.http.core.internal.ProxyServiceImpl;
import org.apache.karaf.http.core.internal.ServletServiceImpl;
import org.apache.karaf.http.core.internal.proxy.RandomBalancingPolicy;
import org.apache.karaf.http.core.internal.proxy.RoundRobinBalancingPolicy;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.HttpService;

@Services(requires={@RequireService(value=HttpService.class), @RequireService(value=WebContainer.class), @RequireService(value=ConfigurationAdmin.class)}, provides={@ProvideService(value=ServletService.class), @ProvideService(value=ProxyService.class)})
@Managed(value="org.apache.karaf.http")
public class Activator
extends BaseActivator
implements ManagedService {
    private ProxyService proxyService;

    @Override
    protected void doStart() throws Exception {
        HttpService httpService = this.getTrackedService(HttpService.class);
        if (httpService == null) {
            return;
        }
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin == null) {
            return;
        }
        WebContainer webContainer = this.getTrackedService(WebContainer.class);
        ServletServiceImpl servletService = null;
        if (webContainer != null) {
            servletService = new ServletServiceImpl(webContainer);
            this.register(ServletService.class, servletService);
        }
        RandomBalancingPolicy randomBalancingPolicy = new RandomBalancingPolicy();
        Hashtable<String, String> randomBalancingPolicyProperties = new Hashtable<String, String>();
        randomBalancingPolicyProperties.put("type", "random");
        this.register(BalancingPolicy.class, randomBalancingPolicy, randomBalancingPolicyProperties);
        RoundRobinBalancingPolicy roundRobinBalancingPolicy = new RoundRobinBalancingPolicy();
        Hashtable<String, String> roundRobinBalancingPolicyProperties = new Hashtable<String, String>();
        roundRobinBalancingPolicyProperties.put("type", "round-robin");
        this.register(BalancingPolicy.class, roundRobinBalancingPolicy, roundRobinBalancingPolicyProperties);
        this.proxyService = new ProxyServiceImpl(httpService, configurationAdmin, this.bundleContext);
        this.register(ProxyService.class, this.proxyService);
        if (servletService != null) {
            HttpMBeanImpl httpMBean = new HttpMBeanImpl(servletService, this.proxyService);
            this.registerMBean(httpMBean, "type=http");
        }
    }

    @Override
    public void updated(Dictionary<String, ?> properties) {
        if (this.proxyService != null) {
            this.proxyService.update(properties);
        }
    }
}

