/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.thingsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.handler.BaseModuleHandlerFactory;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.internal.module.handler.AnnotationActionHandler;
import org.openhab.core.automation.module.provider.AnnotationActionModuleTypeHelper;
import org.openhab.core.automation.module.provider.ModuleInformation;
import org.openhab.core.automation.module.provider.i18n.ModuleTypeI18nService;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeProvider;
import org.openhab.core.automation.util.ActionInputsHelper;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.openhab.core.thing.binding.ThingActions;
import org.openhab.core.thing.binding.ThingActionsScope;
import org.openhab.core.thing.binding.ThingHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={ModuleTypeProvider.class, ModuleHandlerFactory.class})
public class AnnotatedThingActionModuleTypeProvider
extends BaseModuleHandlerFactory
implements ModuleTypeProvider {
    private final Logger logger = LoggerFactory.getLogger(AnnotatedThingActionModuleTypeProvider.class);
    private final Collection<ProviderChangeListener<ModuleType>> changeListeners = ConcurrentHashMap.newKeySet();
    private final Map<String, Set<ModuleInformation>> moduleInformation = new ConcurrentHashMap<String, Set<ModuleInformation>>();
    private final AnnotationActionModuleTypeHelper helper;
    private final ModuleTypeI18nService moduleTypeI18nService;
    private final ActionInputsHelper actionInputsHelper;

    @Activate
    public AnnotatedThingActionModuleTypeProvider(@Reference ModuleTypeI18nService moduleTypeI18nService, @Reference AnnotationActionModuleTypeHelper helper, @Reference ActionInputsHelper actionInputsHelper) {
        this.moduleTypeI18nService = moduleTypeI18nService;
        this.helper = helper;
        this.actionInputsHelper = actionInputsHelper;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        this.moduleInformation.clear();
    }

    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.changeListeners.add(listener);
    }

    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.changeListeners.remove(listener);
    }

    public Collection<ModuleType> getAll() {
        ArrayList<ModuleType> moduleTypes = new ArrayList<ModuleType>();
        for (String moduleUID : this.moduleInformation.keySet()) {
            ActionType mt = this.helper.buildModuleType(moduleUID, this.moduleInformation);
            if (mt == null) continue;
            moduleTypes.add(mt);
        }
        return moduleTypes;
    }

    @Override
    public <T extends ModuleType> T getModuleType(String uid, @Nullable Locale locale) {
        return (T)this.localizeModuleType(uid, locale);
    }

    @Override
    public <T extends ModuleType> Collection<T> getModuleTypes(@Nullable Locale locale) {
        ArrayList<ModuleType> result = new ArrayList<ModuleType>();
        for (Map.Entry<String, Set<ModuleInformation>> entry : this.moduleInformation.entrySet()) {
            ModuleType localizedModuleType = this.localizeModuleType(entry.getKey(), locale);
            if (localizedModuleType == null) continue;
            result.add(localizedModuleType);
        }
        return result;
    }

    private @Nullable ModuleType localizeModuleType(String uid, @Nullable Locale locale) {
        Set<ModuleInformation> mis = this.moduleInformation.get(uid);
        if (mis != null && !mis.isEmpty()) {
            ModuleInformation mi = mis.iterator().next();
            Bundle bundle = FrameworkUtil.getBundle(mi.getActionProvider().getClass());
            ActionType mt = this.helper.buildModuleType(uid, this.moduleInformation);
            return this.moduleTypeI18nService.getModuleTypePerLocale(mt, locale, bundle);
        }
        return null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addAnnotatedThingActions(ThingActions annotatedThingActions) {
        if (annotatedThingActions.getClass().isAnnotationPresent(ThingActionsScope.class)) {
            ThingActionsScope scope = annotatedThingActions.getClass().getAnnotation(ThingActionsScope.class);
            Collection<ModuleInformation> moduleInformations = this.helper.parseAnnotations(scope.name(), annotatedThingActions);
            String thingUID = this.getThingUID(annotatedThingActions);
            for (ModuleInformation mi : moduleInformations) {
                mi.setThingUID(thingUID);
                ActionType oldType = null;
                if (this.moduleInformation.containsKey(mi.getUID())) {
                    oldType = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
                    Set<ModuleInformation> availableModuleConfigs = this.moduleInformation.get(mi.getUID());
                    availableModuleConfigs.add(mi);
                } else {
                    ConcurrentHashMap.KeySetView configs = ConcurrentHashMap.newKeySet();
                    configs.add(mi);
                    this.moduleInformation.put(mi.getUID(), configs);
                }
                ActionType mt = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
                if (mt == null) continue;
                for (ProviderChangeListener<ModuleType> l : this.changeListeners) {
                    if (oldType != null) {
                        l.updated((Provider)this, (Object)oldType, (Object)mt);
                        continue;
                    }
                    l.added((Provider)this, (Object)mt);
                }
            }
        } else {
            this.logger.error("Missing 'ThingActionsScope' for '{}'. Please add it to your class definition.", annotatedThingActions.getClass());
        }
    }

    public void removeAnnotatedThingActions(ThingActions annotatedThingActions) {
        if (annotatedThingActions.getClass().isAnnotationPresent(ThingActionsScope.class)) {
            ThingActionsScope scope = annotatedThingActions.getClass().getAnnotation(ThingActionsScope.class);
            Collection<ModuleInformation> moduleInformations = this.helper.parseAnnotations(scope.name(), annotatedThingActions);
            String thingUID = this.getThingUID(annotatedThingActions);
            for (ModuleInformation mi : moduleInformations) {
                mi.setThingUID(thingUID);
                Set<ModuleInformation> availableModuleConfigs = this.moduleInformation.get(mi.getUID());
                if (availableModuleConfigs == null) continue;
                ActionType oldType = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
                if (availableModuleConfigs.size() > 1) {
                    availableModuleConfigs.remove(mi);
                } else {
                    this.moduleInformation.remove(mi.getUID());
                }
                ActionType mt = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
                if (oldType == null) continue;
                for (ProviderChangeListener<ModuleType> l : this.changeListeners) {
                    if (mt != null) {
                        l.updated((Provider)this, (Object)oldType, (Object)mt);
                        continue;
                    }
                    l.removed((Provider)this, (Object)oldType);
                }
            }
        } else {
            this.logger.error("Missing 'ThingActionsScope' for '{}'. Please add it to your class definition.", annotatedThingActions.getClass());
        }
    }

    private String getThingUID(ThingActions annotatedThingActions) {
        ThingHandler handler = annotatedThingActions.getThingHandler();
        if (handler == null) {
            throw new IllegalStateException(String.format("ThingHandler for '%s' is missing.", annotatedThingActions.getClass()));
        }
        return handler.getThing().getUID().getAsString();
    }

    @Override
    public Collection<String> getTypes() {
        return this.moduleInformation.keySet();
    }

    @Override
    protected @Nullable ModuleHandler internalCreate(Module module, String ruleUID) {
        ModuleInformation finalMI;
        Action actionModule;
        if (module instanceof Action && this.moduleInformation.containsKey((actionModule = (Action)module).getTypeUID()) && (finalMI = this.helper.getModuleInformationForIdentifier(actionModule, this.moduleInformation, true)) != null) {
            ActionType moduleType = this.helper.buildModuleType(module.getTypeUID(), this.moduleInformation);
            if (moduleType == null) {
                return null;
            }
            return new AnnotationActionHandler(actionModule, moduleType, finalMI.getMethod(), finalMI.getActionProvider(), this.actionInputsHelper);
        }
        return null;
    }
}

