/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.x509.CertificateConfigurationHelper;
import org.eclipse.californium.scandium.dtls.x509.ConfigurationHelperSetup;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticNewAdvancedCertificateVerifier
implements NewAdvancedCertificateVerifier,
ConfigurationHelperSetup {
    private static final X509Certificate[] X509_TRUST_ALL = new X509Certificate[0];
    private static final RawPublicKeyIdentity[] RPK_TRUST_ALL = new RawPublicKeyIdentity[0];
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final X509Certificate[] trustedCertificates;
    private final Set<RawPublicKeyIdentity> trustedRPKs;
    private final List<CertificateType> supportedCertificateTypes;
    private final boolean useEmptyAcceptedIssuers;

    public StaticNewAdvancedCertificateVerifier(X509Certificate[] trustedCertificates, RawPublicKeyIdentity[] trustedRPKs, List<CertificateType> supportedCertificateTypes) {
        this(trustedCertificates, trustedRPKs, supportedCertificateTypes, false);
    }

    public StaticNewAdvancedCertificateVerifier(X509Certificate[] trustedCertificates, RawPublicKeyIdentity[] trustedRPKs, List<CertificateType> supportedCertificateTypes, boolean useEmptyAcceptedIssuers) {
        if (trustedCertificates == null && trustedRPKs == null) {
            throw new IllegalArgumentException("no trusts provided!");
        }
        if (supportedCertificateTypes == null) {
            supportedCertificateTypes = new ArrayList<CertificateType>(2);
            if (trustedRPKs != null) {
                supportedCertificateTypes.add(CertificateType.RAW_PUBLIC_KEY);
            }
            if (trustedCertificates != null) {
                supportedCertificateTypes.add(CertificateType.X_509);
            }
        } else {
            if (supportedCertificateTypes.isEmpty()) {
                throw new IllegalArgumentException("list of supported certificate types must not be empty!");
            }
            if (supportedCertificateTypes.contains((Object)CertificateType.RAW_PUBLIC_KEY) && trustedRPKs == null) {
                throw new IllegalArgumentException("RPK support requires RPK trusts!");
            }
            if (supportedCertificateTypes.contains((Object)CertificateType.X_509) && trustedCertificates == null) {
                throw new IllegalArgumentException("x509support requires x509 trusts!");
            }
        }
        this.trustedCertificates = trustedCertificates == null ? null : Arrays.copyOf(trustedCertificates, trustedCertificates.length);
        this.trustedRPKs = trustedRPKs == null ? null : new HashSet<RawPublicKeyIdentity>(Arrays.asList(trustedRPKs));
        this.supportedCertificateTypes = Collections.unmodifiableList(supportedCertificateTypes);
        this.useEmptyAcceptedIssuers = useEmptyAcceptedIssuers;
    }

    @Override
    public void setupConfigurationHelper(CertificateConfigurationHelper helper) {
        helper.addConfigurationDefaultsForTrusts(this.trustedCertificates);
        if (this.trustedRPKs != null) {
            for (RawPublicKeyIdentity identity : this.trustedRPKs) {
                helper.addConfigurationDefaultsForTrusts(identity.getKey());
            }
        }
    }

    @Override
    public List<CertificateType> getSupportedCertificateTypes() {
        return this.supportedCertificateTypes;
    }

    @Override
    public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverNames, InetSocketAddress remotePeer, boolean clientUsage, boolean verifySubject, boolean truncateCertificatePath, CertificateMessage message) {
        this.LOGGER.debug("Verify for SNI: {}, IP: {}", (Object)serverNames, StringUtil.toLog((SocketAddress)remotePeer));
        try {
            CertPath certChain = message.getCertificateChain();
            if (certChain == null) {
                RawPublicKeyIdentity rpk;
                if (this.trustedRPKs == null) {
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_CERTIFICATE);
                    throw new HandshakeException("RPK verification not enabled!", alert);
                }
                PublicKey publicKey = message.getPublicKey();
                if (!this.trustedRPKs.isEmpty() && !this.trustedRPKs.contains(rpk = new RawPublicKeyIdentity(publicKey))) {
                    this.LOGGER.debug("Certificate validation failed: Raw public key is not trusted");
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                    throw new HandshakeException("Raw public key is not trusted!", alert);
                }
                return new CertificateVerificationResult(cid, publicKey, null);
            }
            if (this.trustedCertificates == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_CERTIFICATE);
                throw new HandshakeException("x509 verification not enabled!", alert);
            }
            try {
                if (!message.isEmpty()) {
                    Certificate certificate = certChain.getCertificates().get(0);
                    if (certificate instanceof X509Certificate) {
                        X509Certificate x509Certificate = (X509Certificate)certificate;
                        if (!CertPathUtil.canBeUsedForAuthentication((X509Certificate)x509Certificate, (boolean)clientUsage)) {
                            this.LOGGER.debug("Certificate validation failed: key usage doesn't match");
                            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                            throw new HandshakeException("Key Usage doesn't match!", alert);
                        }
                        if (verifySubject) {
                            this.verifyCertificatesSubject(serverNames, remotePeer, x509Certificate);
                        }
                    }
                    certChain = CertPathUtil.validateCertificatePathWithIssuer((boolean)truncateCertificatePath, (CertPath)certChain, (X509Certificate[])this.trustedCertificates);
                }
                return new CertificateVerificationResult(cid, certChain, null);
            }
            catch (CertPathValidatorException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CertificateExpiredException) {
                    this.LOGGER.debug("Certificate expired: {}", (Object)cause.getMessage());
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.CERTIFICATE_EXPIRED);
                    throw new HandshakeException("Certificate expired", alert);
                }
                if (cause != null) {
                    this.LOGGER.debug("Certificate validation failed: {}/{}", (Object)e.getMessage(), (Object)cause.getMessage());
                } else {
                    this.LOGGER.debug("Certificate validation failed: {}", (Object)e.getMessage());
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                throw new HandshakeException("Certificate chain could not be validated", alert, e);
            }
            catch (GeneralSecurityException e) {
                if (this.LOGGER.isTraceEnabled()) {
                    this.LOGGER.trace("Certificate validation failed", (Throwable)e);
                } else if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Certificate validation failed due to {}", (Object)e.getMessage());
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECRYPT_ERROR);
                throw new HandshakeException("Certificate chain could not be validated", alert, e);
            }
        }
        catch (HandshakeException e) {
            this.LOGGER.debug("Certificate validation failed!", (Throwable)e);
            return new CertificateVerificationResult(cid, e, null);
        }
    }

    public void verifyCertificatesSubject(ServerNames serverNames, InetSocketAddress peer, X509Certificate certificate) throws HandshakeException {
        String cn;
        ServerName serverName;
        if (certificate == null) {
            throw new NullPointerException("Certficate must not be null!");
        }
        if (serverNames == null && peer == null) {
            return;
        }
        String literalIp = null;
        String hostname = null;
        if (peer != null) {
            hostname = peer.getHostString();
            InetAddress destination = peer.getAddress();
            if (destination != null) {
                literalIp = destination.getHostAddress();
            }
        }
        if (serverNames != null && (serverName = serverNames.getServerName(ServerName.NameType.HOST_NAME)) != null) {
            hostname = serverName.getNameAsString();
        }
        if (hostname != null && hostname.equals(literalIp)) {
            hostname = null;
        }
        if (hostname != null) {
            if (!CertPathUtil.matchDestination((X509Certificate)certificate, (String)hostname)) {
                cn = CertPathUtil.getSubjectsCn((X509Certificate)certificate);
                this.LOGGER.debug("Certificate {} validation failed: destination doesn't match", (Object)cn);
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                throw new HandshakeException("Certificate " + cn + ": Destination '" + hostname + "' doesn't match!", alert);
            }
        } else if (!CertPathUtil.matchLiteralIP((X509Certificate)certificate, literalIp)) {
            cn = CertPathUtil.getSubjectsCn((X509Certificate)certificate);
            this.LOGGER.debug("Certificate {} validation failed: literal IP doesn't match", (Object)cn);
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            throw new HandshakeException("Certificate " + cn + ": Literal IP " + literalIp + " doesn't match!", alert);
        }
    }

    @Override
    public List<X500Principal> getAcceptedIssuers() {
        if (!this.useEmptyAcceptedIssuers && this.trustedCertificates != null) {
            return CertPathUtil.toSubjects(Arrays.asList(this.trustedCertificates));
        }
        return CertPathUtil.toSubjects(null);
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected X509Certificate[] trustedCertificates;
        protected RawPublicKeyIdentity[] trustedRPKs;
        protected List<CertificateType> supportedCertificateTypes;
        protected boolean useEmptyAcceptedIssuers;

        public Builder setTrustedCertificates(Certificate ... trustedCertificates) {
            if (trustedCertificates == null) {
                this.trustedCertificates = null;
            } else if (trustedCertificates.length == 0) {
                this.trustedCertificates = X509_TRUST_ALL;
            } else {
                X509Certificate[] certificates = SslContextUtil.asX509Certificates((Certificate[])trustedCertificates);
                SslContextUtil.ensureUniqueCertificates((X509Certificate[])certificates);
                this.trustedCertificates = certificates;
            }
            return this;
        }

        public Builder setTrustAllCertificates() {
            this.trustedCertificates = X509_TRUST_ALL;
            return this;
        }

        public Builder setTrustedRPKs(RawPublicKeyIdentity ... trustedRPKs) {
            HashSet<RawPublicKeyIdentity> set = new HashSet<RawPublicKeyIdentity>();
            for (RawPublicKeyIdentity identity : trustedRPKs) {
                if (set.add(identity)) continue;
                throw new IllegalArgumentException("Truststore contains raw public key certificates duplicates: " + identity.getName());
            }
            this.trustedRPKs = trustedRPKs;
            return this;
        }

        public Builder setTrustAllRPKs() {
            this.trustedRPKs = RPK_TRUST_ALL;
            return this;
        }

        public Builder setSupportedCertificateTypes(List<CertificateType> supportedCertificateTypes) {
            this.supportedCertificateTypes = supportedCertificateTypes;
            return this;
        }

        public Builder setUseEmptyAcceptedIssuers(boolean useEmptyAcceptedIssuers) {
            this.useEmptyAcceptedIssuers = useEmptyAcceptedIssuers;
            return this;
        }

        public boolean hasTrusts() {
            return this.trustedCertificates != null || this.trustedRPKs != null;
        }

        public NewAdvancedCertificateVerifier build() {
            return new StaticNewAdvancedCertificateVerifier(this.trustedCertificates, this.trustedRPKs, this.supportedCertificateTypes, this.useEmptyAcceptedIssuers);
        }
    }
}

