/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.rulesupport.shared;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.module.script.rulesupport.shared.ScriptedRuleProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangeListener;

@NonNullByDefault
public class RuleSupportRuleRegistryDelegate
implements RuleRegistry {
    private final RuleRegistry ruleRegistry;
    private final Set<String> rules = new HashSet<String>();
    private final ScriptedRuleProvider ruleProvider;

    public RuleSupportRuleRegistryDelegate(RuleRegistry ruleRegistry, ScriptedRuleProvider ruleProvider) {
        this.ruleRegistry = ruleRegistry;
        this.ruleProvider = ruleProvider;
    }

    public void addRegistryChangeListener(RegistryChangeListener<Rule> listener) {
        this.ruleRegistry.addRegistryChangeListener(listener);
    }

    public Collection<Rule> getAll() {
        return this.ruleRegistry.getAll();
    }

    public Stream<Rule> stream() {
        return this.ruleRegistry.stream();
    }

    public @Nullable Rule get(String key) {
        return (Rule)this.ruleRegistry.get((Object)key);
    }

    public void removeRegistryChangeListener(RegistryChangeListener<Rule> listener) {
        this.ruleRegistry.removeRegistryChangeListener(listener);
    }

    public Rule add(Rule element) {
        this.ruleProvider.add(element);
        this.rules.add(element.getUID());
        return element;
    }

    public void addPermanent(Rule element) {
        this.ruleRegistry.add(element);
    }

    public @Nullable Rule update(Rule element) {
        return (Rule)this.ruleRegistry.update((Identifiable)element);
    }

    public @Nullable Rule remove(String key) {
        if (this.rules.remove(key)) {
            return this.ruleProvider.remove(key);
        }
        return (Rule)this.ruleRegistry.remove((Object)key);
    }

    public Collection<Rule> getByTag(@Nullable String tag) {
        return this.ruleRegistry.getByTag(tag);
    }

    public void removeAllAddedByScript() {
        for (String rule : this.rules) {
            this.ruleProvider.remove(rule);
        }
        this.rules.clear();
    }

    public Collection<Rule> getByTags(String ... tags) {
        return this.ruleRegistry.getByTags(tags);
    }

    public void regenerateFromTemplate(String ruleUID) {
        this.ruleRegistry.regenerateFromTemplate(ruleUID);
    }
}

