/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import org.jupnp.UpnpService;
import org.jupnp.model.message.discovery.OutgoingSearchRequest;
import org.jupnp.model.message.header.MXHeader;
import org.jupnp.model.message.header.STAllHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.protocol.SendingAsync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingSearch
extends SendingAsync {
    private final Logger logger = LoggerFactory.getLogger(SendingSearch.class);
    private final UpnpHeader searchTarget;
    private final int mxSeconds;

    public SendingSearch(UpnpService upnpService) {
        this(upnpService, new STAllHeader());
    }

    public SendingSearch(UpnpService upnpService, UpnpHeader searchTarget) {
        this(upnpService, searchTarget, MXHeader.DEFAULT_VALUE);
    }

    public SendingSearch(UpnpService upnpService, UpnpHeader searchTarget, int mxSeconds) {
        super(upnpService);
        if (!UpnpHeader.Type.ST.isValidHeaderType(searchTarget.getClass())) {
            throw new IllegalArgumentException("Given search target instance is not a valid header class for type ST: " + String.valueOf(searchTarget.getClass()));
        }
        this.searchTarget = searchTarget;
        this.mxSeconds = mxSeconds;
    }

    public UpnpHeader getSearchTarget() {
        return this.searchTarget;
    }

    public int getMxSeconds() {
        return this.mxSeconds;
    }

    @Override
    protected void execute() throws RouterException {
        this.logger.trace("Executing search for target: {} with MX seconds: {}", (Object)this.searchTarget.getString(), (Object)this.getMxSeconds());
        OutgoingSearchRequest msg = new OutgoingSearchRequest(this.searchTarget, this.getMxSeconds());
        this.prepareOutgoingSearchRequest(msg);
        int i = 0;
        while (i < this.getBulkRepeat()) {
            try {
                this.getUpnpService().getRouter().send(msg);
                this.logger.trace("Sleeping {} milliseconds", (Object)this.getBulkIntervalMilliseconds());
                Thread.sleep(this.getBulkIntervalMilliseconds());
            }
            catch (InterruptedException e) {
                break;
            }
            ++i;
        }
    }

    public int getBulkRepeat() {
        return 3;
    }

    public int getBulkIntervalMilliseconds() {
        return 500;
    }

    protected void prepareOutgoingSearchRequest(OutgoingSearchRequest message) {
    }
}

