/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.util.Objects;
import javax.measure.Quantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.spi.Range;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record QuantityRange<Q extends Quantity<Q>>(Quantity<Q> minimum, Quantity<Q> maximum, Quantity<Q> resolution) implements Range<Quantity<Q>>
{
    public static QuantityRange of(Quantity minimum, Quantity maximum, Quantity resolution) {
        if (!QuantityRange.isCompatibleQuantityTriple(minimum, maximum, resolution)) {
            throw new IllegalArgumentException();
        }
        return new QuantityRange(minimum, maximum, resolution);
    }

    public static QuantityRange of(Quantity minimum, Quantity maximum) {
        if (!QuantityRange.isCompatibleQuantityPair(minimum, maximum)) {
            throw new IllegalArgumentException();
        }
        return new QuantityRange(minimum, maximum, null);
    }

    private static boolean isCompatibleQuantityPair(Quantity q1, Quantity q2) {
        return q1 == null || q2 == null || q1.getUnit().isCompatible(q2.getUnit());
    }

    private static boolean isCompatibleQuantityTriple(Quantity q1, Quantity q2, Quantity q3) {
        return QuantityRange.isCompatibleQuantityPair(q1, q2) && QuantityRange.isCompatibleQuantityPair(q1, q3) && QuantityRange.isCompatibleQuantityPair(q2, q3);
    }

    private boolean isAboveMinimum(Quantity<Q> q) {
        if (q instanceof ComparableQuantity) {
            return ((ComparableQuantity)q).isGreaterThanOrEqualTo(this.getMinimum());
        }
        Quantity qConverted = q.to(this.getMinimum().getUnit());
        return qConverted.getValue().doubleValue() >= this.getMinimum().getValue().doubleValue();
    }

    private boolean isBelowMaximum(Quantity<Q> q) {
        if (q instanceof ComparableQuantity) {
            return ((ComparableQuantity)q).isLessThanOrEqualTo(this.getMaximum());
        }
        Quantity qConverted = q.to(this.getMaximum().getUnit());
        return qConverted.getValue().doubleValue() <= this.getMaximum().getValue().doubleValue();
    }

    private boolean fulfillsMaximumConstraint(Quantity<Q> q) {
        return !this.hasMaximum() || this.isBelowMaximum(q);
    }

    private boolean fulfillsMinimumConstraint(Quantity<Q> q) {
        return !this.hasMinimum() || this.isAboveMinimum(q);
    }

    @Override
    public boolean contains(Quantity<Q> q) {
        Objects.requireNonNull(q);
        return q.getValue() != null && q.getUnit() != null && this.fulfillsMinimumConstraint(q) && this.fulfillsMaximumConstraint(q);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuantityRange) {
            QuantityRange other = (QuantityRange)obj;
            return Objects.equals(this.getMinimum(), other.getMinimum()) && Objects.equals(this.getMaximum(), other.getMaximum()) && Objects.equals(this.getResolution(), other.getResolution());
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("min=").append(this.getMinimum()).append(", max=").append(this.getMaximum());
        if (this.getResolution() != null) {
            sb.append(", res=").append(this.getResolution());
        }
        return sb.toString();
    }

    @Override
    public Quantity<Q> getMinimum() {
        return this.minimum;
    }

    @Override
    public Quantity<Q> getMaximum() {
        return this.maximum;
    }

    @Override
    public Quantity<Q> getResolution() {
        return this.resolution;
    }

    @Override
    public boolean hasMinimum() {
        return this.minimum != null;
    }

    @Override
    public boolean hasMaximum() {
        return this.maximum != null;
    }
}

