/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import java.util.HashSet;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.jax.rs.whiteboard.internal.ServiceReferenceFilteredPublisher;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class ServiceReferenceRegistry
implements AutoCloseable {
    private final HashSet<ServiceReferenceFilteredPublisher> _extensionPublishers = new HashSet();
    private final HashSet<CachingServiceReference<?>> _registeredExtensions = new HashSet();

    @Override
    public void close() {
        for (ServiceReferenceFilteredPublisher extensionPublisher : new HashSet<ServiceReferenceFilteredPublisher>(this._extensionPublishers)) {
            extensionPublisher.close();
        }
    }

    public OSGi<CachingServiceReference<?>> waitFor(String filterString) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException();
        }
        return OSGi.fromOsgiRunnable((bc, p) -> {
            ServiceReferenceRegistry serviceReferenceRegistry = this;
            synchronized (serviceReferenceRegistry) {
                ServiceReferenceFilteredPublisher ep = new ServiceReferenceFilteredPublisher(p, filter);
                this._extensionPublishers.add(ep);
                for (CachingServiceReference<?> extension : new HashSet(this._registeredExtensions)) {
                    ep.publishIfMatched(extension);
                }
                return () -> {
                    ServiceReferenceRegistry serviceReferenceRegistry = this;
                    synchronized (serviceReferenceRegistry) {
                        this._extensionPublishers.remove(ep);
                        for (CachingServiceReference<?> extension : new HashSet(this._registeredExtensions)) {
                            ep.retractIfMatched(extension);
                        }
                    }
                };
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CachingServiceReference<?> serviceReference) {
        ServiceReferenceRegistry serviceReferenceRegistry = this;
        synchronized (serviceReferenceRegistry) {
            this._registeredExtensions.add(serviceReference);
            for (ServiceReferenceFilteredPublisher publisher : new HashSet<ServiceReferenceFilteredPublisher>(this._extensionPublishers)) {
                publisher.publishIfMatched(serviceReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(CachingServiceReference<?> serviceReference) {
        ServiceReferenceRegistry serviceReferenceRegistry = this;
        synchronized (serviceReferenceRegistry) {
            for (ServiceReferenceFilteredPublisher publisher : new HashSet<ServiceReferenceFilteredPublisher>(this._extensionPublishers)) {
                publisher.retractIfMatched(serviceReference);
            }
            this._registeredExtensions.remove(serviceReference);
        }
    }
}

