/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldUInt;
import com.igormaznitsa.jbbp.model.JBBPNumericArray;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldArrayUInt
extends JBBPAbstractArrayField<JBBPFieldUInt>
implements JBBPNumericArray {
    private static final long serialVersionUID = -2146953450724853264L;
    private final int[] array;

    public JBBPFieldArrayUInt(JBBPNamedFieldInfo name, int[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public long[] getArray() {
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = (long)this.array[i] & 0xFFFFFFFFL;
        }
        return result;
    }

    public int[] getInternalArray() {
        return this.array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldUInt getElementAt(int index) {
        JBBPFieldUInt result = new JBBPFieldUInt(this.fieldNameInfo, (long)this.array[index] & 0xFFFFFFFFL);
        result.payload = this.payload;
        return result;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        long[] result = new long[this.array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (reverseBits ? JBBPFieldInt.reverseBits(this.array[i]) : (long)this.array[i]) & 0xFFFFFFFFL;
        }
        return result;
    }

    @Override
    public int getAsInt(int index) {
        return this.array[index];
    }

    @Override
    public long getAsLong(int index) {
        return (long)this.array[index] & 0xFFFFFFFFL;
    }

    @Override
    public boolean getAsBool(int index) {
        return (long)this.array[index] != 0L;
    }

    @Override
    public String getTypeAsString() {
        return "uint [" + this.array.length + "]";
    }
}

