/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.audio.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.openhab.core.audio.AudioDialogProvider;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.io.websocket.WebSocketAdapter;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketConnection;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={PCMWebSocketAdapter.class, WebSocketAdapter.class})
public class PCMWebSocketAdapter
implements WebSocketAdapter {
    public static final String ADAPTER_ID = "audio-pcm";
    private final Logger logger = LoggerFactory.getLogger(PCMWebSocketAdapter.class);
    private final ScheduledExecutorService executor = ThreadPoolManager.getScheduledPool((String)"audio-pcm-websocket");
    protected final BundleContext bundleContext;
    protected final AudioManager audioManager;
    protected final AudioDialogProvider audioDialogProvider;
    private final ScheduledFuture<?> pingTask;
    private final Set<PCMWebSocketConnection> webSocketConnections = Collections.synchronizedSet(new HashSet());

    @Activate
    public PCMWebSocketAdapter(BundleContext bundleContext, @Reference AudioManager audioManager, @Reference AudioDialogProvider audioDialogProvider) {
        this.bundleContext = bundleContext;
        this.audioManager = audioManager;
        this.audioDialogProvider = audioDialogProvider;
        this.pingTask = this.executor.scheduleWithFixedDelay(this::pingHandlers, 10L, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSpeakerConnected(PCMWebSocketConnection speaker) throws IllegalStateException {
        Set<PCMWebSocketConnection> set = this.webSocketConnections;
        synchronized (set) {
            if (this.getSpeakerConnection(speaker.getId()) != null) {
                throw new IllegalStateException("Another speaker with the same id is already connected");
            }
            this.webSocketConnections.add(speaker);
            this.logger.debug("connected speakers {}", (Object)this.webSocketConnections.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onClientDisconnected(PCMWebSocketConnection connection) {
        this.logger.debug("speaker disconnected '{}'", (Object)connection.getId());
        Set<PCMWebSocketConnection> set = this.webSocketConnections;
        synchronized (set) {
            this.webSocketConnections.remove(connection);
            this.logger.debug("connected speakers {}", (Object)this.webSocketConnections.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable PCMWebSocketConnection getSpeakerConnection(String id) {
        Set<PCMWebSocketConnection> set = this.webSocketConnections;
        synchronized (set) {
            return this.webSocketConnections.stream().filter(speakerConnection -> speakerConnection.getId().equalsIgnoreCase(id)).findAny().orElse(null);
        }
    }

    public String getId() {
        return ADAPTER_ID;
    }

    public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
        this.logger.debug("creating connection");
        return new PCMWebSocketConnection(this, this.executor);
    }

    @Deactivate
    public synchronized void deactivate() {
        this.logger.debug("stopping connection check");
        this.pingTask.cancel(true);
        this.disconnectAll();
    }

    private void pingHandlers() {
        ArrayList<PCMWebSocketConnection> handlers = new ArrayList<PCMWebSocketConnection>(this.webSocketConnections);
        for (PCMWebSocketConnection handler : handlers) {
            if (handler == null) continue;
            boolean pinged = false;
            RemoteEndpoint remote = handler.getRemote();
            if (remote != null) {
                try {
                    remote.sendPing(ByteBuffer.wrap("oh".getBytes(StandardCharsets.UTF_8)));
                    pinged = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (pinged) continue;
            this.logger.debug("Ping failed, disconnecting speaker '{}'", (Object)handler.getId());
            Session session = handler.getSession();
            if (session == null) continue;
            session.close();
        }
    }

    private void disconnectAll() {
        this.logger.debug("Disconnecting {} clients...", (Object)this.webSocketConnections.size());
        ArrayList<PCMWebSocketConnection> connections = new ArrayList<PCMWebSocketConnection>(this.webSocketConnections);
        for (PCMWebSocketConnection connection : connections) {
            this.onClientDisconnected(connection);
            connection.disconnect();
        }
    }
}

