// { dg-do compile { target c++26 } }
// { dg-additional-options "-freflection" }

#include <meta>

using namespace std::meta;

struct S {
  template <typename U>
  constexpr int foo (int x, const U &) const { return 41 + x + s; }
  template <typename U>
  constexpr int foo (long x, const U &) const { return 42 + x + s; }
  template <typename U>
  constexpr int foo (long long x, const U &) const { return 43 + x + s; }
  template <typename U>
  static constexpr int bar (int x, const U &) { return 72 + x; } 
  template <typename U>
  static constexpr int bar (long x, const U &) { return 73 + x; } 
  template <typename U>
  static constexpr int bar (long long x, const U &) { return 74 + x; } 
  constexpr S (int x) : s (x) {}
  int s;
};
struct T : public S {
  template <typename U>
  constexpr int foo (int x, const U &) const { return 51 + x + s; }
  template <typename U>
  constexpr int foo (long x, const U &) const { return 52 + x + s; }
  template <typename U>
  constexpr int foo (long long x, const U &) const { return 53 + x + s; }
  template <typename U>
  static constexpr int bar (int x, const U &) { return 82 + x; } 
  template <typename U>
  static constexpr int bar (long x, const U &) { return 83 + x; } 
  template <typename U>
  static constexpr int bar (long long x, const U &) { return 84 + x; } 
  constexpr T (int x) : S (x) {}
};

constexpr access_context uctx = access_context::unchecked ();

constexpr S s = 1;
static_assert (s.foo (0, 1.0f) == 42);
static_assert (s.foo (0L, 1.0) == 43);
static_assert (s.foo (0LL, 1.0L) == 44);
static_assert (s.template [:members_of (^^S, uctx)[0]:] (10, 1.0f) == 52);
static_assert (s.template [:members_of (^^S, uctx)[0]:] (20L, 1.0) == 62);
static_assert (s.template [:members_of (^^S, uctx)[0]:] (30LL, 1.0L) == 72);
static_assert (s.template [:members_of (^^S, uctx)[1]:] (10, 1.0f) == 53);
static_assert (s.template [:members_of (^^S, uctx)[1]:] (20L, 1.0) == 63);
static_assert (s.template [:members_of (^^S, uctx)[1]:] (30LL, 1.0L) == 73);
static_assert (s.template [:members_of (^^S, uctx)[2]:] (10, 1.0f) == 54);
static_assert (s.template [:members_of (^^S, uctx)[2]:] (20L, 1.0) == 64);
static_assert (s.template [:members_of (^^S, uctx)[2]:] (30LL, 1.0L) == 74);
static_assert (s.foo <float> (0, 1.0f) == 42);
static_assert (s.foo <double> (0L, 1.0) == 43);
static_assert (s.foo <long double> (0LL, 1.0L) == 44);
static_assert (s.template [:members_of (^^S, uctx)[0]:] <float> (10, 1.0f) == 52);
static_assert (s.template [:members_of (^^S, uctx)[0]:] <double> (20L, 1.0) == 62);
static_assert (s.template [:members_of (^^S, uctx)[0]:] <long double> (30LL, 1.0L) == 72);
static_assert (s.template [:members_of (^^S, uctx)[1]:] <float> (10, 1.0f) == 53);
static_assert (s.template [:members_of (^^S, uctx)[1]:] <double> (20L, 1.0) == 63);
static_assert (s.template [:members_of (^^S, uctx)[1]:] <long double> (30LL, 1.0L) == 73);
static_assert (s.template [:members_of (^^S, uctx)[2]:] <float> (10, 1.0f) == 54);
static_assert (s.template [:members_of (^^S, uctx)[2]:] <double> (20L, 1.0) == 64);
static_assert (s.template [:members_of (^^S, uctx)[2]:] <long double> (30LL, 1.0L) == 74);
static_assert (s.bar (0, 1.0f) == 72);
static_assert (s.bar (0L, 1.0) == 73);
static_assert (s.bar (0LL, 1.0L) == 74);
static_assert (s.template [:members_of (^^S, uctx)[3]:] (10, 1.0f) == 82);
static_assert (s.template [:members_of (^^S, uctx)[3]:] (20L, 1.0) == 92);
static_assert (s.template [:members_of (^^S, uctx)[3]:] (30LL, 1.0L) == 102);
static_assert (s.template [:members_of (^^S, uctx)[4]:] (10, 1.0f) == 83);
static_assert (s.template [:members_of (^^S, uctx)[4]:] (20L, 1.0) == 93);
static_assert (s.template [:members_of (^^S, uctx)[4]:] (30LL, 1.0L) == 103);
static_assert (s.template [:members_of (^^S, uctx)[5]:] (10, 1.0f) == 84);
static_assert (s.template [:members_of (^^S, uctx)[5]:] (20L, 1.0) == 94);
static_assert (s.template [:members_of (^^S, uctx)[5]:] (30LL, 1.0L) == 104);
static_assert (s.bar <float> (0, 1.0f) == 72);
static_assert (s.bar <double> (0L, 1.0) == 73);
static_assert (s.bar <long double> (0LL, 1.0L) == 74);
static_assert (s.template [:members_of (^^S, uctx)[3]:] <float> (10, 1.0f) == 82);
static_assert (s.template [:members_of (^^S, uctx)[3]:] <double> (20L, 1.0) == 92);
static_assert (s.template [:members_of (^^S, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
static_assert (s.template [:members_of (^^S, uctx)[4]:] <float> (10, 1.0f) == 83);
static_assert (s.template [:members_of (^^S, uctx)[4]:] <double> (20L, 1.0) == 93);
static_assert (s.template [:members_of (^^S, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
static_assert (s.template [:members_of (^^S, uctx)[5]:] <float> (10, 1.0f) == 84);
static_assert (s.template [:members_of (^^S, uctx)[5]:] <double> (20L, 1.0) == 94);
static_assert (s.template [:members_of (^^S, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
constexpr T t = 2;
static_assert (t.foo (0, 1.0f) == 53);
static_assert (t.foo (0L, 1.0) == 54);
static_assert (t.foo (0LL, 1.0L) == 55);
static_assert (t.template [:members_of (^^S, uctx)[0]:] (10, 1.0f) == 53);
static_assert (t.template [:members_of (^^S, uctx)[0]:] (20L, 1.0) == 63);
static_assert (t.template [:members_of (^^S, uctx)[0]:] (30LL, 1.0L) == 73);
static_assert (t.template [:members_of (^^S, uctx)[1]:] (10, 1.0f) == 54);
static_assert (t.template [:members_of (^^S, uctx)[1]:] (20L, 1.0) == 64);
static_assert (t.template [:members_of (^^S, uctx)[1]:] (30LL, 1.0L) == 74);
static_assert (t.template [:members_of (^^S, uctx)[2]:] (10, 1.0f) == 55);
static_assert (t.template [:members_of (^^S, uctx)[2]:] (20L, 1.0) == 65);
static_assert (t.template [:members_of (^^S, uctx)[2]:] (30LL, 1.0L) == 75);
static_assert (t.template [:members_of (^^T, uctx)[0]:] (10, 1.0f) == 63);
static_assert (t.template [:members_of (^^T, uctx)[0]:] (20L, 1.0) == 73);
static_assert (t.template [:members_of (^^T, uctx)[0]:] (30LL, 1.0L) == 83);
static_assert (t.template [:members_of (^^T, uctx)[1]:] (10, 1.0f) == 64);
static_assert (t.template [:members_of (^^T, uctx)[1]:] (20L, 1.0) == 74);
static_assert (t.template [:members_of (^^T, uctx)[1]:] (30LL, 1.0L) == 84);
static_assert (t.template [:members_of (^^T, uctx)[2]:] (10, 1.0f) == 65);
static_assert (t.template [:members_of (^^T, uctx)[2]:] (20L, 1.0) == 75);
static_assert (t.template [:members_of (^^T, uctx)[2]:] (30LL, 1.0L) == 85);
static_assert (t.foo <float> (0, 1.0f) == 53);
static_assert (t.foo <double> (0L, 1.0) == 54);
static_assert (t.foo <long double> (0LL, 1.0L) == 55);
static_assert (t.template [:members_of (^^S, uctx)[0]:] <float> (10, 1.0f) == 53);
static_assert (t.template [:members_of (^^S, uctx)[0]:] <double> (20L, 1.0) == 63);
static_assert (t.template [:members_of (^^S, uctx)[0]:] <long double> (30LL, 1.0L) == 73);
static_assert (t.template [:members_of (^^S, uctx)[1]:] <float> (10, 1.0f) == 54);
static_assert (t.template [:members_of (^^S, uctx)[1]:] <double> (20L, 1.0) == 64);
static_assert (t.template [:members_of (^^S, uctx)[1]:] <long double> (30LL, 1.0L) == 74);
static_assert (t.template [:members_of (^^S, uctx)[2]:] <float> (10, 1.0f) == 55);
static_assert (t.template [:members_of (^^S, uctx)[2]:] <double> (20L, 1.0) == 65);
static_assert (t.template [:members_of (^^S, uctx)[2]:] <long double> (30LL, 1.0L) == 75);
static_assert (t.template [:members_of (^^T, uctx)[0]:] <float> (10, 1.0f) == 63);
static_assert (t.template [:members_of (^^T, uctx)[0]:] <double> (20L, 1.0) == 73);
static_assert (t.template [:members_of (^^T, uctx)[0]:] <long double> (30LL, 1.0L) == 83);
static_assert (t.template [:members_of (^^T, uctx)[1]:] <float> (10, 1.0f) == 64);
static_assert (t.template [:members_of (^^T, uctx)[1]:] <double> (20L, 1.0) == 74);
static_assert (t.template [:members_of (^^T, uctx)[1]:] <long double> (30LL, 1.0L) == 84);
static_assert (t.template [:members_of (^^T, uctx)[2]:] <float> (10, 1.0f) == 65);
static_assert (t.template [:members_of (^^T, uctx)[2]:] <double> (20L, 1.0) == 75);
static_assert (t.template [:members_of (^^T, uctx)[2]:] <long double> (30LL, 1.0L) == 85);
static_assert (t.bar (0, 1.0f) == 82);
static_assert (t.bar (0L, 1.0) == 83);
static_assert (t.bar (0LL, 1.0L) == 84);
static_assert (t.template [:members_of (^^S, uctx)[3]:] (10, 1.0f) == 82);
static_assert (t.template [:members_of (^^S, uctx)[3]:] (20L, 1.0) == 92);
static_assert (t.template [:members_of (^^S, uctx)[3]:] (30LL, 1.0L) == 102);
static_assert (t.template [:members_of (^^S, uctx)[4]:] (10, 1.0f) == 83);
static_assert (t.template [:members_of (^^S, uctx)[4]:] (20L, 1.0) == 93);
static_assert (t.template [:members_of (^^S, uctx)[4]:] (30LL, 1.0L) == 103);
static_assert (t.template [:members_of (^^S, uctx)[5]:] (10, 1.0f) == 84);
static_assert (t.template [:members_of (^^S, uctx)[5]:] (20L, 1.0) == 94);
static_assert (t.template [:members_of (^^S, uctx)[5]:] (30LL, 1.0L) == 104);
static_assert (t.template [:members_of (^^T, uctx)[3]:] (10, 1.0f) == 92);
static_assert (t.template [:members_of (^^T, uctx)[3]:] (20L, 1.0) == 102);
static_assert (t.template [:members_of (^^T, uctx)[3]:] (30LL, 1.0L) == 112);
static_assert (t.template [:members_of (^^T, uctx)[4]:] (10, 1.0f) == 93);
static_assert (t.template [:members_of (^^T, uctx)[4]:] (20L, 1.0) == 103);
static_assert (t.template [:members_of (^^T, uctx)[4]:] (30LL, 1.0L) == 113);
static_assert (t.template [:members_of (^^T, uctx)[5]:] (10, 1.0f) == 94);
static_assert (t.template [:members_of (^^T, uctx)[5]:] (20L, 1.0) == 104);
static_assert (t.template [:members_of (^^T, uctx)[5]:] (30LL, 1.0L) == 114);
static_assert (t.bar <float> (0, 1.0f) == 82);
static_assert (t.bar <double> (0L, 1.0) == 83);
static_assert (t.bar <long double> (0LL, 1.0L) == 84);
static_assert (t.template [:members_of (^^S, uctx)[3]:] <float> (10, 1.0f) == 82);
static_assert (t.template [:members_of (^^S, uctx)[3]:] <double> (20L, 1.0) == 92);
static_assert (t.template [:members_of (^^S, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
static_assert (t.template [:members_of (^^S, uctx)[4]:] <float> (10, 1.0f) == 83);
static_assert (t.template [:members_of (^^S, uctx)[4]:] <double> (20L, 1.0) == 93);
static_assert (t.template [:members_of (^^S, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
static_assert (t.template [:members_of (^^S, uctx)[5]:] <float> (10, 1.0f) == 84);
static_assert (t.template [:members_of (^^S, uctx)[5]:] <double> (20L, 1.0) == 94);
static_assert (t.template [:members_of (^^S, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
static_assert (t.template [:members_of (^^T, uctx)[3]:] <float> (10, 1.0f) == 92);
static_assert (t.template [:members_of (^^T, uctx)[3]:] <double> (20L, 1.0) == 102);
static_assert (t.template [:members_of (^^T, uctx)[3]:] <long double> (30LL, 1.0L) == 112);
static_assert (t.template [:members_of (^^T, uctx)[4]:] <float> (10, 1.0f) == 93);
static_assert (t.template [:members_of (^^T, uctx)[4]:] <double> (20L, 1.0) == 103);
static_assert (t.template [:members_of (^^T, uctx)[4]:] <long double> (30LL, 1.0L) == 113);
static_assert (t.template [:members_of (^^T, uctx)[5]:] <float> (10, 1.0f) == 94);
static_assert (t.template [:members_of (^^T, uctx)[5]:] <double> (20L, 1.0) == 104);
static_assert (t.template [:members_of (^^T, uctx)[5]:] <long double> (30LL, 1.0L) == 114);

template <int N>
void
foo ()
{
  constexpr S s = 1;
  static_assert (s.foo (0, 1.0f) == 42);
  static_assert (s.foo (0L, 1.0) == 43);
  static_assert (s.foo (0LL, 1.0L) == 44);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] (10, 1.0f) == 52);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] (20L, 1.0) == 62);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] (30LL, 1.0L) == 72);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] (10, 1.0f) == 53);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] (20L, 1.0) == 63);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] (30LL, 1.0L) == 73);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] (10, 1.0f) == 54);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] (20L, 1.0) == 64);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] (30LL, 1.0L) == 74);
  static_assert (s.foo <float> (0, 1.0f) == 42);
  static_assert (s.foo <double> (0L, 1.0) == 43);
  static_assert (s.foo <long double> (0LL, 1.0L) == 44);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] <float> (10, 1.0f) == 52);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] <double> (20L, 1.0) == 62);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] <long double> (30LL, 1.0L) == 72);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] <float> (10, 1.0f) == 53);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] <double> (20L, 1.0) == 63);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] <long double> (30LL, 1.0L) == 73);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] <float> (10, 1.0f) == 54);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] <double> (20L, 1.0) == 64);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] <long double> (30LL, 1.0L) == 74);
  static_assert (s.bar (0, 1.0f) == 72);
  static_assert (s.bar (0L, 1.0) == 73);
  static_assert (s.bar (0LL, 1.0L) == 74);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] (10, 1.0f) == 82);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] (20L, 1.0) == 92);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] (30LL, 1.0L) == 102);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] (10, 1.0f) == 83);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] (20L, 1.0) == 93);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] (30LL, 1.0L) == 103);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] (10, 1.0f) == 84);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] (20L, 1.0) == 94);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] (30LL, 1.0L) == 104);
  static_assert (s.bar <float> (0, 1.0f) == 72);
  static_assert (s.bar <double> (0L, 1.0) == 73);
  static_assert (s.bar <long double> (0LL, 1.0L) == 74);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] <float> (10, 1.0f) == 82);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] <double> (20L, 1.0) == 92);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] <float> (10, 1.0f) == 83);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] <double> (20L, 1.0) == 93);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] <float> (10, 1.0f) == 84);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] <double> (20L, 1.0) == 94);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
  constexpr T t = 2;
  static_assert (t.foo (0, 1.0f) == 53);
  static_assert (t.foo (0L, 1.0) == 54);
  static_assert (t.foo (0LL, 1.0L) == 55);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] (10, 1.0f) == 53);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] (20L, 1.0) == 63);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] (30LL, 1.0L) == 73);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] (10, 1.0f) == 54);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] (20L, 1.0) == 64);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] (30LL, 1.0L) == 74);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] (10, 1.0f) == 55);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] (20L, 1.0) == 65);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] (30LL, 1.0L) == 75);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] (10, 1.0f) == 63);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] (20L, 1.0) == 73);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] (30LL, 1.0L) == 83);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] (10, 1.0f) == 64);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] (20L, 1.0) == 74);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] (30LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] (10, 1.0f) == 65);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] (20L, 1.0) == 75);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] (30LL, 1.0L) == 85);
  static_assert (t.foo <float> (0, 1.0f) == 53);
  static_assert (t.foo <double> (0L, 1.0) == 54);
  static_assert (t.foo <long double> (0LL, 1.0L) == 55);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] <float> (10, 1.0f) == 53);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] <double> (20L, 1.0) == 63);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] <long double> (30LL, 1.0L) == 73);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] <float> (10, 1.0f) == 54);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] <double> (20L, 1.0) == 64);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] <long double> (30LL, 1.0L) == 74);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] <float> (10, 1.0f) == 55);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] <double> (20L, 1.0) == 65);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] <long double> (30LL, 1.0L) == 75);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] <float> (10, 1.0f) == 63);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] <double> (20L, 1.0) == 73);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] <long double> (30LL, 1.0L) == 83);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] <float> (10, 1.0f) == 64);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] <double> (20L, 1.0) == 74);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] <long double> (30LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] <float> (10, 1.0f) == 65);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] <double> (20L, 1.0) == 75);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] <long double> (30LL, 1.0L) == 85);
  static_assert (t.bar (0, 1.0f) == 82);
  static_assert (t.bar (0L, 1.0) == 83);
  static_assert (t.bar (0LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] (10, 1.0f) == 82);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] (20L, 1.0) == 92);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] (30LL, 1.0L) == 102);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] (10, 1.0f) == 83);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] (20L, 1.0) == 93);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] (30LL, 1.0L) == 103);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] (10, 1.0f) == 84);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] (20L, 1.0) == 94);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] (30LL, 1.0L) == 104);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] (10, 1.0f) == 92);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] (20L, 1.0) == 102);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] (30LL, 1.0L) == 112);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] (10, 1.0f) == 93);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] (20L, 1.0) == 103);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] (30LL, 1.0L) == 113);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] (10, 1.0f) == 94);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] (20L, 1.0) == 104);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] (30LL, 1.0L) == 114);
  static_assert (t.bar <float> (0, 1.0f) == 82);
  static_assert (t.bar <double> (0L, 1.0) == 83);
  static_assert (t.bar <long double> (0LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] <float> (10, 1.0f) == 82);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] <double> (20L, 1.0) == 92);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] <float> (10, 1.0f) == 83);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] <double> (20L, 1.0) == 93);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] <float> (10, 1.0f) == 84);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] <double> (20L, 1.0) == 94);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] <float> (10, 1.0f) == 92);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] <double> (20L, 1.0) == 102);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] <long double> (30LL, 1.0L) == 112);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] <float> (10, 1.0f) == 93);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] <double> (20L, 1.0) == 103);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] <long double> (30LL, 1.0L) == 113);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] <float> (10, 1.0f) == 94);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] <double> (20L, 1.0) == 104);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] <long double> (30LL, 1.0L) == 114);
}

template <typename A, typename B>
void
bar ()
{
  constexpr A s = 1;
  static_assert (s.foo (0, 1.0f) == 42);
  static_assert (s.foo (0L, 1.0) == 43);
  static_assert (s.foo (0LL, 1.0L) == 44);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] (10, 1.0f) == 52);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] (20L, 1.0) == 62);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] (30LL, 1.0L) == 72);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] (10, 1.0f) == 53);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] (20L, 1.0) == 63);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] (30LL, 1.0L) == 73);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] (10, 1.0f) == 54);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] (20L, 1.0) == 64);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] (30LL, 1.0L) == 74);
  static_assert (s.template foo <float> (0, 1.0f) == 42);
  static_assert (s.template foo <double> (0L, 1.0) == 43);
  static_assert (s.template foo <long double> (0LL, 1.0L) == 44);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] <float> (10, 1.0f) == 52);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] <double> (20L, 1.0) == 62);
  static_assert (s.template [:members_of (^^S, uctx)[0]:] <long double> (30LL, 1.0L) == 72);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] <float> (10, 1.0f) == 53);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] <double> (20L, 1.0) == 63);
  static_assert (s.template [:members_of (^^S, uctx)[1]:] <long double> (30LL, 1.0L) == 73);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] <float> (10, 1.0f) == 54);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] <double> (20L, 1.0) == 64);
  static_assert (s.template [:members_of (^^S, uctx)[2]:] <long double> (30LL, 1.0L) == 74);
  static_assert (s.bar (0, 1.0f) == 72);
  static_assert (s.bar (0L, 1.0) == 73);
  static_assert (s.bar (0LL, 1.0L) == 74);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] (10, 1.0f) == 82);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] (20L, 1.0) == 92);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] (30LL, 1.0L) == 102);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] (10, 1.0f) == 83);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] (20L, 1.0) == 93);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] (30LL, 1.0L) == 103);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] (10, 1.0f) == 84);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] (20L, 1.0) == 94);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] (30LL, 1.0L) == 104);
  static_assert (s.template bar <float> (0, 1.0f) == 72);
  static_assert (s.template bar <double> (0L, 1.0) == 73);
  static_assert (s.template bar <long double> (0LL, 1.0L) == 74);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] <float> (10, 1.0f) == 82);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] <double> (20L, 1.0) == 92);
  static_assert (s.template [:members_of (^^S, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] <float> (10, 1.0f) == 83);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] <double> (20L, 1.0) == 93);
  static_assert (s.template [:members_of (^^S, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] <float> (10, 1.0f) == 84);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] <double> (20L, 1.0) == 94);
  static_assert (s.template [:members_of (^^S, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
  constexpr B t = 2;
  static_assert (t.foo (0, 1.0f) == 53);
  static_assert (t.foo (0L, 1.0) == 54);
  static_assert (t.foo (0LL, 1.0L) == 55);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] (10, 1.0f) == 53);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] (20L, 1.0) == 63);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] (30LL, 1.0L) == 73);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] (10, 1.0f) == 54);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] (20L, 1.0) == 64);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] (30LL, 1.0L) == 74);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] (10, 1.0f) == 55);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] (20L, 1.0) == 65);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] (30LL, 1.0L) == 75);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] (10, 1.0f) == 63);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] (20L, 1.0) == 73);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] (30LL, 1.0L) == 83);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] (10, 1.0f) == 64);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] (20L, 1.0) == 74);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] (30LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] (10, 1.0f) == 65);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] (20L, 1.0) == 75);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] (30LL, 1.0L) == 85);
  static_assert (t.template foo <float> (0, 1.0f) == 53);
  static_assert (t.template foo <double> (0L, 1.0) == 54);
  static_assert (t.template foo <long double> (0LL, 1.0L) == 55);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] <float> (10, 1.0f) == 53);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] <double> (20L, 1.0) == 63);
  static_assert (t.template [:members_of (^^S, uctx)[0]:] <long double> (30LL, 1.0L) == 73);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] <float> (10, 1.0f) == 54);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] <double> (20L, 1.0) == 64);
  static_assert (t.template [:members_of (^^S, uctx)[1]:] <long double> (30LL, 1.0L) == 74);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] <float> (10, 1.0f) == 55);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] <double> (20L, 1.0) == 65);
  static_assert (t.template [:members_of (^^S, uctx)[2]:] <long double> (30LL, 1.0L) == 75);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] <float> (10, 1.0f) == 63);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] <double> (20L, 1.0) == 73);
  static_assert (t.template [:members_of (^^T, uctx)[0]:] <long double> (30LL, 1.0L) == 83);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] <float> (10, 1.0f) == 64);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] <double> (20L, 1.0) == 74);
  static_assert (t.template [:members_of (^^T, uctx)[1]:] <long double> (30LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] <float> (10, 1.0f) == 65);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] <double> (20L, 1.0) == 75);
  static_assert (t.template [:members_of (^^T, uctx)[2]:] <long double> (30LL, 1.0L) == 85);
  static_assert (t.bar (0, 1.0f) == 82);
  static_assert (t.bar (0L, 1.0) == 83);
  static_assert (t.bar (0LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] (10, 1.0f) == 82);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] (20L, 1.0) == 92);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] (30LL, 1.0L) == 102);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] (10, 1.0f) == 83);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] (20L, 1.0) == 93);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] (30LL, 1.0L) == 103);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] (10, 1.0f) == 84);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] (20L, 1.0) == 94);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] (30LL, 1.0L) == 104);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] (10, 1.0f) == 92);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] (20L, 1.0) == 102);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] (30LL, 1.0L) == 112);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] (10, 1.0f) == 93);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] (20L, 1.0) == 103);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] (30LL, 1.0L) == 113);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] (10, 1.0f) == 94);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] (20L, 1.0) == 104);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] (30LL, 1.0L) == 114);
  static_assert (t.template bar <float> (0, 1.0f) == 82);
  static_assert (t.template bar <double> (0L, 1.0) == 83);
  static_assert (t.template bar <long double> (0LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] <float> (10, 1.0f) == 82);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] <double> (20L, 1.0) == 92);
  static_assert (t.template [:members_of (^^S, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] <float> (10, 1.0f) == 83);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] <double> (20L, 1.0) == 93);
  static_assert (t.template [:members_of (^^S, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] <float> (10, 1.0f) == 84);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] <double> (20L, 1.0) == 94);
  static_assert (t.template [:members_of (^^S, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] <float> (10, 1.0f) == 92);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] <double> (20L, 1.0) == 102);
  static_assert (t.template [:members_of (^^T, uctx)[3]:] <long double> (30LL, 1.0L) == 112);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] <float> (10, 1.0f) == 93);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] <double> (20L, 1.0) == 103);
  static_assert (t.template [:members_of (^^T, uctx)[4]:] <long double> (30LL, 1.0L) == 113);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] <float> (10, 1.0f) == 94);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] <double> (20L, 1.0) == 104);
  static_assert (t.template [:members_of (^^T, uctx)[5]:] <long double> (30LL, 1.0L) == 114);
}

template <typename A, typename B>
void
baz ()
{
  constexpr S s = 1;
  static_assert (s.foo (0, 1.0f) == 42);
  static_assert (s.foo (0L, 1.0) == 43);
  static_assert (s.foo (0LL, 1.0L) == 44);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] (10, 1.0f) == 52);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] (20L, 1.0) == 62);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] (30LL, 1.0L) == 72);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] (10, 1.0f) == 53);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] (20L, 1.0) == 63);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] (30LL, 1.0L) == 73);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] (10, 1.0f) == 54);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] (20L, 1.0) == 64);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] (30LL, 1.0L) == 74);
  static_assert (s.foo <float> (0, 1.0f) == 42);
  static_assert (s.foo <double> (0L, 1.0) == 43);
  static_assert (s.foo <long double> (0LL, 1.0L) == 44);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] <float> (10, 1.0f) == 52);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] <double> (20L, 1.0) == 62);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] <long double> (30LL, 1.0L) == 72);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] <float> (10, 1.0f) == 53);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] <double> (20L, 1.0) == 63);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] <long double> (30LL, 1.0L) == 73);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] <float> (10, 1.0f) == 54);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] <double> (20L, 1.0) == 64);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] <long double> (30LL, 1.0L) == 74);
  static_assert (s.bar (0, 1.0f) == 72);
  static_assert (s.bar (0L, 1.0) == 73);
  static_assert (s.bar (0LL, 1.0L) == 74);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] (10, 1.0f) == 82);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] (20L, 1.0) == 92);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] (30LL, 1.0L) == 102);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] (10, 1.0f) == 83);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] (20L, 1.0) == 93);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] (30LL, 1.0L) == 103);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] (10, 1.0f) == 84);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] (20L, 1.0) == 94);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] (30LL, 1.0L) == 104);
  static_assert (s.bar <float> (0, 1.0f) == 72);
  static_assert (s.bar <double> (0L, 1.0) == 73);
  static_assert (s.bar <long double> (0LL, 1.0L) == 74);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] <float> (10, 1.0f) == 82);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] <double> (20L, 1.0) == 92);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] <float> (10, 1.0f) == 83);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] <double> (20L, 1.0) == 93);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] <float> (10, 1.0f) == 84);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] <double> (20L, 1.0) == 94);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
  constexpr T t = 2;
  static_assert (t.foo (0, 1.0f) == 53);
  static_assert (t.foo (0L, 1.0) == 54);
  static_assert (t.foo (0LL, 1.0L) == 55);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] (10, 1.0f) == 53);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] (20L, 1.0) == 63);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] (30LL, 1.0L) == 73);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] (10, 1.0f) == 54);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] (20L, 1.0) == 64);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] (30LL, 1.0L) == 74);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] (10, 1.0f) == 55);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] (20L, 1.0) == 65);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] (30LL, 1.0L) == 75);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] (10, 1.0f) == 63);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] (20L, 1.0) == 73);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] (30LL, 1.0L) == 83);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] (10, 1.0f) == 64);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] (20L, 1.0) == 74);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] (30LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] (10, 1.0f) == 65);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] (20L, 1.0) == 75);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] (30LL, 1.0L) == 85);
  static_assert (t.foo <float> (0, 1.0f) == 53);
  static_assert (t.foo <double> (0L, 1.0) == 54);
  static_assert (t.foo <long double> (0LL, 1.0L) == 55);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] <float> (10, 1.0f) == 53);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] <double> (20L, 1.0) == 63);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] <long double> (30LL, 1.0L) == 73);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] <float> (10, 1.0f) == 54);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] <double> (20L, 1.0) == 64);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] <long double> (30LL, 1.0L) == 74);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] <float> (10, 1.0f) == 55);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] <double> (20L, 1.0) == 65);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] <long double> (30LL, 1.0L) == 75);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] <float> (10, 1.0f) == 63);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] <double> (20L, 1.0) == 73);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] <long double> (30LL, 1.0L) == 83);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] <float> (10, 1.0f) == 64);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] <double> (20L, 1.0) == 74);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] <long double> (30LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] <float> (10, 1.0f) == 65);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] <double> (20L, 1.0) == 75);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] <long double> (30LL, 1.0L) == 85);
  static_assert (t.bar (0, 1.0f) == 82);
  static_assert (t.bar (0L, 1.0) == 83);
  static_assert (t.bar (0LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] (10, 1.0f) == 82);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] (20L, 1.0) == 92);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] (30LL, 1.0L) == 102);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] (10, 1.0f) == 83);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] (20L, 1.0) == 93);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] (30LL, 1.0L) == 103);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] (10, 1.0f) == 84);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] (20L, 1.0) == 94);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] (30LL, 1.0L) == 104);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] (10, 1.0f) == 92);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] (20L, 1.0) == 102);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] (30LL, 1.0L) == 112);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] (10, 1.0f) == 93);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] (20L, 1.0) == 103);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] (30LL, 1.0L) == 113);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] (10, 1.0f) == 94);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] (20L, 1.0) == 104);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] (30LL, 1.0L) == 114);
  static_assert (t.bar <float> (0, 1.0f) == 82);
  static_assert (t.bar <double> (0L, 1.0) == 83);
  static_assert (t.bar <long double> (0LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] <float> (10, 1.0f) == 82);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] <double> (20L, 1.0) == 92);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] <float> (10, 1.0f) == 83);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] <double> (20L, 1.0) == 93);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] <float> (10, 1.0f) == 84);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] <double> (20L, 1.0) == 94);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] <float> (10, 1.0f) == 92);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] <double> (20L, 1.0) == 102);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] <long double> (30LL, 1.0L) == 112);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] <float> (10, 1.0f) == 93);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] <double> (20L, 1.0) == 103);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] <long double> (30LL, 1.0L) == 113);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] <float> (10, 1.0f) == 94);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] <double> (20L, 1.0) == 104);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] <long double> (30LL, 1.0L) == 114);
}

template <typename A, typename B>
void
qux ()
{
  constexpr A s = 1;
  static_assert (s.foo (0, 1.0f) == 42);
  static_assert (s.foo (0L, 1.0) == 43);
  static_assert (s.foo (0LL, 1.0L) == 44);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] (10, 1.0f) == 52);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] (20L, 1.0) == 62);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] (30LL, 1.0L) == 72);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] (10, 1.0f) == 53);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] (20L, 1.0) == 63);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] (30LL, 1.0L) == 73);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] (10, 1.0f) == 54);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] (20L, 1.0) == 64);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] (30LL, 1.0L) == 74);
  static_assert (s.template foo <float> (0, 1.0f) == 42);
  static_assert (s.template foo <double> (0L, 1.0) == 43);
  static_assert (s.template foo <long double> (0LL, 1.0L) == 44);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] <float> (10, 1.0f) == 52);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] <double> (20L, 1.0) == 62);
  static_assert (s.template [:members_of (^^A, uctx)[0]:] <long double> (30LL, 1.0L) == 72);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] <float> (10, 1.0f) == 53);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] <double> (20L, 1.0) == 63);
  static_assert (s.template [:members_of (^^A, uctx)[1]:] <long double> (30LL, 1.0L) == 73);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] <float> (10, 1.0f) == 54);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] <double> (20L, 1.0) == 64);
  static_assert (s.template [:members_of (^^A, uctx)[2]:] <long double> (30LL, 1.0L) == 74);
  static_assert (s.bar (0, 1.0f) == 72);
  static_assert (s.bar (0L, 1.0) == 73);
  static_assert (s.bar (0LL, 1.0L) == 74);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] (10, 1.0f) == 82);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] (20L, 1.0) == 92);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] (30LL, 1.0L) == 102);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] (10, 1.0f) == 83);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] (20L, 1.0) == 93);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] (30LL, 1.0L) == 103);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] (10, 1.0f) == 84);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] (20L, 1.0) == 94);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] (30LL, 1.0L) == 104);
  static_assert (s.template bar <float> (0, 1.0f) == 72);
  static_assert (s.template bar <double> (0L, 1.0) == 73);
  static_assert (s.template bar <long double> (0LL, 1.0L) == 74);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] <float> (10, 1.0f) == 82);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] <double> (20L, 1.0) == 92);
  static_assert (s.template [:members_of (^^A, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] <float> (10, 1.0f) == 83);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] <double> (20L, 1.0) == 93);
  static_assert (s.template [:members_of (^^A, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] <float> (10, 1.0f) == 84);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] <double> (20L, 1.0) == 94);
  static_assert (s.template [:members_of (^^A, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
  constexpr B t = 2;
  static_assert (t.foo (0, 1.0f) == 53);
  static_assert (t.foo (0L, 1.0) == 54);
  static_assert (t.foo (0LL, 1.0L) == 55);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] (10, 1.0f) == 53);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] (20L, 1.0) == 63);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] (30LL, 1.0L) == 73);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] (10, 1.0f) == 54);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] (20L, 1.0) == 64);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] (30LL, 1.0L) == 74);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] (10, 1.0f) == 55);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] (20L, 1.0) == 65);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] (30LL, 1.0L) == 75);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] (10, 1.0f) == 63);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] (20L, 1.0) == 73);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] (30LL, 1.0L) == 83);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] (10, 1.0f) == 64);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] (20L, 1.0) == 74);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] (30LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] (10, 1.0f) == 65);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] (20L, 1.0) == 75);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] (30LL, 1.0L) == 85);
  static_assert (t.template foo <float> (0, 1.0f) == 53);
  static_assert (t.template foo <double> (0L, 1.0) == 54);
  static_assert (t.template foo <long double> (0LL, 1.0L) == 55);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] <float> (10, 1.0f) == 53);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] <double> (20L, 1.0) == 63);
  static_assert (t.template [:members_of (^^A, uctx)[0]:] <long double> (30LL, 1.0L) == 73);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] <float> (10, 1.0f) == 54);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] <double> (20L, 1.0) == 64);
  static_assert (t.template [:members_of (^^A, uctx)[1]:] <long double> (30LL, 1.0L) == 74);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] <float> (10, 1.0f) == 55);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] <double> (20L, 1.0) == 65);
  static_assert (t.template [:members_of (^^A, uctx)[2]:] <long double> (30LL, 1.0L) == 75);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] <float> (10, 1.0f) == 63);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] <double> (20L, 1.0) == 73);
  static_assert (t.template [:members_of (^^B, uctx)[0]:] <long double> (30LL, 1.0L) == 83);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] <float> (10, 1.0f) == 64);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] <double> (20L, 1.0) == 74);
  static_assert (t.template [:members_of (^^B, uctx)[1]:] <long double> (30LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] <float> (10, 1.0f) == 65);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] <double> (20L, 1.0) == 75);
  static_assert (t.template [:members_of (^^B, uctx)[2]:] <long double> (30LL, 1.0L) == 85);
  static_assert (t.bar (0, 1.0f) == 82);
  static_assert (t.bar (0L, 1.0) == 83);
  static_assert (t.bar (0LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] (10, 1.0f) == 82);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] (20L, 1.0) == 92);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] (30LL, 1.0L) == 102);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] (10, 1.0f) == 83);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] (20L, 1.0) == 93);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] (30LL, 1.0L) == 103);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] (10, 1.0f) == 84);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] (20L, 1.0) == 94);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] (30LL, 1.0L) == 104);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] (10, 1.0f) == 92);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] (20L, 1.0) == 102);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] (30LL, 1.0L) == 112);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] (10, 1.0f) == 93);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] (20L, 1.0) == 103);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] (30LL, 1.0L) == 113);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] (10, 1.0f) == 94);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] (20L, 1.0) == 104);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] (30LL, 1.0L) == 114);
  static_assert (t.template bar <float> (0, 1.0f) == 82);
  static_assert (t.template bar <double> (0L, 1.0) == 83);
  static_assert (t.template bar <long double> (0LL, 1.0L) == 84);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] <float> (10, 1.0f) == 82);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] <double> (20L, 1.0) == 92);
  static_assert (t.template [:members_of (^^A, uctx)[3]:] <long double> (30LL, 1.0L) == 102);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] <float> (10, 1.0f) == 83);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] <double> (20L, 1.0) == 93);
  static_assert (t.template [:members_of (^^A, uctx)[4]:] <long double> (30LL, 1.0L) == 103);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] <float> (10, 1.0f) == 84);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] <double> (20L, 1.0) == 94);
  static_assert (t.template [:members_of (^^A, uctx)[5]:] <long double> (30LL, 1.0L) == 104);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] <float> (10, 1.0f) == 92);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] <double> (20L, 1.0) == 102);
  static_assert (t.template [:members_of (^^B, uctx)[3]:] <long double> (30LL, 1.0L) == 112);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] <float> (10, 1.0f) == 93);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] <double> (20L, 1.0) == 103);
  static_assert (t.template [:members_of (^^B, uctx)[4]:] <long double> (30LL, 1.0L) == 113);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] <float> (10, 1.0f) == 94);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] <double> (20L, 1.0) == 104);
  static_assert (t.template [:members_of (^^B, uctx)[5]:] <long double> (30LL, 1.0L) == 114);
}

void
fred ()
{
  foo <42> ();
  bar <S, T> ();
  baz <S, T> ();
  qux <S, T> ();
}
