/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_jv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Wektu Rerata Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Wektu Standar Samoa",
               "",
               "Wektu Ketiga Samoa",
               "",
               "Wektu Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Wektu Standar Kepuloan Cook",
               "",
               "Wektu Ketiga Kepuloan Cook",
               "",
               "Wektu Kepuloan Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Wektu Standar Kuba",
               "CST",
               "Wektu Ketigo Kuba",
               "CDT",
               "Wektu Kuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Wektu Standar Fiji",
               "",
               "Wektu Ketigo Fiji",
               "",
               "Wektu Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Wektu Standar Teluk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Wektu Standar Hovd",
               "",
               "Wektu Ketiga Hovd",
               "",
               "Wektu Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Wektu Standar Iran",
               "",
               "Wektu Ketigo Iran",
               "",
               "Wektu Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Wektu Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Wektu Standar Omsk",
               "",
               "Wektu Ketigo Omsk",
               "",
               "Wektu Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Wektu Standar Peru",
               "",
               "Wektu Ketigo Peru",
               "",
               "Wektu Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Wektu Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wektu Pulo Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Wektu Standar Chili",
               "",
               "Wektu Ketigo Chili",
               "",
               "Wektu Chili",
               "",
            };
        final String[] China = new String[] {
               "Wektu Standar Cina",
               "CST",
               "Wektu Ketiga Cina",
               "CDT",
               "Wektu Cina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Wektu Kepuloan Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Wektu Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Wektu Standar India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Wektu Standar Jepang",
               "JST",
               "Wektu Ketiga Jepang",
               "JDT",
               "Wektu Jepang",
               "JT",
            };
        final String[] Korea = new String[] {
               "Wektu Standar Korea",
               "KST",
               "Wektu Ketiga Korea",
               "KST",
               "Wektu Korea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Wektu Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Wektu Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Wektu Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Wektu Standar Samoa Amerika",
               "SST",
               "Wektu Ketiga Samoa Amerika",
               "SST",
               "Wektu Samoa Amerika",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Wektu Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Wektu Standar Tonga",
               "",
               "Wektu Ketigo Tonga",
               "",
               "Wektu Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Wektu Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Wektu Standar Alaska",
               "AKST",
               "Wektu Ketigo Alaska",
               "AKDT",
               "Wektu Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Wektu Standar Amazon",
               "",
               "Wektu Ketigo Amazon",
               "",
               "Wektu Amazon",
               "",
            };
        final String[] Azores = new String[] {
               "Wektu Standar Azores",
               "",
               "Wektu Ketigo Azores",
               "",
               "Wektu Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Wektu Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Wektu Brunei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Wektu Standar Pulo Paskah",
               "",
               "Wektu Ketigo Pulo Paskah",
               "",
               "Wektu Pulo Paskah",
               "",
            };
        final String[] Guyana = new String[] {
               "Wektu Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Wektu Standar Hawaii-Aleutian",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Wektu Standar Israel",
               "IST",
               "Wektu Ketigo Israel",
               "IDT",
               "Wektu Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Wektu Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Wektu Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Wektu Standar Moscow",
               "MSK",
               "Wektu Ketigo Moscow",
               "MSK",
               "Wektu Moscow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Wektu Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Wektu Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Wektu Standar Taiwan",
               "CST",
               "Wektu Awan Taiwan",
               "CDT",
               "Wektu Taiwan",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Wektu Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wektu Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wektu Wallis lan Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Wektu Standar Arab",
               "",
               "Wektu Ketigo Arab",
               "",
               "Wektu Arab",
               "",
            };
        final String[] Armenia = new String[] {
               "Wektu Standar Armenia",
               "",
               "Wektu Ketigo Armenia",
               "",
               "Wektu Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Wektu Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Wektu Standar Chatham",
               "",
               "Wektu Ketigo Chatham",
               "",
               "Wektu Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Wektu Universal Kakoordhinasi",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Wektu Ekuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Wektu Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Wektu Standar Georgia",
               "",
               "Wektu Ketigo Georgia",
               "",
               "Wektu Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Wektu Standar Irkutsk",
               "",
               "Wektu Ketigo Irkutsk",
               "",
               "Wektu Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Wektu Standar Magadan",
               "",
               "Wektu Ketigo Magadan",
               "",
               "Wektu Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Wektu Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Wektu Standar Pulo Norfolk",
               "",
               "Wektu Ketigo Pulo Norfolk",
               "",
               "Wektu Pulo Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Wektu Standar Fernando de Noronha",
               "",
               "Wektu Ketigo Fernando de Noronha",
               "",
               "Wektu Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Wektu Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Wektu Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Wektu Kepuloan Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Wektu Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Wektu Standar Uruguay",
               "",
               "Wektu Ketigo Uruguay",
               "",
               "Wektu Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Wektu Standar Vanuatu",
               "",
               "Wektu Ketigo Vanuatu",
               "",
               "Wektu Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Wektu Standar Yakutsk",
               "",
               "Wektu Ketigo Yakutsk",
               "",
               "Wektu Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Wektu Standar Atlantik",
               "AST",
               "Wektu Ketigo Atlantik",
               "AST",
               "Wektu Atlantik",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Wektu Standar Brasilia",
               "",
               "Wektu Ketigo Brasilia",
               "",
               "Wektu Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Wektu Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Wektu Standar Kolombia",
               "",
               "Wektu Ketigo Kolombia",
               "",
               "Wektu Kolombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Wektu Standar Kepuloan Falkland",
               "",
               "Wektu Ketigo Kepuloan Falkland",
               "",
               "Wektu Kepuloan Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Wektu Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Wektu Maladewa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Wektu Standar Ulaanbaatar",
               "",
               "Wektu Ketiga Ulaanbaatar",
               "",
               "Wektu Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Wektu Standar Pakistan",
               "PKT",
               "Wektu Ketigo Pakistan",
               "PKST",
               "Wektu Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Wektu Standar Paraguay",
               "",
               "Wektu Ketigo Paraguay",
               "",
               "Wektu Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Wektu Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Wektu Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Wektu Standar Argentina",
               "",
               "Wektu Ketigo Argentina",
               "",
               "Wektu Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Wektu Pulo Natal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Wektu Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Wektu Standar Hong Kong",
               "HKT",
               "Wektu Ketiga Hong Kong",
               "HKST",
               "Wektu Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Wektu Indocina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Wektu Kirgizstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Wektu Standar Lord Howe",
               "",
               "Wektu Ketigo Lord Howe",
               "",
               "Wektu Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Wektu Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Wektu Standar Mauritius",
               "",
               "Wektu Ketigo Mauritius",
               "",
               "Wektu Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Wektu Singapura",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Wektu Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Wektu Standar Azerbaijan",
               "",
               "Wektu Ketigo Azerbaijan",
               "",
               "Wektu Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Wektu Standar Bangladesh",
               "",
               "Wektu Ketigo Bangladesh",
               "",
               "Wektu Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Wektu Standar Tanjung Verde",
               "",
               "Wektu Ketigo Tanjung Verde",
               "",
               "Wektu Tanjung Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Wektu Timor-Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Wektu Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Wektu Seichelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Wektu Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Wektu Standar Usbekistan",
               "",
               "Wektu Ketigo Usbekistan",
               "",
               "Wektu Usbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Wektu Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Wektu Standar Krasnoyarsk",
               "",
               "Wektu Ketigo Krasnoyarsk",
               "",
               "Wektu Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Wektu Standar Selandia Anyar",
               "NZST",
               "Wektu Ketigo Selandia Anyar",
               "NZDT",
               "Wektu Selandia Anyar",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Wektu Standar Filipina",
               "PST",
               "Wektu Ketigo Filipina",
               "PDT",
               "Wektu Filipina",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Wektu Standar Vladivostok",
               "",
               "Wektu Ketigo Vladivostok",
               "",
               "Wektu Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Wektu Segoro Hindia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Wektu Kepuloan Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Wektu Standar Newfoundland",
               "NST",
               "Wektu Ketigo Newfoundland",
               "NDT",
               "Wektu Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Wektu Standar Turkmenistan",
               "",
               "Wektu Ketigo Turkmenistan",
               "",
               "Wektu Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Wektu Guiana Prancis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Wektu Standar Kaledonia Anyar",
               "",
               "Wektu Ketigo Kaledonia Anyar",
               "",
               "Wektu Kaledonia Anyar",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Wektu Georgia Kidul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Wektu Standar Yekaterinburg",
               "",
               "Wektu Ketigo Yekaterinburg",
               "",
               "Wektu Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Wektu Afrika Tengah",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Wektu Afrika Wetan",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Wektu Afrika Kulon",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Wektu Dumont d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Wektu Standar Eropa Tengah",
               "CET",
               "Wektu Ketigo Eropa Tengah",
               "CEST",
               "Wektu Eropa Tengah",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Wektu Standar Eropa sisih Wetan",
               "EET",
               "Wektu Ketigo Eropa sisih Wetan",
               "EEST",
               "Wektu Eropa sisih Wetan",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Wektu Standar Eropa sisih Kulon",
               "WET",
               "Wektu Ketigo Eropa sisih Kulon",
               "WEST",
               "Wektu Eropa sisih Kulon",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Wektu Standar Pasifik Meksiko",
               "MST",
               "Wektu Ketigo Pasifik Meksiko",
               "MDT",
               "Wektu Pasifik Meksiko",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Wektu Standar Afrika Kidul",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Wektu Standar Tengah",
               "CST",
               "Wektu Ketigo Tengah",
               "CDT",
               "Wektu Tengah",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Wektu Standar sisih Wetan",
               "EST",
               "Wektu Ketigo sisih Wetah",
               "EST",
               "Wektu sisih Wetan",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Wektu Standar Pasifik",
               "PST",
               "Wektu Ketigo Pasifik",
               "PDT",
               "Wektu Pasifik",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Wektu Antartika lan Prancis sisih Kidul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Wektu Kepuloan Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Wektu Standar Hawaii-Aleutian",
               "HST",
               "Wektu Ketigo Hawaii-Aleutian",
               "HDT",
               "Wektu Hawaii-Aleutian",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Wektu Kepuloan Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Wektu Standar Santa Pierre lan Miquelon",
               "",
               "Wektu Ketigo Santa Pierre lan Miquelon",
               "",
               "Wektu Santa Pierre lan Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Wektu Standar Giri",
               "MST",
               "Wektu Ketigo Giri",
               "MST",
               "Wektu Giri",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Wektu Kepuloan Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Wektu Papua Nugini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Wektu Standar Australia Tengah",
               "ACST",
               "Wektu Ketigo Australia Tengah",
               "ACDT",
               "Wektu Australia Tengah",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Wektu Standar Australia sisih Wetan",
               "AEST",
               "Wektu Ketigo Australia sisih Wetan",
               "AEDT",
               "Wektu Australia sisih Wetan",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Wektu Standar Australia sisih Kulon",
               "AWST",
               "Wektu Ketigo Australia sisih Kulon",
               "AWDT",
               "Wektu Australia sisih Kulon",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Wektu Indonesia Tengah",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Wektu Indonesia sisih Wetan",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Wektu Indonesia sisih Kulon",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Wektu Standar Australia Tengah sisih Kulon",
               "",
               "Wektu Ketigo Australia Tengah sisih Kulon",
               "",
               "Wektu Australia Tengah sisih Kulon",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Wektu Rerata Greenwich",
                    "GMT",
                    "Wektu Ketigo Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Wektu Universal Kakoordhinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Wektu Rerata Greenwich",
                    "GMT",
                    "Wektu Standar Irlandia",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Wektu Universal Kakoordhinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Wektu Universal Kakoordhinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Wektu Rerata Greenwich",
                    "GMT",
                    "Wektu Ketigo Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Wektu Universal Kakoordhinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Wektu Universal Kakoordhinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Wektu Universal Kakoordhinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Wektu Rerata Greenwich",
                    "GMT",
                    "Wektu Standar Irlandia",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Wektu Rerata Greenwich",
                    "GMT",
                    "Wektu Ketigo Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Wektu Rerata Greenwich",
                    "GMT",
                    "Wektu Ketigo Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Wektu Rerata Greenwich",
                    "GMT",
                    "Wektu Ketigo Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Wektu Rerata Greenwich",
                    "GMT",
                    "Wektu Ketigo Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Wektu Rerata Greenwich",
                    "GMT",
                    "Wektu Ketigo Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Lokasi Ora Dikenali" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Calcutta", "Kalkuta" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostanai" },
            { "timezone.excity.Europe/Athens", "Athena" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Indian/Chagos", "Khagos" },
            { "timezone.excity.Indian/Comoro", "Komoro" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.America/Belize", "Belise" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Cayman", "Caiman" },
            { "timezone.excity.America/Cuiaba", "Kuiaba" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Jerusalem", "Yerusalem" },
            { "timezone.excity.Asia/Singapore", "Singapura" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Pacific/Easter", "Paskah" },
            { "timezone.excity.America/Caracas", "Karakas" },
            { "timezone.excity.America/Cayenne", "Kayenne" },
            { "timezone.excity.America/Cordoba", "Kordoba" },
            { "timezone.excity.America/Halifax", "Halifak" },
            { "timezone.excity.America/Mendoza", "Mendosa" },
            { "timezone.excity.Atlantic/Canary", "Kanari" },
            { "timezone.excity.Indian/Maldives", "Maladewa" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/St_Johns", "Santa John" },
            { "timezone.excity.America/St_Kitts", "Santa Kitts" },
            { "timezone.excity.America/St_Lucia", "Santa Lucia" },
            { "timezone.excity.Indian/Christmas", "Natal" },
            { "timezone.excity.Africa/Casablanca", "Kasablanka" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Glace_Bay", "Teluk Glace" },
            { "timezone.excity.America/Goose_Bay", "Teluk Goose" },
            { "timezone.excity.America/St_Thomas", "Santa Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburk" },
            { "timezone.excity.America/Costa_Rica", "Kosta Rika" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "timezone.excity.America/St_Vincent", "Santa Vincent" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Pulo Man" },
            { "timezone.excity.America/Fort_Nelson", "Benteng Nelson" },
            { "timezone.excity.America/Mexico_City", "Kutho Meksiko" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Riko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kape Verde" },
            { "timezone.excity.America/Campo_Grande", "Kampo Grande" },
            { "timezone.excity.America/Indiana/Knox", "Knox [Indiana]" },
            { "timezone.excity.Pacific/Port_Moresby", "Pelabuhan Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Teluk Cambridge" },
            { "timezone.excity.America/Ciudad_Juarez", "Ciudad Juáres" },
            { "timezone.excity.America/Indiana/Vevay", "Vevay [Indiana]" },
            { "timezone.excity.America/Port_of_Spain", "Palabuhan Spanyol" },
            { "timezone.excity.America/St_Barthelemy", "Santa Barthelemy" },
            { "timezone.excity.America/Swift_Current", "Arus Banter" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia Kidul" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo [Indiana]" },
            { "timezone.excity.America/Indiana/Winamac", "Winamac [Indiana]" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell City [Indiana]" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincennes [Indiana]" },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg [Indiana]" },
            { "timezone.excity.America/Kentucky/Monticello", "Monticello [Kentucky]" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah [Dakota Lor]" },
            { "timezone.excity.America/North_Dakota/Center", "Tengah [Dakota Lor]" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Salem Anyar [Dakota Lor]" },
        };
        return data;
    }
}
