SYD-RUN(1)

# NAME

*syd-run* - Run a program inside a container with the given process ID

# SYNOPSIS

*syd-run* _[-hvacimnptuU]_ _pid_ _{command [arg...]}_

# DESCRIPTION

The _syd-run_(2) utility runs a program inside a _syd_(1) container with
the given process ID. This requires the use of system calls _setns_(2),
and _pidfd_open_(2) which require Linux-5.8 or newer. Note, entering
_pid_namespaces_(7) and _time_namespaces_(7) is a privileged operation,
whereas entering _cgroup_namespaces_(7), _ipc_namespaces_(7),
_mount_namespaces_(7), _network_namespaces_(7), and _uts_namespaces_(7)
is unprivileged when combined with _user_namespaces_(7) provided that
unprivileged _user_namespaces_(7) support is enabled in the Linux
kernel.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-v*
:< Be verbose. Print informational messages on standard error.
|[ *-a*
:< Auto-detect namespaces to enter. PID and Time namespaces are excluded. This is the default.
|[ *-c*
:< Enter into CGroup namespace.
|[ *-i*
:< Enter into IPC namespace.
|[ *-m*
:< Enter into mount namespace.
|[ *-n*
:< Enter into network namespace.
|[ *-p*
:< Enter into PID namespace.
|[ *-t*
:< Enter into time namespace.
|[ *-u*
:< Enter into UTS namespace.
|[ *-U*
:< Enter into user namespace.

# EXIT STATUS

On clean exit, _syd-run_(1) exits with the same code as the child
process. On unclean termination, exit code is set to 128 plus signal
number. In case executing the child process fails _syd-run_(1) exits
with the _errno_(3) number.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _setns_(2), _pidfd_open_(2)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
