/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors.privileges;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreCommandGrantPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleReference;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.ui.editors.privileges.PermissionInfo;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorLabelProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;

abstract class PostgresPermissionsEditor<T extends DBSObject>
extends AbstractDatabaseObjectEditor<PostgrePrivilegeOwner> {
    protected final Map<String, PostgrePrivilege> objectToPrivileges = new HashMap<String, PostgrePrivilege>();
    @NotNull
    protected DBSObject[] selectedObjects = new DBSObject[0];
    protected Table permissionTable;
    private PageControl pageControl;
    private Composite permEditPanel;
    private DatabaseNavigatorTree roleOrObjectTable;
    private Text selectedObjectNames;
    private boolean isLoaded;

    PostgresPermissionsEditor() {
    }

    public void createPartControl(Composite parent) {
        this.pageControl = new PageControl(parent);
        CustomSashForm composite = UIUtils.createPartDivider((IWorkbenchPart)this.getSite().getPart(), (Composite)this.pageControl, (int)256);
        composite.setLayoutData((Object)new GridData(1808));
        this.addSelectableObjectsTree((Composite)composite);
        this.addPermissionsPanel((Composite)composite);
        this.addButtons(this.permEditPanel);
        this.addText(this.permEditPanel);
        this.pageControl.createOrSubstituteProgressPanel(this.getSite());
    }

    private void handleSelectionChange() {
        this.refreshPermissionsPanel(NavigatorUtils.getSelectedObjects((ISelection)this.roleOrObjectTable.getViewer().getSelection()));
    }

    private PostgrePrivilege getObjectPermissions(DBSObject object) {
        return this.objectToPrivileges.get(this.getObjectName(object));
    }

    protected String getObjectName(DBSObject object) {
        if (object instanceof PostgreProcedure) {
            PostgreProcedure procedure = (PostgreProcedure)object;
            return DBUtils.getQuotedIdentifier((DBSObject)procedure.getSchema()) + "." + procedure.getOverloadedName();
        }
        if (object instanceof DBNDatabaseFolder) {
            DBNDatabaseFolder folder = (DBNDatabaseFolder)object;
            String parentNodeName = folder.getParentNode().getNodeDisplayName();
            Class childrenClass = folder.getChildrenClass();
            if (DBSSequence.class.isAssignableFrom(childrenClass)) {
                return parentNodeName + "." + String.valueOf(PostgrePrivilegeGrant.Kind.SEQUENCE);
            }
            if (DBSProcedure.class.isAssignableFrom(childrenClass)) {
                return parentNodeName + "." + String.valueOf(PostgrePrivilegeGrant.Kind.FUNCTION);
            }
            return parentNodeName + "." + String.valueOf(PostgrePrivilegeGrant.Kind.TABLE);
        }
        return DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DDL);
    }

    private void grantAllCurrentPrivileges() {
        PostgrePrivilegeType[] privilegesToGrant = (PostgrePrivilegeType[])Arrays.stream(this.permissionTable.getItems()).filter(Predicate.not(TableItem::getChecked)).peek(x -> x.setChecked(true)).map(x -> (PostgrePrivilegeType)x.getData()).toArray(PostgrePrivilegeType[]::new);
        this.grantPrivilegeToSelectedObjects(privilegesToGrant);
    }

    private void revokeAllCurrentPrivileges() {
        PostgrePrivilegeType[] privilegesToRevoke = (PostgrePrivilegeType[])Arrays.stream(this.permissionTable.getItems()).filter(TableItem::getChecked).peek(x -> x.setChecked(false)).map(x -> (PostgrePrivilegeType)x.getData()).toArray(PostgrePrivilegeType[]::new);
        this.revokeFromSelectedObjects(privilegesToRevoke);
    }

    private void grantPrivilegeToSelectedObjects(PostgrePrivilegeType[] privilegeTypes) {
        this.applyToSelectedObjects(privilegeTypes, this::grantPrivilege, Action.GRANT);
    }

    private void revokeFromSelectedObjects(PostgrePrivilegeType[] privilegeTypes) {
        this.applyToSelectedObjects(privilegeTypes, this::revokePrivilege, Action.REVOKE);
    }

    private void applyToSelectedObjects(PostgrePrivilegeType[] privilegeTypes, BiFunction<PostgrePrivilegeType, T, PostgrePrivilege> privilegeProvider, Action action) {
        DBSObject[] dBSObjectArray = this.selectedObjects;
        int n = this.selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObject selectedObject = dBSObjectArray[n2];
            PostgrePrivilege privilege = null;
            PostgrePrivilegeType[] postgrePrivilegeTypeArray = privilegeTypes;
            int n3 = privilegeTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                PostgrePrivilegeType privilegeType = postgrePrivilegeTypeArray[n4];
                privilege = privilegeProvider.apply(privilegeType, (PostgrePrivilegeType)selectedObject);
                ++n4;
            }
            if (privilege != null) {
                this.addCommand(action, privilege, selectedObject, privilegeTypes);
            }
            ++n2;
        }
    }

    @Nullable
    protected abstract PostgrePrivilege grantPrivilege(PostgrePrivilegeType var1, T var2);

    @Nullable
    protected abstract PostgrePrivilege revokePrivilege(PostgrePrivilegeType var1, T var2);

    private void addCommand(Action action, PostgrePrivilege privilege, @NotNull DBSObject object, PostgrePrivilegeType[] privilegeTypes) {
        this.addChangeCommand((DBECommand)new PostgreCommandGrantPrivilege(privilege.getOwner(), action == Action.GRANT, object, privilege, privilegeTypes), (DBECommandReflector)new DBECommandReflector<PostgrePrivilegeOwner, PostgreCommandGrantPrivilege>(){

            public void redoCommand(PostgreCommandGrantPrivilege cmd) {
            }

            public void undoCommand(PostgreCommandGrantPrivilege cmd) {
            }
        });
    }

    @NotNull
    protected PostgrePrivilegeGrant createGrant(@NotNull PostgrePrivilegeOwner databaseObject, @NotNull PostgreRole role, @NotNull PostgrePrivilegeType type) {
        String currentUserName = databaseObject.getDataSource().getContainer().getActualConnectionConfiguration().getUserName();
        PostgreRoleReference currentUserReference = new PostgreRoleReference(databaseObject.getDatabase(), currentUserName, null);
        return new PostgrePrivilegeGrant(currentUserReference, role.getRoleReference(), databaseObject.getDatabase().getName(), databaseObject.getSchema().getName(), databaseObject.getName(), type, false, false);
    }

    private void refreshPermissionsPanel(@NotNull List<DBSObject> objects) {
        Optional<DBSObject> illegalObject = objects.stream().filter(Predicate.not(this::doesSupportObject)).findAny();
        if (objects.isEmpty() || illegalObject.isPresent()) {
            UIUtils.enableWithChildren((Control)this.permEditPanel, (boolean)false);
            this.selectedObjectNames.setText(PostgreMessages.dialog_object_description_text_no_objects);
            return;
        }
        this.selectedObjects = objects.toArray(new DBSObject[0]);
        this.permissionTable.removeAll();
        PostgrePrivilegeType[] supportedPrivilegeTypes = this.getSupportedPrivilegeTypes(objects.getFirst());
        PostgrePrivilege objectPermissions = this.getObjectPermissions(this.selectedObjects[0]);
        PostgrePrivilegeType[] postgrePrivilegeTypeArray = supportedPrivilegeTypes;
        int n = supportedPrivilegeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            PostgrePrivilegeType privilegeType = postgrePrivilegeTypeArray[n2];
            TableItem tableItem = new TableItem(this.permissionTable, 16384);
            tableItem.setText(0, privilegeType.name());
            tableItem.setData((Object)privilegeType);
            if (objectPermissions != null) {
                short permission = objectPermissions.getPermission(privilegeType);
                tableItem.setChecked((permission & 1) != 0);
                tableItem.setText(1, (permission & 2) != 0 ? "X" : "");
                tableItem.setText(2, (permission & 4) != 0 ? "X" : "");
            }
            ++n2;
        }
        this.permissionTable.getParent().layout(true);
        UIUtils.packColumns((Table)this.permissionTable, (boolean)false);
        String objectNames = objects.stream().map(it -> DBUtils.getObjectFullName((DBPDataSource)it.getDataSource(), (DBPNamedObject)it, (DBPEvaluationContext)DBPEvaluationContext.DML)).collect(Collectors.joining(", "));
        this.selectedObjectNames.setText(objectNames);
        UIUtils.enableWithChildren((Control)this.permEditPanel, (boolean)true);
    }

    public void setFocus() {
        if (this.pageControl != null) {
            this.pageControl.activate(true);
        }
        if (this.roleOrObjectTable != null) {
            this.roleOrObjectTable.getViewer().getControl().setFocus();
        }
    }

    public synchronized void activatePart() {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.permissionTable, (boolean)false));
        LoadingJob.createService((ILoadService)new DatabaseLoadService<PermissionInfo>("Load permissions", this.getExecutionContext()){

            public PermissionInfo evaluate(@NotNull DBRProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask("Load privileges from database..", 1);
                try {
                    monitor.subTask("Load " + ((PostgrePrivilegeOwner)PostgresPermissionsEditor.this.getDatabaseObject()).getName() + " privileges");
                    PermissionInfo permissionInfo = PostgresPermissionsEditor.this.laodPermissionInfo(monitor);
                    return permissionInfo;
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        }, this.pageControl.createLoadVisualizer()).schedule();
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        boolean onSave;
        boolean bl = onSave = source instanceof DBNEvent && ((DBNEvent)source).getSource() == DBNEvent.UPDATE_ON_SAVE;
        if (force || onSave || !this.isLoaded) {
            this.isLoaded = false;
            UIUtils.syncExec(() -> this.refreshPermissionsPanel(List.of()));
            this.activatePart();
            return IRefreshablePart.RefreshResult.REFRESHED;
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    private Composite addPermissionsPanel(Composite parent) {
        this.permEditPanel = new Composite(parent, 0);
        this.permEditPanel.setLayout((Layout)new GridLayout(1, true));
        this.permissionTable = this.addPermissionTable(this.permEditPanel);
        return this.permEditPanel;
    }

    private Table addPermissionTable(Composite composite) {
        Table table = new Table(composite, 65568);
        table.setLayoutData((Object)new GridData(768));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        UIUtils.createTableColumn((Table)table, (int)16384, (String)PostgreMessages.dialog_create_table_column_name_permission);
        UIUtils.createTableColumn((Table)table, (int)0x1000000, (String)PostgreMessages.dialog_create_table_column_name_with_garant);
        UIUtils.createTableColumn((Table)table, (int)0x1000000, (String)PostgreMessages.dialog_create_table_column_name_with_hierarchy);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem tableItem = (TableItem)e.item;
                    if (e.detail == 32) {
                        PostgrePrivilegeType[] privilegeTypes = new PostgrePrivilegeType[]{(PostgrePrivilegeType)tableItem.getData()};
                        if (tableItem.getChecked()) {
                            PostgresPermissionsEditor.this.grantPrivilegeToSelectedObjects(privilegeTypes);
                        } else {
                            PostgresPermissionsEditor.this.revokeFromSelectedObjects(privilegeTypes);
                        }
                    }
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
            }
        });
        return table;
    }

    private DatabaseNavigatorTree addSelectableObjectsTree(Composite composite) {
        this.roleOrObjectTable = new DatabaseNavigatorTree(composite, (DBNNode)NavigatorUtils.getSelectedProject().getNavigatorModel().getRoot(), 65538, false, (INavigatorFilter)this.navigatorTreeFilter());
        this.roleOrObjectTable.setLayoutData((Object)new GridData(1808));
        this.setupTreeViewer(this.roleOrObjectTable, this.objectToPrivileges.keySet());
        return this.roleOrObjectTable;
    }

    private void setupTreeViewer(DatabaseNavigatorTree objectTree, final Set<String> objectNames) {
        TreeViewer treeViewer = objectTree.getViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)new DatabaseNavigatorLabelProvider(objectTree){

            public Font getFont(Object element) {
                if (element instanceof DBNDatabaseNode) {
                    DBSObject object = ((DBNDatabaseNode)element).getObject();
                    if (object instanceof PostgreSchema) {
                        String schemaPrefix = DBUtils.getQuotedIdentifier((DBSObject)object) + ".";
                        for (String tableName : objectNames) {
                            if (!tableName.startsWith(schemaPrefix)) continue;
                            return BaseThemeSettings.instance.treeAndTableFontBold;
                        }
                    } else if (PostgresPermissionsEditor.this.getObjectPermissions(object) != null) {
                        return BaseThemeSettings.instance.treeAndTableFontBold;
                    }
                }
                return null;
            }
        });
        treeViewer.addSelectionChangedListener(event -> this.handleSelectionChange());
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof DBNNode && !(element instanceof DBNDatabaseNode)) {
                    return false;
                }
                if (element instanceof DBNDatabaseFolder) {
                    DBNDatabaseFolder dbFolder = (DBNDatabaseFolder)element;
                    DBXTreeFolder meta = dbFolder.getMeta();
                    Class childType = meta.getSource().getObjectClass(meta.getType());
                    if (childType == null) {
                        return false;
                    }
                    if (PostgreProcedure.class.isAssignableFrom(childType)) {
                        PostgrePrivilegeOwner owner = (PostgrePrivilegeOwner)PostgresPermissionsEditor.this.getDatabaseObject();
                        if (owner instanceof PostgreRole) {
                            PostgreRole role = (PostgreRole)owner;
                            return role.supportsRoutinesPermissions();
                        }
                        return true;
                    }
                    return PostgreTableReal.class.isAssignableFrom(childType) || PostgreSequence.class.isAssignableFrom(childType) || PostgreProcedure.class.isAssignableFrom(childType) || PostgreRole.class.isAssignableFrom(childType);
                }
                return true;
            }
        });
    }

    private void addButtons(Composite parent) {
        Composite buttonPanel = new Composite(parent, 0);
        buttonPanel.setLayoutData((Object)new GridData(768));
        buttonPanel.setLayout((Layout)new RowLayout());
        UIUtils.createPushButton((Composite)buttonPanel, (String)PostgreMessages.dialog_create_push_button_grant_all, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgresPermissionsEditor.this.grantAllCurrentPrivileges();
            }
        });
        UIUtils.createPushButton((Composite)buttonPanel, (String)PostgreMessages.dialog_create_push_button_revoke_all, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgresPermissionsEditor.this.revokeAllCurrentPrivileges();
            }
        });
    }

    private void addText(Composite parent) {
        this.selectedObjectNames = new Text(parent, 2634);
        this.selectedObjectNames.setLayoutData((Object)new GridData(1808));
    }

    protected abstract PostgrePrivilegeType[] getSupportedPrivilegeTypes(DBSObject var1);

    protected abstract boolean doesSupportObject(DBSObject var1);

    protected abstract PermissionInfo laodPermissionInfo(DBRProgressMonitor var1) throws DBException;

    protected abstract DatabaseNavigatorTreeFilter navigatorTreeFilter();

    private static enum Action {
        GRANT,
        REVOKE;

    }

    private class PageControl
    extends ProgressPageControl {
        PageControl(Composite parent) {
            super(parent, 0x10000000);
        }

        ProgressPageControl.ProgressVisualizer<PermissionInfo> createLoadVisualizer() {
            return new ProgressPageControl.ProgressVisualizer<PermissionInfo>((ProgressPageControl)this){

                public void completeLoading(PermissionInfo privs) {
                    super.completeLoading((Object)privs);
                    if (privs == null) {
                        return;
                    }
                    ((PageControl)PageControl.this).PostgresPermissionsEditor.this.objectToPrivileges.clear();
                    for (PostgrePrivilege perm : privs.privileges()) {
                        ((PageControl)PageControl.this).PostgresPermissionsEditor.this.objectToPrivileges.put(perm.getName(), perm);
                    }
                    ((PageControl)PageControl.this).PostgresPermissionsEditor.this.roleOrObjectTable.reloadTree((DBNNode)privs.objectRootNode());
                    ((PageControl)PageControl.this).PostgresPermissionsEditor.this.roleOrObjectTable.getViewer().expandToLevel(2);
                    PostgresPermissionsEditor.this.handleSelectionChange();
                }
            };
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            super.fillCustomActions(contributionManager);
            contributionManager.add((IContributionItem)new Separator());
            IWorkbenchPartSite workbenchSite = PostgresPermissionsEditor.this.getSite();
            if (workbenchSite != null) {
                DatabaseEditorUtils.contributeStandardEditorActions((IWorkbenchSite)workbenchSite, (IContributionManager)contributionManager);
            }
        }
    }
}

