/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.item.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataPredicates;
import org.openhab.core.items.MetadataProvider;
import org.openhab.core.model.core.ModelCoreConstants;
import org.osgi.service.component.annotations.Component;

@Component(service={MetadataProvider.class, GenericMetadataProvider.class})
@NonNullByDefault
public class GenericMetadataProvider
extends AbstractProvider<Metadata>
implements MetadataProvider {
    private final Map<String, Set<Metadata>> metadata = new HashMap<String, Set<Metadata>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public void addMetadata(String modelName, String bindingType, String itemName, String value, @Nullable Map<String, Object> configuration) {
        MetadataKey key = new MetadataKey(bindingType, itemName);
        Metadata md = new Metadata(key, value, configuration);
        try {
            this.lock.writeLock().lock();
            Set mdSet = Objects.requireNonNull(this.metadata.computeIfAbsent(modelName, k -> new HashSet()));
            mdSet.add(md);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (!ModelCoreConstants.isIsolatedModel((String)modelName)) {
            this.notifyListenersAboutAddedElement(md);
        }
    }

    public void removeMetadataByNamespace(String namespace) {
        HashMap toBeNotified;
        try {
            this.lock.writeLock().lock();
            toBeNotified = new HashMap();
            HashSet<String> modelsToRemove = new HashSet<String>();
            for (Map.Entry<String, Set<Metadata>> entry : this.metadata.entrySet()) {
                String modelName = entry.getKey();
                Set<Metadata> mdSet = entry.getValue();
                Set toBeRemoved = mdSet.stream().filter(MetadataPredicates.hasNamespace((String)namespace)).collect(Collectors.toSet());
                mdSet.removeAll(toBeRemoved);
                if (mdSet.isEmpty()) {
                    modelsToRemove.add(modelName);
                }
                if (ModelCoreConstants.isIsolatedModel((String)modelName) || toBeRemoved.isEmpty()) continue;
                toBeNotified.put(modelName, toBeRemoved);
            }
            modelsToRemove.forEach(this.metadata::remove);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        toBeNotified.values().forEach(set -> set.forEach(arg_0 -> ((GenericMetadataProvider)this).notifyListenersAboutRemovedElement(arg_0)));
    }

    public void removeMetadataByItemName(String modelName, String itemName) {
        HashSet toBeNotified;
        try {
            this.lock.writeLock().lock();
            toBeNotified = new HashSet();
            Set mdSet = this.metadata.getOrDefault(modelName, new HashSet());
            Set toBeRemoved = mdSet.stream().filter(MetadataPredicates.ofItem((String)itemName)).collect(Collectors.toSet());
            mdSet.removeAll(toBeRemoved);
            if (mdSet.isEmpty()) {
                this.metadata.remove(modelName);
            }
            if (!ModelCoreConstants.isIsolatedModel((String)modelName) && !toBeRemoved.isEmpty()) {
                toBeNotified.addAll(toBeRemoved);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        toBeNotified.forEach(arg_0 -> ((GenericMetadataProvider)this).notifyListenersAboutRemovedElement(arg_0));
    }

    public Collection<Metadata> getAll() {
        try {
            this.lock.readLock().lock();
            Set set = this.metadata.keySet().stream().filter(name -> !ModelCoreConstants.isIsolatedModel((String)name)).map(name -> this.metadata.getOrDefault(name, Set.of())).flatMap(s -> s.stream()).collect(Collectors.toSet());
            Set<Metadata> set2 = Set.copyOf(set);
            return set2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Metadata> getAllFromModel(String modelName) {
        try {
            this.lock.readLock().lock();
            Set set = this.metadata.getOrDefault(modelName, Set.of());
            Set<Metadata> set2 = Set.copyOf(set);
            return set2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

