/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.code.plugin;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/anthropic/code/plugin/IDENotificationUtil;", "", "<init>", "()V", "NOTIFICATION_GROUP_ID_SETUP", "", "NOTIFICATION_GROUP_ID_ERROR", "showClaudeNotFoundWarning", "", "project", "Lcom/intellij/openapi/project/Project;", "showPluginOutOfDateWarning", "claude-code-jetbrains-plugin"})
public final class IDENotificationUtil {
    @NotNull
    public static final IDENotificationUtil INSTANCE = new IDENotificationUtil();
    @NotNull
    private static final String NOTIFICATION_GROUP_ID_SETUP = "ClaudeCodePluginSetup";
    @NotNull
    private static final String NOTIFICATION_GROUP_ID_ERROR = "ClaudeCodePluginError";

    private IDENotificationUtil() {
    }

    public final void showClaudeNotFoundWarning(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID_SETUP);
        Notification notification = notificationGroup.createNotification("Cannot launch Claude Code", "Please ensure Claude Code is installed and the 'claude' command is in your system path.", NotificationType.ERROR);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)"Install Claude Code", IDENotificationUtil::showClaudeNotFoundWarning$lambda$0));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)"Open Settings", () -> IDENotificationUtil.showClaudeNotFoundWarning$lambda$1(project)));
        notification.notify(project);
    }

    public final void showPluginOutOfDateWarning(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID_ERROR);
        Notification notification = notificationGroup.createNotification("Claude Code plugin out-of-date", "This version of the plugin is no longer supported. Please update the plugin.", NotificationType.ERROR);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)"Update plugin", IDENotificationUtil::showPluginOutOfDateWarning$lambda$2));
        notification.notify(project);
    }

    private static final void showClaudeNotFoundWarning$lambda$0() {
        BrowserUtil.open((String)"https://claude.com/claude-code");
    }

    private static final void showClaudeNotFoundWarning$lambda$1(Project $project) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, "com.anthropic.code.plugin.settings");
    }

    private static final void showPluginOutOfDateWarning$lambda$2() {
        BrowserUtil.open((String)"https://docs.claude.com/s/claude-code-jetbrains");
    }
}

