// This file is @generated by prost-build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateCacheEntryRequest {
    /// Scope and other metadata for the cache entry
    #[prost(message, optional, tag = "1")]
    pub metadata: ::core::option::Option<CacheMetadata>,
    /// An explicit key for a cache entry
    #[prost(string, tag = "2")]
    pub key: ::prost::alloc::string::String,
    /// Hash of the compression tool, runner OS and paths cached
    #[prost(string, tag = "3")]
    pub version: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateCacheEntryResponse {
    #[prost(bool, tag = "1")]
    pub ok: bool,
    /// SAS URL to upload the cache archive
    #[prost(string, tag = "2")]
    pub signed_upload_url: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FinalizeCacheEntryUploadRequest {
    /// Scope and other metadata for the cache entry
    #[prost(message, optional, tag = "1")]
    pub metadata: ::core::option::Option<CacheMetadata>,
    /// An explicit key for a cache entry
    #[prost(string, tag = "2")]
    pub key: ::prost::alloc::string::String,
    /// Size of the cache archive in Bytes
    #[prost(int64, tag = "3")]
    pub size_bytes: i64,
    /// Hash of the compression tool, runner OS and paths cached
    #[prost(string, tag = "4")]
    pub version: ::prost::alloc::string::String,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct FinalizeCacheEntryUploadResponse {
    #[prost(bool, tag = "1")]
    pub ok: bool,
    /// Cache entry database ID
    #[prost(int64, tag = "2")]
    pub entry_id: i64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetCacheEntryDownloadUrlRequest {
    /// Scope and other metadata for the cache entry
    #[prost(message, optional, tag = "1")]
    pub metadata: ::core::option::Option<CacheMetadata>,
    /// An explicit key for a cache entry
    #[prost(string, tag = "2")]
    pub key: ::prost::alloc::string::String,
    /// Restore keys used for prefix searching
    #[prost(string, repeated, tag = "3")]
    pub restore_keys: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Hash of the compression tool, runner OS and paths cached
    #[prost(string, tag = "4")]
    pub version: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetCacheEntryDownloadUrlResponse {
    #[prost(bool, tag = "1")]
    pub ok: bool,
    /// SAS URL to download the cache archive
    #[prost(string, tag = "2")]
    pub signed_download_url: ::prost::alloc::string::String,
    /// Key or restore key that matches the lookup
    #[prost(string, tag = "3")]
    pub matched_key: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CacheMetadata {
    /// Backend repository id
    #[prost(int64, tag = "1")]
    pub repository_id: i64,
    /// Scopes for the cache entry
    #[prost(message, repeated, tag = "2")]
    pub scope: ::prost::alloc::vec::Vec<CacheScope>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CacheScope {
    /// Determines the scope of the cache entry
    #[prost(string, tag = "1")]
    pub scope: ::prost::alloc::string::String,
    /// None: 0 | Read: 1 | Write: 2 | All: (1|2)
    #[prost(int64, tag = "2")]
    pub permission: i64,
}
