// Code generated by smithy-go-codegen DO NOT EDIT.

package lightsail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lightsail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a snapshot of a block storage disk. You can use snapshots for backups,
// to make copies of disks, and to save data before shutting down a Lightsail
// instance.
//
// You can take a snapshot of an attached disk that is in use; however, snapshots
// only capture data that has been written to your disk at the time the snapshot
// command is issued. This may exclude any data that has been cached by any
// applications or the operating system. If you can pause any file systems on the
// disk long enough to take a snapshot, your snapshot should be complete.
// Nevertheless, if you cannot pause all file writes to the disk, you should
// unmount the disk from within the Lightsail instance, issue the create disk
// snapshot command, and then remount the disk to ensure a consistent and complete
// snapshot. You may remount and use your disk while the snapshot status is
// pending.
//
// You can also use this operation to create a snapshot of an instance's system
// volume. You might want to do this, for example, to recover data from the system
// volume of a botched instance or to create a backup of the system volume like you
// would for a block storage disk. To create a snapshot of a system volume, just
// define the instance name parameter when issuing the snapshot command, and a
// snapshot of the defined instance's system volume will be created. After the
// snapshot is available, you can create a block storage disk from the snapshot and
// attach it to a running instance to access the data on the disk.
//
// The create disk snapshot operation supports tag-based access control via
// request tags. For more information, see the [Amazon Lightsail Developer Guide].
//
// [Amazon Lightsail Developer Guide]: https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-controlling-access-using-tags
func (c *Client) CreateDiskSnapshot(ctx context.Context, params *CreateDiskSnapshotInput, optFns ...func(*Options)) (*CreateDiskSnapshotOutput, error) {
	if params == nil {
		params = &CreateDiskSnapshotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDiskSnapshot", params, optFns, c.addOperationCreateDiskSnapshotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDiskSnapshotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDiskSnapshotInput struct {

	// The name of the destination disk snapshot ( my-disk-snapshot ) based on the
	// source disk.
	//
	// This member is required.
	DiskSnapshotName *string

	// The unique name of the source disk ( Disk-Virginia-1 ).
	//
	// This parameter cannot be defined together with the instance name parameter. The
	// disk name and instance name parameters are mutually exclusive.
	DiskName *string

	// The unique name of the source instance ( Amazon_Linux-512MB-Virginia-1 ). When
	// this is defined, a snapshot of the instance's system volume is created.
	//
	// This parameter cannot be defined together with the disk name parameter. The
	// instance name and disk name parameters are mutually exclusive.
	InstanceName *string

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateDiskSnapshotOutput struct {

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected by the
	// request.
	Operations []types.Operation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDiskSnapshotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateDiskSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateDiskSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDiskSnapshot"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDiskSnapshotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDiskSnapshot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDiskSnapshot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDiskSnapshot",
	}
}
