/*
Intelligent DNS API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package idns

import (
	"encoding/json"
)

// checks if the Zone type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Zone{}

// Zone struct for Zone
type Zone struct {
	// Hosted zone id
	Id *int32 `json:"id,omitempty"`
	// Hosted zone name
	Name *string `json:"name,omitempty"`
	// Hosted zone domain
	Domain *string `json:"domain,omitempty"`
	// If hosted zone is active
	IsActive *bool `json:"is_active,omitempty"`
	Retry NullableInt32 `json:"retry,omitempty"`
	NxTtl NullableInt32 `json:"nx_ttl,omitempty"`
	SoaTtl NullableInt32 `json:"soa_ttl,omitempty"`
	Refresh NullableInt32 `json:"refresh,omitempty"`
	Expiry NullableInt32 `json:"expiry,omitempty"`
	// List of nameservers
	Nameservers []string `json:"nameservers,omitempty"`
}

// NewZone instantiates a new Zone object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewZone() *Zone {
	this := Zone{}
	return &this
}

// NewZoneWithDefaults instantiates a new Zone object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewZoneWithDefaults() *Zone {
	this := Zone{}
	return &this
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *Zone) GetId() int32 {
	if o == nil || IsNil(o.Id) {
		var ret int32
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Zone) GetIdOk() (*int32, bool) {
	if o == nil || IsNil(o.Id) {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *Zone) HasId() bool {
	if o != nil && !IsNil(o.Id) {
		return true
	}

	return false
}

// SetId gets a reference to the given int32 and assigns it to the Id field.
func (o *Zone) SetId(v int32) {
	o.Id = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *Zone) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Zone) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *Zone) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *Zone) SetName(v string) {
	o.Name = &v
}

// GetDomain returns the Domain field value if set, zero value otherwise.
func (o *Zone) GetDomain() string {
	if o == nil || IsNil(o.Domain) {
		var ret string
		return ret
	}
	return *o.Domain
}

// GetDomainOk returns a tuple with the Domain field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Zone) GetDomainOk() (*string, bool) {
	if o == nil || IsNil(o.Domain) {
		return nil, false
	}
	return o.Domain, true
}

// HasDomain returns a boolean if a field has been set.
func (o *Zone) HasDomain() bool {
	if o != nil && !IsNil(o.Domain) {
		return true
	}

	return false
}

// SetDomain gets a reference to the given string and assigns it to the Domain field.
func (o *Zone) SetDomain(v string) {
	o.Domain = &v
}

// GetIsActive returns the IsActive field value if set, zero value otherwise.
func (o *Zone) GetIsActive() bool {
	if o == nil || IsNil(o.IsActive) {
		var ret bool
		return ret
	}
	return *o.IsActive
}

// GetIsActiveOk returns a tuple with the IsActive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Zone) GetIsActiveOk() (*bool, bool) {
	if o == nil || IsNil(o.IsActive) {
		return nil, false
	}
	return o.IsActive, true
}

// HasIsActive returns a boolean if a field has been set.
func (o *Zone) HasIsActive() bool {
	if o != nil && !IsNil(o.IsActive) {
		return true
	}

	return false
}

// SetIsActive gets a reference to the given bool and assigns it to the IsActive field.
func (o *Zone) SetIsActive(v bool) {
	o.IsActive = &v
}

// GetRetry returns the Retry field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Zone) GetRetry() int32 {
	if o == nil || IsNil(o.Retry.Get()) {
		var ret int32
		return ret
	}
	return *o.Retry.Get()
}

// GetRetryOk returns a tuple with the Retry field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Zone) GetRetryOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Retry.Get(), o.Retry.IsSet()
}

// HasRetry returns a boolean if a field has been set.
func (o *Zone) HasRetry() bool {
	if o != nil && o.Retry.IsSet() {
		return true
	}

	return false
}

// SetRetry gets a reference to the given NullableInt32 and assigns it to the Retry field.
func (o *Zone) SetRetry(v int32) {
	o.Retry.Set(&v)
}
// SetRetryNil sets the value for Retry to be an explicit nil
func (o *Zone) SetRetryNil() {
	o.Retry.Set(nil)
}

// UnsetRetry ensures that no value is present for Retry, not even an explicit nil
func (o *Zone) UnsetRetry() {
	o.Retry.Unset()
}

// GetNxTtl returns the NxTtl field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Zone) GetNxTtl() int32 {
	if o == nil || IsNil(o.NxTtl.Get()) {
		var ret int32
		return ret
	}
	return *o.NxTtl.Get()
}

// GetNxTtlOk returns a tuple with the NxTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Zone) GetNxTtlOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.NxTtl.Get(), o.NxTtl.IsSet()
}

// HasNxTtl returns a boolean if a field has been set.
func (o *Zone) HasNxTtl() bool {
	if o != nil && o.NxTtl.IsSet() {
		return true
	}

	return false
}

// SetNxTtl gets a reference to the given NullableInt32 and assigns it to the NxTtl field.
func (o *Zone) SetNxTtl(v int32) {
	o.NxTtl.Set(&v)
}
// SetNxTtlNil sets the value for NxTtl to be an explicit nil
func (o *Zone) SetNxTtlNil() {
	o.NxTtl.Set(nil)
}

// UnsetNxTtl ensures that no value is present for NxTtl, not even an explicit nil
func (o *Zone) UnsetNxTtl() {
	o.NxTtl.Unset()
}

// GetSoaTtl returns the SoaTtl field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Zone) GetSoaTtl() int32 {
	if o == nil || IsNil(o.SoaTtl.Get()) {
		var ret int32
		return ret
	}
	return *o.SoaTtl.Get()
}

// GetSoaTtlOk returns a tuple with the SoaTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Zone) GetSoaTtlOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.SoaTtl.Get(), o.SoaTtl.IsSet()
}

// HasSoaTtl returns a boolean if a field has been set.
func (o *Zone) HasSoaTtl() bool {
	if o != nil && o.SoaTtl.IsSet() {
		return true
	}

	return false
}

// SetSoaTtl gets a reference to the given NullableInt32 and assigns it to the SoaTtl field.
func (o *Zone) SetSoaTtl(v int32) {
	o.SoaTtl.Set(&v)
}
// SetSoaTtlNil sets the value for SoaTtl to be an explicit nil
func (o *Zone) SetSoaTtlNil() {
	o.SoaTtl.Set(nil)
}

// UnsetSoaTtl ensures that no value is present for SoaTtl, not even an explicit nil
func (o *Zone) UnsetSoaTtl() {
	o.SoaTtl.Unset()
}

// GetRefresh returns the Refresh field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Zone) GetRefresh() int32 {
	if o == nil || IsNil(o.Refresh.Get()) {
		var ret int32
		return ret
	}
	return *o.Refresh.Get()
}

// GetRefreshOk returns a tuple with the Refresh field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Zone) GetRefreshOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Refresh.Get(), o.Refresh.IsSet()
}

// HasRefresh returns a boolean if a field has been set.
func (o *Zone) HasRefresh() bool {
	if o != nil && o.Refresh.IsSet() {
		return true
	}

	return false
}

// SetRefresh gets a reference to the given NullableInt32 and assigns it to the Refresh field.
func (o *Zone) SetRefresh(v int32) {
	o.Refresh.Set(&v)
}
// SetRefreshNil sets the value for Refresh to be an explicit nil
func (o *Zone) SetRefreshNil() {
	o.Refresh.Set(nil)
}

// UnsetRefresh ensures that no value is present for Refresh, not even an explicit nil
func (o *Zone) UnsetRefresh() {
	o.Refresh.Unset()
}

// GetExpiry returns the Expiry field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Zone) GetExpiry() int32 {
	if o == nil || IsNil(o.Expiry.Get()) {
		var ret int32
		return ret
	}
	return *o.Expiry.Get()
}

// GetExpiryOk returns a tuple with the Expiry field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Zone) GetExpiryOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Expiry.Get(), o.Expiry.IsSet()
}

// HasExpiry returns a boolean if a field has been set.
func (o *Zone) HasExpiry() bool {
	if o != nil && o.Expiry.IsSet() {
		return true
	}

	return false
}

// SetExpiry gets a reference to the given NullableInt32 and assigns it to the Expiry field.
func (o *Zone) SetExpiry(v int32) {
	o.Expiry.Set(&v)
}
// SetExpiryNil sets the value for Expiry to be an explicit nil
func (o *Zone) SetExpiryNil() {
	o.Expiry.Set(nil)
}

// UnsetExpiry ensures that no value is present for Expiry, not even an explicit nil
func (o *Zone) UnsetExpiry() {
	o.Expiry.Unset()
}

// GetNameservers returns the Nameservers field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Zone) GetNameservers() []string {
	if o == nil {
		var ret []string
		return ret
	}
	return o.Nameservers
}

// GetNameserversOk returns a tuple with the Nameservers field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Zone) GetNameserversOk() ([]string, bool) {
	if o == nil || IsNil(o.Nameservers) {
		return nil, false
	}
	return o.Nameservers, true
}

// HasNameservers returns a boolean if a field has been set.
func (o *Zone) HasNameservers() bool {
	if o != nil && IsNil(o.Nameservers) {
		return true
	}

	return false
}

// SetNameservers gets a reference to the given []string and assigns it to the Nameservers field.
func (o *Zone) SetNameservers(v []string) {
	o.Nameservers = v
}

func (o Zone) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Zone) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Id) {
		toSerialize["id"] = o.Id
	}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Domain) {
		toSerialize["domain"] = o.Domain
	}
	if !IsNil(o.IsActive) {
		toSerialize["is_active"] = o.IsActive
	}
	if o.Retry.IsSet() {
		toSerialize["retry"] = o.Retry.Get()
	}
	if o.NxTtl.IsSet() {
		toSerialize["nx_ttl"] = o.NxTtl.Get()
	}
	if o.SoaTtl.IsSet() {
		toSerialize["soa_ttl"] = o.SoaTtl.Get()
	}
	if o.Refresh.IsSet() {
		toSerialize["refresh"] = o.Refresh.Get()
	}
	if o.Expiry.IsSet() {
		toSerialize["expiry"] = o.Expiry.Get()
	}
	if o.Nameservers != nil {
		toSerialize["nameservers"] = o.Nameservers
	}
	return toSerialize, nil
}

type NullableZone struct {
	value *Zone
	isSet bool
}

func (v NullableZone) Get() *Zone {
	return v.value
}

func (v *NullableZone) Set(val *Zone) {
	v.value = val
	v.isSet = true
}

func (v NullableZone) IsSet() bool {
	return v.isSet
}

func (v *NullableZone) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableZone(val *Zone) *NullableZone {
	return &NullableZone{value: val, isSet: true}
}

func (v NullableZone) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableZone) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


