// Code generated by sdkgen-v2. DO NOT EDIT.
package iamsdk

import (
	"context"

	iam "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	sdkop "github.com/yandex-cloud/go-sdk/v2/pkg/operation"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/reflect/protoreflect"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// OAuthClientClient provides methods for managing OAuthClient resources of Yandex.Cloud IAM.
type OAuthClientClient interface {
	Get(context.Context, *iam.GetOAuthClientRequest, ...grpc.CallOption) (*iam.OAuthClient, error)
	List(context.Context, *iam.ListOAuthClientsRequest, ...grpc.CallOption) (*iam.ListOAuthClientsResponse, error)
	Create(context.Context, *iam.CreateOAuthClientRequest, ...grpc.CallOption) (*OAuthClientCreateOperation, error)
	Update(context.Context, *iam.UpdateOAuthClientRequest, ...grpc.CallOption) (*OAuthClientUpdateOperation, error)
	Delete(context.Context, *iam.DeleteOAuthClientRequest, ...grpc.CallOption) (*OAuthClientDeleteOperation, error)
}

var _ OAuthClientClient = oAuthClientClient{}

type oAuthClientClient struct {
	connector transport.Connector
}

// NewOAuthClientClient returns OAuthClientClient implementation.
func NewOAuthClientClient(connector transport.Connector) OAuthClientClient {
	return oAuthClientClient{connector}
}

// Get is an operation of Yandex.Cloud IAM OAuthClient service.
func (c oAuthClientClient) Get(ctx context.Context, in *iam.GetOAuthClientRequest, opts ...grpc.CallOption) (*iam.OAuthClient, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientGet, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewOAuthClientServiceClient(connection).Get(ctx, in, opts...)
}

// List is an operation of Yandex.Cloud IAM OAuthClient service.
func (c oAuthClientClient) List(ctx context.Context, in *iam.ListOAuthClientsRequest, opts ...grpc.CallOption) (*iam.ListOAuthClientsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientList, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewOAuthClientServiceClient(connection).List(ctx, in, opts...)
}

// OAuthClientCreateOperation is used to monitor the state of Create operations.
type OAuthClientCreateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *OAuthClientCreateOperation) Metadata() *iam.CreateOAuthClientMetadata {
	return o.Operation.Metadata().(*iam.CreateOAuthClientMetadata)
}

// Response retrieves the operation response.
func (o *OAuthClientCreateOperation) Response() *iam.OAuthClient {
	return o.Operation.Response().(*iam.OAuthClient)
}

// Wait polls the operation until it's done.
func (o *OAuthClientCreateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*iam.OAuthClient, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*iam.OAuthClient)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *OAuthClientCreateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*iam.OAuthClient, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*iam.OAuthClient)
	return response, err
}

// Create is an operation of Yandex.Cloud IAM OAuthClient service.
// It returns an object which should be used to monitor the operation state.
func (c oAuthClientClient) Create(ctx context.Context, in *iam.CreateOAuthClientRequest, opts ...grpc.CallOption) (*OAuthClientCreateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientCreate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewOAuthClientServiceClient(connection).Create(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*iam.CreateOAuthClientMetadata)(nil),
		ResponseType: (*iam.OAuthClient)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &OAuthClientCreateOperation{*op}, nil
}

// OAuthClientUpdateOperation is used to monitor the state of Update operations.
type OAuthClientUpdateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *OAuthClientUpdateOperation) Metadata() *iam.UpdateOAuthClientMetadata {
	return o.Operation.Metadata().(*iam.UpdateOAuthClientMetadata)
}

// Response retrieves the operation response.
func (o *OAuthClientUpdateOperation) Response() *iam.OAuthClient {
	return o.Operation.Response().(*iam.OAuthClient)
}

// Wait polls the operation until it's done.
func (o *OAuthClientUpdateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*iam.OAuthClient, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*iam.OAuthClient)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *OAuthClientUpdateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*iam.OAuthClient, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*iam.OAuthClient)
	return response, err
}

// Update is an operation of Yandex.Cloud IAM OAuthClient service.
// It returns an object which should be used to monitor the operation state.
func (c oAuthClientClient) Update(ctx context.Context, in *iam.UpdateOAuthClientRequest, opts ...grpc.CallOption) (*OAuthClientUpdateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientUpdate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewOAuthClientServiceClient(connection).Update(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*iam.UpdateOAuthClientMetadata)(nil),
		ResponseType: (*iam.OAuthClient)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &OAuthClientUpdateOperation{*op}, nil
}

// OAuthClientDeleteOperation is used to monitor the state of Delete operations.
type OAuthClientDeleteOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *OAuthClientDeleteOperation) Metadata() *iam.DeleteOAuthClientMetadata {
	return o.Operation.Metadata().(*iam.DeleteOAuthClientMetadata)
}

// Response retrieves the operation response.
func (o *OAuthClientDeleteOperation) Response() *emptypb.Empty {
	return o.Operation.Response().(*emptypb.Empty)
}

// Wait polls the operation until it's done.
func (o *OAuthClientDeleteOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *OAuthClientDeleteOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// Delete is an operation of Yandex.Cloud IAM OAuthClient service.
// It returns an object which should be used to monitor the operation state.
func (c oAuthClientClient) Delete(ctx context.Context, in *iam.DeleteOAuthClientRequest, opts ...grpc.CallOption) (*OAuthClientDeleteOperation, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientDelete, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewOAuthClientServiceClient(connection).Delete(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*iam.DeleteOAuthClientMetadata)(nil),
		ResponseType: (*emptypb.Empty)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &OAuthClientDeleteOperation{*op}, nil
}

// pollOperation returns the current state of the polled operation.
func (c oAuthClientClient) pollOperation(ctx context.Context, operationId string, opts ...grpc.CallOption) (sdkop.YCOperation, error) {
	connection, err := c.connector.GetConnection(ctx, OAuthClientOperationPoller, opts...)
	if err != nil {
		return nil, err
	}
	return operation.NewOperationServiceClient(connection).Get(ctx, &operation.GetOperationRequest{OperationId: operationId}, opts...)
}

var (
	OAuthClientGet             = protoreflect.FullName("yandex.cloud.iam.v1.OAuthClientService.Get")
	OAuthClientList            = protoreflect.FullName("yandex.cloud.iam.v1.OAuthClientService.List")
	OAuthClientCreate          = protoreflect.FullName("yandex.cloud.iam.v1.OAuthClientService.Create")
	OAuthClientUpdate          = protoreflect.FullName("yandex.cloud.iam.v1.OAuthClientService.Update")
	OAuthClientDelete          = protoreflect.FullName("yandex.cloud.iam.v1.OAuthClientService.Delete")
	OAuthClientOperationPoller = protoreflect.FullName("yandex.cloud.operation.OperationService.Get")
)
