/*
 * Copyright 2016-2017 Józef Kucia for CodeWeavers
 * Copyright 2020-2021 Philip Rebohle for Valve Corporation
 * Copyright 2020-2021 Joshua Ashton for Valve Corporation
 * Copyright 2020-2021 Hans-Kristian Arntzen for Valve Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#define VKD3D_DBG_CHANNEL VKD3D_DBG_CHANNEL_API
#include "d3d12_crosstest.h"

static void check_clip_distance(struct test_context *context,
        ID3D12PipelineState *pso, D3D12_VERTEX_BUFFER_VIEW vbv[2], ID3D12Resource *vb,
        ID3D12Resource *vs_cb, ID3D12Resource *gs_cb)
{
    static const float white[] = {1.0f, 1.0f, 1.0f, 1.0f};
    struct vertex
    {
        float clip_distance0;
        float clip_distance1;
    };

    ID3D12GraphicsCommandList *command_list = context->list;
    ID3D12CommandQueue *queue = context->queue;
    struct resource_readback rb;
    struct vertex vertices[4];
    unsigned int i;
    D3D12_BOX box;

    for (i = 0; i < ARRAY_SIZE(vertices); ++i)
        vertices[i].clip_distance0 = 1.0f;
    update_buffer_data(vb, 0, sizeof(vertices), vertices);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context->rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context->root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context->viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context->scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, 2, vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context->rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    check_sub_resource_uint(context->render_target, 0, queue, command_list, 0xff00ff00, 0);

    reset_command_list(command_list, context->allocator);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);

    for (i = 0; i < ARRAY_SIZE(vertices); ++i)
        vertices[i].clip_distance0 = 0.0f;
    update_buffer_data(vb, 0, sizeof(vertices), vertices);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context->rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context->root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context->viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context->scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, 2, vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context->rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    check_sub_resource_uint(context->render_target, 0, queue, command_list, 0xff00ff00, 0);

    reset_command_list(command_list, context->allocator);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);

    for (i = 0; i < ARRAY_SIZE(vertices); ++i)
        vertices[i].clip_distance0 = -1.0f;
    update_buffer_data(vb, 0, sizeof(vertices), vertices);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context->rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context->root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context->viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context->scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, 2, vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context->rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    check_sub_resource_uint(context->render_target, 0, queue, command_list, 0xffffffff, 0);

    reset_command_list(command_list, context->allocator);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);

    for (i = 0; i < ARRAY_SIZE(vertices); ++i)
        vertices[i].clip_distance0 = i < 2 ? 1.0f : -1.0f;
    update_buffer_data(vb, 0, sizeof(vertices), vertices);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context->rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context->root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context->viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context->scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, 2, vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context->rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    get_texture_readback_with_command_list(context->render_target, 0, &rb, queue, command_list);
    set_box(&box, 0, 0, 0, 320, 480, 1);
    check_readback_data_uint(&rb, &box, 0xff00ff00, 1);
    set_box(&box, 320, 0, 0, 320, 480, 1);
    check_readback_data_uint(&rb, &box, 0xffffffff, 1);
    release_resource_readback(&rb);

    reset_command_list(command_list, context->allocator);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);

    for (i = 0; i < ARRAY_SIZE(vertices); ++i)
        vertices[i].clip_distance0 = i % 2 ? 1.0f : -1.0f;
    update_buffer_data(vb, 0, sizeof(vertices), vertices);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context->rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context->root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context->viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context->scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, 2, vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context->rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    get_texture_readback_with_command_list(context->render_target, 0, &rb, queue, command_list);
    set_box(&box, 0, 0, 0, 640, 240, 1);
    check_readback_data_uint(&rb, &box, 0xff00ff00, 0);
    set_box(&box, 0, 240, 0, 640, 240, 1);
    check_readback_data_uint(&rb, &box, 0xffffffff, 0);
    release_resource_readback(&rb);

    reset_command_list(command_list, context->allocator);
    transition_resource_state(command_list, context->render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);
}

static void test_clip_distance(bool use_dxil)
{
    D3D12_ROOT_SIGNATURE_DESC root_signature_desc;
    D3D12_GRAPHICS_PIPELINE_STATE_DESC pso_desc;
    D3D12_ROOT_PARAMETER root_parameters[3];
    ID3D12GraphicsCommandList *command_list;
    ID3D12Resource *vs_cb, *gs_cb, *vb[2];
    D3D12_INPUT_LAYOUT_DESC input_layout;
    D3D12_VERTEX_BUFFER_VIEW vbv[2];
    struct test_context_desc desc;
    struct resource_readback rb;
    struct test_context context;
    ID3D12CommandQueue *queue;
    ID3D12PipelineState *pso;
    ID3D12Device *device;
    unsigned int i;
    D3D12_BOX box;
    HRESULT hr;

#if 0
    bool use_constant;
    float clip_distance;

    struct input
    {
        float4 position : POSITION;
        float distance0 : CLIP_DISTANCE0;
        float distance1 : CLIP_DISTANCE1;
    };

    struct vertex
    {
        float4 position : SV_POSITION;
        float user_clip : CLIP_DISTANCE;
        float clip : SV_ClipDistance;
    };

    void main(input vin, out vertex vertex)
    {
        vertex.position = vin.position;
        vertex.user_clip = vin.distance0;
        vertex.clip = vin.distance0;
        if (use_constant)
            vertex.clip = clip_distance;
    }
#endif
    static const DWORD vs_code_dxbc[] =
    {
        0x43425844, 0x09dfef58, 0x88570f2e, 0x1ebcf953, 0x9f97e22a, 0x00000001, 0x000001dc, 0x00000003,
        0x0000002c, 0x0000009c, 0x00000120, 0x4e475349, 0x00000068, 0x00000003, 0x00000008, 0x00000050,
        0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000f0f, 0x00000059, 0x00000000, 0x00000000,
        0x00000003, 0x00000001, 0x00000101, 0x00000059, 0x00000001, 0x00000000, 0x00000003, 0x00000002,
        0x00000001, 0x49534f50, 0x4e4f4954, 0x494c4300, 0x49445f50, 0x4e415453, 0xab004543, 0x4e47534f,
        0x0000007c, 0x00000003, 0x00000008, 0x00000050, 0x00000000, 0x00000001, 0x00000003, 0x00000000,
        0x0000000f, 0x0000005c, 0x00000000, 0x00000000, 0x00000003, 0x00000001, 0x00000e01, 0x0000006a,
        0x00000000, 0x00000002, 0x00000003, 0x00000002, 0x00000e01, 0x505f5653, 0x5449534f, 0x004e4f49,
        0x50494c43, 0x5349445f, 0x434e4154, 0x56530045, 0x696c435f, 0x73694470, 0x636e6174, 0xabab0065,
        0x52444853, 0x000000b4, 0x00010040, 0x0000002d, 0x04000059, 0x00208e46, 0x00000000, 0x00000001,
        0x0300005f, 0x001010f2, 0x00000000, 0x0300005f, 0x00101012, 0x00000001, 0x04000067, 0x001020f2,
        0x00000000, 0x00000001, 0x03000065, 0x00102012, 0x00000001, 0x04000067, 0x00102012, 0x00000002,
        0x00000002, 0x05000036, 0x001020f2, 0x00000000, 0x00101e46, 0x00000000, 0x05000036, 0x00102012,
        0x00000001, 0x0010100a, 0x00000001, 0x0b000037, 0x00102012, 0x00000002, 0x0020800a, 0x00000000,
        0x00000000, 0x0020801a, 0x00000000, 0x00000000, 0x0010100a, 0x00000001, 0x0100003e,
    };
    static const BYTE vs_code_dxil[] =
    {
        0x44, 0x58, 0x42, 0x43, 0x25, 0x82, 0x13, 0xc7, 0x3e, 0x10, 0x6a, 0x84, 0x4d, 0x5e, 0x84, 0xcf, 0x55, 0x24, 0xe8, 0xca, 0x01, 0x00, 0x00, 0x00, 0x4b, 0x09, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
        0x34, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0xd9, 0x00, 0x00, 0x00, 0x73, 0x01, 0x00, 0x00, 0x93, 0x02, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0x8d, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4c, 0x49,
        0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x4f, 0x53, 0x47, 0x31, 0x92, 0x00, 0x00,
        0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
        0x00, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
        0x00, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e,
        0x43, 0x45, 0x00, 0x53, 0x56, 0x5f, 0x43, 0x6c, 0x69, 0x70, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x00, 0x50, 0x53, 0x56, 0x30, 0x18, 0x01, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03,
        0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x00,
        0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54,
        0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x44, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x41, 0x00, 0x03,
        0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02, 0x41, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x44, 0x03, 0x03,
        0x04, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x41, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x41, 0x06, 0x03,
        0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0xb0, 0x06, 0x00, 0x00, 0x60, 0x00, 0x01, 0x00, 0xac,
        0x01, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0x00, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x98, 0x06, 0x00, 0x00, 0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00, 0xa3, 0x01, 0x00, 0x00, 0x0b,
        0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49, 0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19, 0x1e,
        0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42, 0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x52, 0x88, 0x48, 0x90, 0x14, 0x20, 0x43, 0x46, 0x88, 0xa5, 0x00,
        0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90, 0x91, 0x22, 0xc4, 0x50, 0x41, 0x51, 0x81, 0x8c, 0xe1, 0x83, 0xe5, 0x8a, 0x04, 0x29, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1b,
        0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x40, 0x02, 0xa8, 0x0d, 0x84, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20, 0x6d, 0x30, 0x86, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x09, 0xa8, 0x00, 0x49,
        0x18, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x13, 0x82, 0x60, 0x42, 0x20, 0x4c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09, 0x20,
        0x64, 0x85, 0x04, 0x93, 0x22, 0xa4, 0x84, 0x04, 0x93, 0x22, 0xe3, 0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x8a, 0x8c, 0x0b, 0x84, 0xa4, 0x4c, 0x10, 0x68, 0x23, 0x00, 0x25, 0x00, 0x14, 0x66, 0x00,
        0xe6, 0x08, 0xc0, 0x60, 0x8e, 0x00, 0x29, 0xc6, 0x20, 0x84, 0x14, 0x42, 0xa6, 0x18, 0x80, 0x10, 0x52, 0x06, 0xa1, 0xa3, 0x86, 0xcb, 0x9f, 0xb0, 0x87, 0x90, 0x7c, 0x6e, 0xa3, 0x8a, 0x95, 0x98,
        0xfc, 0xe2, 0xb6, 0x11, 0x31, 0xc6, 0x18, 0x54, 0xee, 0x19, 0x2e, 0x7f, 0xc2, 0x1e, 0x42, 0xf2, 0x43, 0xa0, 0x19, 0x16, 0x02, 0x05, 0xab, 0x10, 0x8a, 0x30, 0x42, 0xed, 0xa8, 0xe1, 0xf2, 0x27,
        0xec, 0x21, 0x24, 0x9f, 0xdb, 0xa8, 0x62, 0x25, 0x26, 0x1f, 0xb9, 0x6d, 0x44, 0x10, 0x42, 0x48, 0x21, 0x1e, 0x61, 0x84, 0xe0, 0x1c, 0x41, 0x50, 0x0c, 0x46, 0x0a, 0x21, 0x92, 0xe6, 0x40, 0xc0,
        0x4c, 0x08, 0x19, 0x9c, 0x02, 0x3b, 0xbc, 0x83, 0x38, 0x84, 0x03, 0x3b, 0xcc, 0x03, 0x12, 0xc8, 0x20, 0x9b, 0x0b, 0x64, 0x0a, 0x00, 0x00, 0x13, 0x14, 0x72, 0xc0, 0x87, 0x74, 0x60, 0x87, 0x36,
        0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0, 0x87, 0x0d, 0xaf, 0x50, 0x0e, 0x6d, 0xd0, 0x0e, 0x7a, 0x50, 0x0e, 0x6d, 0x00, 0x0f, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90,
        0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x78, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe9, 0x30, 0x07, 0x72,
        0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x76, 0x40, 0x07, 0x7a, 0x60, 0x07, 0x74, 0xd0, 0x06, 0xe6, 0x10, 0x07, 0x76, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x60, 0x0e, 0x73, 0x20, 0x07,
        0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe6, 0x60, 0x07, 0x74, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x6d, 0xe0, 0x0e, 0x78, 0xa0, 0x07, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x76, 0x40,
        0x07, 0x43, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x3c, 0x06, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x79, 0x10, 0x20, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf2, 0x34, 0x40, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xe4, 0x81, 0x80, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x60, 0xc8, 0x33, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x16, 0x08, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c,
        0x09, 0x26, 0x47, 0xc6, 0x04, 0x43, 0x22, 0x25, 0x30, 0x02, 0x50, 0x08, 0xc5, 0x50, 0x10, 0x45, 0x40, 0xa5, 0x24, 0x46, 0x00, 0x0a, 0xa1, 0x04, 0xca, 0xa0, 0x08, 0x8a, 0x81, 0xee, 0x0c, 0x00,
        0xe1, 0xb1, 0x96, 0x24, 0x09, 0x04, 0x02, 0x81, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0xc4, 0x88,
        0x0c, 0x6f, 0xec, 0xed, 0x4d, 0x0c, 0x44, 0x06, 0x26, 0x26, 0xc7, 0x05, 0xa6, 0xc6, 0x05, 0x06, 0x66, 0x43, 0x10, 0x4c, 0x10, 0x08, 0x63, 0x82, 0x40, 0x1c, 0x1b, 0x84, 0x81, 0x98, 0x20, 0x10,
        0xc8, 0x06, 0x61, 0x30, 0x28, 0xd8, 0xcd, 0x4d, 0x10, 0x88, 0x64, 0xc3, 0x80, 0x24, 0xc4, 0x04, 0xe1, 0x9a, 0x08, 0x4c, 0x10, 0x08, 0x65, 0x03, 0x42, 0x2c, 0x0c, 0x41, 0x0c, 0x0d, 0xb0, 0x21,
        0x70, 0x36, 0x10, 0x00, 0xf0, 0x00, 0x13, 0x04, 0x01, 0xd8, 0x00, 0x6c, 0x18, 0x08, 0x49, 0xda, 0x10, 0x4c, 0x1b, 0x86, 0x21, 0xa2, 0x26, 0x08, 0x18, 0xb5, 0x21, 0xb0, 0x48, 0xb4, 0x85, 0xa5,
        0xb9, 0x11, 0x81, 0x7a, 0x9a, 0x4a, 0xa2, 0x4a, 0x7a, 0x72, 0x9a, 0x20, 0x14, 0xcc, 0x04, 0xa1, 0x68, 0x36, 0x04, 0xc4, 0x04, 0xa1, 0x70, 0x36, 0x2c, 0x44, 0xa6, 0x6d, 0xdc, 0x36, 0x74, 0xc4,
        0x06, 0xb0, 0x19, 0x62, 0x4a, 0x82, 0xfa, 0x22, 0x4a, 0x9a, 0xa2, 0x0a, 0x72, 0x1a, 0x2a, 0x9a, 0x20, 0x14, 0xcf, 0x86, 0x65, 0xf8, 0xb4, 0x8d, 0xdb, 0x06, 0x30, 0x18, 0x36, 0x60, 0x82, 0x40,
        0x2c, 0x1b, 0x82, 0x61, 0xc3, 0x22, 0x06, 0x9f, 0xb6, 0x8d, 0xc1, 0x36, 0x80, 0x81, 0x18, 0x6c, 0xc0, 0x86, 0xc1, 0x0b, 0x03, 0x32, 0xe0, 0x32, 0x65, 0xf5, 0x05, 0xf5, 0x36, 0x97, 0x46, 0x97,
        0xf6, 0xe6, 0x36, 0x41, 0x28, 0xa0, 0x0d, 0x0b, 0x61, 0x06, 0xda, 0x19, 0x70, 0xdd, 0xd0, 0x11, 0x1b, 0x30, 0x41, 0x28, 0xa2, 0x0d, 0xcb, 0xf0, 0x69, 0x1b, 0x97, 0x06, 0x03, 0x18, 0x0c, 0x1b,
        0xc0, 0x67, 0xca, 0xea, 0x6b, 0x88, 0x2d, 0x0d, 0x8e, 0x28, 0x6d, 0x8e, 0x2e, 0xcc, 0x6d, 0xac, 0x6c, 0x82, 0x50, 0x48, 0x1b, 0x16, 0x31, 0x58, 0x03, 0x8d, 0x0d, 0xb8, 0x34, 0x18, 0xc0, 0x40,
        0x0c, 0x36, 0x60, 0xc3, 0x80, 0x06, 0x6a, 0xd0, 0x06, 0x1b, 0x86, 0x32, 0x70, 0x03, 0x60, 0x43, 0x11, 0x61, 0x6f, 0x00, 0x01, 0x55, 0xd8, 0xd8, 0xec, 0xda, 0x5c, 0xd2, 0xc8, 0xca, 0xdc, 0xe8,
        0xa6, 0x04, 0x41, 0x15, 0x32, 0x3c, 0x17, 0xbb, 0x32, 0xb9, 0xb9, 0xb4, 0x37, 0xb7, 0x29, 0x01, 0xd1, 0x84, 0x0c, 0xcf, 0xc5, 0x2e, 0x8c, 0xcd, 0xae, 0x4c, 0x6e, 0x4a, 0x60, 0xd4, 0x21, 0xc3,
        0x73, 0x99, 0x43, 0x0b, 0x23, 0x2b, 0x93, 0x6b, 0x7a, 0x23, 0x2b, 0x63, 0x9b, 0x12, 0x24, 0x65, 0xc8, 0xf0, 0x5c, 0xe4, 0xca, 0xe6, 0xde, 0xea, 0xe4, 0xc6, 0xca, 0xe6, 0xa6, 0x04, 0x4f, 0x25,
        0x32, 0x3c, 0x17, 0xba, 0x3c, 0xb8, 0xb2, 0x20, 0x37, 0xb7, 0x37, 0xba, 0x30, 0xba, 0xb4, 0x37, 0xb7, 0xb9, 0x29, 0x01, 0x55, 0x87, 0x0c, 0xcf, 0xc5, 0x2e, 0xad, 0xec, 0x2e, 0x89, 0x6c, 0x8a,
        0x2e, 0x8c, 0xae, 0x6c, 0x4a, 0x60, 0xd5, 0x21, 0xc3, 0x73, 0x29, 0x73, 0xa3, 0x93, 0xcb, 0x83, 0x7a, 0x4b, 0x73, 0xa3, 0x9b, 0x9b, 0x12, 0xbc, 0x01, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x4c,
        0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c, 0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3, 0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6, 0x00,
        0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30, 0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8, 0x43,
        0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c, 0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07, 0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11, 0x0e,
        0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e, 0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d, 0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89, 0x3b,
        0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37, 0x80,
        0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07, 0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87, 0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81, 0x2c,
        0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5, 0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c, 0xc4,
        0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8, 0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc, 0x83,
        0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b, 0xb0, 0xc3, 0x8c, 0xcc, 0x21, 0x07, 0x7c, 0x70, 0x03, 0x74, 0x60, 0x07, 0x37, 0x90, 0x87, 0x72, 0x98, 0x87, 0x77, 0xa8, 0x07, 0x79, 0x18, 0x87, 0x72,
        0x70, 0x83, 0x70, 0xa0, 0x07, 0x7a, 0x90, 0x87, 0x74, 0x10, 0x87, 0x7a, 0xa0, 0x87, 0x72, 0x00, 0x00, 0x00, 0x00, 0x71, 0x20, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x36, 0xb0, 0x0d, 0x97, 0xef,
        0x3c, 0xbe, 0x10, 0x50, 0x45, 0x41, 0x44, 0xa5, 0x03, 0x0c, 0x25, 0x61, 0x00, 0x02, 0xe6, 0x17, 0xb7, 0x6d, 0x04, 0xdb, 0x70, 0xf9, 0xce, 0xe3, 0x0b, 0x01, 0x55, 0x14, 0x44, 0x54, 0x3a, 0xc0,
        0x50, 0x12, 0x06, 0x20, 0x60, 0x3e, 0x72, 0xdb, 0x56, 0x20, 0x0d, 0x97, 0xef, 0x3c, 0xbe, 0x10, 0x11, 0xc0, 0x44, 0x84, 0x40, 0x33, 0x2c, 0x84, 0x05, 0x4c, 0xc3, 0xe5, 0x3b, 0x8f, 0xbf, 0x38,
        0xc0, 0x20, 0x36, 0x0f, 0x35, 0xf9, 0xc5, 0x6d, 0x9b, 0x40, 0x35, 0x5c, 0xbe, 0xf3, 0xf8, 0xd2, 0xe4, 0x44, 0x04, 0x4a, 0x4d, 0x0f, 0x35, 0xf9, 0xc5, 0x6d, 0x1b, 0x00, 0xc1, 0x00, 0x48, 0x03,
        0x00, 0x00, 0x00, 0x61, 0x20, 0x00, 0x00, 0x37, 0x00, 0x00, 0x00, 0x13, 0x04, 0x43, 0x2c, 0x10, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x44, 0x4a, 0x61, 0x06, 0xa0, 0xec, 0x4a, 0x8e, 0xe4,
        0x08, 0x00, 0x00, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x30, 0x55, 0x42, 0x32, 0x4d, 0xc1, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x18, 0xda, 0x54, 0x51, 0x4e, 0x31, 0x62, 0x90, 0x00, 0x20, 0x08,
        0x06, 0xc6, 0x46, 0x55, 0xd5, 0x63, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x81, 0xc1, 0x55, 0x96, 0xe5, 0x1c, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x60, 0x74, 0xd6, 0x75, 0x35, 0xc8, 0x88, 0x41,
        0x02, 0x80, 0x20, 0x18, 0x18, 0xde, 0x85, 0x61, 0x4f, 0x32, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x88, 0xb7, 0x64, 0xd9, 0x44, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0xe2, 0x2d, 0x59, 0x16,
        0x0d, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x80, 0x78, 0x4b, 0x96, 0x3d, 0xc2, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x20, 0xde, 0x92, 0x65, 0x50, 0x30, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x88,
        0xb7, 0x68, 0xd9, 0x54, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0xe2, 0x2d, 0x55, 0x36, 0x15, 0x23, 0x06, 0x07, 0x00, 0x82, 0x60, 0x00, 0x71, 0x89, 0x91, 0x8d, 0x26, 0x04, 0xc0, 0x70, 0x43,
        0xb0, 0x81, 0xc1, 0x2c, 0x83, 0x10, 0x04, 0x23, 0x06, 0x07, 0x00, 0x82, 0x60, 0xd0, 0x80, 0x01, 0x93, 0x70, 0xa3, 0x09, 0x41, 0x30, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0xc8, 0x18, 0x40, 0x9a,
        0x87, 0x05, 0xb3, 0x04, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    };
    const D3D12_SHADER_BYTECODE vs = {
        use_dxil ? (const void*)vs_code_dxil : (const void*)vs_code_dxbc,
        use_dxil ? sizeof(vs_code_dxil) : sizeof(vs_code_dxbc)
    };
#if 0
    bool use_constant;
    float clip_distance0;
    float clip_distance1;

    struct input
    {
        float4 position : POSITION;
        float distance0 : CLIP_DISTANCE0;
        float distance1 : CLIP_DISTANCE1;
    };

    struct vertex
    {
        float4 position : SV_POSITION;
        float user_clip : CLIP_DISTANCE;
        float2 clip : SV_ClipDistance;
    };

    void main(input vin, out vertex vertex)
    {
        vertex.position = vin.position;
        vertex.user_clip = vin.distance0;
        vertex.clip.x = vin.distance0;
        if (use_constant)
            vertex.clip.x = clip_distance0;
        vertex.clip.y = vin.distance1;
        if (use_constant)
            vertex.clip.y = clip_distance1;
    }
#endif
    static const DWORD vs_multiple_code_dxbc[] =
    {
        0x43425844, 0xef5cc236, 0xe2fbfa69, 0x560b6591, 0x23037999, 0x00000001, 0x00000214, 0x00000003,
        0x0000002c, 0x0000009c, 0x00000120, 0x4e475349, 0x00000068, 0x00000003, 0x00000008, 0x00000050,
        0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000f0f, 0x00000059, 0x00000000, 0x00000000,
        0x00000003, 0x00000001, 0x00000101, 0x00000059, 0x00000001, 0x00000000, 0x00000003, 0x00000002,
        0x00000101, 0x49534f50, 0x4e4f4954, 0x494c4300, 0x49445f50, 0x4e415453, 0xab004543, 0x4e47534f,
        0x0000007c, 0x00000003, 0x00000008, 0x00000050, 0x00000000, 0x00000001, 0x00000003, 0x00000000,
        0x0000000f, 0x0000005c, 0x00000000, 0x00000000, 0x00000003, 0x00000001, 0x00000e01, 0x0000006a,
        0x00000000, 0x00000002, 0x00000003, 0x00000002, 0x00000c03, 0x505f5653, 0x5449534f, 0x004e4f49,
        0x50494c43, 0x5349445f, 0x434e4154, 0x56530045, 0x696c435f, 0x73694470, 0x636e6174, 0xabab0065,
        0x52444853, 0x000000ec, 0x00010040, 0x0000003b, 0x04000059, 0x00208e46, 0x00000000, 0x00000001,
        0x0300005f, 0x001010f2, 0x00000000, 0x0300005f, 0x00101012, 0x00000001, 0x0300005f, 0x00101012,
        0x00000002, 0x04000067, 0x001020f2, 0x00000000, 0x00000001, 0x03000065, 0x00102012, 0x00000001,
        0x04000067, 0x00102032, 0x00000002, 0x00000002, 0x05000036, 0x001020f2, 0x00000000, 0x00101e46,
        0x00000000, 0x05000036, 0x00102012, 0x00000001, 0x0010100a, 0x00000001, 0x0b000037, 0x00102012,
        0x00000002, 0x0020800a, 0x00000000, 0x00000000, 0x0020801a, 0x00000000, 0x00000000, 0x0010100a,
        0x00000001, 0x0b000037, 0x00102022, 0x00000002, 0x0020800a, 0x00000000, 0x00000000, 0x0020802a,
        0x00000000, 0x00000000, 0x0010100a, 0x00000002, 0x0100003e,
    };
    static const BYTE vs_multiple_code_dxil[] =
    {
        0x44, 0x58, 0x42, 0x43, 0x1b, 0x08, 0x36, 0x59, 0x4c, 0xe7, 0xe1, 0x80, 0x86, 0x51, 0x84, 0xf3, 0xb9, 0x20, 0xa9, 0x38, 0x01, 0x00, 0x00, 0x00, 0x7b, 0x09, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
        0x34, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0xd9, 0x00, 0x00, 0x00, 0x73, 0x01, 0x00, 0x00, 0x93, 0x02, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0x8d, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4c, 0x49,
        0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x4f, 0x53, 0x47, 0x31, 0x92, 0x00, 0x00,
        0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
        0x00, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
        0x00, 0x03, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e,
        0x43, 0x45, 0x00, 0x53, 0x56, 0x5f, 0x43, 0x6c, 0x69, 0x70, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x00, 0x50, 0x53, 0x56, 0x30, 0x18, 0x01, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03,
        0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x00,
        0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54,
        0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
        0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x44, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x41, 0x00, 0x03,
        0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02, 0x41, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x44, 0x03, 0x03,
        0x04, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x41, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x42, 0x06, 0x03,
        0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0xe0, 0x06, 0x00, 0x00, 0x60, 0x00, 0x01, 0x00, 0xb8,
        0x01, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0x00, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0xc8, 0x06, 0x00, 0x00, 0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00, 0xaf, 0x01, 0x00, 0x00, 0x0b,
        0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49, 0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19, 0x1e,
        0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42, 0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x52, 0x88, 0x48, 0x90, 0x14, 0x20, 0x43, 0x46, 0x88, 0xa5, 0x00,
        0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90, 0x91, 0x22, 0xc4, 0x50, 0x41, 0x51, 0x81, 0x8c, 0xe1, 0x83, 0xe5, 0x8a, 0x04, 0x29, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1b,
        0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x40, 0x02, 0xa8, 0x0d, 0x84, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20, 0x6d, 0x30, 0x86, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x09, 0xa8, 0x00, 0x49,
        0x18, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x13, 0x82, 0x60, 0x42, 0x20, 0x4c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09, 0x20,
        0x64, 0x85, 0x04, 0x93, 0x22, 0xa4, 0x84, 0x04, 0x93, 0x22, 0xe3, 0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x8a, 0x8c, 0x0b, 0x84, 0xa4, 0x4c, 0x10, 0x68, 0x23, 0x00, 0x25, 0x00, 0x14, 0x66, 0x00,
        0xe6, 0x08, 0xc0, 0x60, 0x8e, 0x00, 0x29, 0xc6, 0x20, 0x84, 0x14, 0x42, 0xa6, 0x18, 0x80, 0x10, 0x52, 0x06, 0xa1, 0xa3, 0x86, 0xcb, 0x9f, 0xb0, 0x87, 0x90, 0x7c, 0x6e, 0xa3, 0x8a, 0x95, 0x98,
        0xfc, 0xe2, 0xb6, 0x11, 0x31, 0xc6, 0x18, 0x54, 0xee, 0x19, 0x2e, 0x7f, 0xc2, 0x1e, 0x42, 0xf2, 0x43, 0xa0, 0x19, 0x16, 0x02, 0x05, 0xab, 0x10, 0x8a, 0x30, 0x42, 0xed, 0xa8, 0xe1, 0xf2, 0x27,
        0xec, 0x21, 0x24, 0x9f, 0xdb, 0xa8, 0x62, 0x25, 0x26, 0x1f, 0xb9, 0x6d, 0x44, 0x10, 0x42, 0x48, 0x21, 0x1e, 0x61, 0x84, 0xe0, 0x1c, 0x41, 0x50, 0x0c, 0x46, 0x0a, 0x21, 0x92, 0xe6, 0x40, 0xc0,
        0x4c, 0x08, 0x19, 0x9c, 0x02, 0x3b, 0xbc, 0x83, 0x38, 0x84, 0x03, 0x3b, 0xcc, 0x03, 0x1a, 0xc8, 0x18, 0x64, 0x73, 0x81, 0x4c, 0x01, 0x00, 0x13, 0x14, 0x72, 0xc0, 0x87, 0x74, 0x60, 0x87, 0x36,
        0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0, 0x87, 0x0d, 0xaf, 0x50, 0x0e, 0x6d, 0xd0, 0x0e, 0x7a, 0x50, 0x0e, 0x6d, 0x00, 0x0f, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90,
        0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x78, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe9, 0x30, 0x07, 0x72,
        0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x76, 0x40, 0x07, 0x7a, 0x60, 0x07, 0x74, 0xd0, 0x06, 0xe6, 0x10, 0x07, 0x76, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x60, 0x0e, 0x73, 0x20, 0x07,
        0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe6, 0x60, 0x07, 0x74, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x6d, 0xe0, 0x0e, 0x78, 0xa0, 0x07, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x76, 0x40,
        0x07, 0x43, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x3c, 0x06, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x79, 0x10, 0x20, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf2, 0x34, 0x40, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xe4, 0x81, 0x80, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x60, 0xc8, 0x33, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x16, 0x08, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c,
        0x09, 0x26, 0x47, 0xc6, 0x04, 0x43, 0x22, 0x25, 0x30, 0x02, 0x50, 0x08, 0xc5, 0x50, 0x18, 0x45, 0x40, 0xa5, 0x24, 0x46, 0x00, 0x0a, 0xa1, 0x04, 0xca, 0xa0, 0x08, 0x8a, 0x81, 0xee, 0x0c, 0x00,
        0xe1, 0xb1, 0x96, 0x44, 0x09, 0x04, 0x02, 0x81, 0x11, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0xc4, 0x88,
        0x0c, 0x6f, 0xec, 0xed, 0x4d, 0x0c, 0x44, 0x06, 0x26, 0x26, 0xc7, 0x05, 0xa6, 0xc6, 0x05, 0x06, 0x66, 0x43, 0x10, 0x4c, 0x10, 0x08, 0x63, 0x82, 0x40, 0x1c, 0x1b, 0x84, 0x81, 0x98, 0x20, 0x10,
        0xc8, 0x06, 0x61, 0x30, 0x28, 0xd8, 0xcd, 0x4d, 0x10, 0x88, 0x64, 0xc3, 0x80, 0x24, 0xc4, 0x04, 0xe1, 0x9a, 0x08, 0x4c, 0x10, 0x08, 0x65, 0x03, 0x42, 0x2c, 0x0c, 0x41, 0x0c, 0x0d, 0xb0, 0x21,
        0x70, 0x36, 0x10, 0x00, 0xf0, 0x00, 0x13, 0x04, 0x01, 0xd8, 0x00, 0x6c, 0x18, 0x08, 0x49, 0xda, 0x10, 0x4c, 0x1b, 0x86, 0x21, 0xa2, 0x26, 0x08, 0x18, 0xb5, 0x21, 0xb0, 0x48, 0xb4, 0x85, 0xa5,
        0xb9, 0x11, 0x81, 0x7a, 0x9a, 0x4a, 0xa2, 0x4a, 0x7a, 0x72, 0x9a, 0x20, 0x14, 0xcc, 0x04, 0xa1, 0x68, 0x36, 0x04, 0xc4, 0x04, 0xa1, 0x70, 0x36, 0x2c, 0x44, 0xa6, 0x6d, 0xdc, 0x36, 0x74, 0xc4,
        0x06, 0xb0, 0x19, 0x62, 0x4a, 0x82, 0xfa, 0x22, 0x4a, 0x9a, 0xa2, 0x0a, 0x72, 0x1a, 0x2a, 0x9a, 0x20, 0x14, 0xcf, 0x86, 0x65, 0xf8, 0xb4, 0x8d, 0xdb, 0x06, 0x30, 0x18, 0x36, 0x60, 0x82, 0x40,
        0x2c, 0x1b, 0x82, 0x61, 0xc3, 0x22, 0x06, 0x9f, 0xb6, 0x8d, 0xc1, 0x36, 0x80, 0x81, 0x18, 0x6c, 0xc0, 0x86, 0xc1, 0x0b, 0x03, 0x32, 0xe0, 0x32, 0x65, 0xf5, 0x05, 0xf5, 0x36, 0x97, 0x46, 0x97,
        0xf6, 0xe6, 0x36, 0x41, 0x28, 0xa0, 0x0d, 0x0b, 0x61, 0x06, 0xda, 0x19, 0x70, 0xdd, 0xd0, 0x11, 0x1b, 0x30, 0x41, 0x28, 0xa2, 0x0d, 0xcb, 0xf0, 0x69, 0x1b, 0x97, 0x06, 0x03, 0x18, 0x0c, 0x1b,
        0xc0, 0x67, 0xca, 0xea, 0x6b, 0x88, 0x2d, 0x0d, 0x8e, 0x28, 0x6d, 0x8e, 0x2e, 0xcc, 0x6d, 0xac, 0x6c, 0x82, 0x50, 0x48, 0x1b, 0x16, 0x31, 0x58, 0x03, 0x8d, 0x0d, 0xb8, 0x34, 0x18, 0xd2, 0x40,
        0x0c, 0x36, 0x60, 0xc3, 0x80, 0x06, 0x6a, 0xd0, 0x06, 0x1b, 0x86, 0x32, 0x70, 0x03, 0x60, 0x43, 0x11, 0x61, 0x6f, 0x00, 0x01, 0x55, 0xd8, 0xd8, 0xec, 0xda, 0x5c, 0xd2, 0xc8, 0xca, 0xdc, 0xe8,
        0xa6, 0x04, 0x41, 0x15, 0x32, 0x3c, 0x17, 0xbb, 0x32, 0xb9, 0xb9, 0xb4, 0x37, 0xb7, 0x29, 0x01, 0xd1, 0x84, 0x0c, 0xcf, 0xc5, 0x2e, 0x8c, 0xcd, 0xae, 0x4c, 0x6e, 0x4a, 0x60, 0xd4, 0x21, 0xc3,
        0x73, 0x99, 0x43, 0x0b, 0x23, 0x2b, 0x93, 0x6b, 0x7a, 0x23, 0x2b, 0x63, 0x9b, 0x12, 0x24, 0x65, 0xc8, 0xf0, 0x5c, 0xe4, 0xca, 0xe6, 0xde, 0xea, 0xe4, 0xc6, 0xca, 0xe6, 0xa6, 0x04, 0x4f, 0x25,
        0x32, 0x3c, 0x17, 0xba, 0x3c, 0xb8, 0xb2, 0x20, 0x37, 0xb7, 0x37, 0xba, 0x30, 0xba, 0xb4, 0x37, 0xb7, 0xb9, 0x29, 0x01, 0x55, 0x87, 0x0c, 0xcf, 0xc5, 0x2e, 0xad, 0xec, 0x2e, 0x89, 0x6c, 0x8a,
        0x2e, 0x8c, 0xae, 0x6c, 0x4a, 0x60, 0xd5, 0x21, 0xc3, 0x73, 0x29, 0x73, 0xa3, 0x93, 0xcb, 0x83, 0x7a, 0x4b, 0x73, 0xa3, 0x9b, 0x9b, 0x12, 0xbc, 0x01, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x4c,
        0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c, 0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3, 0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6, 0x00,
        0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30, 0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8, 0x43,
        0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c, 0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07, 0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11, 0x0e,
        0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e, 0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d, 0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89, 0x3b,
        0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37, 0x80,
        0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07, 0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87, 0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81, 0x2c,
        0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5, 0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c, 0xc4,
        0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8, 0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc, 0x83,
        0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b, 0xb0, 0xc3, 0x8c, 0xcc, 0x21, 0x07, 0x7c, 0x70, 0x03, 0x74, 0x60, 0x07, 0x37, 0x90, 0x87, 0x72, 0x98, 0x87, 0x77, 0xa8, 0x07, 0x79, 0x18, 0x87, 0x72,
        0x70, 0x83, 0x70, 0xa0, 0x07, 0x7a, 0x90, 0x87, 0x74, 0x10, 0x87, 0x7a, 0xa0, 0x87, 0x72, 0x00, 0x00, 0x00, 0x00, 0x71, 0x20, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x36, 0xb0, 0x0d, 0x97, 0xef,
        0x3c, 0xbe, 0x10, 0x50, 0x45, 0x41, 0x44, 0xa5, 0x03, 0x0c, 0x25, 0x61, 0x00, 0x02, 0xe6, 0x17, 0xb7, 0x6d, 0x04, 0xdb, 0x70, 0xf9, 0xce, 0xe3, 0x0b, 0x01, 0x55, 0x14, 0x44, 0x54, 0x3a, 0xc0,
        0x50, 0x12, 0x06, 0x20, 0x60, 0x3e, 0x72, 0xdb, 0x56, 0x20, 0x0d, 0x97, 0xef, 0x3c, 0xbe, 0x10, 0x11, 0xc0, 0x44, 0x84, 0x40, 0x33, 0x2c, 0x84, 0x05, 0x4c, 0xc3, 0xe5, 0x3b, 0x8f, 0xbf, 0x38,
        0xc0, 0x20, 0x36, 0x0f, 0x35, 0xf9, 0xc5, 0x6d, 0x9b, 0x40, 0x35, 0x5c, 0xbe, 0xf3, 0xf8, 0xd2, 0xe4, 0x44, 0x04, 0x4a, 0x4d, 0x0f, 0x35, 0xf9, 0xc5, 0x6d, 0x1b, 0x00, 0xc1, 0x00, 0x48, 0x03,
        0x00, 0x00, 0x00, 0x61, 0x20, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x13, 0x04, 0x45, 0x2c, 0x10, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x44, 0x4a, 0x61, 0x06, 0xa0, 0xec, 0x4a, 0x8e, 0xe4,
        0x08, 0x00, 0x00, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x30, 0x55, 0x42, 0x32, 0x4d, 0xc1, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x18, 0xda, 0x04, 0x51, 0x4e, 0x31, 0x62, 0x90, 0x00, 0x20, 0x08,
        0x06, 0xc6, 0x46, 0x59, 0xd5, 0x63, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x81, 0xc1, 0x55, 0x96, 0x05, 0x1d, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x60, 0x74, 0xd6, 0x75, 0x3d, 0xc8, 0x88, 0x41,
        0x02, 0x80, 0x20, 0x18, 0x18, 0xde, 0x85, 0x61, 0x4e, 0x32, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0xc6, 0x87, 0x65, 0x19, 0xa4, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0xf2, 0x31, 0x9a, 0x46,
        0x11, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x80, 0x7c, 0x8c, 0xa6, 0x49, 0xc3, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x20, 0x1f, 0xa3, 0x69, 0x90, 0x30, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0xc8,
        0xc7, 0x68, 0x5a, 0x14, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0xf2, 0x31, 0x9b, 0x46, 0x15, 0x23, 0x06, 0x07, 0x00, 0x82, 0x60, 0x00, 0x75, 0xca, 0xa1, 0x8d, 0x26, 0x04, 0xc0, 0x70, 0x43,
        0xc0, 0x81, 0xc1, 0x2c, 0x83, 0x10, 0x04, 0x23, 0x06, 0x07, 0x00, 0x82, 0x60, 0xd0, 0x84, 0x41, 0xa3, 0x74, 0xa3, 0x09, 0x41, 0x30, 0x4b, 0x20, 0x0c, 0x54, 0x0c, 0x42, 0x40, 0x01, 0xb3, 0x0c,
        0xc4, 0x40, 0x8c, 0x18, 0x1c, 0x00, 0x08, 0x82, 0x41, 0x43, 0x06, 0x50, 0x03, 0x06, 0xa3, 0x09, 0x81, 0x30, 0x4b, 0x40, 0x0c, 0x54, 0x0c, 0xc2, 0xc0, 0x09, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60,
        0x80, 0xa0, 0x41, 0xf5, 0x8d, 0x41, 0x47, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x82, 0x06, 0xd5, 0x37, 0x06, 0x5b, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };
    const D3D12_SHADER_BYTECODE vs_multiple = {
        use_dxil ? (const void*)vs_multiple_code_dxil : (const void*)vs_multiple_code_dxbc,
        use_dxil ? sizeof(vs_multiple_code_dxil) : sizeof(vs_multiple_code_dxbc)
    };
#if 0
    bool use_constant;
    float clip_distance;

    struct vertex
    {
        float4 position : SV_POSITION;
        float user_clip : CLIP_DISTANCE;
        float clip : SV_ClipDistance;
    };

    [maxvertexcount(3)]
    void main(triangle vertex input[3], inout TriangleStream<vertex> output)
    {
        vertex o;
        o = input[0];
        o.clip = input[0].user_clip;
        if (use_constant)
            o.clip = clip_distance;
        output.Append(o);
        o = input[1];
        o.clip = input[1].user_clip;
        if (use_constant)
            o.clip = clip_distance;
        output.Append(o);
        o = input[2];
        o.clip = input[2].user_clip;
        if (use_constant)
            o.clip = clip_distance;
        output.Append(o);
    }
#endif
    static const DWORD gs_code_dxbc[] =
    {
        0x43425844, 0x9b0823e9, 0xab3ed100, 0xba0ff618, 0x1bbd1cb8, 0x00000001, 0x00000338, 0x00000003,
        0x0000002c, 0x000000b0, 0x00000134, 0x4e475349, 0x0000007c, 0x00000003, 0x00000008, 0x00000050,
        0x00000000, 0x00000001, 0x00000003, 0x00000000, 0x00000f0f, 0x0000005c, 0x00000000, 0x00000000,
        0x00000003, 0x00000001, 0x00000101, 0x0000006a, 0x00000000, 0x00000002, 0x00000003, 0x00000002,
        0x00000001, 0x505f5653, 0x5449534f, 0x004e4f49, 0x50494c43, 0x5349445f, 0x434e4154, 0x56530045,
        0x696c435f, 0x73694470, 0x636e6174, 0xabab0065, 0x4e47534f, 0x0000007c, 0x00000003, 0x00000008,
        0x00000050, 0x00000000, 0x00000001, 0x00000003, 0x00000000, 0x0000000f, 0x0000005c, 0x00000000,
        0x00000000, 0x00000003, 0x00000001, 0x00000e01, 0x0000006a, 0x00000000, 0x00000002, 0x00000003,
        0x00000002, 0x00000e01, 0x505f5653, 0x5449534f, 0x004e4f49, 0x50494c43, 0x5349445f, 0x434e4154,
        0x56530045, 0x696c435f, 0x73694470, 0x636e6174, 0xabab0065, 0x52444853, 0x000001fc, 0x00020040,
        0x0000007f, 0x04000059, 0x00208e46, 0x00000000, 0x00000001, 0x05000061, 0x002010f2, 0x00000003,
        0x00000000, 0x00000001, 0x0400005f, 0x00201012, 0x00000003, 0x00000001, 0x0400005f, 0x00201012,
        0x00000003, 0x00000002, 0x02000068, 0x00000001, 0x0100185d, 0x0100285c, 0x04000067, 0x001020f2,
        0x00000000, 0x00000001, 0x03000065, 0x00102012, 0x00000001, 0x04000067, 0x00102012, 0x00000002,
        0x00000002, 0x0200005e, 0x00000003, 0x06000036, 0x001020f2, 0x00000000, 0x00201e46, 0x00000000,
        0x00000000, 0x06000036, 0x00102012, 0x00000001, 0x0020100a, 0x00000000, 0x00000001, 0x0c000037,
        0x00100012, 0x00000000, 0x0020800a, 0x00000000, 0x00000000, 0x0020801a, 0x00000000, 0x00000000,
        0x0020100a, 0x00000000, 0x00000001, 0x05000036, 0x00102012, 0x00000002, 0x0010000a, 0x00000000,
        0x01000013, 0x06000036, 0x001020f2, 0x00000000, 0x00201e46, 0x00000001, 0x00000000, 0x06000036,
        0x00102012, 0x00000001, 0x0020100a, 0x00000001, 0x00000001, 0x0c000037, 0x00100012, 0x00000000,
        0x0020800a, 0x00000000, 0x00000000, 0x0020801a, 0x00000000, 0x00000000, 0x0020100a, 0x00000001,
        0x00000001, 0x05000036, 0x00102012, 0x00000002, 0x0010000a, 0x00000000, 0x01000013, 0x06000036,
        0x001020f2, 0x00000000, 0x00201e46, 0x00000002, 0x00000000, 0x06000036, 0x00102012, 0x00000001,
        0x0020100a, 0x00000002, 0x00000001, 0x0c000037, 0x00100012, 0x00000000, 0x0020800a, 0x00000000,
        0x00000000, 0x0020801a, 0x00000000, 0x00000000, 0x0020100a, 0x00000002, 0x00000001, 0x05000036,
        0x00102012, 0x00000002, 0x0010000a, 0x00000000, 0x01000013, 0x0100003e,
    };
    static const BYTE gs_code_dxil[] =
    {
        0x44, 0x58, 0x42, 0x43, 0xa9, 0x65, 0x4e, 0x53, 0x93, 0xb5, 0x18, 0x67, 0x7a, 0x42, 0xd4, 0x57, 0x24, 0xf9, 0x2c, 0xc3, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x0b, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
        0x34, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0xde, 0x00, 0x00, 0x00, 0x78, 0x01, 0x00, 0x00, 0x80, 0x02, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0x92, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x00,
        0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x53, 0x56, 0x5f, 0x43, 0x6c, 0x69, 0x70, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x00, 0x4f, 0x53,
        0x47, 0x31, 0x92, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44,
        0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x53, 0x56, 0x5f, 0x43, 0x6c, 0x69, 0x70, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x00, 0x50, 0x53, 0x56, 0x30, 0x00, 0x01, 0x00, 0x00,
        0x24, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x03, 0x00,
        0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x20, 0x00, 0x00, 0x00, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x44, 0x03, 0x03, 0x04, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x41, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x41, 0x06, 0x03, 0x02, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x44, 0x03, 0x03, 0x04, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x41, 0x00, 0x03, 0x02, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x41, 0x06, 0x03, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x44, 0x58, 0x49, 0x4c, 0x94, 0x08, 0x00, 0x00, 0x60, 0x00, 0x02, 0x00, 0x25, 0x02, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0x00, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x7c, 0x08, 0x00, 0x00,
        0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00, 0x1c, 0x02, 0x00, 0x00, 0x0b, 0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23, 0x91, 0x41, 0xc8, 0x04, 0x49,
        0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19, 0x1e, 0x04, 0x8b, 0x62, 0x80, 0x14, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42, 0xa4, 0x10, 0x32, 0x14, 0x38, 0x08, 0x18, 0x4b,
        0x0a, 0x32, 0x52, 0x88, 0x48, 0x90, 0x14, 0x20, 0x43, 0x46, 0x88, 0xa5, 0x00, 0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90, 0x91, 0x22, 0xc4, 0x50, 0x41, 0x51, 0x81, 0x8c, 0xe1, 0x83, 0xe5, 0x8a,
        0x04, 0x29, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1b, 0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x40, 0x02, 0xa8, 0x0d, 0x84, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x20,
        0x6d, 0x30, 0x86, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x09, 0xa8, 0x00, 0x49, 0x18, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x13, 0x82, 0x60, 0x42, 0x20, 0x4c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00,
        0x89, 0x20, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x32, 0x22, 0x48, 0x09, 0x20, 0x64, 0x85, 0x04, 0x93, 0x22, 0xa4, 0x84, 0x04, 0x93, 0x22, 0xe3, 0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x8a, 0x8c,
        0x0b, 0x84, 0xa4, 0x4c, 0x10, 0x70, 0x23, 0x00, 0x25, 0x00, 0x14, 0x66, 0x00, 0xe6, 0x08, 0xc0, 0x60, 0x8e, 0x00, 0x29, 0xc6, 0x20, 0x84, 0x14, 0x42, 0xa6, 0x18, 0x80, 0x10, 0x52, 0x06, 0xa1,
        0x32, 0x00, 0x52, 0x48, 0x1d, 0x35, 0x5c, 0xfe, 0x84, 0x3d, 0x84, 0xe4, 0x73, 0x1b, 0x55, 0xac, 0xc4, 0xe4, 0x17, 0xb7, 0x8d, 0x88, 0x31, 0xc6, 0xa0, 0x72, 0xcf, 0x70, 0xf9, 0x13, 0xf6, 0x10,
        0x92, 0x1f, 0x02, 0xcd, 0xb0, 0x10, 0x28, 0x68, 0x85, 0x60, 0xc4, 0x11, 0x7a, 0x47, 0x0d, 0x97, 0x3f, 0x61, 0x0f, 0x21, 0xf9, 0xdc, 0x46, 0x15, 0x2b, 0x31, 0xf9, 0xc8, 0x6d, 0x23, 0x82, 0x10,
        0x42, 0x0a, 0x11, 0x89, 0x23, 0x24, 0xe7, 0x08, 0x82, 0x62, 0x38, 0x52, 0x08, 0xa1, 0x54, 0x07, 0x02, 0x66, 0x42, 0xc8, 0xe0, 0x14, 0xd8, 0xe1, 0x1d, 0xc4, 0x21, 0x1c, 0xd8, 0x61, 0x1e, 0x90,
        0x40, 0x06, 0xe1, 0x74, 0x20, 0x53, 0x00, 0x00, 0x13, 0x14, 0x72, 0xc0, 0x87, 0x74, 0x60, 0x87, 0x36, 0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0, 0x87, 0x0d, 0xaf, 0x50, 0x0e, 0x6d, 0xd0, 0x0e,
        0x7a, 0x50, 0x0e, 0x6d, 0x00, 0x0f, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x78, 0xa0, 0x07, 0x73, 0x20,
        0x07, 0x6d, 0x90, 0x0e, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe9, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x76, 0x40, 0x07, 0x7a, 0x60, 0x07, 0x74,
        0xd0, 0x06, 0xe6, 0x10, 0x07, 0x76, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x60, 0x0e, 0x73, 0x20, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe6, 0x60, 0x07, 0x74, 0xa0, 0x07, 0x76, 0x40, 0x07,
        0x6d, 0xe0, 0x0e, 0x78, 0xa0, 0x07, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x43, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86,
        0x3c, 0x06, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x79, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf2, 0x28, 0x40, 0x00, 0x08, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xe4, 0x79, 0x80, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xc8, 0x23, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xc0, 0x90, 0xa7, 0x02, 0x02, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x2c, 0x10, 0x0f, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c, 0x09, 0x26, 0x47,
        0xc6, 0x04, 0x43, 0x22, 0x25, 0x30, 0x02, 0x50, 0x08, 0xc5, 0x50, 0x10, 0x45, 0x50, 0x06, 0xa5, 0x40, 0xa5, 0x24, 0xca, 0xa0, 0x10, 0x46, 0x00, 0x8a, 0xa0, 0x04, 0x8a, 0x81, 0xf2, 0x0c, 0x00,
        0xe9, 0xb1, 0x9c, 0x24, 0x09, 0x04, 0x02, 0x81, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0xc4,
        0x88, 0x0c, 0x6f, 0xec, 0xed, 0x4d, 0x0c, 0x44, 0x06, 0x26, 0x26, 0xc7, 0x05, 0xa6, 0xc6, 0x05, 0x06, 0x66, 0x43, 0x10, 0x4c, 0x10, 0x88, 0x63, 0x82, 0x40, 0x20, 0x1b, 0x84, 0x81, 0x98, 0x20,
        0x10, 0xc9, 0x06, 0x61, 0x30, 0x28, 0x9c, 0xcd, 0x4d, 0x10, 0x08, 0x65, 0xc3, 0x80, 0x24, 0xc4, 0x04, 0x21, 0xb3, 0x08, 0x4c, 0x10, 0x88, 0x65, 0x03, 0x42, 0x2c, 0x0c, 0x41, 0x0c, 0x0d, 0xb0,
        0x21, 0x70, 0x36, 0x10, 0x00, 0xf0, 0x00, 0x13, 0x04, 0x01, 0xd8, 0x00, 0x6c, 0x18, 0x08, 0x49, 0xda, 0x10, 0x4c, 0x1b, 0x86, 0x21, 0xa2, 0x26, 0x08, 0xda, 0xb5, 0x21, 0xb0, 0x48, 0xb4, 0x85,
        0xa5, 0xb9, 0x71, 0x99, 0xb2, 0xfa, 0x82, 0x7a, 0x9b, 0x4b, 0xa3, 0x4b, 0x7b, 0x73, 0x9b, 0x20, 0x14, 0xcf, 0x04, 0xa1, 0x80, 0x36, 0x04, 0xc4, 0x04, 0xa1, 0x88, 0x26, 0x08, 0x85, 0xb4, 0x61,
        0x21, 0x32, 0x6d, 0xe3, 0xba, 0xa1, 0x23, 0x3c, 0x80, 0xcd, 0x10, 0x53, 0x12, 0xd4, 0x17, 0x51, 0xd2, 0x14, 0x55, 0x90, 0xd3, 0x50, 0xd1, 0x04, 0xa1, 0x98, 0x26, 0x08, 0x05, 0xb5, 0x61, 0x19,
        0xc0, 0x40, 0xf3, 0xb8, 0x30, 0x18, 0xc4, 0x60, 0xf0, 0x80, 0x09, 0x02, 0xc1, 0xf0, 0x99, 0xb2, 0xfa, 0x1a, 0x62, 0x4b, 0x83, 0x23, 0x4a, 0x9b, 0xa3, 0x0b, 0x73, 0x1b, 0x2b, 0x9b, 0x20, 0x14,
        0xd5, 0x86, 0x85, 0x0c, 0xca, 0x40, 0x33, 0x03, 0x2e, 0x0c, 0x06, 0x31, 0x20, 0x03, 0x0f, 0xd8, 0x30, 0x7c, 0x63, 0x70, 0x06, 0x1b, 0x06, 0x34, 0x40, 0x03, 0x60, 0x82, 0x40, 0x34, 0x13, 0x04,
        0xc2, 0xd9, 0x50, 0xa8, 0x81, 0x1a, 0x0c, 0x6b, 0x30, 0x6c, 0x10, 0x06, 0x36, 0xd8, 0x50, 0x44, 0x58, 0x1a, 0x40, 0x6d, 0x50, 0x85, 0x8d, 0xcd, 0xae, 0xcd, 0x25, 0x8d, 0xac, 0xcc, 0x8d, 0x6e,
        0x4a, 0x10, 0x54, 0x21, 0xc3, 0x73, 0xb1, 0x2b, 0x93, 0x9b, 0x4b, 0x7b, 0x73, 0x9b, 0x12, 0x10, 0x4d, 0xc8, 0xf0, 0x5c, 0xec, 0xc2, 0xd8, 0xec, 0xca, 0xe4, 0xa6, 0x04, 0x46, 0x1d, 0x32, 0x3c,
        0x97, 0x39, 0xb4, 0x30, 0xb2, 0x32, 0xb9, 0xa6, 0x37, 0xb2, 0x32, 0xb6, 0x29, 0x41, 0x52, 0x86, 0x0c, 0xcf, 0x45, 0xae, 0x6c, 0xee, 0xad, 0x4e, 0x6e, 0xac, 0x6c, 0x6e, 0x4a, 0xf0, 0x54, 0x22,
        0xc3, 0x73, 0xa1, 0xcb, 0x83, 0x2b, 0x0b, 0x72, 0x73, 0x7b, 0xa3, 0x0b, 0xa3, 0x4b, 0x7b, 0x73, 0x9b, 0x9b, 0x12, 0x50, 0x75, 0xc8, 0xf0, 0x5c, 0xec, 0xd2, 0xca, 0xee, 0x92, 0xc8, 0xa6, 0xe8,
        0xc2, 0xe8, 0xca, 0xa6, 0x04, 0x56, 0x1d, 0x32, 0x3c, 0x97, 0x32, 0x37, 0x3a, 0xb9, 0x3c, 0xa8, 0xb7, 0x34, 0x37, 0xba, 0xb9, 0x29, 0x41, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00,
        0x4c, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c, 0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d, 0x88, 0x43, 0x38, 0x84, 0xc3, 0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6,
        0x00, 0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d, 0xce, 0xa1, 0x1c, 0x66, 0x30, 0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8,
        0x43, 0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c, 0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79, 0x48, 0x87, 0x70, 0x70, 0x07, 0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11,
        0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e, 0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50, 0x0e, 0x33, 0x10, 0xc4, 0x1d, 0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89,
        0x3b, 0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03, 0x3b, 0xcc, 0xf0, 0x14, 0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37,
        0x80, 0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07, 0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76, 0x78, 0x87, 0x77, 0x80, 0x87, 0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81,
        0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5, 0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c,
        0xc4, 0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43, 0x39, 0xc8, 0x43, 0x39, 0xb8, 0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc,
        0x83, 0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b, 0xb0, 0xc3, 0x8c, 0xcc, 0x21, 0x07, 0x7c, 0x70, 0x03, 0x74, 0x60, 0x07, 0x37, 0x90, 0x87, 0x72, 0x98, 0x87, 0x77, 0xa8, 0x07, 0x79, 0x18, 0x87,
        0x72, 0x70, 0x83, 0x70, 0xa0, 0x07, 0x7a, 0x90, 0x87, 0x74, 0x10, 0x87, 0x7a, 0xa0, 0x87, 0x72, 0x00, 0x00, 0x00, 0x00, 0x71, 0x20, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x46, 0xb0, 0x0d, 0x97,
        0xef, 0x3c, 0xbe, 0x10, 0x50, 0x45, 0x41, 0x44, 0xa5, 0x03, 0x0c, 0x25, 0x61, 0x00, 0x02, 0xe6, 0x17, 0xb7, 0x6d, 0x05, 0xdb, 0x70, 0xf9, 0xce, 0xe3, 0x0b, 0x01, 0x55, 0x14, 0x44, 0x54, 0x3a,
        0xc0, 0x50, 0x12, 0x06, 0x20, 0x60, 0x3e, 0x72, 0xdb, 0x66, 0x20, 0x0d, 0x97, 0xef, 0x3c, 0xbe, 0x10, 0x11, 0xc0, 0x44, 0x84, 0x40, 0x33, 0x2c, 0x84, 0x0d, 0x40, 0xc3, 0xe5, 0x3b, 0x8f, 0x4f,
        0x30, 0xc8, 0xc4, 0x4e, 0x11, 0x01, 0x30, 0x16, 0x30, 0x0d, 0x97, 0xef, 0x3c, 0xfe, 0xe2, 0x00, 0x83, 0xd8, 0x3c, 0xd4, 0xe4, 0x17, 0xb7, 0x6d, 0x02, 0xd5, 0x70, 0xf9, 0xce, 0xe3, 0x4b, 0x93,
        0x13, 0x11, 0x28, 0x35, 0x3d, 0xd4, 0xe4, 0x17, 0xb7, 0x6d, 0x00, 0x04, 0x03, 0x20, 0x0d, 0x00, 0x61, 0x20, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x13, 0x04, 0x47, 0x2c, 0x10, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x00, 0x00, 0x44, 0xca, 0xae, 0x84, 0x03, 0x4a, 0x8e, 0xe8, 0x08, 0x00, 0x00, 0x00, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x50, 0x59, 0x42, 0x42, 0x51, 0xc1, 0x88, 0x41, 0x02, 0x80,
        0x20, 0x18, 0x18, 0x1c, 0x55, 0x55, 0x4b, 0x35, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x46, 0x57, 0x59, 0x96, 0x62, 0x8d, 0x18, 0x24, 0x00, 0x08, 0x82, 0x81, 0xe1, 0x59, 0xd7, 0xc5, 0x5c, 0x23,
        0x06, 0x09, 0x00, 0x82, 0x60, 0x60, 0x7c, 0x17, 0x86, 0x41, 0xd8, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x18, 0x60, 0x80, 0x69, 0xd9, 0x93, 0x8d, 0x18, 0x1c, 0x00, 0x08, 0x82, 0x81, 0xd4, 0x29,
        0x86, 0x36, 0x9a, 0x10, 0x00, 0xc3, 0x0d, 0x01, 0x07, 0x06, 0xb3, 0x0c, 0x42, 0x10, 0x8c, 0x18, 0x1c, 0x00, 0x08, 0x82, 0xc1, 0x13, 0x06, 0x4d, 0xd2, 0x8d, 0x26, 0x04, 0xc1, 0x2c, 0x81, 0x30,
        0x50, 0x31, 0x08, 0x01, 0x03, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x62, 0x06, 0x1a, 0x18, 0x80, 0x81, 0xb5, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x62, 0x06, 0x1a, 0x18, 0x80, 0x01,
        0xa5, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x62, 0x06, 0x1a, 0x18, 0x80, 0x41, 0x95, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x62, 0x06, 0x1a, 0x18, 0x80, 0x01, 0x86, 0x8c, 0x18, 0x24,
        0x00, 0x08, 0x82, 0x01, 0x62, 0x06, 0x5a, 0x18, 0x80, 0x81, 0x75, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x62, 0x06, 0x1a, 0x07, 0x06, 0x56, 0x30, 0x62, 0x60, 0x00, 0x20, 0x08, 0x06, 0x4a,
        0x19, 0x3c, 0xd6, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x18, 0x67, 0xf0, 0x81, 0x01, 0x18, 0x58, 0x61, 0x30, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x06, 0x1a, 0x80, 0x41, 0x18, 0x84, 0x41, 0x25,
        0x06, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x60, 0xa4, 0x41, 0x18, 0x88, 0x81, 0x18, 0x5c, 0x63, 0x30, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x86, 0x1a, 0x88, 0xc1, 0x18, 0x8c, 0xc1, 0x46, 0x06,
        0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x60, 0xac, 0xc1, 0x18, 0x94, 0x01, 0x19, 0x68, 0x65, 0x30, 0x62, 0x70, 0x00, 0x20, 0x08, 0x06, 0x12, 0x1a, 0x54, 0x51, 0x19, 0x8c, 0x26, 0x04, 0xc0, 0x70,
        0x43, 0x70, 0x06, 0x60, 0x30, 0xcb, 0x40, 0x0c, 0xc1, 0x88, 0xc1, 0x01, 0x80, 0x20, 0x18, 0x3c, 0x6c, 0x80, 0x51, 0x68, 0x30, 0x9a, 0x10, 0x04, 0xb3, 0x04, 0xc4, 0x40, 0xc5, 0x20, 0x0c, 0x8c,
        0x30, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x48, 0x1c, 0x94, 0xc1, 0x1a, 0xac, 0x41, 0x18, 0x2c, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x80, 0xc4, 0x41, 0x19, 0xac, 0xc1, 0x1a, 0x7c, 0xca, 0x88,
        0x41, 0x02, 0x80, 0x20, 0x18, 0x20, 0x71, 0x50, 0x06, 0x6b, 0xb0, 0x06, 0x60, 0x90, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x12, 0x07, 0x65, 0xb0, 0x06, 0x6b, 0x30, 0x06, 0xc8, 0x88, 0x41,
        0x02, 0x80, 0x20, 0x18, 0x20, 0x71, 0x50, 0x06, 0x6c, 0xb0, 0x06, 0x61, 0x70, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x12, 0x07, 0x65, 0x70, 0x06, 0x6b, 0x10, 0x06, 0xc1, 0x88, 0x81, 0x01,
        0x80, 0x20, 0x18, 0x28, 0x70, 0xa0, 0x85, 0xc1, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x18, 0x72, 0xa0, 0x06, 0x6b, 0xb0, 0x06, 0x61, 0x70, 0x06, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x60, 0xcc,
        0xc1, 0x1a, 0xb0, 0x01, 0x1b, 0x80, 0x01, 0x1a, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x81, 0x41, 0x07, 0x6c, 0xd0, 0x06, 0x6d, 0x20, 0x06, 0x69, 0x30, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x46,
        0x1d, 0xb4, 0x81, 0x1b, 0xb8, 0x81, 0x19, 0xa8, 0xc1, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x18, 0x76, 0xe0, 0x06, 0x70, 0xf0, 0x06, 0x65, 0xb0, 0x06, 0x23, 0x06, 0x07, 0x00, 0x82, 0x60, 0x20,
        0xcd, 0x01, 0x18, 0x70, 0x70, 0x30, 0x9a, 0x10, 0x00, 0xc3, 0x0d, 0x81, 0x1c, 0x80, 0xc1, 0x2c, 0x83, 0x51, 0x04, 0x23, 0x06, 0x07, 0x00, 0x82, 0x60, 0xf0, 0xdc, 0xc1, 0x18, 0x7c, 0x73, 0x30,
        0x9a, 0x10, 0x04, 0xb3, 0x04, 0xc6, 0x40, 0xc5, 0x20, 0x14, 0x0c, 0x31, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x08, 0x1f, 0xc0, 0x81, 0x1d, 0xd8, 0x01, 0x1b, 0x2c, 0x23, 0x06, 0x09, 0x00, 0x82,
        0x60, 0x80, 0xf0, 0x01, 0x1c, 0xd8, 0x81, 0x1d, 0xa8, 0x81, 0x32, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x08, 0x1f, 0xc0, 0x81, 0x1d, 0xd8, 0xc1, 0x1a, 0x24, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60,
        0x80, 0xf0, 0x01, 0x1c, 0xd8, 0x81, 0x1d, 0xb8, 0x01, 0x32, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0x08, 0x1f, 0xc0, 0xc1, 0x1d, 0xd8, 0x01, 0x1b, 0x1c, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x80,
        0xf0, 0x01, 0x1c, 0xc8, 0x81, 0x1d, 0xb0, 0x41, 0x30, 0x62, 0x60, 0x00, 0x20, 0x08, 0x06, 0xca, 0x1e, 0x94, 0x01, 0x1b, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };
    const D3D12_SHADER_BYTECODE gs = {
        use_dxil ? (const void*)gs_code_dxil : (const void*)gs_code_dxbc,
        use_dxil ? sizeof(gs_code_dxil) : sizeof(gs_code_dxbc)
    };
    static const D3D12_INPUT_ELEMENT_DESC layout_desc[] =
    {
        {"POSITION",      0, DXGI_FORMAT_R32G32_FLOAT, 0, 0, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CLIP_DISTANCE", 0, DXGI_FORMAT_R32_FLOAT,    1, 0, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CLIP_DISTANCE", 1, DXGI_FORMAT_R32_FLOAT,    1, 4, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
    };
    static const struct vec4 quad[] =
    {
        {-1.0f, -1.0f},
        {-1.0f,  1.0f},
        { 1.0f, -1.0f},
        { 1.0f,  1.0f},
    };
    struct
    {
        float clip_distance0;
        float clip_distance1;
    }
    vertices[] =
    {
        {1.0f, 1.0f},
        {1.0f, 1.0f},
        {1.0f, 1.0f},
        {1.0f, 1.0f},
    };
    static const float white[] = {1.0f, 1.0f, 1.0f, 1.0f};
    struct
    {
        bool use_constant;
        float clip_distance0;
        float clip_distance1;
        float padding;
    } cb_data;

    memset(&desc, 0, sizeof(desc));
    desc.rt_width = 640;
    desc.rt_height = 480;
    desc.no_root_signature = true;
    if (!init_test_context(&context, &desc))
        return;

    if (use_dxil && !context_supports_dxil(&context))
    {
        destroy_test_context(&context);
        return;
    }

    device = context.device;
    command_list = context.list;
    queue = context.queue;

    root_parameters[0].ParameterType = D3D12_ROOT_PARAMETER_TYPE_CBV;
    root_parameters[0].Descriptor.ShaderRegister = 0;
    root_parameters[0].Descriptor.RegisterSpace = 0;
    root_parameters[0].ShaderVisibility = D3D12_SHADER_VISIBILITY_VERTEX;
    root_parameters[1].ParameterType = D3D12_ROOT_PARAMETER_TYPE_CBV;
    root_parameters[1].Descriptor.ShaderRegister = 1;
    root_parameters[1].Descriptor.RegisterSpace = 0;
    root_parameters[1].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
    root_parameters[2].ParameterType = D3D12_ROOT_PARAMETER_TYPE_CBV;
    root_parameters[2].Descriptor.ShaderRegister = 0;
    root_parameters[2].Descriptor.RegisterSpace = 0;
    root_parameters[2].ShaderVisibility = D3D12_SHADER_VISIBILITY_GEOMETRY;
    root_signature_desc.NumParameters = ARRAY_SIZE(root_parameters);
    root_signature_desc.pParameters = root_parameters;
    root_signature_desc.NumStaticSamplers = 0;
    root_signature_desc.pStaticSamplers = NULL;
    root_signature_desc.Flags = D3D12_ROOT_SIGNATURE_FLAG_ALLOW_INPUT_ASSEMBLER_INPUT_LAYOUT;
    hr = create_root_signature(device, &root_signature_desc, &context.root_signature);
    ok(hr == S_OK, "Got unexpected hr %#x.\n", hr);

    input_layout.pInputElementDescs = layout_desc;
    input_layout.NumElements = ARRAY_SIZE(layout_desc);

    if (use_dxil)
    {
        init_pipeline_state_desc_dxil(&pso_desc, context.root_signature,
                context.render_target_desc.Format, &vs, NULL, &input_layout);
    }
    else
    {
        init_pipeline_state_desc(&pso_desc, context.root_signature,
                context.render_target_desc.Format, &vs, NULL, &input_layout);
    }
    hr = ID3D12Device_CreateGraphicsPipelineState(device, &pso_desc,
            &IID_ID3D12PipelineState, (void **)&pso);
    ok(hr == S_OK, "Failed to create pipeline state, hr %#x.\n", hr);

    vb[0] = create_upload_buffer(device, sizeof(quad), quad);
    vbv[0].BufferLocation = ID3D12Resource_GetGPUVirtualAddress(vb[0]);
    vbv[0].StrideInBytes = sizeof(*quad);
    vbv[0].SizeInBytes = sizeof(quad);

    vb[1] = create_upload_buffer(device, sizeof(vertices), vertices);
    vbv[1].BufferLocation = ID3D12Resource_GetGPUVirtualAddress(vb[1]);
    vbv[1].StrideInBytes = sizeof(*vertices);
    vbv[1].SizeInBytes = sizeof(vertices);

    memset(&cb_data, 0, sizeof(cb_data));
    vs_cb = create_upload_buffer(device, sizeof(cb_data), &cb_data);
    gs_cb = create_upload_buffer(device, sizeof(cb_data), &cb_data);

    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context.rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context.viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context.scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, ARRAY_SIZE(vbv), vbv);

    /* vertex shader */
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context.rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    check_sub_resource_uint(context.render_target, 0, queue, command_list, 0xff00ff00, 0);

    reset_command_list(command_list, context.allocator);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);
    check_clip_distance(&context, pso, vbv, vb[1], vs_cb, gs_cb);

    cb_data.use_constant = true;
    cb_data.clip_distance0 = -1.0f;
    update_buffer_data(vs_cb, 0, sizeof(cb_data), &cb_data);

    ID3D12PipelineState_Release(pso);

    /* geometry shader */
    pso_desc.GS = gs;
    hr = ID3D12Device_CreateGraphicsPipelineState(device, &pso_desc,
            &IID_ID3D12PipelineState, (void **)&pso);
    ok(hr == S_OK, "Failed to create pipeline state, hr %#x.\n", hr);

    check_clip_distance(&context, pso, vbv, vb[1], vs_cb, gs_cb);

    cb_data.use_constant = true;
    cb_data.clip_distance0 = 1.0f;
    update_buffer_data(gs_cb, 0, sizeof(cb_data), &cb_data);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context.rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context.viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context.scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, ARRAY_SIZE(vbv), vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context.rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    check_sub_resource_uint(context.render_target, 0, queue, command_list, 0xff00ff00, 0);

    ID3D12PipelineState_Release(pso);
    reset_command_list(command_list, context.allocator);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);

    /* multiple clip distances */
    pso_desc.VS = vs_multiple;
    memset(&pso_desc.GS, 0, sizeof(pso_desc.GS));
    hr = ID3D12Device_CreateGraphicsPipelineState(device, &pso_desc,
            &IID_ID3D12PipelineState, (void **)&pso);
    ok(hr == S_OK, "Failed to create pipeline state, hr %#x.\n", hr);

    cb_data.use_constant = false;
    update_buffer_data(vs_cb, 0, sizeof(cb_data), &cb_data);

    for (i = 0; i < ARRAY_SIZE(vertices); ++i)
        vertices[i].clip_distance0 = 1.0f;
    update_buffer_data(vb[1], 0, sizeof(vertices), vertices);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context.rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context.viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context.scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, ARRAY_SIZE(vbv), vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context.rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    check_sub_resource_uint(context.render_target, 0, queue, command_list, 0xff00ff00, 0);

    reset_command_list(command_list, context.allocator);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);

    for (i = 0; i < ARRAY_SIZE(vertices); ++i)
    {
        vertices[i].clip_distance0 = i < 2 ? 1.0f : -1.0f;
        vertices[i].clip_distance1 = i % 2 ? 1.0f : -1.0f;
    }
    update_buffer_data(vb[1], 0, sizeof(vertices), vertices);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context.rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context.viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context.scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, ARRAY_SIZE(vbv), vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context.rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);

    get_texture_readback_with_command_list(context.render_target, 0, &rb, queue, command_list);
    set_box(&box, 0, 0, 0, 320, 240, 1);
    check_readback_data_uint(&rb, &box, 0xff00ff00, 1);
    set_box(&box, 0, 240, 0, 320, 480, 1);
    check_readback_data_uint(&rb, &box, 0xffffffff, 1);
    set_box(&box, 320, 0, 0, 640, 480, 1);
    check_readback_data_uint(&rb, &box, 0xffffffff, 1);
    release_resource_readback(&rb);

    reset_command_list(command_list, context.allocator);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);

    cb_data.use_constant = true;
    cb_data.clip_distance0 = 0.0f;
    cb_data.clip_distance1 = 0.0f;
    update_buffer_data(vs_cb, 0, sizeof(cb_data), &cb_data);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context.rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 0,
            ID3D12Resource_GetGPUVirtualAddress(vs_cb));
    ID3D12GraphicsCommandList_SetGraphicsRootConstantBufferView(command_list, 2,
            ID3D12Resource_GetGPUVirtualAddress(gs_cb));
    ID3D12GraphicsCommandList_SetPipelineState(command_list, pso);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context.viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context.scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, ARRAY_SIZE(vbv), vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context.rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    check_sub_resource_uint(context.render_target, 0, queue, command_list, 0xff00ff00, 0);

    ID3D12PipelineState_Release(pso);
    for (i = 0; i < ARRAY_SIZE(vb); ++i)
        ID3D12Resource_Release(vb[i]);
    ID3D12Resource_Release(vs_cb);
    ID3D12Resource_Release(gs_cb);
    destroy_test_context(&context);
}

void test_clip_distance_dxbc(void)
{
    test_clip_distance(false);
}

void test_clip_distance_dxil(void)
{
    test_clip_distance(true);
}

static void test_combined_clip_and_cull_distances(bool use_dxil)
{
    ID3D12GraphicsCommandList *command_list;
    D3D12_INPUT_LAYOUT_DESC input_layout;
    D3D12_VERTEX_BUFFER_VIEW vbv[2];
    struct test_context_desc desc;
    struct test_context context;
    struct resource_readback rb;
    ID3D12CommandQueue *queue;
    ID3D12Resource *vb[2];
    ID3D12Device *device;
    unsigned int i, j, k;

#if 0
    struct input
    {
        float4 position : POSITION;
        float clip0 : CLIP_DISTANCE0;
        float clip1 : CLIP_DISTANCE1;
        float clip2 : CLIP_DISTANCE2;
        float clip3 : CLIP_DISTANCE3;
        float cull0 : CULL_DISTANCE0;
        float cull1 : CULL_DISTANCE1;
        float cull2 : CULL_DISTANCE2;
        float cull3 : CULL_DISTANCE3;
    };

    struct vertex
    {
        float4 position : SV_Position;
        float3 clip0 : SV_ClipDistance1;
        float3 cull0 : SV_CullDistance1;
        float clip1 : SV_ClipDistance2;
        float cull1 : SV_CullDistance2;
    };

    void main(input vin, out vertex vertex)
    {
        vertex.position = vin.position;
        vertex.clip0 = float3(vin.clip0, vin.clip1, vin.clip2);
        vertex.cull0 = float3(vin.cull0, vin.cull1, vin.cull2);
        vertex.clip1 = vin.clip3;
        vertex.cull1 = vin.cull3;
    }
#endif
    static const DWORD vs_code_dxbc[] =
    {
        0x43425844, 0xa24fb3ea, 0x92e2c2b0, 0xb599b1b9, 0xd671f830, 0x00000001, 0x00000374, 0x00000003,
        0x0000002c, 0x0000013c, 0x000001f0, 0x4e475349, 0x00000108, 0x00000009, 0x00000008, 0x000000e0,
        0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000f0f, 0x000000e9, 0x00000000, 0x00000000,
        0x00000003, 0x00000001, 0x00000101, 0x000000e9, 0x00000001, 0x00000000, 0x00000003, 0x00000002,
        0x00000101, 0x000000e9, 0x00000002, 0x00000000, 0x00000003, 0x00000003, 0x00000101, 0x000000e9,
        0x00000003, 0x00000000, 0x00000003, 0x00000004, 0x00000101, 0x000000f7, 0x00000000, 0x00000000,
        0x00000003, 0x00000005, 0x00000101, 0x000000f7, 0x00000001, 0x00000000, 0x00000003, 0x00000006,
        0x00000101, 0x000000f7, 0x00000002, 0x00000000, 0x00000003, 0x00000007, 0x00000101, 0x000000f7,
        0x00000003, 0x00000000, 0x00000003, 0x00000008, 0x00000101, 0x49534f50, 0x4e4f4954, 0x494c4300,
        0x49445f50, 0x4e415453, 0x43004543, 0x5f4c4c55, 0x54534944, 0x45434e41, 0xababab00, 0x4e47534f,
        0x000000ac, 0x00000005, 0x00000008, 0x00000080, 0x00000000, 0x00000001, 0x00000003, 0x00000000,
        0x0000000f, 0x0000008c, 0x00000000, 0x00000002, 0x00000003, 0x00000001, 0x00000807, 0x0000008c,
        0x00000001, 0x00000002, 0x00000003, 0x00000001, 0x00000708, 0x0000009c, 0x00000000, 0x00000003,
        0x00000003, 0x00000002, 0x00000807, 0x0000009c, 0x00000001, 0x00000003, 0x00000003, 0x00000002,
        0x00000708, 0x505f5653, 0x7469736f, 0x006e6f69, 0x435f5653, 0x4470696c, 0x61747369, 0x0065636e,
        0x435f5653, 0x446c6c75, 0x61747369, 0x0065636e, 0x52444853, 0x0000017c, 0x00010040, 0x0000005f,
        0x0300005f, 0x001010f2, 0x00000000, 0x0300005f, 0x00101012, 0x00000001, 0x0300005f, 0x00101012,
        0x00000002, 0x0300005f, 0x00101012, 0x00000003, 0x0300005f, 0x00101012, 0x00000004, 0x0300005f,
        0x00101012, 0x00000005, 0x0300005f, 0x00101012, 0x00000006, 0x0300005f, 0x00101012, 0x00000007,
        0x0300005f, 0x00101012, 0x00000008, 0x04000067, 0x001020f2, 0x00000000, 0x00000001, 0x04000067,
        0x00102072, 0x00000001, 0x00000002, 0x04000067, 0x00102082, 0x00000001, 0x00000002, 0x04000067,
        0x00102072, 0x00000002, 0x00000003, 0x04000067, 0x00102082, 0x00000002, 0x00000003, 0x05000036,
        0x001020f2, 0x00000000, 0x00101e46, 0x00000000, 0x05000036, 0x00102012, 0x00000001, 0x0010100a,
        0x00000001, 0x05000036, 0x00102022, 0x00000001, 0x0010100a, 0x00000002, 0x05000036, 0x00102042,
        0x00000001, 0x0010100a, 0x00000003, 0x05000036, 0x00102082, 0x00000001, 0x0010100a, 0x00000004,
        0x05000036, 0x00102012, 0x00000002, 0x0010100a, 0x00000005, 0x05000036, 0x00102022, 0x00000002,
        0x0010100a, 0x00000006, 0x05000036, 0x00102042, 0x00000002, 0x0010100a, 0x00000007, 0x05000036,
        0x00102082, 0x00000002, 0x0010100a, 0x00000008, 0x0100003e,
    };
    static const BYTE vs_code_dxil[] =
    {
        0x44, 0x58, 0x42, 0x43, 0x58, 0xbc, 0x5d, 0xad, 0xbf, 0x11, 0x93, 0x02, 0x79, 0x8c, 0xb2, 0x4d, 0x39, 0x1a, 0x1c, 0x6f, 0x01, 0x00, 0x00, 0x00, 0xb5, 0x0b, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
        0x34, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0xed, 0x01, 0x00, 0x00, 0xc9, 0x02, 0x00, 0x00, 0x05, 0x05, 0x00, 0x00, 0x53, 0x46, 0x49, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x49, 0x53, 0x47, 0x31, 0xa1, 0x01, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x85, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x93, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4c, 0x49,
        0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49,
        0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e,
        0x43, 0x45, 0x00, 0x43, 0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43,
        0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x4f, 0x53, 0x47, 0x31, 0xd4, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xb4, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xb4, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xc4, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x07, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xc4, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x56, 0x5f,
        0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x53, 0x56, 0x5f, 0x43, 0x6c, 0x69, 0x70, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x00, 0x53, 0x56, 0x5f, 0x43, 0x75, 0x6c, 0x6c,
        0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x00, 0x50, 0x53, 0x56, 0x30, 0x34, 0x02, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x09, 0x05, 0x00, 0x09, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00,
        0x00, 0x00, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49,
        0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x4c, 0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e,
        0x43, 0x45, 0x00, 0x43, 0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43,
        0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x43, 0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x44,
        0x00, 0x03, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x41, 0x00, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02, 0x41,
        0x00, 0x03, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x03, 0x41, 0x00, 0x03, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x04, 0x41,
        0x00, 0x03, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x41, 0x00, 0x03, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x06, 0x41,
        0x00, 0x03, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x07, 0x41, 0x00, 0x03, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x08, 0x41,
        0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x44, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x43,
        0x06, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02, 0x43, 0x07, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x01, 0x71,
        0x06, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02, 0x71, 0x07, 0x03, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
        0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0xa8, 0x06, 0x00, 0x00, 0x60, 0x00, 0x01, 0x00, 0xaa, 0x01, 0x00, 0x00, 0x44, 0x58, 0x49, 0x4c, 0x00, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00,
        0x00, 0x90, 0x06, 0x00, 0x00, 0x42, 0x43, 0xc0, 0xde, 0x21, 0x0c, 0x00, 0x00, 0xa1, 0x01, 0x00, 0x00, 0x0b, 0x82, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x07, 0x81, 0x23,
        0x91, 0x41, 0xc8, 0x04, 0x49, 0x06, 0x10, 0x32, 0x39, 0x92, 0x01, 0x84, 0x0c, 0x25, 0x05, 0x08, 0x19, 0x1e, 0x04, 0x8b, 0x62, 0x80, 0x10, 0x45, 0x02, 0x42, 0x92, 0x0b, 0x42, 0x84, 0x10, 0x32,
        0x14, 0x38, 0x08, 0x18, 0x4b, 0x0a, 0x32, 0x42, 0x88, 0x48, 0x90, 0x14, 0x20, 0x43, 0x46, 0x88, 0xa5, 0x00, 0x19, 0x32, 0x42, 0xe4, 0x48, 0x0e, 0x90, 0x11, 0x22, 0xc4, 0x50, 0x41, 0x51, 0x81,
        0x8c, 0xe1, 0x83, 0xe5, 0x8a, 0x04, 0x21, 0x46, 0x06, 0x51, 0x18, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x1b, 0x8c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x40, 0x02, 0xa8, 0x0d, 0x84, 0xf0, 0xff,
        0xff, 0xff, 0xff, 0x03, 0x20, 0x01, 0x00, 0x00, 0x00, 0x49, 0x18, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13, 0x82, 0x60, 0x42, 0x20, 0x00, 0x00, 0x00, 0x89, 0x20, 0x00, 0x00, 0x0f, 0x00, 0x00,
        0x00, 0x32, 0x22, 0x08, 0x09, 0x20, 0x64, 0x85, 0x04, 0x13, 0x22, 0xa4, 0x84, 0x04, 0x13, 0x22, 0xe3, 0x84, 0xa1, 0x90, 0x14, 0x12, 0x4c, 0x88, 0x8c, 0x0b, 0x84, 0x84, 0x4c, 0x10, 0x30, 0x23,
        0x00, 0x25, 0x00, 0x8a, 0x19, 0x80, 0x39, 0x02, 0x30, 0x98, 0x23, 0x40, 0x8a, 0x31, 0x44, 0x54, 0x44, 0x56, 0x0c, 0x20, 0xa2, 0x1a, 0xc2, 0x81, 0x80, 0x1c, 0x21, 0x00, 0x00, 0x13, 0x14, 0x72,
        0xc0, 0x87, 0x74, 0x60, 0x87, 0x36, 0x68, 0x87, 0x79, 0x68, 0x03, 0x72, 0xc0, 0x87, 0x0d, 0xaf, 0x50, 0x0e, 0x6d, 0xd0, 0x0e, 0x7a, 0x50, 0x0e, 0x6d, 0x00, 0x0f, 0x7a, 0x30, 0x07, 0x72, 0xa0,
        0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x78, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x71, 0x60, 0x07, 0x7a, 0x30, 0x07, 0x72,
        0xd0, 0x06, 0xe9, 0x30, 0x07, 0x72, 0xa0, 0x07, 0x73, 0x20, 0x07, 0x6d, 0x90, 0x0e, 0x76, 0x40, 0x07, 0x7a, 0x60, 0x07, 0x74, 0xd0, 0x06, 0xe6, 0x10, 0x07, 0x76, 0xa0, 0x07, 0x73, 0x20, 0x07,
        0x6d, 0x60, 0x0e, 0x73, 0x20, 0x07, 0x7a, 0x30, 0x07, 0x72, 0xd0, 0x06, 0xe6, 0x60, 0x07, 0x74, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x6d, 0xe0, 0x0e, 0x78, 0xa0, 0x07, 0x71, 0x60, 0x07, 0x7a, 0x30,
        0x07, 0x72, 0xa0, 0x07, 0x76, 0x40, 0x07, 0x43, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x3c, 0x06, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x0c, 0x79, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0x02, 0x01, 0x15, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x98, 0x14, 0x19, 0x11, 0x4c, 0x90, 0x8c, 0x09, 0x26,
        0x47, 0xc6, 0x04, 0x43, 0xa2, 0x12, 0x18, 0x01, 0x28, 0x84, 0x62, 0x28, 0x82, 0x32, 0x28, 0x85, 0x72, 0x28, 0x08, 0xaa, 0x92, 0x18, 0x01, 0x28, 0x84, 0x12, 0x28, 0x83, 0x62, 0x28, 0x82, 0x72,
        0xa0, 0x1d, 0x6b, 0x0c, 0xc2, 0x80, 0x09, 0x04, 0x02, 0x81, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x40, 0x01, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x40,
        0x30, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x87, 0x00, 0x00, 0x00, 0x1a, 0x03, 0x4c, 0x90, 0x46, 0x02, 0x13, 0xc4, 0x88, 0x0c, 0x6f, 0xec, 0xed, 0x4d, 0x0c,
        0x44, 0x06, 0x26, 0x26, 0xc7, 0x05, 0xa6, 0xc6, 0x05, 0x06, 0x66, 0x43, 0x10, 0x4c, 0x10, 0x88, 0x61, 0x82, 0x40, 0x10, 0x1b, 0x84, 0x81, 0x98, 0x20, 0x10, 0xc5, 0x06, 0x61, 0x30, 0x28, 0xd8,
        0xcd, 0x4d, 0x10, 0x08, 0x63, 0xc3, 0x80, 0x24, 0xc4, 0x04, 0x41, 0x00, 0x36, 0x00, 0x1b, 0x06, 0x82, 0x61, 0x36, 0x04, 0xcd, 0x86, 0x61, 0x58, 0x9c, 0x09, 0xc2, 0x42, 0x6d, 0x08, 0x20, 0x12,
        0x6d, 0x61, 0x69, 0x6e, 0x44, 0xa0, 0x9e, 0xa6, 0x92, 0xa8, 0x92, 0x9e, 0x9c, 0x26, 0x08, 0x05, 0x33, 0x41, 0x28, 0x9a, 0x0d, 0x01, 0x31, 0x41, 0x28, 0x9c, 0x0d, 0x0b, 0x31, 0x51, 0x95, 0x55,
        0x0d, 0x17, 0x51, 0x01, 0x6c, 0x86, 0x98, 0x92, 0xa0, 0xbe, 0x88, 0x92, 0xa6, 0xa8, 0x82, 0x9c, 0x86, 0x8a, 0x26, 0x08, 0xc5, 0xb3, 0x61, 0x19, 0x32, 0xaa, 0xb2, 0xaa, 0x41, 0x1b, 0x2a, 0x60,
        0x82, 0x40, 0x1c, 0x1b, 0x82, 0x61, 0xc3, 0xc2, 0x65, 0x54, 0xd5, 0x55, 0x83, 0xc6, 0x55, 0xc0, 0x04, 0x81, 0x40, 0x36, 0x04, 0xdc, 0x86, 0xe5, 0xcb, 0xa8, 0x0a, 0x0c, 0xaa, 0x41, 0xfb, 0x2a,
        0x60, 0x43, 0xf0, 0x6d, 0x58, 0x8c, 0x8c, 0xaa, 0xc4, 0xa0, 0x1a, 0x34, 0xa3, 0x02, 0x26, 0x08, 0x44, 0xc2, 0x66, 0xa8, 0x8a, 0x89, 0xe9, 0x8b, 0x28, 0x69, 0x8a, 0x2a, 0xc8, 0x69, 0xa8, 0x68,
        0xc3, 0x42, 0x06, 0x65, 0x40, 0x55, 0x56, 0x35, 0x68, 0x64, 0x50, 0x01, 0x1b, 0x96, 0xa4, 0x0c, 0xa8, 0xaa, 0xab, 0x06, 0x2d, 0xa9, 0x80, 0x09, 0x02, 0xa1, 0x6c, 0x58, 0xd0, 0xa0, 0x0c, 0xa8,
        0x0a, 0x0c, 0xaa, 0x41, 0x43, 0x83, 0x0a, 0x98, 0x20, 0x10, 0xcb, 0x86, 0x45, 0x0d, 0xca, 0x80, 0xaa, 0xc4, 0xa0, 0x1a, 0x34, 0x35, 0xa8, 0x80, 0x0d, 0x09, 0xb6, 0x79, 0x61, 0x30, 0x06, 0x66,
        0x70, 0x06, 0x69, 0xb0, 0x06, 0x5c, 0xa6, 0xac, 0xbe, 0xa0, 0xde, 0xe6, 0xd2, 0xe8, 0xd2, 0xde, 0xdc, 0x26, 0x08, 0x05, 0xb4, 0x61, 0x21, 0xda, 0x80, 0x72, 0x03, 0xeb, 0x1a, 0x2e, 0xa2, 0x02,
        0xf8, 0x4c, 0x59, 0x7d, 0x0d, 0xb1, 0xa5, 0xc1, 0x11, 0xa5, 0xcd, 0xd1, 0x85, 0xb9, 0x8d, 0x95, 0x4d, 0x10, 0x8a, 0x68, 0x82, 0x50, 0x48, 0x1b, 0x96, 0x01, 0x0e, 0xa8, 0x38, 0xe8, 0xe4, 0x60,
        0x70, 0x83, 0xa1, 0x02, 0xf8, 0x4c, 0x59, 0x7d, 0x0d, 0xd5, 0xb1, 0xb1, 0x11, 0xa5, 0xcd, 0xd1, 0x85, 0xb9, 0x8d, 0x95, 0x4d, 0x10, 0x8a, 0x69, 0xc3, 0xc2, 0xd1, 0x01, 0x55, 0x07, 0x9d, 0x1c,
        0x0c, 0x6e, 0xc0, 0x55, 0xc0, 0x86, 0xe5, 0x83, 0x03, 0x2a, 0x0e, 0xc0, 0x40, 0x0e, 0x06, 0x6d, 0x70, 0x03, 0x60, 0xc3, 0x62, 0xd0, 0x01, 0x55, 0x07, 0x60, 0x20, 0x07, 0x83, 0xc6, 0xb9, 0x01,
        0xb0, 0xa1, 0x78, 0x83, 0x39, 0xb0, 0x83, 0x3b, 0xc0, 0x83, 0x0d, 0x03, 0x1b, 0xe4, 0x01, 0xb0, 0xa1, 0x58, 0x24, 0x3d, 0x00, 0x80, 0x2a, 0x6c, 0x6c, 0x76, 0x6d, 0x2e, 0x69, 0x64, 0x65, 0x6e,
        0x74, 0x53, 0x82, 0xa0, 0x0a, 0x19, 0x9e, 0x8b, 0x5d, 0x99, 0xdc, 0x5c, 0xda, 0x9b, 0xdb, 0x94, 0x80, 0x68, 0x42, 0x86, 0xe7, 0x62, 0x17, 0xc6, 0x66, 0x57, 0x26, 0x37, 0x25, 0x30, 0xea, 0x90,
        0xe1, 0xb9, 0xcc, 0xa1, 0x85, 0x91, 0x95, 0xc9, 0x35, 0xbd, 0x91, 0x95, 0xb1, 0x4d, 0x09, 0x92, 0x4a, 0x64, 0x78, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
        0x6f, 0x6e, 0x73, 0x53, 0x02, 0xa7, 0x0e, 0x19, 0x9e, 0x8b, 0x5d, 0x5a, 0xd9, 0x5d, 0x12, 0xd9, 0x14, 0x5d, 0x18, 0x5d, 0xd9, 0x94, 0x00, 0xaa, 0x43, 0x86, 0xe7, 0x52, 0xe6, 0x46, 0x27, 0x97,
        0x07, 0xf5, 0x96, 0xe6, 0x46, 0x37, 0x37, 0x25, 0xd0, 0x03, 0x00, 0x00, 0x00, 0x79, 0x18, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x33, 0x08, 0x80, 0x1c, 0xc4, 0xe1, 0x1c, 0x66, 0x14, 0x01, 0x3d,
        0x88, 0x43, 0x38, 0x84, 0xc3, 0x8c, 0x42, 0x80, 0x07, 0x79, 0x78, 0x07, 0x73, 0x98, 0x71, 0x0c, 0xe6, 0x00, 0x0f, 0xed, 0x10, 0x0e, 0xf4, 0x80, 0x0e, 0x33, 0x0c, 0x42, 0x1e, 0xc2, 0xc1, 0x1d,
        0xce, 0xa1, 0x1c, 0x66, 0x30, 0x05, 0x3d, 0x88, 0x43, 0x38, 0x84, 0x83, 0x1b, 0xcc, 0x03, 0x3d, 0xc8, 0x43, 0x3d, 0x8c, 0x03, 0x3d, 0xcc, 0x78, 0x8c, 0x74, 0x70, 0x07, 0x7b, 0x08, 0x07, 0x79,
        0x48, 0x87, 0x70, 0x70, 0x07, 0x7a, 0x70, 0x03, 0x76, 0x78, 0x87, 0x70, 0x20, 0x87, 0x19, 0xcc, 0x11, 0x0e, 0xec, 0x90, 0x0e, 0xe1, 0x30, 0x0f, 0x6e, 0x30, 0x0f, 0xe3, 0xf0, 0x0e, 0xf0, 0x50,
        0x0e, 0x33, 0x10, 0xc4, 0x1d, 0xde, 0x21, 0x1c, 0xd8, 0x21, 0x1d, 0xc2, 0x61, 0x1e, 0x66, 0x30, 0x89, 0x3b, 0xbc, 0x83, 0x3b, 0xd0, 0x43, 0x39, 0xb4, 0x03, 0x3c, 0xbc, 0x83, 0x3c, 0x84, 0x03,
        0x3b, 0xcc, 0xf0, 0x14, 0x76, 0x60, 0x07, 0x7b, 0x68, 0x07, 0x37, 0x68, 0x87, 0x72, 0x68, 0x07, 0x37, 0x80, 0x87, 0x70, 0x90, 0x87, 0x70, 0x60, 0x07, 0x76, 0x28, 0x07, 0x76, 0xf8, 0x05, 0x76,
        0x78, 0x87, 0x77, 0x80, 0x87, 0x5f, 0x08, 0x87, 0x71, 0x18, 0x87, 0x72, 0x98, 0x87, 0x79, 0x98, 0x81, 0x2c, 0xee, 0xf0, 0x0e, 0xee, 0xe0, 0x0e, 0xf5, 0xc0, 0x0e, 0xec, 0x30, 0x03, 0x62, 0xc8,
        0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xcc, 0xa1, 0x1c, 0xe4, 0xa1, 0x1c, 0xdc, 0x61, 0x1c, 0xca, 0x21, 0x1c, 0xc4, 0x81, 0x1d, 0xca, 0x61, 0x06, 0xd6, 0x90, 0x43, 0x39, 0xc8, 0x43, 0x39, 0x98, 0x43,
        0x39, 0xc8, 0x43, 0x39, 0xb8, 0xc3, 0x38, 0x94, 0x43, 0x38, 0x88, 0x03, 0x3b, 0x94, 0xc3, 0x2f, 0xbc, 0x83, 0x3c, 0xfc, 0x82, 0x3b, 0xd4, 0x03, 0x3b, 0xb0, 0x03, 0x00, 0x00, 0x71, 0x20, 0x00,
        0x00, 0x0b, 0x00, 0x00, 0x00, 0x16, 0x30, 0x0d, 0x97, 0xef, 0x3c, 0xfe, 0xe2, 0x00, 0x83, 0xd8, 0x3c, 0xd4, 0xe4, 0x17, 0xb7, 0x6d, 0x02, 0xd5, 0x70, 0xf9, 0xce, 0xe3, 0x4b, 0x93, 0x13, 0x11,
        0x28, 0x35, 0x3d, 0xd4, 0xe4, 0x17, 0xb7, 0x6d, 0x00, 0x04, 0x03, 0x20, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x61, 0x20, 0x00, 0x00, 0x4e, 0x00, 0x00, 0x00, 0x13, 0x04, 0x41, 0x2c, 0x10, 0x00, 0x00,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x44, 0x33, 0x00, 0x00, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x60, 0x54, 0xd1, 0x22, 0x25, 0xc1, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x18, 0x96, 0xd4, 0x4c, 0x8a,
        0x30, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0xc6, 0x35, 0x49, 0xd4, 0x32, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x81, 0x81, 0x51, 0x50, 0xc5, 0x10, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x60, 0x64,
        0x55, 0x65, 0x35, 0xc5, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x18, 0x9a, 0x35, 0x5d, 0x8e, 0x31, 0x62, 0x90, 0x00, 0x20, 0x08, 0x06, 0xc6, 0x76, 0x55, 0xd8, 0x73, 0x8c, 0x18, 0x24, 0x00, 0x08,
        0x82, 0x81, 0xc1, 0x61, 0x5a, 0x06, 0x21, 0x23, 0x06, 0x09, 0x00, 0x82, 0x60, 0x60, 0x74, 0x99, 0xa6, 0x45, 0xc9, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x18, 0x9e, 0xb6, 0x6d, 0x90, 0x32, 0x62,
        0x90, 0x00, 0x20, 0x08, 0x06, 0xc6, 0xb7, 0x71, 0x9c, 0xb3, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x81, 0x01, 0x06, 0x5c, 0xd7, 0x45, 0xcc, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x20, 0x60, 0x90,
        0x79, 0x5e, 0x45, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x02, 0x06, 0x99, 0xe7, 0x4d, 0xc3, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x20, 0x60, 0x90, 0x79, 0x1e, 0x24, 0x8c, 0x18, 0x24, 0x00,
        0x08, 0x82, 0x01, 0x02, 0x06, 0x99, 0xe7, 0x49, 0xc1, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x20, 0x60, 0x90, 0x7d, 0x5e, 0x55, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x02, 0x06, 0xd9, 0xe7,
        0x4d, 0xc6, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x20, 0x60, 0x90, 0x7d, 0x1e, 0x74, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x02, 0x06, 0xd9, 0xe6, 0x55, 0xc9, 0x88, 0x41, 0x02, 0x80, 0x20,
        0x18, 0x20, 0x60, 0x90, 0x6d, 0xde, 0xa4, 0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x02, 0x06, 0xd9, 0xe6, 0x41, 0xcb, 0x88, 0x41, 0x02, 0x80, 0x20, 0x18, 0x20, 0x60, 0x90, 0x69, 0x5e, 0x85,
        0x8c, 0x18, 0x24, 0x00, 0x08, 0x82, 0x01, 0x02, 0x06, 0x59, 0xe7, 0x55, 0x0c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };
    const D3D12_SHADER_BYTECODE vs = {
        use_dxil ? (const void*)vs_code_dxil : (const void*)vs_code_dxbc,
        use_dxil ? sizeof(vs_code_dxil) : sizeof(vs_code_dxbc)
    };
    static const D3D12_INPUT_ELEMENT_DESC layout_desc[] =
    {
        {"POSITION",      0, DXGI_FORMAT_R32G32_FLOAT, 0,  0, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CLIP_DISTANCE", 0, DXGI_FORMAT_R32_FLOAT,    1,  0, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CLIP_DISTANCE", 1, DXGI_FORMAT_R32_FLOAT,    1,  4, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CLIP_DISTANCE", 2, DXGI_FORMAT_R32_FLOAT,    1,  8, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CLIP_DISTANCE", 3, DXGI_FORMAT_R32_FLOAT,    1, 12, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CULL_DISTANCE", 0, DXGI_FORMAT_R32_FLOAT,    1, 16, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CULL_DISTANCE", 1, DXGI_FORMAT_R32_FLOAT,    1, 20, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CULL_DISTANCE", 2, DXGI_FORMAT_R32_FLOAT,    1, 24, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
        {"CULL_DISTANCE", 3, DXGI_FORMAT_R32_FLOAT,    1, 28, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0},
    };
    static const struct vec4 quad[] =
    {
        {-1.0f, -1.0f},
        {-1.0f,  1.0f},
        { 1.0f, -1.0f},
        { 1.0f,  1.0f},
    };
    struct
    {
        float clip_distance[4];
        float cull_distance[4];
    }
    vertices[4] =
    {
        {{1.0f, 1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f, 1.0f}},
        {{1.0f, 1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f, 1.0f}},
        {{1.0f, 1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f, 1.0f}},
        {{1.0f, 1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f, 1.0f}},
    };
    static const struct test
    {
        float vertices[4];
        bool triangle_visible[2];
    }
    cull_distance_tests[] =
    {
        {{-1.0f,  1.0f,  1.0f,  1.0f}, {true, true}},
        {{ 1.0f, -1.0f,  1.0f,  1.0f}, {true, true}},
        {{ 1.0f,  1.0f,  1.0f, -1.0f}, {true, true}},
        {{-1.0f, -1.0f,  1.0f,  1.0f}, {true, true}},
        {{-1.0f,  1.0f, -1.0f,  1.0f}, {true, true}},
        {{-1.0f,  1.0f,  1.0f, -1.0f}, {true, true}},
        {{ 1.0f, -1.0f, -1.0f,  1.0f}, {true, true}},
        {{ 1.0f, -1.0f,  1.0f, -1.0f}, {true, true}},
        {{ 1.0f,  1.0f, -1.0f, -1.0f}, {true, true}},

        {{-1.0f, -1.0f, -1.0f,  1.0f}, {false, true}},
        {{-1.0f, -1.0f,  1.0f, -1.0f}, {true,  true}},
        {{-1.0f, -1.0f,  1.0f, -1.0f}, {true,  true}},
        {{-1.0f,  1.0f, -1.0f, -1.0f}, {true,  true}},
        {{ 1.0f, -1.0f, -1.0f, -1.0f}, {true,  false}},

        {{-1.0f, -1.0f, -1.0f, -1.0f}, {false, false}},
    };
    static const float white[] = {1.0f, 1.0f, 1.0f, 1.0f};

    memset(&desc, 0, sizeof(desc));
    desc.rt_width = 640;
    desc.rt_height = 480;
    desc.root_signature_flags = D3D12_ROOT_SIGNATURE_FLAG_ALLOW_INPUT_ASSEMBLER_INPUT_LAYOUT;
    desc.no_pipeline = true;
    if (!init_test_context(&context, &desc))
        return;

    if (use_dxil && !context_supports_dxil(&context))
    {
        destroy_test_context(&context);
        return;
    }

    device = context.device;
    command_list = context.list;
    queue = context.queue;

    input_layout.pInputElementDescs = layout_desc;
    input_layout.NumElements = ARRAY_SIZE(layout_desc);

    if (use_dxil)
    {
        context.pipeline_state = create_pipeline_state_dxil(device, context.root_signature,
                context.render_target_desc.Format, &vs, NULL, &input_layout);
    }
    else
    {
        context.pipeline_state = create_pipeline_state(device, context.root_signature,
                context.render_target_desc.Format, &vs, NULL, &input_layout);
    }

    vb[0] = create_upload_buffer(device, sizeof(quad), quad);
    vbv[0].BufferLocation = ID3D12Resource_GetGPUVirtualAddress(vb[0]);
    vbv[0].StrideInBytes = sizeof(*quad);
    vbv[0].SizeInBytes = sizeof(quad);

    vb[1] = create_upload_buffer(device, sizeof(vertices), vertices);
    vbv[1].BufferLocation = ID3D12Resource_GetGPUVirtualAddress(vb[1]);
    vbv[1].StrideInBytes = sizeof(*vertices);
    vbv[1].SizeInBytes = sizeof(vertices);

    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context.rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetPipelineState(command_list, context.pipeline_state);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context.viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context.scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, ARRAY_SIZE(vbv), vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context.rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    check_sub_resource_uint(context.render_target, 0, queue, command_list, 0xff00ff00, 0);

    reset_command_list(command_list, context.allocator);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);

    for (i = 0; i < ARRAY_SIZE(vertices->cull_distance); ++i)
    {
        for (j = 0; j < ARRAY_SIZE(cull_distance_tests); ++j)
        {
            const struct test *test = &cull_distance_tests[j];
            unsigned int expected_color[ARRAY_SIZE(test->triangle_visible)];
            unsigned int color;

            for (k = 0; k < ARRAY_SIZE(vertices); ++k)
                vertices[k].cull_distance[i] = test->vertices[k];
            update_buffer_data(vb[1], 0, sizeof(vertices), vertices);

            ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context.rtv, false, NULL);
            ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context.root_signature);
            ID3D12GraphicsCommandList_SetPipelineState(command_list, context.pipeline_state);
            ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
            ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context.viewport);
            ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context.scissor_rect);
            ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, ARRAY_SIZE(vbv), vbv);
            ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context.rtv, white, 0, NULL);
            ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
            transition_resource_state(command_list, context.render_target,
                    D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);

            for (k = 0; k < ARRAY_SIZE(expected_color); ++k)
                expected_color[k] = test->triangle_visible[k] ? 0xff00ff00 : 0xffffffff;

            if (expected_color[0] == expected_color[1])
            {
                check_sub_resource_uint(context.render_target, 0, queue, command_list, expected_color[0], 0);
            }
            else
            {
                get_texture_readback_with_command_list(context.render_target, 0, &rb, queue, command_list);
                color = get_readback_uint(&rb, 160, 240, 0);
                ok(color == expected_color[0], "Got unexpected color 0x%08x.\n", color);
                color = get_readback_uint(&rb, 480, 240, 0);
                ok(color == expected_color[1], "Got unexpected color 0x%08x.\n", color);
                release_resource_readback(&rb);
            }

            reset_command_list(command_list, context.allocator);
            transition_resource_state(command_list, context.render_target,
                    D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);
        }

        for (j = 0; j < ARRAY_SIZE(vertices); ++j)
            vertices[j].cull_distance[i] = 1.0f;
    }

    for (i = 0; i < ARRAY_SIZE(vertices->clip_distance); ++i)
    {
        for (j = 0; j < ARRAY_SIZE(vertices); ++j)
            vertices[j].clip_distance[i] = -1.0f;
        update_buffer_data(vb[1], 0, sizeof(vertices), vertices);

        ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context.rtv, false, NULL);
        ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context.root_signature);
        ID3D12GraphicsCommandList_SetPipelineState(command_list, context.pipeline_state);
        ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
        ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context.viewport);
        ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context.scissor_rect);
        ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, ARRAY_SIZE(vbv), vbv);
        ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context.rtv, white, 0, NULL);
        ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
        transition_resource_state(command_list, context.render_target,
                D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);

        check_sub_resource_uint(context.render_target, 0, queue, command_list, 0xffffffff, 0);

        reset_command_list(command_list, context.allocator);
        transition_resource_state(command_list, context.render_target,
                D3D12_RESOURCE_STATE_COPY_SOURCE, D3D12_RESOURCE_STATE_RENDER_TARGET);

        for (j = 0; j < ARRAY_SIZE(vertices); ++j)
            vertices[j].clip_distance[i] = 1.0f;
    }

    memset(vertices, 0, sizeof(vertices));
    update_buffer_data(vb[1], 0, sizeof(vertices), vertices);
    ID3D12GraphicsCommandList_OMSetRenderTargets(command_list, 1, &context.rtv, false, NULL);
    ID3D12GraphicsCommandList_SetGraphicsRootSignature(command_list, context.root_signature);
    ID3D12GraphicsCommandList_SetPipelineState(command_list, context.pipeline_state);
    ID3D12GraphicsCommandList_IASetPrimitiveTopology(command_list, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    ID3D12GraphicsCommandList_RSSetViewports(command_list, 1, &context.viewport);
    ID3D12GraphicsCommandList_RSSetScissorRects(command_list, 1, &context.scissor_rect);
    ID3D12GraphicsCommandList_IASetVertexBuffers(command_list, 0, ARRAY_SIZE(vbv), vbv);
    ID3D12GraphicsCommandList_ClearRenderTargetView(command_list, context.rtv, white, 0, NULL);
    ID3D12GraphicsCommandList_DrawInstanced(command_list, 4, 1, 0, 0);
    transition_resource_state(command_list, context.render_target,
            D3D12_RESOURCE_STATE_RENDER_TARGET, D3D12_RESOURCE_STATE_COPY_SOURCE);
    check_sub_resource_uint(context.render_target, 0, queue, command_list, 0xff00ff00, 0);

    for (i = 0; i < ARRAY_SIZE(vb); ++i)
        ID3D12Resource_Release(vb[i]);
    destroy_test_context(&context);
}

void test_combined_clip_and_cull_distances_dxbc(void)
{
    test_combined_clip_and_cull_distances(false);
}

void test_combined_clip_and_cull_distances_dxil(void)
{
    test_combined_clip_and_cull_distances(true);
}

