/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.data.hints;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintContext;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintProvider;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.data.hints.AbstractValueBindingDescriptor;
import org.jkiss.dbeaver.registry.data.hints.ValueHintRegistry;
import org.jkiss.utils.CommonUtils;

public class ValueHintProviderDescriptor
extends AbstractValueBindingDescriptor<DBDValueHintProvider, DBDValueHintContext> {
    private static final Log log = Log.getLog(ValueHintProviderDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataHintProvider";
    public static final String TAG_HINT_PROVIDER = "hintProvider";
    @NotNull
    private final DBDValueHintProvider.HintObject forObject;
    private final boolean visibleByDefault;
    private final boolean association;
    @NotNull
    private final String label;

    public ValueHintProviderDescriptor(IConfigurationElement config) {
        super(config);
        String forAttr = config.getAttribute("for");
        if (forAttr != null) {
            forAttr = forAttr.toUpperCase();
        }
        this.forObject = (DBDValueHintProvider.HintObject)CommonUtils.valueOf(DBDValueHintProvider.HintObject.class, (String)forAttr, (Enum)DBDValueHintProvider.HintObject.CELL);
        this.visibleByDefault = CommonUtils.getBoolean((String)config.getAttribute("visibleByDefault"), (boolean)true);
        this.association = CommonUtils.getBoolean((String)config.getAttribute("association"));
        this.label = config.getAttribute("label");
    }

    @Override
    protected Class<DBDValueHintProvider> getImplClass() {
        return DBDValueHintProvider.class;
    }

    @NotNull
    public DBDValueHintProvider.HintObject getForObject() {
        return this.forObject;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isEnabled(DBSTypedObject typedObject, DBDValueHintContext context, boolean checkConfigDisable) {
        if (checkConfigDisable) {
            DBSDataContainer dataContainer = context.getDataContainer();
            DBPDataSource dataSource = dataContainer == null ? null : dataContainer.getDataSource();
            DBSEntity contextEntity = dataSource == null ? null : context.getContextEntity();
            if (!ValueHintRegistry.getInstance().isHintEnabled(this, dataSource == null ? null : dataSource.getContainer(), contextEntity)) {
                return false;
            }
        }
        if (this.association && typedObject != null) {
            DBDAttributeBinding binding;
            return typedObject instanceof DBDAttributeBinding && !CommonUtils.isEmpty((binding = (DBDAttributeBinding)typedObject).getReferrers());
        }
        return true;
    }

    public boolean isVisibleByDefault() {
        return this.visibleByDefault;
    }
}

